/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.http;

import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import com.baidu.mapapi.JNIInitializer;
import com.baidu.mapapi.common.Logger;
import com.baidu.mapsdkplatform.comapi.util.h;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;

public class HttpClient {
    private String b = null;
    private String c = null;
    HttpURLConnection a;
    private int d;
    public static boolean isHttpsEnable = true;
    private int e;
    private String f;
    private ProtoResultCallback g;

    public void setReadTimeOut(int readTimeOut) {
        this.e = readTimeOut;
    }

    public void setMaxTimeOut(int maxTimeOut) {
        this.d = maxTimeOut;
    }

    public HttpClient(String method, ProtoResultCallback callback) {
        this.f = method;
        this.g = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void request(String requestUrl) {
        block20: {
            this.b = requestUrl;
            if (!this.checkNetwork()) {
                this.g.onFailed(HttpStateError.NETWORK_ERROR);
                return;
            }
            this.a = this.a();
            if (this.a == null) {
                Log.e((String)"HttpClient", (String)"url connection failed");
                this.g.onFailed(HttpStateError.INNER_ERROR);
                return;
            }
            if (TextUtils.isEmpty((CharSequence)this.b)) {
                this.g.onFailed(HttpStateError.REQUEST_ERROR);
                return;
            }
            int responseCode = -1;
            try {
                BufferedReader reader = null;
                this.a.connect();
                InputStream inputStream = null;
                try {
                    responseCode = this.a.getResponseCode();
                    if (200 == responseCode) {
                        int code;
                        inputStream = this.a.getInputStream();
                        reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                        StringBuffer stringBuffer = new StringBuffer();
                        while ((code = reader.read()) != -1) {
                            stringBuffer.append((char)code);
                        }
                        this.c = stringBuffer.toString();
                        break block20;
                    }
                    Log.e((String)"HttpClient", (String)("responseCode is: " + responseCode));
                    HttpStateError error = responseCode >= 500 ? HttpStateError.SERVER_ERROR : (responseCode >= 400 ? HttpStateError.REQUEST_ERROR : HttpStateError.INNER_ERROR);
                    if (Logger.debugEnable()) {
                        inputStream = this.a.getErrorStream();
                        Logger.logW("HttpClient", inputStream.toString());
                    } else {
                        Logger.logW("HttpClient", "Get response from server failed, http response code=" + responseCode + ", error=" + (Object)((Object)error));
                    }
                    this.g.onFailed(error);
                    return;
                }
                catch (Exception e2) {
                    if (Logger.debugEnable()) {
                        e2.printStackTrace();
                    } else {
                        Logger.logW("HttpClient", e2.getMessage());
                    }
                    Log.e((String)"HttpClient", (String)"Catch exception. INNER_ERROR", (Throwable)e2);
                    this.g.onFailed(HttpStateError.INNER_ERROR);
                    return;
                }
                finally {
                    if (inputStream != null && reader != null) {
                        reader.close();
                        inputStream.close();
                    }
                    if (null != this.a) {
                        this.a.disconnect();
                    }
                }
            }
            catch (Exception e3) {
                if (Logger.debugEnable()) {
                    e3.printStackTrace();
                } else {
                    Logger.logW("HttpClient", e3.getMessage());
                }
                Log.e((String)"HttpClient", (String)"Catch connection exception, INNER_ERROR", (Throwable)e3);
                this.g.onFailed(HttpStateError.INNER_ERROR);
                return;
            }
        }
        this.g.onSuccess(this.c);
    }

    protected boolean checkNetwork() {
        try {
            ConnectivityManager manager = (ConnectivityManager)JNIInitializer.getCachedContext().getSystemService("connectivity");
            if (null == manager) {
                return false;
            }
            if (Build.VERSION.SDK_INT >= 29) {
                Network network = manager.getActiveNetwork();
                NetworkCapabilities networkCapabilities = manager.getNetworkCapabilities(network);
                return networkCapabilities != null && networkCapabilities.hasCapability(12);
            }
            NetworkInfo networkInfo = manager.getActiveNetworkInfo();
            if (networkInfo == null || !networkInfo.isAvailable()) {
                return false;
            }
        }
        catch (Exception manager) {
            if (Logger.debugEnable()) {
                manager.printStackTrace();
            } else {
                Logger.logW("HttpClient", manager.getMessage());
            }
            manager.printStackTrace();
            return false;
        }
        return true;
    }

    private HttpURLConnection a() {
        try {
            HttpURLConnection connection;
            URL url = new URL(this.b);
            if (isHttpsEnable) {
                connection = (HttpsURLConnection)url.openConnection();
                ((HttpsURLConnection)connection).setHostnameVerifier(new a());
            } else {
                connection = (HttpURLConnection)url.openConnection();
            }
            connection.setRequestMethod(this.f);
            connection.setDoOutput(false);
            connection.setDoInput(true);
            connection.setConnectTimeout(this.d);
            connection.setReadTimeout(this.e);
            return connection;
        }
        catch (Exception e2) {
            Log.e((String)"HttpClient", (String)"url connect failed");
            if (Logger.debugEnable()) {
                e2.printStackTrace();
            } else {
                Logger.logW("HttpClient", e2.getMessage());
            }
            return null;
        }
    }

    public static String getPhoneInfo() {
        return h.e();
    }

    public static String getAuthToken() {
        return h.c;
    }

    static class a
    implements HostnameVerifier {
        a() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            HostnameVerifier hVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
            return hVerifier.verify(hostname, session);
        }
    }

    public static enum HttpStateError {
        NO_ERROR,
        NETWORK_ERROR,
        INNER_ERROR,
        REQUEST_ERROR,
        SERVER_ERROR;

    }

    public static abstract class ProtoResultCallback {
        public abstract void onSuccess(String var1);

        public abstract void onFailed(HttpStateError var1);
    }
}

