/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.map;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.baidu.mapapi.OpenLogUtil;
import com.baidu.mapapi.common.SysOSUtil;
import com.baidu.mapapi.map.BitmapDescriptor;
import com.baidu.mapapi.map.BitmapDescriptorFactory;
import com.baidu.mapapi.map.HeatMap;
import com.baidu.mapapi.map.InfoWindow;
import com.baidu.mapapi.map.MapBaseIndoorMapInfo;
import com.baidu.mapapi.map.MapLanguage;
import com.baidu.mapapi.map.MapLayer;
import com.baidu.mapapi.map.MapPoi;
import com.baidu.mapapi.map.MapStatus;
import com.baidu.mapapi.map.MapStatusUpdate;
import com.baidu.mapapi.map.MapStatusUpdateFactory;
import com.baidu.mapapi.map.MapView;
import com.baidu.mapapi.map.MapViewLayoutParams;
import com.baidu.mapapi.map.Marker;
import com.baidu.mapapi.map.MarkerOptions;
import com.baidu.mapapi.map.MultiPoint;
import com.baidu.mapapi.map.MultiPointItem;
import com.baidu.mapapi.map.MyLocationConfiguration;
import com.baidu.mapapi.map.MyLocationData;
import com.baidu.mapapi.map.Overlay;
import com.baidu.mapapi.map.OverlayOptions;
import com.baidu.mapapi.map.Polyline;
import com.baidu.mapapi.map.Projection;
import com.baidu.mapapi.map.TextureMapView;
import com.baidu.mapapi.map.TileOverlay;
import com.baidu.mapapi.map.TileOverlayOptions;
import com.baidu.mapapi.map.UiSettings;
import com.baidu.mapapi.map.WearMapView;
import com.baidu.mapapi.map.a;
import com.baidu.mapapi.map.c;
import com.baidu.mapapi.map.d;
import com.baidu.mapapi.map.f;
import com.baidu.mapapi.map.g;
import com.baidu.mapapi.map.h;
import com.baidu.mapapi.map.i;
import com.baidu.mapapi.map.j;
import com.baidu.mapapi.map.k;
import com.baidu.mapapi.map.track.TraceAnimationListener;
import com.baidu.mapapi.map.track.TraceOptions;
import com.baidu.mapapi.map.track.TraceOverlay;
import com.baidu.mapapi.model.CoordUtil;
import com.baidu.mapapi.model.LatLng;
import com.baidu.mapapi.model.LatLngBounds;
import com.baidu.mapsdkplatform.comapi.commonutils.b;
import com.baidu.mapsdkplatform.comapi.map.v;
import com.baidu.mapsdkplatform.comapi.map.w;
import com.baidu.mapsdkplatform.comapi.map.x;
import com.baidu.platform.comapi.basestruct.GeoPoint;
import com.baidu.platform.comapi.map.MapSurfaceView;
import com.baidu.platform.comapi.map.MapTextureView;
import com.baidu.platform.comapi.map.OverlayLocationData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.microedition.khronos.opengles.GL10;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BaiduMap {
    public static final int MAP_TYPE_NORMAL = 1;
    public static final int MAP_TYPE_SATELLITE = 2;
    public static final int MAP_TYPE_NONE = 3;
    public static int mapStatusReason = 256;
    private static final String e = BaiduMap.class.getSimpleName();
    private Projection f;
    private UiSettings g;
    private MapSurfaceView h;
    private MapTextureView i;
    private com.baidu.mapsdkplatform.comapi.map.d j;
    private List<Overlay> k;
    private List<Marker> l;
    private List<Marker> m;
    private List<InfoWindow> n;
    private Overlay.a o;
    private InfoWindow.a p;
    private OnMapStatusChangeListener q;
    private OnMapTouchListener r;
    private onMapGestureListener s;
    private OnMapClickListener t;
    private OnMapLoadedCallback u;
    private OnMapRenderCallback v;
    private OnMapDoubleClickListener w;
    private OnMapLongClickListener x;
    private CopyOnWriteArrayList<OnMarkerClickListener> y = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<OnPolylineClickListener> z = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<OnMultiPointClickListener> A = new CopyOnWriteArrayList();
    private OnMarkerDragListener B;
    private OnMyLocationClickListener C;
    private SnapshotReadyCallback D;
    private OnMapDrawFrameCallback E;
    private OnBaseIndoorMapListener F;
    private OnMapRenderValidDataListener G;
    private OnHeatMapDrawFrameCallBack H;
    private OnSynchronizationListener I;
    private TileOverlay J;
    private HeatMap K;
    private Lock L = new ReentrantLock();
    private Lock M = new ReentrantLock();
    private Map<String, InfoWindow> N;
    private Map<InfoWindow, Marker> O;
    private Marker P;
    private MyLocationData Q;
    private MyLocationConfiguration R;
    MapView a;
    TextureMapView b;
    WearMapView c;
    w d;
    private boolean S;
    private boolean T;
    private boolean U;
    private boolean V;
    private Point W;
    public static final float REAL_MAX_ZOOM_LEVEL = 21.0f;
    public static final float REAL_MIN_ZOOM_LEVEL = 4.0f;
    private volatile boolean X = false;
    private com.baidu.mapsdkplatform.comapi.map.a.c Y;

    private void d() {
        this.X = false;
        this.k = new CopyOnWriteArrayList<Overlay>();
        this.l = new CopyOnWriteArrayList<Marker>();
        this.m = new CopyOnWriteArrayList<Marker>();
        this.N = new ConcurrentHashMap<String, InfoWindow>();
        this.O = new ConcurrentHashMap<InfoWindow, Marker>();
        this.n = new CopyOnWriteArrayList<InfoWindow>();
        int x2 = (int)(40.0f * SysOSUtil.getDensity());
        int y2 = (int)(40.0f * SysOSUtil.getDensity());
        this.W = new Point(x2, y2);
        this.g = new UiSettings(this.j);
        this.o = new a(this);
        this.p = new c(this);
        d listener = new d(this);
        this.j.a(listener);
        f heatMapLayerReqDataInterface = new f(this);
        this.j.a(heatMapLayerReqDataInterface);
        g tileOverlayReqDataInterface = new g(this);
        this.j.a(tileOverlayReqDataInterface);
        this.S = this.j.B();
        this.T = this.j.C();
    }

    BaiduMap(Context context, MapTextureView mapSDKTextureView, v mapOptions) {
        this.i = mapSDKTextureView;
        this.j = new com.baidu.mapsdkplatform.comapi.map.d(context, mapSDKTextureView, mapOptions, null, 0);
        mapSDKTextureView.setBaseMap(this.j);
        this.d = com.baidu.mapsdkplatform.comapi.map.w.b;
        this.d();
    }

    BaiduMap(Context context, MapSurfaceView mapSurfaceView, v mapOptions) {
        this.h = mapSurfaceView;
        this.j = new com.baidu.mapsdkplatform.comapi.map.d(context, mapSurfaceView, mapOptions, null, 0);
        mapSurfaceView.setBaseMap(this.j);
        this.d = com.baidu.mapsdkplatform.comapi.map.w.a;
        this.d();
    }

    public final TraceOverlay addTraceOverlay(TraceOptions traceOptions, TraceAnimationListener traceAnimationListener) {
        if (traceOptions == null) {
            return null;
        }
        if (this.Y == null || this.Y.d()) {
            if (this.d == com.baidu.mapsdkplatform.comapi.map.w.a) {
                this.Y = new com.baidu.mapsdkplatform.comapi.map.a.c(this.h);
            } else if (this.d == com.baidu.mapsdkplatform.comapi.map.w.b) {
                this.Y = new com.baidu.mapsdkplatform.comapi.map.a.c(this.i);
            } else {
                return null;
            }
            this.Y.a();
        }
        this.Y.a(traceAnimationListener);
        return this.Y.a(traceOptions);
    }

    public final Overlay addOverlay(OverlayOptions options) {
        if (options == null || this.X) {
            return null;
        }
        Overlay o2 = options.a();
        o2.listener = this.o;
        if (o2 instanceof Marker) {
            Marker marker = (Marker)o2;
            marker.A = this.p;
            if (marker.s != null && marker.s.size() != 0) {
                this.l.add(marker);
                if (this.j != null) {
                    this.j.c(true);
                }
            }
            this.m.add(marker);
            if (marker.z != null) {
                this.showInfoWindow(marker.z, false);
            }
        }
        Bundle b2 = new Bundle();
        o2.a(b2);
        if (this.j != null && !this.X) {
            this.j.c(b2);
        }
        this.k.add(o2);
        return o2;
    }

    public LatLngBounds getOverlayLatLngBounds(OverlayOptions options) {
        if (options == null || this.j == null) {
            return null;
        }
        Overlay o2 = options.a();
        Bundle b2 = new Bundle();
        o2.a(b2);
        return this.j.b(b2);
    }

    public final List<Overlay> addOverlays(List<OverlayOptions> options) {
        if (options == null || this.X) {
            return null;
        }
        ArrayList<Overlay> overlayList = new ArrayList<Overlay>();
        int size = options.size();
        int time = size / 400;
        for (int i2 = 0; i2 < time + 1; ++i2) {
            int bundleLength = 0;
            bundleLength = time == 0 ? size : (i2 == time ? size - time * 400 : 400);
            Bundle[] bundles = new Bundle[bundleLength];
            for (int j2 = 0; j2 < 400 && i2 * 400 + j2 < size; ++j2) {
                if (this.X) {
                    return null;
                }
                OverlayOptions option = options.get(i2 * 400 + j2);
                if (option == null) continue;
                Bundle b2 = new Bundle();
                Overlay o2 = option.a();
                o2.listener = this.o;
                if (o2 instanceof Marker) {
                    Marker marker = (Marker)o2;
                    marker.A = this.p;
                    if (marker.s != null && marker.s.size() != 0) {
                        this.l.add(marker);
                        if (this.j != null) {
                            this.j.c(true);
                        }
                    }
                    this.m.add(marker);
                }
                this.k.add(o2);
                overlayList.add(o2);
                o2.a(b2);
                if (this.j != null) {
                    this.j.g(b2);
                    this.j.d(b2);
                }
                bundles[j2] = b2;
            }
            if (this.j == null) continue;
            this.j.a(bundles);
        }
        return overlayList;
    }

    public void removeOverLays(List<Overlay> overlays) {
        if (overlays == null || this.X) {
            return;
        }
        int size = overlays.size();
        int time = size / 400;
        for (int i2 = 0; i2 < time + 1; ++i2) {
            int bundleLength = 0;
            bundleLength = time == 0 ? size : (i2 == time ? size - time * 400 : 400);
            Bundle[] bundles = new Bundle[bundleLength];
            for (int j2 = 0; j2 < 400 && i2 * 400 + j2 < size; ++j2) {
                if (this.X) {
                    return;
                }
                Overlay overlay = overlays.get(i2 * 400 + j2);
                if (overlay == null) continue;
                Bundle bundle = overlay.a();
                if (this.j != null) {
                    this.j.g(bundle);
                }
                bundles[j2] = bundle;
                if (this.m != null && this.m.contains(overlay)) {
                    this.m.remove(overlay);
                }
                if (!this.l.contains(overlay)) continue;
                Marker marker = (Marker)overlay;
                if (marker.s == null) continue;
                this.l.remove(marker);
                if (this.l.size() != 0 || this.j == null) continue;
                this.j.c(false);
            }
            if (this.j == null) continue;
            this.j.b(bundles);
        }
        this.k.removeAll(overlays);
    }

    public List<Marker> getMarkersInBounds(LatLngBounds bounds) {
        MapStatus ms = this.getMapStatus();
        if (ms == null) {
            return null;
        }
        ArrayList<Marker> markers = new ArrayList<Marker>();
        if (this.m.size() == 0) {
            return null;
        }
        for (Marker marker : this.m) {
            if (!bounds.contains(marker.getPosition())) continue;
            markers.add(marker);
        }
        return markers;
    }

    public final void clear() {
        if (this.X) {
            return;
        }
        this.k.clear();
        this.l.clear();
        this.m.clear();
        if (this.j != null) {
            this.j.c(false);
            this.j.n();
        }
        this.hideInfoWindow();
    }

    public final void setMapStatus(MapStatusUpdate update) {
        if (update == null) {
            return;
        }
        x newInner = this.a(update);
        if (this.j == null) {
            return;
        }
        mapStatusReason |= 0x100;
        this.j.B(true);
        this.j.a(newInner);
    }

    public final MapStatus getMapStatus() {
        if (this.j == null) {
            return null;
        }
        x inner = this.j.D();
        return MapStatus.a(inner);
    }

    public final LatLngBounds getMapStatusLimit() {
        if (this.j == null) {
            return null;
        }
        return this.j.E();
    }

    public final void setMapStatusLimits(LatLngBounds bounds) {
        if (this.j == null) {
            return;
        }
        this.j.a(bounds);
        MapStatusUpdate u2 = MapStatusUpdateFactory.newLatLngBounds(bounds);
        this.setMapStatus(u2);
    }

    public final void animateMapStatus(MapStatusUpdate update, int durationMs) {
        if (update == null || durationMs <= 0) {
            return;
        }
        x newInner = this.a(update);
        if (this.j == null) {
            return;
        }
        mapStatusReason |= 0x100;
        if (!this.V) {
            this.j.a(newInner);
        } else {
            this.j.a(newInner, durationMs);
        }
    }

    public float getZoomToBound(int l2, int t2, int r2, int b2, int width, int height) {
        if (this.j == null) {
            return 0.0f;
        }
        return this.j.a(l2, t2, r2, b2, width, height);
    }

    public final void animateMapStatus(MapStatusUpdate update) {
        this.animateMapStatus(update, 300);
    }

    private x a(MapStatusUpdate update) {
        if (this.j == null) {
            return null;
        }
        x oldInner = this.j.D();
        MapStatus newStatus = update.a(this.j, this.getMapStatus());
        if (null == newStatus) {
            return null;
        }
        x newInner = newStatus.b(oldInner);
        return newInner;
    }

    public final void setMapType(int type) {
        if (this.j == null) {
            return;
        }
        switch (type) {
            case 3: {
                if (this.j.B()) {
                    this.j.C(false);
                }
                if (this.j.C()) {
                    this.j.D(false);
                }
                this.j.j(false);
                this.j.o(false);
                break;
            }
            case 1: {
                this.j.a(false);
                this.j.C(this.S);
                this.j.D(this.T);
                this.j.j(true);
                this.j.o(this.U);
                break;
            }
            case 2: {
                this.j.a(true);
                this.j.C(this.S);
                this.j.D(this.T);
                this.j.j(true);
                break;
            }
        }
        if (OpenLogUtil.isMapLogEnable()) {
            com.baidu.mapsdkplatform.comapi.commonutils.b.a().a("BasicMap setMapType type = " + type);
        }
    }

    public final int getMapType() {
        if (this.j == null) {
            return 1;
        }
        if (!this.j.l()) {
            return 3;
        }
        return this.j.k() ? 2 : 1;
    }

    @Deprecated
    public MapSurfaceView getmGLMapView() {
        return this.h;
    }

    public MapSurfaceView getGLMapView() {
        return this.h;
    }

    public MapTextureView getMapTextureView() {
        return this.i;
    }

    public final float getMaxZoomLevel() {
        if (this.j == null) {
            return 0.0f;
        }
        return this.j.b();
    }

    public final void setMaxAndMinZoomLevel(float max, float min) {
        if (max > 21.0f) {
            return;
        }
        if (min < 4.0f) {
            return;
        }
        if (max < min) {
            return;
        }
        if (this.j != null) {
            this.j.a(max, min);
        }
    }

    public final float getMinZoomLevel() {
        if (this.j == null) {
            return 0.0f;
        }
        return this.j.b;
    }

    public final Projection getProjection() {
        return this.f;
    }

    public final UiSettings getUiSettings() {
        return this.g;
    }

    public final void setBuildingsEnabled(boolean enabled) {
        if (this.j != null) {
            this.j.m(enabled);
        }
    }

    public final boolean isBuildingsEnabled() {
        if (this.j == null) {
            return false;
        }
        return this.j.m();
    }

    public final void setMyLocationEnabled(boolean enabled) {
        if (this.j != null) {
            this.j.q(enabled);
        }
    }

    public final boolean isMyLocationEnabled() {
        if (this.j == null) {
            return false;
        }
        return this.j.u();
    }

    public final void setMyLocationData(MyLocationData data) {
        this.Q = data;
        if (this.R == null) {
            this.R = new MyLocationConfiguration(MyLocationConfiguration.LocationMode.NORMAL, false, null);
        }
        this.a(data, this.R);
    }

    public final MyLocationData getLocationData() {
        return this.Q;
    }

    public final void setMyLocationConfiguration(MyLocationConfiguration configuration) {
        this.R = configuration;
        this.a(this.Q, this.R);
    }

    @Deprecated
    public final void setMyLocationConfigeration(MyLocationConfiguration configeration) {
        this.setMyLocationConfiguration(configeration);
    }

    public final MyLocationConfiguration getLocationConfiguration() {
        return this.R;
    }

    @Deprecated
    public final MyLocationConfiguration getLocationConfigeration() {
        return this.getLocationConfiguration();
    }

    private final void a(MyLocationData data, MyLocationConfiguration configeration) {
        Bitmap bm;
        if (data == null || configeration == null || !this.isMyLocationEnabled()) {
            return;
        }
        JSONObject dataset = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        JSONObject elem = new JSONObject();
        JSONObject elemEx = new JSONObject();
        LatLng ll = new LatLng(data.latitude, data.longitude);
        GeoPoint gp = CoordUtil.ll2mc(ll);
        try {
            dataset.put("type", 0);
            elem.put("ptx", gp.getLongitudeE6());
            elem.put("pty", gp.getLatitudeE6());
            float radius = CoordUtil.getMCDistanceByOneLatLngAndRadius(ll, (int)data.accuracy);
            elem.put("radius", (double)radius);
            float dir = data.direction;
            if (configeration.enableDirection) {
                dir = data.direction % 360.0f;
                if (dir > 180.0f) {
                    dir -= 360.0f;
                } else if (dir < -180.0f) {
                    dir += 360.0f;
                }
            } else {
                dir = -1001.0f;
            }
            elem.put("direction", (double)dir);
            elem.put("iconarrownor", (Object)"NormalLocArrow");
            if ("BaiduMapSDK_map_v".equals("BaiduMapSDK_map_for_navi_v")) {
                elem.put("iconarrownorid", 776);
                elem.put("iconarrowfocid", 777);
            } else {
                elem.put("iconarrownorid", 28);
                elem.put("iconarrowfocid", 29);
            }
            elem.put("iconarrowfoc", (Object)"FocusLocArrow");
            elem.put("lineid", configeration.accuracyCircleStrokeColor);
            elem.put("areaid", configeration.accuracyCircleFillColor);
            jsonArray.put((Object)elem);
            if (configeration.locationMode == MyLocationConfiguration.LocationMode.COMPASS) {
                elemEx.put("ptx", gp.getLongitudeE6());
                elemEx.put("pty", gp.getLatitudeE6());
                elemEx.put("radius", 0);
                elemEx.put("direction", 0);
                elemEx.put("iconarrownor", (Object)"direction_wheel");
                elemEx.put("iconarrowfoc", (Object)"direction_wheel");
                if ("BaiduMapSDK_map_v".equals("BaiduMapSDK_map_for_navi_v")) {
                    elemEx.put("iconarrownorid", 339);
                    elemEx.put("iconarrowfocid", 339);
                } else {
                    elemEx.put("iconarrownorid", 54);
                    elemEx.put("iconarrowfocid", 54);
                }
                jsonArray.put((Object)elemEx);
            }
            dataset.put("data", (Object)jsonArray);
        }
        catch (JSONException e2) {
            e2.printStackTrace();
        }
        if (configeration.customMarker != null && (bm = configeration.customMarker.getBitmap()) != null && !bm.isRecycled()) {
            ArrayList<OverlayLocationData> list = new ArrayList<OverlayLocationData>();
            OverlayLocationData overlayLocationData = new OverlayLocationData();
            overlayLocationData.setImage(bm);
            overlayLocationData.setImgHeight(bm.getHeight());
            overlayLocationData.setImgWidth(bm.getWidth());
            overlayLocationData.setImgName("icon");
            overlayLocationData.setRotation(configeration.enableDirection ? 1 : 0);
            list.add(overlayLocationData);
            if (this.j != null) {
                this.j.a(list);
            }
        }
        if (this.j != null) {
            this.j.a(dataset.toString(), (Bundle)null);
        }
        switch (configeration.locationMode) {
            case COMPASS: {
                MapStatus ms = new MapStatus.Builder().rotate(data.direction).overlook(-45.0f).target(new LatLng(data.latitude, data.longitude)).targetScreen(this.getMapStatus().targetScreen).zoom(this.getMapStatus().zoom).build();
                MapStatusUpdate update = MapStatusUpdateFactory.newMapStatus(ms);
                this.animateMapStatus(update);
                break;
            }
            case FOLLOWING: {
                MapStatus ms = new MapStatus.Builder().target(new LatLng(data.latitude, data.longitude)).zoom(this.getMapStatus().zoom).rotate(this.getMapStatus().rotate).overlook(this.getMapStatus().overlook).targetScreen(this.getMapStatus().targetScreen).build();
                MapStatusUpdate update = MapStatusUpdateFactory.newMapStatus(ms);
                this.animateMapStatus(update);
                break;
            }
            case NORMAL: {
                break;
            }
        }
    }

    public void addHeatMap(HeatMap heatmap) {
        if (heatmap == null || this.j == null) {
            return;
        }
        this.L.lock();
        try {
            if (heatmap == this.K) {
                return;
            }
            if (this.K != null) {
                this.K.b();
                this.K.c();
                this.K.a = null;
                this.j.q();
            }
            this.K = heatmap;
            this.K.a = this;
            Bundle b2 = heatmap.toBundle();
            this.j.r(true);
            this.j.h(b2);
        }
        finally {
            this.L.unlock();
        }
    }

    public void startHeatMapFrameAnimation() {
        if (this.j == null) {
            return;
        }
        this.j.o();
    }

    public void stopHeatMapFrameAnimation() {
        if (this.j == null) {
            return;
        }
        this.j.p();
    }

    public void setHeatMapFrameAnimationIndex(int index) {
        if (this.j == null) {
            return;
        }
        this.j.b(index);
    }

    void a(HeatMap heatmap) {
        this.L.lock();
        try {
            if (this.K != null && this.j != null && heatmap == this.K) {
                this.K.b();
                this.K.c();
                this.K.a = null;
                this.j.q();
                this.K = null;
                this.j.r(false);
            }
        }
        finally {
            this.L.unlock();
        }
    }

    void a() {
        if (this.j == null) {
            return;
        }
        this.j.v();
    }

    public final void setBaiduHeatMapEnabled(boolean enabled) {
        if (this.j != null) {
            this.j.k(enabled);
        }
    }

    public final void setIndoorEnable(boolean enabled) {
        if (this.j != null) {
            this.U = enabled;
            this.j.o(enabled);
        }
        if (this.F != null && !enabled) {
            this.F.onBaseIndoorMapMode(false, null);
        }
    }

    public void setCompassPosition(Point p2) {
        if (this.j == null) {
            return;
        }
        Point point = new Point(p2.x, p2.y);
        if (this.j.a(point)) {
            this.W = p2;
        }
    }

    public void setCompassIcon(Bitmap icon) {
        if (icon == null) {
            throw new IllegalArgumentException("BDMapSDKException: compass's icon can not be null");
        }
        if (this.j == null) {
            return;
        }
        this.j.a(icon);
    }

    public final Point getCompassPosition() {
        if (this.j != null) {
            String compassPosition = this.j.h();
            return this.a(compassPosition);
        }
        return null;
    }

    private Point a(String compassPosition) {
        if (TextUtils.isEmpty((CharSequence)compassPosition)) {
            return null;
        }
        int x2 = 0;
        int y2 = 0;
        for (String string : compassPosition.replaceAll("^\\{", "").replaceAll("\\}$", "").split(",")) {
            String[] keyValue = string.replaceAll("\"", "").split(":");
            if ("x".equals(keyValue[0])) {
                x2 = Integer.valueOf(keyValue[1]);
            }
            if (!"y".equals(keyValue[0])) continue;
            y2 = Integer.valueOf(keyValue[1]);
        }
        return new Point(x2, y2);
    }

    public final boolean isBaiduHeatMapEnabled() {
        if (this.j == null) {
            return false;
        }
        return this.j.i();
    }

    public final boolean isSupportBaiduHeatMap() {
        if (this.j == null) {
            return false;
        }
        return this.j.j();
    }

    public final void setTrafficEnabled(boolean enabled) {
        if (this.j != null) {
            this.j.l(enabled);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Deprecated
    public boolean setCustomTrafficColor(String severeCongestion, String congestion, String slow, String smooth) {
        if (this.j == null) {
            return false;
        }
        String pattern = "^#[0-9a-fA-F]{8}$";
        if (!(TextUtils.isEmpty((CharSequence)severeCongestion) || TextUtils.isEmpty((CharSequence)congestion) || TextUtils.isEmpty((CharSequence)slow) || TextUtils.isEmpty((CharSequence)smooth))) {
            if (severeCongestion.matches(pattern) && congestion.matches(pattern) && slow.matches(pattern) && smooth.matches(pattern)) {
                this.j.a(Color.parseColor((String)severeCongestion), Color.parseColor((String)congestion), Color.parseColor((String)slow), Color.parseColor((String)smooth), true);
                return true;
            }
            Log.e((String)e, (String)"the string of the input customTrafficColor is error");
            return false;
        }
        if (!TextUtils.isEmpty((CharSequence)severeCongestion)) return true;
        if (!TextUtils.isEmpty((CharSequence)congestion)) return true;
        if (!TextUtils.isEmpty((CharSequence)slow)) return true;
        if (!TextUtils.isEmpty((CharSequence)smooth)) return true;
        this.j.a(Color.parseColor((String)"#ffffffff"), Color.parseColor((String)"#ffffffff"), Color.parseColor((String)"#ffffffff"), Color.parseColor((String)"#ffffffff"), false);
        return true;
    }

    public final boolean isTrafficEnabled() {
        if (this.j == null) {
            return false;
        }
        return this.j.g();
    }

    public final void showMapPoi(boolean isShow) {
        if (this.j != null) {
            this.j.C(isShow);
            this.S = isShow;
        }
    }

    public final boolean isShowMapPoi() {
        return this.S;
    }

    public final void showMapIndoorPoi(boolean isShow) {
        if (this.j != null) {
            this.j.D(isShow);
            this.T = isShow;
        }
    }

    @Deprecated
    public final void setPadding(int left, int top, int right, int bottom) {
        this.setViewPadding(left, top, right, bottom);
    }

    public final void setViewPadding(int left, int top, int right, int bottom) {
        if (left < 0 || top < 0 || right < 0 || bottom < 0) {
            return;
        }
        if (this.j == null) {
            return;
        }
        switch (this.d) {
            case b: {
                if (this.b == null) {
                    return;
                }
                float scaleX = (float)(this.b.getWidth() - left - right) / (float)this.b.getWidth();
                float scaleY = (float)(this.b.getHeight() - top - bottom) / (float)this.b.getHeight();
                this.j.a(new Point((int)((float)left + (float)this.W.x * scaleX), (int)((float)top + (float)this.W.y * scaleY)));
                this.b.setPadding(left, top, right, bottom);
                this.b.invalidate();
                break;
            }
            case a: {
                if (this.a == null) {
                    return;
                }
                float scaleX = (float)(this.a.getWidth() - left - right) / (float)this.a.getWidth();
                float scaleY = (float)(this.a.getHeight() - top - bottom) / (float)this.a.getHeight();
                this.j.a(new Point((int)((float)left + (float)this.W.x * scaleX), (int)((float)top + (float)this.W.y * scaleY)));
                this.a.setPadding(left, top, right, bottom);
                this.a.invalidate();
                break;
            }
        }
    }

    public final void snapshot(SnapshotReadyCallback callback) {
        this.D = callback;
        switch (this.d) {
            case b: {
                if (this.i == null || this.i.getController() == null) break;
                this.i.doCaptureMapView(new h(this), this.i.getController().getScreenWidth(), this.i.getController().getScreenHeight(), Bitmap.Config.ARGB_8888);
                this.i.requestRender();
                break;
            }
            case a: {
                if (this.h == null || this.h.getController() == null) break;
                this.h.doCaptureMapView(new i(this), this.h.getController().getScreenWidth(), this.h.getController().getScreenHeight(), Bitmap.Config.ARGB_8888);
                this.h.requestRender();
                break;
            }
        }
    }

    public final void snapshotScope(Rect rect, SnapshotReadyCallback callback) {
        if (this.j == null) {
            return;
        }
        this.D = callback;
        switch (this.d) {
            case b: {
                if (this.i == null) break;
                this.i.doCaptureMapView(new j(this), rect, Bitmap.Config.ARGB_8888);
                this.i.requestRender();
                break;
            }
            case a: {
                if (this.h == null) break;
                this.h.doCaptureMapView((com.baidu.platform.comapi.map.c)new k(this), rect, Bitmap.Config.ARGB_8888);
                this.h.requestRender();
                break;
            }
        }
    }

    public void showInfoWindow(InfoWindow infoWindow) {
        this.showInfoWindow(infoWindow, true);
    }

    public void showInfoWindow(InfoWindow infoWindow, boolean isHideOthers) {
        BitmapDescriptor bd;
        Set<InfoWindow> infoWindows = this.O.keySet();
        if (infoWindow == null || infoWindows.contains(infoWindow) || this.X) {
            return;
        }
        if (isHideOthers) {
            this.hideInfoWindow();
        }
        boolean isAddPopMarker = true;
        infoWindow.f = this.p;
        if (infoWindow.c != null && infoWindow.k) {
            View mInfoWindowView = infoWindow.c;
            mInfoWindowView.destroyDrawingCache();
            MapViewLayoutParams.Builder b2 = new MapViewLayoutParams.Builder();
            MapViewLayoutParams mlp = b2.layoutMode(MapViewLayoutParams.ELayoutMode.mapMode).position(infoWindow.d).yOffset(infoWindow.g).build();
            switch (this.d) {
                case b: {
                    if (this.b == null) break;
                    this.b.addView(mInfoWindowView, mlp);
                    break;
                }
                case a: {
                    if (this.a == null) break;
                    this.a.addView(mInfoWindowView, mlp);
                    break;
                }
            }
            isAddPopMarker = false;
        }
        if ((bd = this.b(infoWindow)) == null) {
            return;
        }
        MarkerOptions mo = new MarkerOptions().perspective(false).icon(bd).position(infoWindow.d).zIndex(Integer.MAX_VALUE).yOffset(infoWindow.g).infoWindow(infoWindow);
        Overlay o2 = mo.a();
        o2.listener = this.o;
        o2.type = com.baidu.mapsdkplatform.comapi.map.i.b;
        Bundle bundle = new Bundle();
        o2.a(bundle);
        if (infoWindow.c != null) {
            bundle.putInt("draw_with_view", 1);
        } else {
            bundle.putInt("draw_with_view", 0);
        }
        if (this.j != null && isAddPopMarker && !this.X) {
            this.j.c(bundle);
            this.k.add(o2);
        }
        Marker infoWindowMarker = (Marker)o2;
        infoWindowMarker.A = this.p;
        this.N.put(infoWindowMarker.F, infoWindow);
        this.O.put(infoWindow, infoWindowMarker);
        this.n.add(infoWindow);
    }

    public void showInfoWindows(List<InfoWindow> infoWindowList) {
        if (null == infoWindowList || infoWindowList.isEmpty()) {
            return;
        }
        for (InfoWindow infoWindow : infoWindowList) {
            this.showInfoWindow(infoWindow, false);
        }
    }

    public List<InfoWindow> getAllInfoWindows() {
        return this.n;
    }

    public void hideInfoWindow() {
        Collection<InfoWindow> infoWindows = this.N.values();
        if (!infoWindows.isEmpty()) {
            for (InfoWindow infoWindow : infoWindows) {
                View infoWindowView;
                if (null == infoWindow || null == (infoWindowView = infoWindow.c)) continue;
                switch (this.d) {
                    case b: {
                        if (null == this.b) break;
                        this.b.removeView(infoWindowView);
                        break;
                    }
                    case a: {
                        if (null == this.a) break;
                        this.a.removeView(infoWindowView);
                        break;
                    }
                }
            }
        }
        for (Overlay overlay : this.k) {
            Set<String> infoWindowMarkerIds = this.N.keySet();
            String markerId = overlay.F;
            if (!(overlay instanceof Marker) || infoWindowMarkerIds.isEmpty() || !infoWindowMarkerIds.contains(markerId)) continue;
            overlay.remove();
        }
        this.N.clear();
        this.O.clear();
        this.n.clear();
    }

    public void hideInfoWindow(InfoWindow infoWindow) {
        Marker marker;
        Set<InfoWindow> infoWindowList = this.O.keySet();
        if (null == infoWindow || infoWindowList.isEmpty() || !infoWindowList.contains(infoWindow)) {
            return;
        }
        View infoWindowView = infoWindow.c;
        if (null != infoWindowView) {
            switch (this.d) {
                case b: {
                    if (null == this.b) break;
                    this.b.removeView(infoWindowView);
                    break;
                }
                case a: {
                    if (null == this.a) break;
                    this.a.removeView(infoWindowView);
                    break;
                }
            }
        }
        if (null != (marker = this.O.get(infoWindow))) {
            marker.remove();
            this.N.remove(marker.F);
        }
        this.O.remove(infoWindow);
        this.n.remove(infoWindow);
    }

    private void a(InfoWindow infoWindow) {
        if (null == infoWindow || this.X) {
            return;
        }
        Set<InfoWindow> infoWindowList = this.O.keySet();
        if (infoWindowList.isEmpty() || !infoWindowList.contains(infoWindow)) {
            this.showInfoWindow(infoWindow, false);
            return;
        }
        boolean isUpdatePopMarker = true;
        View infoWindowView = infoWindow.c;
        if (null != infoWindowView && infoWindow.k) {
            infoWindowView.destroyDrawingCache();
            MapViewLayoutParams.Builder b2 = new MapViewLayoutParams.Builder();
            MapViewLayoutParams mlp = b2.layoutMode(MapViewLayoutParams.ELayoutMode.mapMode).position(infoWindow.d).yOffset(infoWindow.g).build();
            switch (this.d) {
                case b: {
                    if (null == this.b) break;
                    this.b.addView(infoWindowView, mlp);
                    infoWindowView.setLayoutParams((ViewGroup.LayoutParams)mlp);
                    break;
                }
                case a: {
                    if (null == this.a) break;
                    this.a.addView(infoWindowView, mlp);
                    break;
                }
            }
            if (infoWindow.j) {
                isUpdatePopMarker = false;
            }
        }
        BitmapDescriptor bitmapDescriptor = this.b(infoWindow);
        Marker marker = this.O.get(infoWindow);
        if (null != marker) {
            Bundle bundle = new Bundle();
            if (infoWindow.b != null) {
                marker.type = com.baidu.mapsdkplatform.comapi.map.i.b;
                marker.b = bitmapDescriptor;
                if (infoWindow.c != null) {
                    bundle.putInt("draw_with_view", 1);
                } else {
                    bundle.putInt("draw_with_view", 0);
                }
            }
            marker.a = infoWindow.d;
            marker.i = infoWindow.g;
            marker.a(bundle);
            if (this.j != null && isUpdatePopMarker && !this.X) {
                this.j.e(bundle);
            }
        }
    }

    private BitmapDescriptor b(InfoWindow infoWindow) {
        BitmapDescriptor bitmapDescriptor;
        if (infoWindow.c != null && infoWindow.k) {
            if (infoWindow.h) {
                if (infoWindow.i <= 0) {
                    infoWindow.i = SysOSUtil.getDensityDpi();
                }
                bitmapDescriptor = BitmapDescriptorFactory.fromViewWithDpi(infoWindow.c, infoWindow.i);
            } else {
                bitmapDescriptor = BitmapDescriptorFactory.fromView(infoWindow.c);
            }
        } else {
            bitmapDescriptor = infoWindow.b;
        }
        return bitmapDescriptor;
    }

    public void setPixelFormatTransparent(boolean bTransparent) {
        if (this.h == null) {
            return;
        }
        if (bTransparent) {
            this.h.setPixelFormatTransparent(true);
        } else {
            this.h.setPixelFormatTransparent(false);
        }
    }

    public final void setOnMapStatusChangeListener(OnMapStatusChangeListener listener) {
        this.q = listener;
    }

    public final void setOnMapTouchListener(OnMapTouchListener listener) {
        this.r = listener;
    }

    public final void setOnMapGestureListener(onMapGestureListener listener) {
        this.s = listener;
    }

    public final void setOnMapClickListener(OnMapClickListener listener) {
        this.t = listener;
    }

    public void setOnMapLoadedCallback(OnMapLoadedCallback callback) {
        this.u = callback;
    }

    public void setOnHeatMapDrawFrameCallBack(OnHeatMapDrawFrameCallBack callBack) {
        this.H = callBack;
    }

    public OnHeatMapDrawFrameCallBack getHeatMapDrawFrameCallBack() {
        return this.H;
    }

    public void setOnMapRenderCallbadk(OnMapRenderCallback callback) {
        this.v = callback;
    }

    public final void setOnMapDoubleClickListener(OnMapDoubleClickListener listener) {
        this.w = listener;
    }

    public final void setOnMapLongClickListener(OnMapLongClickListener listener) {
        this.x = listener;
    }

    public final void setOnPolylineClickListener(OnPolylineClickListener listener) {
        if (listener != null) {
            this.z.add(listener);
        }
    }

    public final void setOnMultiPointClickListener(OnMultiPointClickListener listener) {
        if (listener != null) {
            this.A.add(listener);
        }
    }

    public final void setOnMarkerClickListener(OnMarkerClickListener listener) {
        if (listener != null && !this.y.contains(listener)) {
            this.y.add(listener);
        }
    }

    public final void setOnMarkerDragListener(OnMarkerDragListener listener) {
        this.B = listener;
    }

    public final void setOnMyLocationClickListener(OnMyLocationClickListener listener) {
        this.C = listener;
    }

    public final void setOnMapDrawFrameCallback(OnMapDrawFrameCallback callback) {
        this.E = callback;
    }

    public final void setOnBaseIndoorMapListener(OnBaseIndoorMapListener listener) {
        this.F = listener;
    }

    public final void setOnMapRenderValidDataListener(OnMapRenderValidDataListener listener) {
        this.G = listener;
    }

    private String a(int errorCode) {
        String errorMessage = "";
        switch (errorCode) {
            case 0: {
                errorMessage = "\u6570\u636e\u8bf7\u6c42\u6210\u529f";
                break;
            }
            case 1004: {
                errorMessage = "\u7f51\u7edc\u8fde\u63a5\u9519\u8bef";
                break;
            }
            case 1005: {
                errorMessage = "\u8bf7\u6c42\u53d1\u9001\u9519\u8bef";
                break;
            }
            case 1006: {
                errorMessage = "\u54cd\u5e94\u6570\u636e\u8bfb\u53d6\u5931\u8d25";
                break;
            }
            case 1007: {
                errorMessage = "\u8fd4\u56de\u54cd\u5e94\u6570\u636e\u8fc7\u5927\uff0c\u6570\u636e\u6ea2\u51fa";
                break;
            }
            case 1008: {
                errorMessage = "\u5f53\u524d\u7f51\u7edc\u7c7b\u578b\u6709\u95ee\u9898";
                break;
            }
            case 1009: {
                errorMessage = "\u6570\u636e\u4e0d\u4e00\u81f4";
                break;
            }
            case 1010: {
                errorMessage = "\u8bf7\u6c42\u53d6\u6d88";
                break;
            }
            case 1011: {
                errorMessage = "\u7f51\u7edc\u8d85\u65f6\u9519\u8bef";
                break;
            }
            case 1012: {
                errorMessage = "\u7f51\u7edc\u8fde\u63a5\u8d85\u65f6";
                break;
            }
            case 1013: {
                errorMessage = "\u7f51\u7edc\u53d1\u9001\u8d85\u65f6";
                break;
            }
            case 1014: {
                errorMessage = "\u7f51\u7edc\u63a5\u6536\u8d85\u65f6";
                break;
            }
            case 1015: {
                errorMessage = "DNS\u89e3\u6790\u9519\u8bef";
                break;
            }
            case 1016: {
                errorMessage = "DNS\u89e3\u6790\u8d85\u65f6";
                break;
            }
            case 1017: {
                errorMessage = "\u7f51\u7edc\u5199\u9519\u8bef";
                break;
            }
            case 1018: {
                errorMessage = "SSL\u63e1\u624b\u9519\u8bef";
                break;
            }
            case 1019: {
                errorMessage = "SSL\u63e1\u624b\u8d85\u65f6";
                break;
            }
        }
        return errorMessage;
    }

    public final void setOnSynchronizationListener(OnSynchronizationListener listener) {
        this.I = listener;
    }

    public MapBaseIndoorMapInfo getFocusedBaseIndoorMapInfo() {
        if (null == this.j) {
            return null;
        }
        return this.j.r();
    }

    public MapBaseIndoorMapInfo.SwitchFloorError switchBaseIndoorMapFloor(String strFloor, String strID) {
        if (TextUtils.isEmpty((CharSequence)strFloor) || TextUtils.isEmpty((CharSequence)strID)) {
            return MapBaseIndoorMapInfo.SwitchFloorError.FLOOR_INFO_ERROR;
        }
        MapBaseIndoorMapInfo mapBaseIndoorMapInfo = this.getFocusedBaseIndoorMapInfo();
        if (null == mapBaseIndoorMapInfo) {
            return MapBaseIndoorMapInfo.SwitchFloorError.SWITCH_ERROR;
        }
        if (!strID.equals(mapBaseIndoorMapInfo.a)) {
            return MapBaseIndoorMapInfo.SwitchFloorError.FOCUSED_ID_ERROR;
        }
        ArrayList<String> floors = mapBaseIndoorMapInfo.getFloors();
        if (floors == null || !floors.contains(strFloor)) {
            return MapBaseIndoorMapInfo.SwitchFloorError.FLOOR_OVERLFLOW;
        }
        if (this.j != null && this.j.a(strFloor, strID)) {
            return MapBaseIndoorMapInfo.SwitchFloorError.SWITCH_OK;
        }
        return MapBaseIndoorMapInfo.SwitchFloorError.SWITCH_ERROR;
    }

    public boolean isBaseIndoorMapMode() {
        if (null == this.j) {
            return false;
        }
        return this.j.s();
    }

    public final void removeMarkerClickListener(OnMarkerClickListener listener) {
        if (this.y.contains(listener)) {
            this.y.remove(listener);
        }
    }

    public TileOverlay addTileLayer(TileOverlayOptions overlayOptions) {
        if (overlayOptions == null) {
            return null;
        }
        if (this.J != null) {
            this.J.b();
            this.J.a = null;
        }
        if (this.j != null && this.j.a(overlayOptions.a())) {
            TileOverlay overlay;
            this.J = overlay = overlayOptions.a(this);
            return overlay;
        }
        return null;
    }

    public void hideSDKLayer() {
        if (null == this.j) {
            return;
        }
        this.j.c();
    }

    public void showSDKLayer() {
        if (null == this.j) {
            return;
        }
        this.j.d();
    }

    public void changeLocationLayerOrder(boolean enable) {
        if (null == this.j) {
            return;
        }
        this.j.f(enable);
    }

    public void setCompassEnable(boolean enable) {
        if (null == this.j) {
            return;
        }
        this.j.h(enable);
    }

    boolean b() {
        if (this.j == null) {
            return false;
        }
        return this.j.f();
    }

    void a(TileOverlay mTileOverlay) {
        this.M.lock();
        try {
            if (mTileOverlay != null && this.J == mTileOverlay) {
                mTileOverlay.b();
                mTileOverlay.a = null;
                mTileOverlay = null;
                if (this.j != null) {
                    this.j.e();
                }
            }
        }
        finally {
            this.J = null;
            this.M.unlock();
        }
    }

    public float[] getProjectionMatrix() {
        if (null == this.j) {
            return null;
        }
        return this.j.M();
    }

    public float[] getViewMatrix() {
        if (null == this.j) {
            return null;
        }
        return this.j.N();
    }

    public void setOverlayUnderPoi(boolean isUnderPoi) {
        if (null == this.j) {
            return;
        }
        this.j.e(isUnderPoi);
    }

    public void switchLayerOrder(MapLayer srcLayer, MapLayer destLayer) {
        if (null == this.j) {
            return;
        }
        this.j.a(srcLayer, destLayer);
    }

    public boolean switchOverlayLayerAndNavigationLayer(boolean isSwitch) {
        if (null == this.j) {
            return false;
        }
        return this.j.g(isSwitch);
    }

    public void showOperateLayer(boolean bShow) {
        if (null == this.j) {
            return;
        }
        this.j.d(bShow);
    }

    public void setLayerClickable(MapLayer mapLayer, boolean isClickable) {
        if (null == this.j) {
            return;
        }
        this.j.a(mapLayer, isClickable);
    }

    public void cleanCache(int mapType) {
        if (null == this.j) {
            return;
        }
        this.j.a(mapType);
    }

    void c() {
        this.X = true;
        if (this.Y != null) {
            this.Y.c();
            this.Y = null;
        }
        this.hideInfoWindow();
    }

    public final String getMapApprovalNumber() {
        if (null == this.j) {
            return "";
        }
        return this.j.O();
    }

    public final String getMapCopyrightInfo() {
        if (null == this.j) {
            return "";
        }
        return this.j.Q();
    }

    public final String getMapMappingQualificationInfo() {
        if (null == this.j) {
            return "";
        }
        return this.j.P();
    }

    public final void setFontSizeLevel(int level) {
        if (this.j != null) {
            this.j.c(level);
        }
    }

    public final int getFontSizeLevel() {
        if (this.j != null) {
            this.j.G();
        }
        return 1;
    }

    public final void setMapLanguage(MapLanguage language) {
    }

    public MapLanguage getMapLanguage() {
        if (this.j != null) {
            int mapLanguage = this.j.R();
            return MapLanguage.values()[mapLanguage];
        }
        return MapLanguage.CHINESE;
    }

    public void setDEMEnable(boolean isEnabled) {
        if (this.j != null) {
            this.j.b(isEnabled);
        }
    }

    static /* synthetic */ com.baidu.mapsdkplatform.comapi.map.d a(BaiduMap x0) {
        return x0.j;
    }

    static /* synthetic */ boolean b(BaiduMap x0) {
        return x0.X;
    }

    static /* synthetic */ List c(BaiduMap x0) {
        return x0.k;
    }

    static /* synthetic */ List d(BaiduMap x0) {
        return x0.m;
    }

    static /* synthetic */ List e(BaiduMap x0) {
        return x0.l;
    }

    static /* synthetic */ void a(BaiduMap x0, InfoWindow x1) {
        x0.a(x1);
    }

    static /* synthetic */ OnMapStatusChangeListener f(BaiduMap x0) {
        return x0.q;
    }

    static /* synthetic */ OnSynchronizationListener g(BaiduMap x0) {
        return x0.I;
    }

    static /* synthetic */ onMapGestureListener h(BaiduMap x0) {
        return x0.s;
    }

    static /* synthetic */ OnMapTouchListener i(BaiduMap x0) {
        return x0.r;
    }

    static /* synthetic */ OnMapClickListener j(BaiduMap x0) {
        return x0.t;
    }

    static /* synthetic */ OnMapDoubleClickListener k(BaiduMap x0) {
        return x0.w;
    }

    static /* synthetic */ OnMapLongClickListener l(BaiduMap x0) {
        return x0.x;
    }

    static /* synthetic */ Projection a(BaiduMap x0, Projection x1) {
        x0.f = x1;
        return x0.f;
    }

    static /* synthetic */ boolean a(BaiduMap x0, boolean x1) {
        x0.V = x1;
        return x0.V;
    }

    static /* synthetic */ OnMapLoadedCallback m(BaiduMap x0) {
        return x0.u;
    }

    static /* synthetic */ OnMapRenderCallback n(BaiduMap x0) {
        return x0.v;
    }

    static /* synthetic */ OnMyLocationClickListener o(BaiduMap x0) {
        return x0.C;
    }

    static /* synthetic */ Map p(BaiduMap x0) {
        return x0.N;
    }

    static /* synthetic */ CopyOnWriteArrayList q(BaiduMap x0) {
        return x0.y;
    }

    static /* synthetic */ CopyOnWriteArrayList r(BaiduMap x0) {
        return x0.z;
    }

    static /* synthetic */ CopyOnWriteArrayList s(BaiduMap x0) {
        return x0.A;
    }

    static /* synthetic */ Marker t(BaiduMap x0) {
        return x0.P;
    }

    static /* synthetic */ Projection u(BaiduMap x0) {
        return x0.f;
    }

    static /* synthetic */ OnMarkerDragListener v(BaiduMap x0) {
        return x0.B;
    }

    static /* synthetic */ Marker a(BaiduMap x0, Marker x1) {
        x0.P = x1;
        return x0.P;
    }

    static /* synthetic */ Lock w(BaiduMap x0) {
        return x0.L;
    }

    static /* synthetic */ HeatMap x(BaiduMap x0) {
        return x0.K;
    }

    static /* synthetic */ OnMapDrawFrameCallback y(BaiduMap x0) {
        return x0.E;
    }

    static /* synthetic */ OnBaseIndoorMapListener z(BaiduMap x0) {
        return x0.F;
    }

    static /* synthetic */ OnMapRenderValidDataListener A(BaiduMap x0) {
        return x0.G;
    }

    static /* synthetic */ String a(BaiduMap x0, int x1) {
        return x0.a(x1);
    }

    static /* synthetic */ OnHeatMapDrawFrameCallBack B(BaiduMap x0) {
        return x0.H;
    }

    static /* synthetic */ Lock C(BaiduMap x0) {
        return x0.M;
    }

    static /* synthetic */ TileOverlay D(BaiduMap x0) {
        return x0.J;
    }

    static /* synthetic */ SnapshotReadyCallback E(BaiduMap x0) {
        return x0.D;
    }

    public static interface OnSynchronizationListener {
        public void onMapStatusChangeReason(int var1);
    }

    public static interface OnMapRenderValidDataListener {
        public void onMapRenderValidData(boolean var1, int var2, String var3);
    }

    public static interface OnBaseIndoorMapListener {
        public void onBaseIndoorMapMode(boolean var1, MapBaseIndoorMapInfo var2);
    }

    public static interface OnMapDrawFrameCallback {
        @Deprecated
        public void onMapDrawFrame(GL10 var1, MapStatus var2);

        public void onMapDrawFrame(MapStatus var1);
    }

    public static interface SnapshotReadyCallback {
        public void onSnapshotReady(Bitmap var1);
    }

    public static interface OnMyLocationClickListener {
        public boolean onMyLocationClick();
    }

    public static interface OnMarkerDragListener {
        public void onMarkerDrag(Marker var1);

        public void onMarkerDragEnd(Marker var1);

        public void onMarkerDragStart(Marker var1);
    }

    public static interface OnMultiPointClickListener {
        public boolean onMultiPointClick(MultiPoint var1, MultiPointItem var2);
    }

    public static interface OnPolylineClickListener {
        public boolean onPolylineClick(Polyline var1);
    }

    public static interface OnMarkerClickListener {
        public boolean onMarkerClick(Marker var1);
    }

    public static interface OnMapLongClickListener {
        public void onMapLongClick(LatLng var1);
    }

    public static interface OnMapDoubleClickListener {
        public void onMapDoubleClick(LatLng var1);
    }

    public static interface OnMapRenderCallback {
        public void onMapRenderFinished();
    }

    public static interface OnHeatMapDrawFrameCallBack {
        public void frameIndex(int var1);
    }

    public static interface OnMapLoadedCallback {
        public void onMapLoaded();
    }

    public static interface OnMapClickListener {
        public void onMapClick(LatLng var1);

        public void onMapPoiClick(MapPoi var1);
    }

    public static interface onMapGestureListener {
        public boolean onMapScroll(Point var1, Point var2, MapStatus var3);

        public boolean onMapDoubleTouch(Point var1, MapStatus var2);

        public boolean onMapTwoClick(Point var1, Point var2, MapStatus var3);

        public boolean onMapKneading(Point var1, Point var2, MapStatus var3);

        public boolean onMapOverLooking(Point var1, Point var2, MapStatus var3);

        public boolean onMapFling(MotionEvent var1, float var2, float var3, MapStatus var4);

        public void onMapStatusChangeFinish(MapStatus var1);
    }

    public static interface OnMapTouchListener {
        public void onTouch(MotionEvent var1);
    }

    public static interface OnMapStatusChangeListener {
        public static final int REASON_GESTURE = 1;
        public static final int REASON_API_ANIMATION = 2;
        public static final int REASON_DEVELOPER_ANIMATION = 3;

        public void onMapStatusChangeStart(MapStatus var1);

        public void onMapStatusChangeStart(MapStatus var1, int var2);

        public void onMapStatusChange(MapStatus var1);

        public void onMapStatusChangeFinish(MapStatus var1);
    }
}

