/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.map;

import android.os.Bundle;
import com.baidu.mapapi.map.BitmapDescriptor;
import com.baidu.mapapi.map.Overlay;
import com.baidu.mapapi.model.CoordUtil;
import com.baidu.mapapi.model.LatLng;
import com.baidu.mapapi.model.LatLngBounds;
import com.baidu.mapsdkplatform.comapi.map.i;
import com.baidu.platform.comapi.basestruct.GeoPoint;

public final class GroundOverlay
extends Overlay {
    private static final String j = GroundOverlay.class.getSimpleName();
    int a;
    BitmapDescriptor b;
    LatLng c;
    double d;
    double e;
    float f;
    float g;
    LatLngBounds h;
    float i;

    GroundOverlay() {
        this.type = com.baidu.mapsdkplatform.comapi.map.i.d;
    }

    public void setImage(BitmapDescriptor image) {
        if (image == null) {
            throw new IllegalArgumentException("BDMapSDKException: image can not be null");
        }
        this.b = image;
        this.listener.c(this);
    }

    public BitmapDescriptor getImage() {
        return this.b;
    }

    public void setPosition(LatLng latLng) {
        if (latLng == null) {
            throw new IllegalArgumentException("BDMapSDKException: position can not be null");
        }
        this.a = 2;
        this.c = latLng;
        this.listener.c(this);
    }

    public LatLng getPosition() {
        return this.c;
    }

    public void setDimensions(int width) {
        this.d = width;
        this.e = 2.147483647E9;
        this.listener.c(this);
    }

    public void setDimensions(int width, int height) {
        this.d = width;
        this.e = height;
        this.listener.c(this);
    }

    public double getWidth() {
        return this.d;
    }

    public double getHeight() {
        return this.e;
    }

    public void setAnchor(float anchorX, float anchorY) {
        if (anchorX < 0.0f || anchorX > 1.0f) {
            return;
        }
        if (anchorY < 0.0f || anchorY > 1.0f) {
            return;
        }
        this.f = anchorX;
        this.g = anchorY;
        this.listener.c(this);
    }

    public float getAnchorX() {
        return this.f;
    }

    public float getAnchorY() {
        return this.g;
    }

    public void setPositionFromBounds(LatLngBounds bounds) {
        if (bounds == null) {
            throw new IllegalArgumentException("BDMapSDKException: bounds can not be null");
        }
        this.a = 1;
        this.h = bounds;
        this.listener.c(this);
    }

    public LatLngBounds getBounds() {
        return this.h;
    }

    public void setTransparency(float transparency) {
        if (transparency > 1.0f || transparency < 0.0f) {
            return;
        }
        this.i = transparency;
        this.listener.c(this);
    }

    public float getTransparency() {
        return this.i;
    }

    @Override
    Bundle a(Bundle b2) {
        super.a(b2);
        b2.putBundle("image_info", this.b.b());
        if (this.a == 1) {
            GeoPoint mcLocationLB = CoordUtil.ll2mc(this.h.southwest);
            double longitudeLB = mcLocationLB.getLongitudeE6();
            double latitudeLB = mcLocationLB.getLatitudeE6();
            GeoPoint mcLocationRT = CoordUtil.ll2mc(this.h.northeast);
            double longitudeRT = mcLocationRT.getLongitudeE6();
            double latitudeRT = mcLocationRT.getLatitudeE6();
            this.d = longitudeRT - longitudeLB;
            this.e = latitudeRT - latitudeLB;
            GeoPoint mcLocationMid = new GeoPoint(latitudeLB + this.e / 2.0, longitudeLB + this.d / 2.0);
            this.c = CoordUtil.mc2ll(mcLocationMid);
            this.f = 0.5f;
            this.g = 0.5f;
        }
        if (this.d <= 0.0 || this.e <= 0.0) {
            throw new IllegalStateException("BDMapSDKException: when you add ground overlay, the width and height must greater than 0");
        }
        b2.putDouble("x_distance", this.d);
        if (this.e == 2.147483647E9) {
            this.e = (int)(this.d * (double)this.b.a.getHeight() / (double)this.b.a.getWidth());
        }
        b2.putDouble("y_distance", this.e);
        GeoPoint gp = CoordUtil.ll2mc(this.c);
        b2.putDouble("location_x", gp.getLongitudeE6());
        b2.putDouble("location_y", gp.getLatitudeE6());
        b2.putFloat("anchor_x", this.f);
        b2.putFloat("anchor_y", this.g);
        b2.putFloat("transparency", this.i);
        return b2;
    }
}

