/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.map;

import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.Point;
import android.os.Bundle;
import android.support.v4.util.LongSparseArray;
import android.util.SparseIntArray;
import com.baidu.mapapi.map.BaiduMap;
import com.baidu.mapapi.map.Gradient;
import com.baidu.mapapi.map.HeatMapAnimation;
import com.baidu.mapapi.map.HeatMapData;
import com.baidu.mapapi.map.Tile;
import com.baidu.mapapi.map.WeightedLatLng;
import com.baidu.mapapi.map.m;
import com.baidu.mapapi.map.o;
import com.baidu.mapapi.map.v;
import com.baidu.mapapi.model.LatLng;
import com.baidu.platform.comapi.util.SysOSUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class HeatMap {
    private static final String b = HeatMap.class.getSimpleName();
    private static final SparseIntArray c = new SparseIntArray();
    private static final int[] d;
    private static final float[] e;
    public static final int DEFAULT_MAX_HIGH = 0;
    private int f = 200;
    private v<WeightedLatLng> g;
    private Collection<WeightedLatLng> h;
    private ArrayList<Collection<WeightedLatLng>> i;
    private float j;
    private float k;
    protected boolean mIsSetMaxIntensity;
    private HeatMapAnimation l;
    private HeatMapAnimation m;
    private int n;
    private Gradient o;
    private double p;
    private m q;
    private int[] r;
    private float[] s;
    private double[] t;
    private double[] u;
    private List<double[]> v;
    private HashMap<String, Tile> w;
    private ExecutorService x;
    private HashSet<String> y;
    BaiduMap a;
    private int z = SysOSUtil.getInstance().getScreenWidth() / 2;
    public static final int DEFAULT_RADIUS = 12;
    public static final double DEFAULT_OPACITY = 0.6;
    public static final Gradient DEFAULT_GRADIENT;
    private static int A;

    private HeatMap(Builder builder) {
        this.w = new HashMap();
        this.x = Executors.newFixedThreadPool(1);
        this.y = new HashSet();
        this.i = builder.b;
        this.n = builder.c;
        this.mIsSetMaxIntensity = builder.i;
        if (!this.mIsSetMaxIntensity && this.i != null) {
            this.v = new ArrayList<double[]>();
            for (int i2 = 0; i2 < this.i.size(); ++i2) {
                this.h = this.i.get(i2);
                this.q = HeatMap.d(this.h);
                this.v.add(this.a(this.n));
            }
        }
        this.h = builder.a;
        if (!this.mIsSetMaxIntensity && this.h != null) {
            this.b(this.h);
        }
        this.m = builder.j;
        this.l = builder.k;
        this.f = builder.f;
        this.j = builder.g;
        this.k = builder.h;
        this.o = builder.d;
        this.p = builder.e;
        this.t = HeatMap.a(this.n, (double)this.n / 3.0);
        this.a(this.o);
    }

    public void removeHeatMap() {
        if (this.a != null) {
            this.a.a(this);
        }
        if (this.i != null) {
            this.i.clear();
        }
        if (this.h != null) {
            this.h.clear();
        }
    }

    private void b(Collection<WeightedLatLng> data) {
        this.h = data;
        if (this.h.isEmpty()) {
            throw new IllegalArgumentException("BDMapSDKException: No input points.");
        }
        this.q = HeatMap.d(this.h);
        this.g = new v(this.q);
        for (WeightedLatLng l2 : this.h) {
            this.g.a(l2);
        }
        this.u = this.a(this.n);
    }

    private static Collection<WeightedLatLng> c(Collection<LatLng> data) {
        ArrayList<WeightedLatLng> weightedData = new ArrayList<WeightedLatLng>();
        for (LatLng l2 : data) {
            weightedData.add(new WeightedLatLng(l2));
        }
        return weightedData;
    }

    protected HeatMapData getData(int index, int zoom) {
        if (zoom > 22 || zoom < 4) {
            return null;
        }
        if (this.i == null && this.h == null) {
            return null;
        }
        if (this.i != null) {
            return this.b(index, zoom);
        }
        if (this.h != null) {
            return this.a(index, zoom);
        }
        return null;
    }

    private HeatMapData a(int index, int zoom) {
        float oneFrameMaxIntensity = 0.0f;
        if (this.h == null) {
            return null;
        }
        if (this.u != null) {
            oneFrameMaxIntensity = (float)this.u[zoom];
        }
        return new HeatMapData(this.h, oneFrameMaxIntensity);
    }

    private HeatMapData b(int index, int zoom) {
        if (this.i == null) {
            return null;
        }
        if (index >= this.i.size()) {
            return null;
        }
        Collection<WeightedLatLng> data = this.i.get(index);
        float frameMaxIntensity = 0.0f;
        if (this.v != null && this.v.size() > index) {
            double[] maxIntensityArray = this.v.get(index);
            frameMaxIntensity = (float)maxIntensityArray[zoom];
        }
        return new HeatMapData(data, frameMaxIntensity);
    }

    synchronized void a() {
        this.y.clear();
        this.w.clear();
    }

    private synchronized void a(String key, Tile tile) {
        this.w.put(key, tile);
    }

    private synchronized void d() {
        this.w.clear();
    }

    void b() {
        this.d();
    }

    void c() {
        this.x.shutdownNow();
    }

    private void a(int x2, int y2, int zoom) {
        double tileWidth = c.get(zoom);
        double padding = tileWidth * (double)this.n / 256.0;
        double tileWidthPadded = tileWidth + 2.0 * padding;
        double bucketWidth = tileWidthPadded / (double)(256 + this.n * 2);
        if (x2 < 0 || y2 < 0) {
            return;
        }
        double minX = (double)x2 * tileWidth - padding;
        double maxX = (double)(x2 + 1) * tileWidth + padding;
        double minY = (double)y2 * tileWidth - padding;
        double maxY = (double)(y2 + 1) * tileWidth + padding;
        m tileBounds = new m(minX, maxX, minY, maxY);
        m paddedBounds = new m(this.q.a - padding, this.q.c + padding, this.q.b - padding, this.q.d + padding);
        if (!tileBounds.a(paddedBounds)) {
            return;
        }
        Collection<WeightedLatLng> points = this.g.a(tileBounds);
        if (points.isEmpty()) {
            return;
        }
        double[][] intensity = new double[256 + this.n * 2][256 + this.n * 2];
        for (WeightedLatLng w2 : points) {
            Point p2 = w2.getPoint();
            int bucketX = (int)(((double)p2.x - minX) / bucketWidth);
            int bucketY = (int)((maxY - (double)p2.y) / bucketWidth);
            if (bucketX >= 256 + this.n * 2) {
                bucketX = 256 + this.n * 2 - 1;
            }
            if (bucketY >= 256 + this.n * 2) {
                bucketY = 256 + this.n * 2 - 1;
            }
            double[] dArray = intensity[bucketX];
            int n2 = bucketY;
            dArray[n2] = dArray[n2] + w2.intensity;
        }
        double[][] convolved = HeatMap.a(intensity, this.t);
        Bitmap bitmap = HeatMap.a(convolved, this.r, this.u[zoom - 1]);
        Tile t2 = HeatMap.a(bitmap);
        bitmap.recycle();
        bitmap = null;
        String key = x2 + "_" + y2 + "_" + zoom;
        this.a(key, t2);
        if (this.w.size() > A) {
            this.a();
        }
        if (this.a != null) {
            this.a.a();
        }
    }

    private void a(Gradient gradient) {
        this.o = gradient;
        this.r = gradient.a(this.p);
        this.s = gradient.a();
    }

    private double[] a(int radius) {
        int i2;
        double[] maxIntensityArray = new double[22];
        for (i2 = 4; i2 < 11; ++i2) {
            maxIntensityArray[i2] = HeatMap.a(this.h, this.q, radius, (int)(1280.0 * Math.pow(2.0, i2 - 3)));
            if (i2 != 4) continue;
            for (int j2 = 0; j2 < i2; ++j2) {
                maxIntensityArray[j2] = maxIntensityArray[i2];
            }
        }
        for (i2 = 11; i2 < 22; ++i2) {
            maxIntensityArray[i2] = maxIntensityArray[10];
        }
        return maxIntensityArray;
    }

    private static Tile a(Bitmap bitmap) {
        ByteBuffer buffer = ByteBuffer.allocate(bitmap.getWidth() * bitmap.getHeight() * 4);
        bitmap.copyPixelsToBuffer((Buffer)buffer);
        byte[] bitmapData = buffer.array();
        return new Tile(256, 256, bitmapData);
    }

    private static m d(Collection<WeightedLatLng> points) {
        Iterator<WeightedLatLng> iter = points.iterator();
        WeightedLatLng first = iter.next();
        double minX = first.getPoint().x;
        double maxX = first.getPoint().x;
        double minY = first.getPoint().y;
        double maxY = first.getPoint().y;
        while (iter.hasNext()) {
            WeightedLatLng l2 = iter.next();
            double x2 = l2.getPoint().x;
            double y2 = l2.getPoint().y;
            if (x2 < minX) {
                minX = x2;
            }
            if (x2 > maxX) {
                maxX = x2;
            }
            if (y2 < minY) {
                minY = y2;
            }
            if (!(y2 > maxY)) continue;
            maxY = y2;
        }
        return new m(minX, maxX, minY, maxY);
    }

    private static double[] a(int radius, double sd) {
        double[] kernel = new double[radius * 2 + 1];
        for (int i2 = -radius; i2 <= radius; ++i2) {
            kernel[i2 + radius] = Math.exp((double)(-i2 * i2) / (2.0 * sd * sd));
        }
        return kernel;
    }

    private static double[][] a(double[][] grid, double[] kernel) {
        int initial;
        double val;
        int y2;
        int x2;
        int radius = (int)Math.floor((double)kernel.length / 2.0);
        int dimOld = grid.length;
        int dim = dimOld - 2 * radius;
        int lowerLimit = radius;
        int upperLimit = radius + dim - 1;
        double[][] intermediate = new double[dimOld][dimOld];
        for (x2 = 0; x2 < dimOld; ++x2) {
            for (y2 = 0; y2 < dimOld; ++y2) {
                val = grid[x2][y2];
                if (val == 0.0) continue;
                int xUpperLimit = (upperLimit < x2 + radius ? upperLimit : x2 + radius) + 1;
                for (int x22 = initial = lowerLimit > x2 - radius ? lowerLimit : x2 - radius; x22 < xUpperLimit; ++x22) {
                    double[] dArray = intermediate[x22];
                    int n2 = y2;
                    dArray[n2] = dArray[n2] + val * kernel[x22 - (x2 - radius)];
                }
            }
        }
        double[][] outputGrid = new double[dim][dim];
        for (x2 = lowerLimit; x2 < upperLimit + 1; ++x2) {
            for (y2 = 0; y2 < dimOld; ++y2) {
                val = intermediate[x2][y2];
                if (val == 0.0) continue;
                int yUpperLimit = (upperLimit < y2 + radius ? upperLimit : y2 + radius) + 1;
                for (int y22 = initial = lowerLimit > y2 - radius ? lowerLimit : y2 - radius; y22 < yUpperLimit; ++y22) {
                    double[] dArray = outputGrid[x2 - radius];
                    int n3 = y22 - radius;
                    dArray[n3] = dArray[n3] + val * kernel[y22 - (y2 - radius)];
                }
            }
        }
        return outputGrid;
    }

    private static Bitmap a(double[][] grid, int[] colorMap, double max) {
        int maxColor = colorMap[colorMap.length - 1];
        double colorMapScaling = (double)(colorMap.length - 1) / max;
        int dim = grid.length;
        int[] colors = new int[dim * dim];
        for (int i2 = 0; i2 < dim; ++i2) {
            for (int j2 = 0; j2 < dim; ++j2) {
                double val = grid[j2][i2];
                int index = i2 * dim + j2;
                int col = (int)(val * colorMapScaling);
                if (val != 0.0) {
                    if (col < colorMap.length) {
                        colors[index] = colorMap[col];
                        continue;
                    }
                    colors[index] = maxColor;
                    continue;
                }
                colors[index] = 0;
            }
        }
        Bitmap tile = Bitmap.createBitmap((int)dim, (int)dim, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        tile.setPixels(colors, 0, dim, 0, 0, dim, dim);
        return tile;
    }

    private static double a(Collection<WeightedLatLng> points, m bounds, int radius, int screenDim) {
        double maxX = bounds.c;
        double minX = bounds.a;
        double maxY = bounds.d;
        double minY = bounds.b;
        double boundsDim = maxX - minX > maxY - minY ? maxX - minX : maxY - minY;
        int nBuckets = (int)((double)(screenDim / (2 * radius)) + 0.5);
        double scale = (double)nBuckets / boundsDim;
        LongSparseArray buckets = new LongSparseArray();
        double max = 0.0;
        for (WeightedLatLng l2 : points) {
            Double value;
            double x2 = l2.getPoint().x;
            double y2 = l2.getPoint().y;
            int xBucket = (int)((x2 - minX) * scale);
            int yBucket = (int)((y2 - minY) * scale);
            LongSparseArray column = (LongSparseArray)buckets.get((long)xBucket);
            if (column == null) {
                column = new LongSparseArray();
                buckets.put((long)xBucket, (Object)column);
            }
            if ((value = (Double)column.get((long)yBucket)) == null) {
                value = 0.0;
            }
            value = value + l2.intensity;
            column.put((long)yBucket, (Object)value);
            if (!(value > max)) continue;
            max = value;
        }
        return max;
    }

    public Bundle toBundle() {
        Bundle b2 = new Bundle();
        b2.putInt("grid_size", this.z);
        b2.putFloat("point_size", (float)(this.n * 2));
        b2.putFloat("max_hight", (float)this.f);
        b2.putFloat("alpha", (float)this.p);
        if (this.i != null) {
            b2.putInt("frame_count", this.i.size());
        } else if (this.h != null) {
            b2.putInt("frame_count", 1);
        }
        b2.putIntArray("color_array", this.r);
        b2.putFloatArray("color_start_points", this.s);
        b2.putBoolean("is_need_init_animation", this.m.getIsAnimation());
        b2.putBoolean("is_need_frame_animation", this.l.getIsAnimation());
        b2.putInt("init_animation_duration", this.m.getDuration());
        b2.putInt("init_animation_type", this.m.getAnimationType());
        b2.putInt("frame_animation_duration", this.l.getDuration());
        b2.putInt("frame_animation_type", this.l.getAnimationType());
        b2.putFloat("max_intentity", this.j);
        b2.putFloat("min_intentity", this.k);
        return b2;
    }

    /* synthetic */ HeatMap(Builder x0, o x1) {
        this(x0);
    }

    static /* synthetic */ void a(HeatMap x0, int x1, int x2, int x3) {
        x0.a(x1, x2, x3);
    }

    static {
        c.put(3, 0x800000);
        c.put(4, 0x400000);
        c.put(5, 0x200000);
        c.put(6, 0x100000);
        c.put(7, 524288);
        c.put(8, 262144);
        c.put(9, 131072);
        c.put(10, 65536);
        c.put(11, 32768);
        c.put(12, 16384);
        c.put(13, 8192);
        c.put(14, 4096);
        c.put(15, 2048);
        c.put(16, 1024);
        c.put(17, 512);
        c.put(18, 256);
        c.put(19, 128);
        c.put(20, 64);
        d = new int[]{Color.rgb((int)0, (int)0, (int)200), Color.rgb((int)0, (int)225, (int)0), Color.rgb((int)255, (int)0, (int)0)};
        e = new float[]{0.08f, 0.4f, 1.0f};
        DEFAULT_GRADIENT = new Gradient(d, e);
        A = 0;
    }

    public static class Builder {
        private Collection<WeightedLatLng> a;
        private ArrayList<Collection<WeightedLatLng>> b;
        private int c = 12;
        private Gradient d = DEFAULT_GRADIENT;
        private double e = 0.6;
        private int f = 0;
        private float g = 1.0f;
        private float h = 0.0f;
        private boolean i = false;
        private HeatMapAnimation j = new HeatMapAnimation(false, 100, HeatMapAnimation.AnimationType.Linear);
        private HeatMapAnimation k = new HeatMapAnimation(false, 100, HeatMapAnimation.AnimationType.Linear);

        public Builder maxIntensity(float intensity) {
            this.g = intensity;
            this.i = true;
            return this;
        }

        public Builder minIntensity(float intensity) {
            this.h = intensity;
            return this;
        }

        public Builder initAnimation(HeatMapAnimation animation) {
            this.j = animation;
            return this;
        }

        public Builder frameAnimation(HeatMapAnimation animation) {
            this.k = animation;
            return this;
        }

        public Builder data(Collection<LatLng> val) {
            if (val == null || val.isEmpty()) {
                throw new IllegalArgumentException("BDMapSDKException: No input points.");
            }
            if (val.contains(null)) {
                throw new IllegalArgumentException("BDMapSDKException: input points can not contain null.");
            }
            return this.weightedData(HeatMap.c(val));
        }

        public Builder datas(List<List<LatLng>> latlngs) {
            if (latlngs == null || latlngs.isEmpty()) {
                throw new IllegalArgumentException("BDMapSDKException: No input datas.");
            }
            if (latlngs.contains(null)) {
                throw new IllegalArgumentException("BDMapSDKException: input points can not contain null.");
            }
            return this.weightedDatas(latlngs);
        }

        public Builder weightedData(Collection<WeightedLatLng> val) {
            if (val == null || val.isEmpty()) {
                throw new IllegalArgumentException("BDMapSDKException: No input points.");
            }
            if (val.contains(null)) {
                throw new IllegalArgumentException("BDMapSDKException: input points can not contain null.");
            }
            this.a = val;
            return this;
        }

        public Builder weightedDatas(List<List<LatLng>> vals) {
            if (vals == null || vals.isEmpty()) {
                throw new IllegalArgumentException("BDMapSDKException: No input points.");
            }
            if (vals.contains(null)) {
                throw new IllegalArgumentException("BDMapSDKException: input points can not contain null.");
            }
            ArrayList<Collection> tempDatas = new ArrayList<Collection>();
            for (Collection collection : vals) {
                Collection val = HeatMap.c(collection);
                tempDatas.add(val);
                this.b = tempDatas;
            }
            return this;
        }

        public Builder radius(int val) {
            if (this.c < 10 || this.c > 50) {
                throw new IllegalArgumentException("BDMapSDKException: Radius not within bounds.");
            }
            this.c = val;
            return this;
        }

        public Builder maxHigh(int val) {
            if (this.f < 0 || this.f > 200) {
                throw new IllegalArgumentException("BDMapSDKException: max_high not within bounds.");
            }
            this.f = val;
            return this;
        }

        public Builder gradient(Gradient val) {
            if (val == null) {
                throw new IllegalArgumentException("BDMapSDKException: gradient can not be null");
            }
            this.d = val;
            return this;
        }

        public Builder opacity(double val) {
            this.e = val;
            if (this.e < 0.0 || this.e > 1.0) {
                throw new IllegalArgumentException("BDMapSDKException: Opacity must be in range [0, 1]");
            }
            return this;
        }

        public HeatMap build() {
            if (this.a == null && this.b == null) {
                throw new IllegalStateException("BDMapSDKException: No input data: you must use either .data or .weightedData before building");
            }
            return new HeatMap(this, null);
        }
    }
}

