/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.map;

import android.os.Bundle;
import com.baidu.mapapi.map.WeightedLatLng;
import java.util.Collection;

public class HeatMapData {
    private double[] a;
    private double[] b;
    private double[] c;
    private float d;

    public HeatMapData(Collection<WeightedLatLng> data, float maxIntensity) {
        int length = data.size();
        int x_Count = 0;
        int y_Count = 0;
        int z_Count = 0;
        this.a = new double[length];
        this.b = new double[length];
        this.c = new double[length];
        for (WeightedLatLng wll : data) {
            this.a[x_Count++] = wll.getPoint().x;
            this.b[y_Count++] = wll.getPoint().y;
            this.c[z_Count++] = wll.getIntensity();
        }
        this.d = maxIntensity;
    }

    public Bundle toBundle() {
        Bundle bundle_heatmap = new Bundle();
        bundle_heatmap.putDoubleArray("x_array", this.a);
        bundle_heatmap.putDoubleArray("y_array", this.b);
        bundle_heatmap.putDoubleArray("z_array", this.c);
        bundle_heatmap.putFloat("max_intentity", this.d);
        return bundle_heatmap;
    }
}

