/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.map;

import android.graphics.Point;
import android.os.Parcel;
import android.os.Parcelable;
import com.baidu.mapapi.map.WinRound;
import com.baidu.mapapi.map.p;
import com.baidu.mapapi.model.CoordUtil;
import com.baidu.mapapi.model.LatLng;
import com.baidu.mapapi.model.LatLngBounds;
import com.baidu.mapsdkplatform.comapi.map.x;
import com.baidu.platform.comapi.basestruct.GeoPoint;

public final class MapStatus
implements Parcelable {
    public final float rotate;
    public final LatLng target;
    public final float overlook;
    public final float zoom;
    public final Point targetScreen;
    public final LatLngBounds bound;
    public WinRound winRound;
    private double b;
    private double c;
    x a;
    public static final Parcelable.Creator<MapStatus> CREATOR = new p();

    MapStatus(float rotate, LatLng target, float overlook, float zoom, Point targetScreen, LatLngBounds bound) {
        this.rotate = rotate;
        this.target = target;
        this.overlook = overlook;
        this.zoom = zoom;
        this.targetScreen = targetScreen;
        if (this.target != null) {
            this.b = CoordUtil.ll2mc(this.target).getLongitudeE6();
            this.c = CoordUtil.ll2mc(this.target).getLatitudeE6();
        }
        this.bound = bound;
    }

    MapStatus(float rotate, LatLng target, float overlook, float zoom, Point targetScreen, double x2, double y2, LatLngBounds bound) {
        this.rotate = rotate;
        this.target = target;
        this.overlook = overlook;
        this.zoom = zoom;
        this.targetScreen = targetScreen;
        this.b = x2;
        this.c = y2;
        this.bound = bound;
    }

    MapStatus(float rotate, LatLng target, float overlook, float zoom, Point targetScreen, x msi, double x2, double y2, LatLngBounds bound, WinRound winRound) {
        this.rotate = rotate;
        this.target = target;
        this.overlook = overlook;
        this.zoom = zoom;
        this.targetScreen = targetScreen;
        this.a = msi;
        this.b = x2;
        this.c = y2;
        this.bound = bound;
        this.winRound = winRound;
    }

    protected MapStatus(Parcel in) {
        this.rotate = in.readFloat();
        this.target = (LatLng)in.readParcelable(LatLng.class.getClassLoader());
        this.overlook = in.readFloat();
        this.zoom = in.readFloat();
        this.targetScreen = (Point)in.readParcelable(Point.class.getClassLoader());
        this.bound = (LatLngBounds)in.readParcelable(LatLngBounds.class.getClassLoader());
        this.b = in.readDouble();
        this.c = in.readDouble();
    }

    double a() {
        return this.b;
    }

    double b() {
        return this.c;
    }

    static MapStatus a(x inner) {
        if (inner == null) {
            return null;
        }
        float rotate = inner.b;
        double lat = inner.e;
        double lon = inner.d;
        GeoPoint gp = new GeoPoint(lat, lon);
        LatLng target = CoordUtil.mc2ll(gp);
        float overlook = inner.c;
        float zoom = inner.a;
        Point targetScreen = new Point(inner.f, inner.g);
        x msi = inner;
        LatLng lb = CoordUtil.mc2ll(new GeoPoint(inner.k.e.getDoubleY(), inner.k.e.getDoubleX()));
        LatLng lt = CoordUtil.mc2ll(new GeoPoint(inner.k.f.getDoubleY(), inner.k.f.getDoubleX()));
        LatLng rb = CoordUtil.mc2ll(new GeoPoint(inner.k.h.getDoubleY(), inner.k.h.getDoubleX()));
        LatLng rt = CoordUtil.mc2ll(new GeoPoint(inner.k.g.getDoubleY(), inner.k.g.getDoubleX()));
        LatLngBounds.Builder builder = new LatLngBounds.Builder();
        builder.include(lb);
        builder.include(lt);
        builder.include(rb);
        builder.include(rt);
        WinRound winRound = inner.j;
        return new MapStatus(rotate, target, overlook, zoom, targetScreen, msi, lon, lat, builder.build(), winRound);
    }

    x c() {
        x inner = new x();
        return this.b(inner);
    }

    x b(x status) {
        if (null == status) {
            return null;
        }
        if (this.rotate != -2.1474836E9f) {
            status.b = (int)this.rotate;
        }
        if (this.zoom != -2.1474836E9f) {
            status.a = this.zoom;
        }
        if (this.overlook != -2.1474836E9f) {
            status.c = (int)this.overlook;
        }
        if (this.target != null) {
            status.d = this.b;
            status.e = this.c;
        }
        if (this.targetScreen != null) {
            status.f = this.targetScreen.x;
            status.g = this.targetScreen.y;
        }
        return status;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeFloat(this.rotate);
        dest.writeParcelable((Parcelable)this.target, flags);
        dest.writeFloat(this.overlook);
        dest.writeFloat(this.zoom);
        dest.writeParcelable((Parcelable)this.targetScreen, flags);
        dest.writeParcelable((Parcelable)this.bound, flags);
        dest.writeDouble(this.b);
        dest.writeDouble(this.c);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.target != null) {
            sb.append("target lat: " + this.target.latitude + "\n");
            sb.append("target lng: " + this.target.longitude + "\n");
        }
        if (this.targetScreen != null) {
            sb.append("target screen x: " + this.targetScreen.x + "\n");
            sb.append("target screen y: " + this.targetScreen.y + "\n");
        }
        sb.append("zoom: " + this.zoom + "\n");
        sb.append("rotate: " + this.rotate + "\n");
        sb.append("overlook: " + this.overlook + "\n");
        return sb.toString();
    }

    public static final class Builder {
        private float a = -2.1474836E9f;
        private LatLng b = null;
        private float c = -2.1474836E9f;
        private float d = -2.1474836E9f;
        private Point e = null;
        private LatLngBounds f = null;
        private double g = 0.0;
        private double h = 0.0;
        private final float i = 15.0f;

        public Builder() {
        }

        public Builder(MapStatus previous) {
            this.a = previous.rotate;
            this.b = previous.target;
            this.c = previous.overlook;
            this.d = previous.zoom;
            this.e = previous.targetScreen;
            this.g = previous.a();
            this.h = previous.b();
        }

        public Builder rotate(float rotate) {
            this.a = rotate;
            return this;
        }

        public Builder target(LatLng location) {
            this.b = location;
            return this;
        }

        public Builder overlook(float overlook) {
            this.c = overlook;
            return this;
        }

        public Builder zoom(float zoom) {
            this.d = this.a(zoom);
            return this;
        }

        public Builder targetScreen(Point p2) {
            this.e = p2;
            return this;
        }

        public MapStatus build() {
            return new MapStatus(this.a, this.b, this.c, this.d, this.e, this.f);
        }

        private float a(float zoom) {
            if (15.0f == zoom) {
                zoom = 15.5f;
            }
            return zoom;
        }
    }
}

