/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.map;

import android.graphics.Point;
import com.baidu.mapapi.map.MapStatus;
import com.baidu.mapapi.map.MapStatusUpdate;
import com.baidu.mapapi.model.LatLng;
import com.baidu.mapapi.model.LatLngBounds;

public final class MapStatusUpdateFactory {
    MapStatusUpdateFactory() {
    }

    public static MapStatusUpdate newMapStatus(MapStatus mapStatus) {
        if (mapStatus == null) {
            return null;
        }
        MapStatusUpdate update = new MapStatusUpdate(1);
        update.a = mapStatus;
        return update;
    }

    public static MapStatusUpdate newLatLng(LatLng latLng) {
        if (latLng == null) {
            return null;
        }
        MapStatusUpdate update = new MapStatusUpdate(2);
        update.b = latLng;
        return update;
    }

    public static MapStatusUpdate newLatLngBounds(LatLngBounds bounds) {
        if (bounds == null) {
            return null;
        }
        MapStatusUpdate update = new MapStatusUpdate(3);
        update.c = bounds;
        return update;
    }

    public static MapStatusUpdate newLatLngBounds(LatLngBounds bounds, int width, int height) {
        if (bounds == null || width <= 0 || height <= 0) {
            return null;
        }
        MapStatusUpdate update = new MapStatusUpdate(9);
        update.c = bounds;
        update.d = width;
        update.e = height;
        return update;
    }

    public static MapStatusUpdate newLatLngZoom(LatLng latLng, float zoom) {
        MapStatusUpdate update = new MapStatusUpdate(4);
        if (latLng == null) {
            return null;
        }
        update.b = latLng;
        update.f = zoom;
        return update;
    }

    public static MapStatusUpdate scrollBy(int xPixel, int yPixel) {
        MapStatusUpdate update = new MapStatusUpdate(5);
        update.g = xPixel;
        update.h = yPixel;
        return update;
    }

    public static MapStatusUpdate zoomBy(float amount) {
        MapStatusUpdate update = new MapStatusUpdate(6);
        update.i = amount;
        return update;
    }

    public static MapStatusUpdate zoomBy(float amount, Point focus) {
        if (focus == null) {
            return null;
        }
        MapStatusUpdate update = new MapStatusUpdate(7);
        update.i = amount;
        update.j = focus;
        return update;
    }

    public static MapStatusUpdate zoomIn() {
        MapStatusUpdate update = new MapStatusUpdate(6);
        update.i = 1.0f;
        return update;
    }

    public static MapStatusUpdate zoomOut() {
        MapStatusUpdate update = new MapStatusUpdate(6);
        update.i = -1.0f;
        return update;
    }

    public static MapStatusUpdate zoomTo(float zoom) {
        MapStatusUpdate update = new MapStatusUpdate(8);
        update.f = zoom;
        return update;
    }

    public static MapStatusUpdate newLatLngBounds(LatLngBounds bounds, int paddingLeft, int paddingTop, int paddingRight, int paddingBottom) {
        if (bounds == null) {
            return null;
        }
        MapStatusUpdate update = new MapStatusUpdate(10);
        update.c = bounds;
        update.k = paddingLeft;
        update.l = paddingTop;
        update.m = paddingRight;
        update.n = paddingBottom;
        return update;
    }

    public static MapStatusUpdate newLatLngZoom(LatLngBounds bounds, int paddingLeft, int paddingTop, int paddingRight, int paddingBottom) {
        if (bounds == null) {
            return null;
        }
        MapStatusUpdate update = new MapStatusUpdate(11);
        update.c = bounds;
        update.k = paddingLeft;
        update.l = paddingTop;
        update.m = paddingRight;
        update.n = paddingBottom;
        return update;
    }
}

