/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.map;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.NinePatch;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.NinePatchDrawable;
import android.os.Bundle;
import android.os.Looper;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseIntArray;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.baidu.mapapi.BMapManager;
import com.baidu.mapapi.common.SysOSUtil;
import com.baidu.mapapi.map.BaiduMap;
import com.baidu.mapapi.map.BaiduMapOptions;
import com.baidu.mapapi.map.CustomMapStyleCallBack;
import com.baidu.mapapi.map.LogoPosition;
import com.baidu.mapapi.map.MapCustomStyleOptions;
import com.baidu.mapapi.map.MapStatus;
import com.baidu.mapapi.map.MapViewLayoutParams;
import com.baidu.mapapi.map.q;
import com.baidu.mapapi.map.r;
import com.baidu.mapapi.map.s;
import com.baidu.mapapi.map.t;
import com.baidu.mapapi.map.u;
import com.baidu.mapapi.model.CoordUtil;
import com.baidu.mapapi.model.LatLng;
import com.baidu.mapsdkplatform.comapi.commonutils.a;
import com.baidu.mapsdkplatform.comapi.map.ad;
import com.baidu.mapsdkplatform.comapi.map.f;
import com.baidu.platform.comapi.basestruct.GeoPoint;
import com.baidu.platform.comapi.map.MapSurfaceView;
import com.baidu.platform.comapi.util.j;
import java.io.File;

public final class MapView
extends ViewGroup {
    private static final String a = MapView.class.getSimpleName();
    private static String b;
    private static int c;
    private static int d;
    private MapSurfaceView e;
    private BaiduMap f;
    private ImageView g;
    private Bitmap h;
    private ad i;
    private Point j;
    private Point k;
    private RelativeLayout l;
    private TextView m;
    private TextView n;
    private ImageView o;
    private Context p;
    private static final SparseIntArray q;
    private int r = LogoPosition.logoPostionleftBottom.ordinal();
    private boolean s = true;
    private boolean t = true;
    private float u;
    private int v;
    private int w;
    private int x;
    private int y;
    private int z;
    private int A;
    private boolean B = false;

    public MapView(Context context) {
        super(context);
        this.a(context, null);
    }

    public MapView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.a(context, null);
    }

    public MapView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.a(context, null);
    }

    public MapView(Context context, BaiduMapOptions options) {
        super(context);
        this.a(context, options);
    }

    @Deprecated
    public static void setCustomMapStylePath(String customMapStylePath) {
        if (customMapStylePath == null || customMapStylePath.length() == 0) {
            throw new RuntimeException("BDMapSDKException: customMapStylePath String is illegal");
        }
        File file = new File(customMapStylePath);
        if (!file.exists()) {
            throw new RuntimeException("BDMapSDKException: please check whether the customMapStylePath file exits");
        }
        b = customMapStylePath;
    }

    @Deprecated
    public static void setIconCustom(int icon_themeId) {
        d = icon_themeId;
    }

    @Deprecated
    public static void setLoadCustomMapStyleFileMode(int loadCustomStyleMode) {
        c = loadCustomStyleMode;
    }

    @Deprecated
    public static void setMapCustomEnable(boolean customMapStyleEnable) {
    }

    public void setCustomStyleFilePathAndMode(String customStyleFilePath, int loadCustomStyleFileMode) {
    }

    public void setMapCustomStylePath(String customStyleFilePath) {
        this.a(customStyleFilePath, "");
    }

    public void setMapCustomStyle(MapCustomStyleOptions mapCustomStyleOptions, CustomMapStyleCallBack customMapStyleCallBack) {
        if (mapCustomStyleOptions == null) {
            return;
        }
        String customStyleId = mapCustomStyleOptions.getCustomMapStyleId();
        if (customStyleId == null || customStyleId.isEmpty()) {
            String localPath = mapCustomStyleOptions.getLocalCustomStyleFilePath();
            if (localPath != null && !localPath.isEmpty()) {
                this.a(localPath, "");
                this.setMapCustomStyleEnable(true);
            }
            return;
        }
        com.baidu.mapsdkplatform.comapi.map.f.a().a(this.p, customStyleId, new q(this, customMapStyleCallBack, mapCustomStyleOptions));
    }

    private void a(String styleFilePath, MapCustomStyleOptions mapCustomStyleOptions) {
        if (!TextUtils.isEmpty((CharSequence)styleFilePath)) {
            this.a(styleFilePath, "");
            this.setMapCustomStyleEnable(true);
        } else {
            String localPath = mapCustomStyleOptions.getLocalCustomStyleFilePath();
            if (!TextUtils.isEmpty((CharSequence)localPath)) {
                this.a(localPath, "");
                this.setMapCustomStyleEnable(true);
            }
        }
    }

    public void setMapCustomStyleEnable(boolean customMapStyleEnable) {
        if (null == this.e || null == this.e.getBaseMap()) {
            return;
        }
        this.e.getBaseMap().p(customMapStyleEnable);
    }

    private void a(Context context, BaiduMapOptions options) {
        this.p = context;
        com.baidu.mapsdkplatform.comapi.map.j.a();
        BMapManager.init();
        this.a(context, options, b, c);
        this.a(context);
        this.b(context);
        if (options != null && !options.h) {
            this.i.setVisibility(4);
        }
        this.c(context);
        if (options != null && !options.i) {
            this.l.setVisibility(4);
        }
        if (options != null && options.j != null) {
            this.r = options.j.ordinal();
        }
        if (options != null && options.l != null) {
            this.k = options.l;
        }
        if (options != null && options.k != null) {
            this.j = options.k;
        }
    }

    private void a(Context context, BaiduMapOptions options, String customMapPath, int loadStyleFileMode) {
        this.e = new MapSurfaceView(context);
        this.f = options != null ? new BaiduMap(context, this.e, options.a()) : new BaiduMap(context, this.e, null);
        this.addView((View)this.e);
        r sdkMapViewListener = new r(this);
        if (null != this.e.getBaseMap()) {
            this.e.getBaseMap().a(sdkMapViewListener);
        }
    }

    private void a(Context context) {
        Bitmap b2;
        String logoFile = "logo_h.png";
        int dpi = SysOSUtil.getDensityDpi();
        if (dpi < 180) {
            logoFile = "logo_l.png";
        }
        if ((b2 = com.baidu.mapsdkplatform.comapi.commonutils.a.a(logoFile, context)) == null) {
            return;
        }
        if (dpi > 480) {
            Matrix matrix = new Matrix();
            matrix.postScale(2.0f, 2.0f);
            this.h = Bitmap.createBitmap((Bitmap)b2, (int)0, (int)0, (int)b2.getWidth(), (int)b2.getHeight(), (Matrix)matrix, (boolean)true);
        } else if (dpi > 320) {
            Matrix matrix = new Matrix();
            matrix.postScale(1.5f, 1.5f);
            this.h = Bitmap.createBitmap((Bitmap)b2, (int)0, (int)0, (int)b2.getWidth(), (int)b2.getHeight(), (Matrix)matrix, (boolean)true);
        } else {
            this.h = b2;
        }
        if (this.h != null) {
            this.g = new ImageView(context);
            this.g.setImageBitmap(this.h);
            this.addView((View)this.g);
        }
    }

    private void b(Context context) {
        this.i = new ad(context, false);
        if (!this.i.a()) {
            return;
        }
        this.i.b(new s(this));
        this.i.a(new t(this));
        this.addView((View)this.i);
    }

    private void b() {
        if (this.i == null || !this.i.a() || null == this.e.getBaseMap()) {
            return;
        }
        float zoomLevel = this.e.getBaseMap().D().a;
        this.i.b(zoomLevel > this.e.getBaseMap().b);
        this.i.a(zoomLevel < this.e.getBaseMap().a);
    }

    private void c(Context context) {
        this.l = new RelativeLayout(context);
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-2, -2);
        this.l.setLayoutParams(params);
        this.m = new TextView(context);
        RelativeLayout.LayoutParams tvbgParams = new RelativeLayout.LayoutParams(-2, -2);
        tvbgParams.addRule(14);
        this.m.setTextColor(Color.parseColor((String)"#FFFFFF"));
        this.m.setTextSize(2, 11.0f);
        this.m.setTypeface(this.m.getTypeface(), 1);
        this.m.setLayoutParams((ViewGroup.LayoutParams)tvbgParams);
        this.m.setId(Integer.MAX_VALUE);
        this.l.addView((View)this.m);
        this.n = new TextView(context);
        RelativeLayout.LayoutParams tvParams = new RelativeLayout.LayoutParams(-2, -2);
        tvParams.width = -2;
        tvParams.height = -2;
        tvParams.addRule(14);
        this.n.setTextColor(Color.parseColor((String)"#000000"));
        this.n.setTextSize(2, 11.0f);
        this.n.setLayoutParams((ViewGroup.LayoutParams)tvParams);
        this.l.addView((View)this.n);
        this.o = new ImageView(context);
        RelativeLayout.LayoutParams ivParams = new RelativeLayout.LayoutParams(-2, -2);
        ivParams.width = -2;
        ivParams.height = -2;
        ivParams.addRule(14);
        ivParams.addRule(3, this.m.getId());
        if (this.o != null) {
            byte[] chunk;
            boolean result;
            this.o.setLayoutParams((ViewGroup.LayoutParams)ivParams);
            Bitmap bitmap = com.baidu.mapsdkplatform.comapi.commonutils.a.a("icon_scale.9.png", context);
            if (bitmap != null && (result = NinePatch.isNinePatchChunk((byte[])(chunk = bitmap.getNinePatchChunk())))) {
                NinePatchDrawable background = new NinePatchDrawable(bitmap, chunk, new Rect(), null);
                this.o.setBackgroundDrawable((Drawable)background);
            }
            this.l.addView((View)this.o);
        }
        this.addView((View)this.l);
    }

    public final BaiduMap getMap() {
        this.f.a = this;
        return this.f;
    }

    public final void onDestroy() {
        if (null != this.f) {
            this.f.c();
        }
        if (null != this.e) {
            this.e.unInit();
        }
        if (this.h != null && !this.h.isRecycled()) {
            this.h.recycle();
            this.h = null;
        }
        if (null != b) {
            b = null;
        }
        this.i.b();
        BMapManager.destroy();
        com.baidu.mapsdkplatform.comapi.map.j.b();
        this.p = null;
    }

    public final void setLogoPosition(LogoPosition position) {
        this.r = position == null ? LogoPosition.logoPostionleftBottom.ordinal() : position.ordinal();
        this.requestLayout();
    }

    public final LogoPosition getLogoPosition() {
        switch (this.r) {
            case 1: {
                return LogoPosition.logoPostionleftTop;
            }
            case 2: {
                return LogoPosition.logoPostionCenterBottom;
            }
            case 3: {
                return LogoPosition.logoPostionCenterTop;
            }
            case 4: {
                return LogoPosition.logoPostionRightBottom;
            }
            case 5: {
                return LogoPosition.logoPostionRightTop;
            }
        }
        return LogoPosition.logoPostionleftBottom;
    }

    public final int getMapLevel() {
        float level = this.e.getZoomLevel();
        return q.get(Math.round(level));
    }

    public final void onPause() {
        this.e.onPause();
    }

    public final void onResume() {
        this.e.onResume();
    }

    public void addView(View child, ViewGroup.LayoutParams params) {
        if (params instanceof MapViewLayoutParams) {
            if (child.getParent() != null) {
                ((ViewGroup)child.getParent()).removeView(child);
            }
            super.addView(child, params);
        }
    }

    private boolean c() {
        return Looper.getMainLooper().getThread() == Thread.currentThread();
    }

    public void removeView(View view) {
        if (view == this.g) {
            return;
        }
        if (this.c()) {
            super.removeView(view);
        } else {
            com.baidu.platform.comapi.util.j.a(new u(this, view), 0L);
        }
    }

    public void setPadding(int left, int top, int right, int bottom) {
        this.v = left;
        this.x = top;
        this.w = right;
        this.y = bottom;
    }

    protected final void onLayout(boolean changed, int l2, int t2, int r2, int b2) {
        int count = this.getChildCount();
        float scaleX = 1.0f;
        float scaleY = 1.0f;
        this.a((View)this.g);
        if (this.getWidth() - this.v - this.w - this.g.getMeasuredWidth() > 0 && this.getHeight() - this.x - this.y - this.g.getMeasuredHeight() > 0) {
            scaleX = (float)(this.getWidth() - this.v - this.w) / (float)this.getWidth();
            scaleY = (float)(this.getHeight() - this.x - this.y) / (float)this.getHeight();
        } else {
            this.v = 0;
            this.w = 0;
            this.y = 0;
            this.x = 0;
        }
        for (int i2 = 0; i2 < count; ++i2) {
            Point p2;
            View child = this.getChildAt(i2);
            if (child == null) continue;
            if (child == this.e) {
                this.e.layout(0, 0, this.getWidth(), this.getHeight());
                continue;
            }
            if (child == this.g) {
                int right;
                int bottom;
                int top;
                int left;
                int paddedLeft = (int)((float)this.v + scaleX * 5.0f);
                int paddedRight = (int)((float)this.w + scaleX * 5.0f);
                int paddedTop = (int)((float)this.x + scaleY * 5.0f);
                int paddedBottom = (int)((float)this.y + scaleY * 5.0f);
                switch (this.r) {
                    case 1: {
                        left = paddedLeft;
                        top = paddedTop;
                        bottom = top + this.g.getMeasuredHeight();
                        right = left + this.g.getMeasuredWidth();
                        break;
                    }
                    case 2: {
                        bottom = this.getHeight() - paddedBottom;
                        top = bottom - this.g.getMeasuredHeight();
                        left = (this.getWidth() - this.g.getMeasuredWidth() + this.v - this.w) / 2;
                        right = (this.getWidth() + this.g.getMeasuredWidth() + this.v - this.w) / 2;
                        break;
                    }
                    case 3: {
                        top = paddedTop;
                        bottom = top + this.g.getMeasuredHeight();
                        left = (this.getWidth() - this.g.getMeasuredWidth() + this.v - this.w) / 2;
                        right = (this.getWidth() + this.g.getMeasuredWidth() + this.v - this.w) / 2;
                        break;
                    }
                    case 4: {
                        bottom = this.getHeight() - paddedBottom;
                        top = bottom - this.g.getMeasuredHeight();
                        right = this.getWidth() - paddedRight;
                        left = right - this.g.getMeasuredWidth();
                        break;
                    }
                    case 5: {
                        top = paddedTop;
                        bottom = top + this.g.getMeasuredHeight();
                        right = this.getWidth() - paddedRight;
                        left = right - this.g.getMeasuredWidth();
                        break;
                    }
                    default: {
                        left = paddedLeft;
                        bottom = this.getHeight() - paddedBottom;
                        right = left + this.g.getMeasuredWidth();
                        top = bottom - this.g.getMeasuredHeight();
                    }
                }
                this.g.layout(left, top, right, bottom);
                continue;
            }
            if (child == this.i) {
                if (!this.i.a()) continue;
                this.a((View)this.i);
                if (this.k == null) {
                    int bottom = (int)((float)(this.getHeight() - 15) * scaleY + (float)this.x);
                    int right = (int)((float)(this.getWidth() - 15) * scaleX + (float)this.v);
                    int left = right - this.i.getMeasuredWidth();
                    int top = bottom - this.i.getMeasuredHeight();
                    if (this.r == 4) {
                        bottom -= this.g.getMeasuredHeight();
                        top -= this.g.getMeasuredHeight();
                    }
                    this.i.layout(left, top, right, bottom);
                    continue;
                }
                this.i.layout(this.k.x, this.k.y, this.k.x + this.i.getMeasuredWidth(), this.k.y + this.i.getMeasuredHeight());
                continue;
            }
            if (child == this.l) {
                this.a((View)this.l);
                if (this.j == null) {
                    int paddedBottom = (int)((float)this.y + scaleY * 5.0f + 56.0f);
                    this.A = this.l.getMeasuredWidth();
                    this.z = this.l.getMeasuredHeight();
                    int left = (int)((float)this.v + scaleX * 5.0f);
                    int top = this.getHeight() - paddedBottom - this.g.getMeasuredHeight();
                    int right = left + this.A;
                    int bottom = top + this.z;
                    this.l.layout(left, top, right, bottom);
                    continue;
                }
                this.l.layout(this.j.x, this.j.y, this.j.x + this.l.getMeasuredWidth(), this.j.y + this.l.getMeasuredHeight());
                continue;
            }
            ViewGroup.LayoutParams lp = child.getLayoutParams();
            if (!(lp instanceof MapViewLayoutParams)) continue;
            MapViewLayoutParams mlp = (MapViewLayoutParams)lp;
            MapViewLayoutParams.ELayoutMode mode = mlp.c;
            if (mode == MapViewLayoutParams.ELayoutMode.absoluteMode) {
                p2 = mlp.b;
            } else {
                LatLng ll = mlp.a;
                GeoPoint gp = CoordUtil.ll2mc(ll);
                p2 = this.e.getBaseMap() != null ? this.e.getBaseMap().a(gp) : new Point();
            }
            this.a(child);
            int width = child.getMeasuredWidth();
            int height = child.getMeasuredHeight();
            float alignX = mlp.d;
            float alignY = mlp.e;
            int left = (int)((float)p2.x - alignX * (float)width);
            int top = (int)((float)p2.y - alignY * (float)height) + mlp.f;
            child.layout(left, top, left + width, top + height);
        }
    }

    private void a(View child) {
        int lpWidth;
        ViewGroup.LayoutParams p2 = child.getLayoutParams();
        if (p2 == null) {
            p2 = new ViewGroup.LayoutParams(-2, -2);
        }
        int childWidthSpec = (lpWidth = p2.width) > 0 ? View.MeasureSpec.makeMeasureSpec((int)lpWidth, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int lpHeight = p2.height;
        int childHeightSpec = lpHeight > 0 ? View.MeasureSpec.makeMeasureSpec((int)lpHeight, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        child.measure(childWidthSpec, childHeightSpec);
    }

    public void showZoomControls(boolean show) {
        if (this.i.a()) {
            this.i.setVisibility(show ? 0 : 8);
            this.s = show;
        }
    }

    public void setZoomControlsPosition(Point p2) {
        if (p2 == null) {
            return;
        }
        if (p2.x >= 0 && p2.y >= 0 && p2.x <= this.getWidth() && p2.y <= this.getHeight()) {
            this.k = p2;
            this.requestLayout();
        }
    }

    public Point getZoomControlsPosition() {
        return this.k;
    }

    public void showScaleControl(boolean show) {
        this.l.setVisibility(show ? 0 : 8);
        this.t = show;
    }

    public boolean isShowScaleControl() {
        return this.t;
    }

    public int getScaleControlViewWidth() {
        return this.A;
    }

    public int getScaleControlViewHeight() {
        return this.z;
    }

    public void setScaleControlPosition(Point p2) {
        if (p2 == null) {
            return;
        }
        if (p2.x >= 0 && p2.y >= 0 && p2.x <= this.getWidth() && p2.y <= this.getHeight()) {
            this.j = p2;
            this.requestLayout();
        }
    }

    public Point getScaleControlPosition() {
        return this.j;
    }

    public void onSaveInstanceState(Bundle bundle) {
        if (bundle == null || this.f == null) {
            return;
        }
        MapStatus mapStatus = this.f.getMapStatus();
        bundle.putParcelable("mapstatus", (Parcelable)mapStatus);
        if (this.j != null) {
            // empty if block
        }
        if (this.k != null) {
            // empty if block
        }
        bundle.putBoolean("mZoomControlEnabled", this.s);
        bundle.putBoolean("mScaleControlEnabled", this.t);
        bundle.putInt("logoPosition", this.r);
        bundle.putInt("paddingLeft", this.v);
        bundle.putInt("paddingTop", this.x);
        bundle.putInt("paddingRight", this.w);
        bundle.putInt("paddingBottom", this.y);
    }

    public void onCreate(Context context, Bundle bundle) {
        if (bundle == null) {
            return;
        }
        MapStatus mapStatus = (MapStatus)bundle.getParcelable("mapstatus");
        if (this.j != null) {
            this.j = (Point)bundle.getParcelable("scalePosition");
        }
        if (this.k != null) {
            this.k = (Point)bundle.getParcelable("zoomPosition");
        }
        this.s = bundle.getBoolean("mZoomControlEnabled");
        this.t = bundle.getBoolean("mScaleControlEnabled");
        this.r = bundle.getInt("logoPosition");
        this.setPadding(bundle.getInt("paddingLeft"), bundle.getInt("paddingTop"), bundle.getInt("paddingRight"), bundle.getInt("paddingBottom"));
        this.a(context, new BaiduMapOptions().mapStatus(mapStatus));
    }

    public final void setZOrderMediaOverlay(boolean isMediaOverlay) {
        if (this.e == null) {
            return;
        }
        this.e.setZOrderMediaOverlay(isMediaOverlay);
    }

    public void setUpViewEventToMapView(MotionEvent event) {
        this.e.onTouchEvent(event);
    }

    public void handleTouchDown(float x2, float y2) {
        if (this.e == null) {
            return;
        }
    }

    public boolean handleTouchUp(float x2, float y2) {
        if (this.e == null) {
            return false;
        }
        return false;
    }

    public boolean inRangeOfView(float x2, float y2) {
        return null != this.e && this.e.inRangeOfView(x2, y2);
    }

    public boolean handleMultiTouch(float x1, float y1, float x2, float y2) {
        return false;
    }

    public boolean handleTouchMove(float x2, float y2) {
        return false;
    }

    public void renderMap() {
    }

    public void cancelRenderMap() {
    }

    private void a(String customStyleFilePath, String customResFilePath) {
        if (this.e == null || this.e.getBaseMap() == null) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)customStyleFilePath)) {
            Log.e((String)a, (String)"customStyleFilePath is empty or null, please check!");
            return;
        }
        if (!customStyleFilePath.endsWith(".sty")) {
            Log.e((String)a, (String)"customStyleFile format is incorrect , please check!");
            return;
        }
        File file = new File(customStyleFilePath);
        if (!file.exists()) {
            Log.e((String)a, (String)"customStyleFile does not exist , please check!");
            return;
        }
        this.e.getBaseMap().b(customStyleFilePath, customResFilePath);
    }

    static /* synthetic */ void a(MapView x0, String x1, MapCustomStyleOptions x2) {
        x0.a(x1, x2);
    }

    static /* synthetic */ boolean a(MapView x0, boolean x1) {
        x0.B = x1;
        return x0.B;
    }

    static /* synthetic */ void a(MapView x0, String x1, String x2) {
        x0.a(x1, x2);
    }

    static /* synthetic */ boolean a(MapView x0) {
        return x0.B;
    }

    static /* synthetic */ MapSurfaceView b(MapView x0) {
        return x0.e;
    }

    static /* synthetic */ float c(MapView x0) {
        return x0.u;
    }

    static /* synthetic */ SparseIntArray a() {
        return q;
    }

    static /* synthetic */ ImageView d(MapView x0) {
        return x0.o;
    }

    static /* synthetic */ TextView e(MapView x0) {
        return x0.m;
    }

    static /* synthetic */ TextView f(MapView x0) {
        return x0.n;
    }

    static /* synthetic */ float a(MapView x0, float x1) {
        x0.u = x1;
        return x0.u;
    }

    static /* synthetic */ void g(MapView x0) {
        x0.b();
    }

    static {
        c = 0;
        d = 0;
        q = new SparseIntArray();
        q.append(3, 2000000);
        q.append(4, 1000000);
        q.append(5, 500000);
        q.append(6, 200000);
        q.append(7, 100000);
        q.append(8, 50000);
        q.append(9, 25000);
        q.append(10, 20000);
        q.append(11, 10000);
        q.append(12, 5000);
        q.append(13, 2000);
        q.append(14, 1000);
        q.append(15, 500);
        q.append(16, 200);
        q.append(17, 100);
        q.append(18, 50);
        q.append(19, 20);
        q.append(20, 10);
        q.append(21, 5);
        q.append(22, 2);
        q.append(23, 2);
        q.append(24, 2);
        q.append(25, 2);
        q.append(26, 2);
    }
}

