/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.map;

import android.graphics.Point;
import android.view.ViewGroup;
import com.baidu.mapapi.model.LatLng;

public final class MapViewLayoutParams
extends ViewGroup.LayoutParams {
    public static final int ALIGN_LEFT = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final int ALIGN_CENTER_HORIZONTAL = 4;
    public static final int ALIGN_TOP = 8;
    public static final int ALIGN_BOTTOM = 16;
    public static final int ALIGN_CENTER_VERTICAL = 32;
    LatLng a;
    Point b;
    ELayoutMode c;
    float d;
    float e;
    int f;

    MapViewLayoutParams(int width, int height, LatLng position, Point point, ELayoutMode mode, int alignX, int alignY, int yOffset) {
        super(width, height);
        this.a = position;
        this.b = point;
        this.c = mode;
        switch (alignX) {
            case 1: {
                this.d = 0.0f;
                break;
            }
            case 4: {
                this.d = 0.5f;
                break;
            }
            case 2: {
                this.d = 1.0f;
                break;
            }
            default: {
                this.d = 0.5f;
            }
        }
        switch (alignY) {
            case 8: {
                this.e = 0.0f;
                break;
            }
            case 32: {
                this.e = 0.5f;
                break;
            }
            case 16: {
                this.e = 1.0f;
                break;
            }
            default: {
                this.e = 1.0f;
            }
        }
        this.f = yOffset;
    }

    public static enum ELayoutMode {
        mapMode,
        absoluteMode;

    }

    public static final class Builder {
        private int a;
        private int b;
        private LatLng c;
        private Point d;
        private ELayoutMode e = ELayoutMode.absoluteMode;
        private int f = 4;
        private int g = 16;
        private int h;

        public MapViewLayoutParams build() {
            boolean illegal = false;
            if (this.e == ELayoutMode.mapMode) {
                if (this.c == null) {
                    illegal = true;
                }
            } else if (this.e == ELayoutMode.absoluteMode && this.d == null) {
                illegal = true;
            }
            if (illegal) {
                throw new IllegalStateException("BDMapSDKException: if it is map mode, you must supply position info; else if it is absolute mode, you must supply the point info");
            }
            return new MapViewLayoutParams(this.a, this.b, this.c, this.d, this.e, this.f, this.g, this.h);
        }

        public Builder width(int width) {
            this.a = width;
            return this;
        }

        public Builder height(int height) {
            this.b = height;
            return this;
        }

        public Builder align(int alignX, int alignY) {
            if (alignX == 1 || alignX == 2 || alignX == 4) {
                this.f = alignX;
            }
            if (alignY == 8 || alignY == 16 || alignY == 32) {
                this.g = alignY;
            }
            return this;
        }

        public Builder position(LatLng position) {
            this.c = position;
            return this;
        }

        public Builder point(Point p2) {
            this.d = p2;
            return this;
        }

        public Builder layoutMode(ELayoutMode mode) {
            this.e = mode;
            return this;
        }

        public Builder yOffset(int yOffset) {
            this.h = yOffset;
            return this;
        }
    }
}

