/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.map;

import android.os.Bundle;
import com.baidu.mapapi.map.CircleHoleOptions;
import com.baidu.mapapi.map.HoleOptions;
import com.baidu.mapapi.map.PolygonHoleOptions;
import com.baidu.mapapi.model.CoordUtil;
import com.baidu.mapapi.model.LatLng;
import com.baidu.mapapi.model.LatLngBounds;
import com.baidu.mapsdkplatform.comapi.map.i;
import com.baidu.platform.comapi.basestruct.GeoPoint;
import java.util.ArrayList;
import java.util.List;

public abstract class Overlay {
    String F = System.currentTimeMillis() + "_" + this.hashCode();
    public i type;
    int G;
    boolean H;
    Bundle I;
    protected a listener;

    protected Overlay() {
    }

    public boolean isVisible() {
        return this.H;
    }

    public void setVisible(boolean visible) {
        this.H = visible;
        this.listener.c(this);
    }

    public int getZIndex() {
        return this.G;
    }

    public void setZIndex(int zIndex) {
        this.G = zIndex;
        this.listener.c(this);
    }

    public Bundle getExtraInfo() {
        return this.I;
    }

    public void setExtraInfo(Bundle extraInfo) {
        this.I = extraInfo;
    }

    Bundle a(Bundle b2) {
        b2.putString("id", this.F);
        b2.putInt("type", this.type.ordinal());
        b2.putInt("visibility", this.H ? 1 : 0);
        b2.putInt("z_index", this.G);
        return b2;
    }

    Bundle a() {
        Bundle b2 = new Bundle();
        b2.putString("id", this.F);
        b2.putInt("type", this.type.ordinal());
        return b2;
    }

    public LatLngBounds getOverlayLatLngBounds() {
        return this.listener.a(this);
    }

    public void remove() {
        this.listener.b(this);
    }

    public boolean isRemoved() {
        return this.listener.d(this);
    }

    static void a(int color, Bundle b2) {
        Bundle colorBundle = new Bundle();
        int alpha = color >>> 24;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        colorBundle.putFloat("red", (float)red / 255.0f);
        colorBundle.putFloat("green", (float)green / 255.0f);
        colorBundle.putFloat("blue", (float)blue / 255.0f);
        colorBundle.putFloat("alpha", (float)alpha / 255.0f);
        b2.putBundle("color", colorBundle);
    }

    static void a(List<LatLng> points, Bundle b2) {
        int length = points.size();
        double[] xArray = new double[length];
        double[] yArray = new double[length];
        for (int i2 = 0; i2 < length; ++i2) {
            GeoPoint gp = CoordUtil.ll2mc(points.get(i2));
            xArray[i2] = gp.getLongitudeE6();
            yArray[i2] = gp.getLatitudeE6();
        }
        b2.putDoubleArray("x_array", xArray);
        b2.putDoubleArray("y_array", yArray);
    }

    static boolean b(List<HoleOptions> holeOptionsList, Bundle b2) {
        if (holeOptionsList == null || holeOptionsList.size() == 0) {
            return false;
        }
        ArrayList<CircleHoleOptions> circleHoleOptions = new ArrayList<CircleHoleOptions>();
        ArrayList<PolygonHoleOptions> polygonHoleOptions = new ArrayList<PolygonHoleOptions>();
        for (HoleOptions holeOptions : holeOptionsList) {
            if (holeOptions instanceof CircleHoleOptions) {
                circleHoleOptions.add((CircleHoleOptions)holeOptions);
                continue;
            }
            if (!(holeOptions instanceof PolygonHoleOptions)) continue;
            polygonHoleOptions.add((PolygonHoleOptions)holeOptions);
        }
        boolean hasCircleHole = false;
        if (circleHoleOptions.size() != 0) {
            hasCircleHole = Overlay.c(circleHoleOptions, b2);
            b2.putInt("has_circle_hole", hasCircleHole ? 1 : 0);
        } else {
            b2.putInt("has_circle_hole", 0);
        }
        boolean hasPolygonHole = false;
        if (polygonHoleOptions.size() != 0) {
            hasPolygonHole = Overlay.d(polygonHoleOptions, b2);
            b2.putInt("has_polygon_hole", hasPolygonHole ? 1 : 0);
        } else {
            b2.putInt("has_polygon_hole", 0);
        }
        return hasCircleHole || hasPolygonHole;
    }

    private static boolean c(List<CircleHoleOptions> circleHoleOptions, Bundle b2) {
        int length = circleHoleOptions.size();
        double[] centerXArray = new double[length];
        double[] centerYArray = new double[length];
        int[] radiusArray = new int[length];
        for (int i2 = 0; i2 < length; ++i2) {
            LatLng center = circleHoleOptions.get(i2).getHoleCenter();
            int radius = circleHoleOptions.get(i2).getHoleRadius();
            if (center == null || radius <= 0) {
                return false;
            }
            GeoPoint gp = CoordUtil.ll2mc(center);
            centerXArray[i2] = gp.getLongitudeE6();
            centerYArray[i2] = gp.getLatitudeE6();
            radiusArray[i2] = radius;
        }
        b2.putDoubleArray("circle_hole_x_array", centerXArray);
        b2.putDoubleArray("circle_hole_y_array", centerYArray);
        b2.putIntArray("circle_hole_radius_array", radiusArray);
        return true;
    }

    private static boolean d(List<PolygonHoleOptions> polygonHoleOptions, Bundle b2) {
        int polygonCount = polygonHoleOptions.size();
        int[] polygonCountArray = new int[polygonCount];
        ArrayList<LatLng> allHolePoints = new ArrayList<LatLng>();
        for (int i2 = 0; i2 < polygonCount; ++i2) {
            List<LatLng> holePoints = polygonHoleOptions.get(i2).getHolePoints();
            if (holePoints == null) {
                return false;
            }
            allHolePoints.addAll(holePoints);
            polygonCountArray[i2] = holePoints.size();
        }
        int pointTotalSize = allHolePoints.size();
        if (pointTotalSize == 0) {
            return false;
        }
        b2.putIntArray("polygon_hole_count_array", polygonCountArray);
        double[] xArray = new double[pointTotalSize];
        double[] yArray = new double[pointTotalSize];
        for (int j2 = 0; j2 < pointTotalSize; ++j2) {
            GeoPoint gp = CoordUtil.ll2mc((LatLng)allHolePoints.get(j2));
            xArray[j2] = gp.getLongitudeE6();
            yArray[j2] = gp.getLatitudeE6();
        }
        b2.putDoubleArray("polygon_hole_x_array", xArray);
        b2.putDoubleArray("polygon_hole_y_array", yArray);
        return true;
    }

    static void b(int color, Bundle b2) {
        Bundle colorBundle = new Bundle();
        int alpha = color >>> 24;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        colorBundle.putFloat("red", (float)red / 255.0f);
        colorBundle.putFloat("green", (float)green / 255.0f);
        colorBundle.putFloat("blue", (float)blue / 255.0f);
        colorBundle.putFloat("alpha", (float)alpha / 255.0f);
        b2.putBundle("m_topFaceColor", colorBundle);
    }

    static void c(int color, Bundle b2) {
        Bundle colorBundle = new Bundle();
        int alpha = color >>> 24;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        colorBundle.putFloat("red", (float)red / 255.0f);
        colorBundle.putFloat("green", (float)green / 255.0f);
        colorBundle.putFloat("blue", (float)blue / 255.0f);
        colorBundle.putFloat("alpha", (float)alpha / 255.0f);
        b2.putBundle("m_sideFaceColor", colorBundle);
    }

    static interface a {
        public void b(Overlay var1);

        public void c(Overlay var1);

        public boolean d(Overlay var1);

        public LatLngBounds a(Overlay var1);
    }
}

