/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.map;

import android.os.Bundle;
import android.util.Log;
import com.baidu.mapapi.map.BaiduMap;
import com.baidu.mapapi.map.FileTileProvider;
import com.baidu.mapapi.map.TileOverlay;
import com.baidu.mapapi.map.TileProvider;
import com.baidu.mapapi.map.UrlTileProvider;
import com.baidu.mapapi.model.CoordUtil;
import com.baidu.mapapi.model.LatLngBounds;
import com.baidu.platform.comapi.basestruct.GeoPoint;

public final class TileOverlayOptions {
    private int a = 0xC800000;
    private TileProvider b;
    private static Bundle c;
    private int d = 20;
    private int e = 3;
    private int f = 15786414;
    private int g = -20037726;
    private int h = -15786414;
    private int i = 20037726;
    public int datasource;
    public String urlString;
    private static final String j;

    public TileOverlayOptions() {
        c = new Bundle();
        c.putInt("rectr", this.f);
        c.putInt("rectb", this.g);
        c.putInt("rectl", this.h);
        c.putInt("rectt", this.i);
    }

    public TileOverlayOptions setMaxTileTmp(int maxTileTmp) {
        this.a = maxTileTmp;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public TileOverlayOptions tileProvider(TileProvider tileProvider) {
        block6: {
            if (tileProvider == null) {
                return null;
            }
            if (tileProvider instanceof UrlTileProvider) {
                this.datasource = 1;
                String url = ((UrlTileProvider)tileProvider).getTileUrl();
                if (url != null && !"".equals(url) && url.contains("{x}") && url.contains("{y}") && url.contains("{z}")) {
                    this.urlString = url;
                    break block6;
                } else {
                    Log.e((String)j, (String)"tile url template is illegal, must contains {x}\u3001{y}\u3001{z}");
                    return null;
                }
            }
            if (!(tileProvider instanceof FileTileProvider)) {
                Log.e((String)j, (String)"tileProvider must be UrlTileProvider or FileTileProvider");
                return null;
            }
            this.datasource = 0;
        }
        this.b = tileProvider;
        int maxDisLevel = tileProvider.getMaxDisLevel();
        int minDisLevel = tileProvider.getMinDisLevel();
        if (maxDisLevel <= 21 && minDisLevel >= 3) {
            this.a(maxDisLevel, minDisLevel);
            return this;
        }
        Log.e((String)j, (String)"display level is illegal");
        return this;
    }

    private TileOverlayOptions a(int maxDisplay, int minDisplay) {
        this.d = maxDisplay;
        this.e = minDisplay;
        return this;
    }

    public TileOverlayOptions setPositionFromBounds(LatLngBounds bounds) {
        if (bounds == null) {
            throw new IllegalArgumentException("BDMapSDKException: bound can not be null");
        }
        GeoPoint mcnortheast = CoordUtil.ll2mc(bounds.northeast);
        GeoPoint mcsouthwest = CoordUtil.ll2mc(bounds.southwest);
        double maxLat = mcnortheast.getLatitudeE6();
        double minLng = mcsouthwest.getLongitudeE6();
        double minLat = mcsouthwest.getLatitudeE6();
        double maxLng = mcnortheast.getLongitudeE6();
        if (maxLat > minLat && maxLng > minLng) {
            c.putInt("rectr", (int)maxLng);
            c.putInt("rectb", (int)minLat);
            c.putInt("rectl", (int)minLng);
            c.putInt("rectt", (int)maxLat);
        } else {
            Log.e((String)j, (String)"BDMapSDKException: bounds is illegal, use default bounds");
        }
        return this;
    }

    TileOverlay a(BaiduMap mBaiduMap) {
        TileOverlay overlay = new TileOverlay(mBaiduMap, this.b);
        return overlay;
    }

    Bundle a() {
        c.putString("url", this.urlString);
        c.putInt("datasource", this.datasource);
        c.putInt("maxDisplay", this.d);
        c.putInt("minDisplay", this.e);
        c.putInt("sdktiletmpmax", this.a);
        return c;
    }

    static {
        j = TileOverlayOptions.class.getSimpleName();
    }
}

