/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.baidu.mapapi.model.LatLng;
import com.baidu.mapapi.model.b;
import java.util.List;

public final class LatLngBounds
implements Parcelable {
    public final LatLng northeast;
    public final LatLng southwest;
    public static final Parcelable.Creator<LatLngBounds> CREATOR = new b();

    LatLngBounds(LatLng northeast, LatLng southwest) {
        this.northeast = northeast;
        this.southwest = southwest;
    }

    protected LatLngBounds(Parcel in) {
        this.northeast = (LatLng)in.readParcelable(LatLng.class.getClassLoader());
        this.southwest = (LatLng)in.readParcelable(LatLng.class.getClassLoader());
    }

    public boolean contains(LatLng point) {
        if (point == null) {
            return false;
        }
        double minLat = this.southwest.latitude;
        double maxLat = this.northeast.latitude;
        double minLng = this.southwest.longitude;
        double maxLng = this.northeast.longitude;
        double lat = point.latitude;
        double lng = point.longitude;
        return lat >= minLat && lat <= maxLat && lng >= minLng && lng <= maxLng;
    }

    public LatLng getCenter() {
        double centerLat = (this.northeast.latitude - this.southwest.latitude) / 2.0 + this.southwest.latitude;
        double centerLng = (this.northeast.longitude - this.southwest.longitude) / 2.0 + this.southwest.longitude;
        LatLng center = new LatLng(centerLat, centerLng);
        return center;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable((Parcelable)this.northeast, flags);
        dest.writeParcelable((Parcelable)this.southwest, flags);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("southwest: ");
        sb.append(this.southwest.latitude);
        sb.append(", ");
        sb.append(this.southwest.longitude);
        sb.append("\n");
        sb.append("northeast: ");
        sb.append(this.northeast.latitude);
        sb.append(", ");
        sb.append(this.northeast.longitude);
        return sb.toString();
    }

    public static final class Builder {
        private double a;
        private double b;
        private double c;
        private double d;
        private double e;
        private double f;
        private boolean g = true;

        public LatLngBounds build() {
            if (this.e != 0.0 || this.f != 0.0) {
                if (this.d != 0.0 || this.c != 0.0) {
                    this.c = this.f + 360.0;
                    if (this.c > this.d) {
                        double tmp = this.d;
                        this.d = this.c;
                        this.c = tmp;
                    }
                } else {
                    this.d = this.e;
                    this.c = this.f;
                }
            }
            if (this.d > 180.0) {
                this.d -= 360.0;
                if (this.d < this.c) {
                    double tmpMax = this.d;
                    this.d = this.c;
                    this.c = tmpMax;
                }
            }
            LatLng northeast = new LatLng(this.b, this.d);
            LatLng southwest = new LatLng(this.a, this.c);
            return new LatLngBounds(northeast, southwest);
        }

        public Builder include(LatLng point) {
            if (point == null) {
                return this;
            }
            if (this.g) {
                this.g = false;
                if (point.longitude >= 0.0) {
                    this.d = this.c = point.longitude;
                } else {
                    this.e = this.f = point.longitude;
                }
                this.b = this.a = point.latitude;
            }
            this.a(point);
            return this;
        }

        public Builder include(List<LatLng> latLngs) {
            if (latLngs == null || latLngs.size() == 0) {
                return this;
            }
            if (latLngs.get(0) != null && this.g) {
                this.g = false;
                if (latLngs.get((int)0).longitude >= 0.0) {
                    this.d = this.c = latLngs.get((int)0).longitude;
                } else {
                    this.e = this.f = latLngs.get((int)0).longitude;
                }
                this.b = this.a = latLngs.get((int)0).latitude;
            }
            for (LatLng latLng : latLngs) {
                this.a(latLng);
            }
            return this;
        }

        private void a(LatLng latLng) {
            if (latLng == null) {
                return;
            }
            double lat = latLng.latitude;
            double lng = latLng.longitude;
            if (lat < this.a) {
                this.a = lat;
            }
            if (lat > this.b) {
                this.b = lat;
            }
            if (lng >= 0.0) {
                if (lng < this.c) {
                    this.c = lng;
                }
                if (lng > this.d) {
                    this.d = lng;
                    if (this.c == 0.0) {
                        this.c = lng;
                    }
                }
                if (lng == 0.0) {
                    this.e = lng;
                }
            } else {
                if (lng < this.f) {
                    this.f = lng;
                }
                if (lng > this.e) {
                    this.e = lng;
                }
            }
        }
    }
}

