/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.utils;

import com.baidu.mapapi.model.LatLng;
import com.baidu.mapapi.utils.DistanceUtil;
import java.util.List;

public class AreaUtil {
    public static double calculateArea(LatLng northeast, LatLng southwest) {
        if (northeast == null || southwest == null) {
            return 0.0;
        }
        LatLng westnorthLatlng = new LatLng(northeast.latitude, southwest.longitude);
        double width = 0.0;
        double height = 0.0;
        width = DistanceUtil.getDistance(westnorthLatlng, southwest);
        height = DistanceUtil.getDistance(northeast, westnorthLatlng);
        if (width == 0.0 || height == 0.0) {
            return 0.0;
        }
        return width * height;
    }

    public static double calculateArea(List<LatLng> latLngs) {
        if (latLngs == null || latLngs.size() < 3) {
            return 0.0;
        }
        double s2 = 0.0;
        double degreeToMeter = 111319.49079327358;
        int size = latLngs.size();
        for (int i2 = 0; i2 < size; ++i2) {
            LatLng point1 = latLngs.get(i2);
            LatLng point2 = latLngs.get((i2 + 1) % size);
            double x1 = point1.longitude * degreeToMeter * Math.cos(point1.latitude * (Math.PI / 180));
            double y1 = point1.latitude * degreeToMeter;
            double x2 = point2.longitude * degreeToMeter * Math.cos(point2.latitude * (Math.PI / 180));
            double y2 = point2.latitude * degreeToMeter;
            s2 += x1 * y2 - y1 * x2;
        }
        return (float)Math.abs(s2 / 2.0);
    }
}

