/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.utils;

import com.baidu.mapapi.model.CoordUtil;
import com.baidu.mapapi.model.LatLng;
import com.baidu.mapapi.utils.DistanceUtil;
import com.baidu.platform.comapi.basestruct.GeoPoint;
import com.baidu.platform.comapi.basestruct.Point;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SpatialRelationUtil {
    public static boolean isPolygonContainsPoint(List<LatLng> mPoints, LatLng point) {
        if (mPoints == null || mPoints.size() == 0 || point == null) {
            return false;
        }
        for (int i2 = 0; i2 < mPoints.size(); ++i2) {
            if (point.longitude != mPoints.get((int)i2).longitude || point.latitude != mPoints.get((int)i2).latitude) continue;
            return true;
        }
        int nCross = 0;
        int i3 = 0;
        LatLng pp1 = null;
        LatLng pp2 = null;
        double x2 = 0.0;
        int count = mPoints.size();
        for (i3 = 0; i3 < count; ++i3) {
            pp1 = mPoints.get(i3);
            pp2 = mPoints.get((i3 + 1) % count);
            if (pp1.latitude == pp2.latitude || point.latitude < Math.min(pp1.latitude, pp2.latitude) || point.latitude >= Math.max(pp1.latitude, pp2.latitude)) continue;
            x2 = (point.latitude - pp1.latitude) * (pp2.longitude - pp1.longitude) / (pp2.latitude - pp1.latitude) + pp1.longitude;
            if (x2 == point.longitude) {
                return true;
            }
            if (!(x2 < point.longitude)) continue;
            ++nCross;
        }
        return nCross % 2 == 1;
    }

    public static boolean isCircleContainsPoint(LatLng center, int radius, LatLng point) {
        if (center == null || radius == 0 || point == null) {
            return false;
        }
        double a2 = DistanceUtil.getDistance(center, point);
        if (a2 > (double)radius) {
            return false;
        }
        if (a2 == (double)radius) {
            return true;
        }
        return true;
    }

    public static LatLng getNearestPointFromLine(List<LatLng> mPoints, LatLng point) {
        if (mPoints == null || mPoints.size() == 0 || point == null) {
            return null;
        }
        LatLng point1 = null;
        for (int i2 = 0; i2 < mPoints.size() - 1; ++i2) {
            LatLng point2;
            LatLng verticalPoint = SpatialRelationUtil.a(mPoints.get(i2), mPoints.get(i2 + 1), point);
            if ((verticalPoint.latitude - mPoints.get((int)i2).latitude) * (verticalPoint.latitude - mPoints.get((int)(i2 + 1)).latitude) <= 0.0 && (verticalPoint.longitude - mPoints.get((int)i2).longitude) * (verticalPoint.longitude - mPoints.get((int)(i2 + 1)).longitude) <= 0.0) {
                point2 = verticalPoint;
            } else {
                LatLng latLng = point2 = DistanceUtil.getDistance(point, mPoints.get(i2)) < DistanceUtil.getDistance(point, mPoints.get(i2 + 1)) ? mPoints.get(i2) : mPoints.get(i2 + 1);
            }
            point1 = point1 != null ? (DistanceUtil.getDistance(point, point2) < DistanceUtil.getDistance(point, point1) ? point2 : point1) : point2;
        }
        return point1;
    }

    public static LatLng getNearestDistancePointFromLine(List<LatLng> mPoints, LatLng point) {
        if (mPoints == null || mPoints.size() == 0 || point == null) {
            return null;
        }
        ArrayList<Point> pointList = new ArrayList<Point>();
        Iterator<LatLng> pointIterator = mPoints.iterator();
        while (pointIterator != null && pointIterator.hasNext()) {
            LatLng lat = pointIterator.next();
            pointList.add(new Point(lat.longitude, lat.latitude));
            if (!lat.equals(point)) continue;
            return lat;
        }
        Point point1 = new Point(point.longitude, point.latitude);
        Point point2 = SpatialRelationUtil.a(pointList, point1);
        if (point2 != null) {
            return new LatLng(point2.doubleY, point2.doubleX);
        }
        return null;
    }

    private static Point a(List<Point> pointList, Point point) {
        if (pointList != null && point != null && pointList.size() != 0) {
            if (pointList.size() < 2) {
                return null;
            }
            Point latLng = null;
            Point point1 = point;
            Point point2 = pointList.get(0);
            int pointSize = pointList.size();
            for (int i2 = 1; i2 <= pointSize - 1; ++i2) {
                Point dist;
                Point pointItem = pointList.get(i2);
                if (i2 == pointSize - 1 && pointItem.equals(point)) {
                    return point;
                }
                if (point2.equals(point)) {
                    return point;
                }
                latLng = dist = SpatialRelationUtil.a(point1.doubleX, point1.doubleY, point2.doubleX, point2.doubleY, pointItem.doubleX, pointItem.doubleY);
                point2 = pointItem;
            }
            return latLng;
        }
        return null;
    }

    private static Point a(double point1X, double point1Y, double point2X, double point2Y, double pointItemX, double pointItemY) {
        double d2;
        double dbb = (pointItemX - point2X) * (point1X - point2X) + (pointItemY - point2Y) * (point1Y - point2Y);
        if (d2 <= 0.0) {
            return new Point(point2X, point2Y);
        }
        double dba = (pointItemX - point2X) * (pointItemX - point2X) + (pointItemY - point2Y) * (pointItemY - point2Y);
        if (dbb >= dba) {
            return new Point(pointItemX, pointItemY);
        }
        double dbc = dbb / dba;
        double x2 = point2X + (pointItemX - point2X) * dbc;
        double y2 = point2Y + (pointItemY - point2Y) * dbc;
        return new Point(x2, y2);
    }

    private static LatLng a(LatLng startPoint, LatLng endPoint, LatLng point) {
        GeoPoint startGeoPoint = CoordUtil.ll2mc(startPoint);
        GeoPoint endGeoPoint = CoordUtil.ll2mc(endPoint);
        GeoPoint geoPoint = CoordUtil.ll2mc(point);
        double dba = Math.sqrt((endGeoPoint.getLongitudeE6() - startGeoPoint.getLongitudeE6()) * (endGeoPoint.getLongitudeE6() - startGeoPoint.getLongitudeE6()) + (endGeoPoint.getLatitudeE6() - startGeoPoint.getLatitudeE6()) * (endGeoPoint.getLatitudeE6() - startGeoPoint.getLatitudeE6()));
        double dbb = (endGeoPoint.getLongitudeE6() - startGeoPoint.getLongitudeE6()) * (geoPoint.getLongitudeE6() - startGeoPoint.getLongitudeE6()) + (endGeoPoint.getLatitudeE6() - startGeoPoint.getLatitudeE6()) * (geoPoint.getLatitudeE6() - startGeoPoint.getLatitudeE6());
        dba = dbb / (dba * dba);
        double x2 = startGeoPoint.getLongitudeE6() + (endGeoPoint.getLongitudeE6() - startGeoPoint.getLongitudeE6()) * dba;
        double y2 = startGeoPoint.getLatitudeE6() + (endGeoPoint.getLatitudeE6() - startGeoPoint.getLatitudeE6()) * dba;
        return CoordUtil.mc2ll(new GeoPoint(y2, x2));
    }
}

