/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.utils.route;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import com.baidu.mapapi.CoordType;
import com.baidu.mapapi.SDKInitializer;
import com.baidu.mapapi.model.LatLng;
import com.baidu.mapapi.navi.IllegalNaviArgumentException;
import com.baidu.mapapi.utils.OpenClientUtil;
import com.baidu.mapapi.utils.b;
import com.baidu.mapapi.utils.poi.IllegalPoiSearchArgumentException;
import com.baidu.mapapi.utils.route.RouteParaOption;
import com.baidu.mapsdkplatform.comapi.util.CoordTrans;

public class BaiduMapRoutePlan {
    private static boolean a = true;

    public static void setSupportWebRoute(boolean isSupport) {
        a = isSupport;
    }

    public static boolean openBaiduMapWalkingRoute(RouteParaOption para, Context context) {
        int version;
        if (para == null || context == null) {
            throw new IllegalPoiSearchArgumentException("BDMapSDKException: para or context can not be null.");
        }
        if (para.c == null && para.a == null) {
            throw new IllegalNaviArgumentException("BDMapSDKException: startPoint and startName not all null.");
        }
        if (para.d == null && para.b == null) {
            throw new IllegalNaviArgumentException("BDMapSDKException: endPoint and endName not all null.");
        }
        if (TextUtils.isEmpty((CharSequence)para.c) && para.a == null || TextUtils.isEmpty((CharSequence)para.d) && para.b == null) {
            Log.e((String)BaiduMapRoutePlan.class.getName(), (String)"poi startName or endName can not be empty string while pt is null");
            return false;
        }
        if (para.f == null) {
            para.f = RouteParaOption.EBusStrategyType.bus_recommend_way;
        }
        if ((version = OpenClientUtil.getBaiduMapVersion(context)) != 0) {
            if (version >= 810) {
                return b.a(para, context, 2);
            }
            Log.e((String)"baidumapsdk", (String)"Baidumap app version is too lowl.Version is greater than 8.1");
            if (a) {
                BaiduMapRoutePlan.a(para, context, 2);
                return true;
            }
            throw new IllegalPoiSearchArgumentException("BDMapSDKException: Baidumap app version is too lowl.Version is greater than 8.1");
        }
        Log.e((String)"baidumapsdk", (String)"BaiduMap app is not installed.");
        if (a) {
            BaiduMapRoutePlan.a(para, context, 2);
            return true;
        }
        throw new IllegalPoiSearchArgumentException("BDMapSDKException: BaiduMap app is not installed.");
    }

    public static boolean openBaiduMapTransitRoute(RouteParaOption para, Context context) {
        int version;
        if (para == null || context == null) {
            throw new IllegalPoiSearchArgumentException("BDMapSDKException: para or context can not be null.");
        }
        if (para.c == null && para.a == null) {
            throw new IllegalNaviArgumentException("BDMapSDKException: startPoint and startName not all null.");
        }
        if (para.d == null && para.b == null) {
            throw new IllegalNaviArgumentException("BDMapSDKException: endPoint and endName not all null.");
        }
        if (TextUtils.isEmpty((CharSequence)para.c) && para.a == null || TextUtils.isEmpty((CharSequence)para.d) && para.b == null) {
            Log.e((String)BaiduMapRoutePlan.class.getName(), (String)"poi startName or endName can not be empty string while pt is null");
            return false;
        }
        if (para.f == null) {
            para.f = RouteParaOption.EBusStrategyType.bus_recommend_way;
        }
        if ((version = OpenClientUtil.getBaiduMapVersion(context)) != 0) {
            if (version >= 810) {
                return b.a(para, context, 1);
            }
            Log.e((String)"baidumapsdk", (String)"Baidumap app version is too lowl.Version is greater than 8.1");
            if (a) {
                BaiduMapRoutePlan.a(para, context, 1);
                return true;
            }
            throw new IllegalPoiSearchArgumentException("BDMapSDKException: Baidumap app version is too lowl.Version is greater than 8.1");
        }
        Log.e((String)"baidumapsdk", (String)"BaiduMap app is not installed.");
        if (a) {
            BaiduMapRoutePlan.a(para, context, 1);
            return true;
        }
        throw new IllegalPoiSearchArgumentException("BDMapSDKException: BaiduMap app is not installed.");
    }

    public static void finish(Context context) {
        if (context != null) {
            b.a(context);
        }
    }

    public static boolean openBaiduMapDrivingRoute(RouteParaOption para, Context context) {
        int version;
        if (para == null || context == null) {
            throw new IllegalPoiSearchArgumentException("BDMapSDKException: para or context can not be null.");
        }
        if (para.c == null && para.a == null) {
            throw new IllegalNaviArgumentException("BDMapSDKException: startPoint and startName not all null.");
        }
        if (para.d == null && para.b == null) {
            throw new IllegalNaviArgumentException("BDMapSDKException: endPoint and endName not all null.");
        }
        if (TextUtils.isEmpty((CharSequence)para.c) && para.a == null || TextUtils.isEmpty((CharSequence)para.d) && para.b == null) {
            Log.e((String)BaiduMapRoutePlan.class.getName(), (String)"poi startName or endName can not be empty string while pt is null");
            return false;
        }
        if (para.f == null) {
            para.f = RouteParaOption.EBusStrategyType.bus_recommend_way;
        }
        if ((version = OpenClientUtil.getBaiduMapVersion(context)) != 0) {
            if (version >= 810) {
                return b.a(para, context, 0);
            }
            Log.e((String)"baidumapsdk", (String)"Baidumap app version is too lowl.Version is greater than 8.1");
            if (a) {
                BaiduMapRoutePlan.a(para, context, 0);
                return true;
            }
            throw new IllegalPoiSearchArgumentException("BDMapSDKException: Baidumap app version is too lowl.Version is greater than 8.1");
        }
        Log.e((String)"baidumapsdk", (String)"BaiduMap app is not installed.");
        if (a) {
            BaiduMapRoutePlan.a(para, context, 0);
            return true;
        }
        throw new IllegalPoiSearchArgumentException("BDMapSDKException: BaiduMap app is not installed.");
    }

    private static void a(RouteParaOption para, Context context, int type) {
        StringBuilder sb = new StringBuilder();
        sb.append("http://api.map.baidu.com/direction?");
        sb.append("origin=");
        LatLng start = para.a;
        if (SDKInitializer.getCoordType() == CoordType.GCJ02 && start != null) {
            start = CoordTrans.gcjToBaidu(start);
        }
        if (para.a != null && para.c != null && !para.c.equals("") && start != null) {
            sb.append("latlng:");
            sb.append(start.latitude);
            sb.append(",");
            sb.append(start.longitude);
            sb.append("|");
            sb.append("name:");
            sb.append(para.c);
        } else if (para.a != null && start != null) {
            sb.append(start.latitude);
            sb.append(",");
            sb.append(start.longitude);
        } else {
            sb.append(para.c);
        }
        LatLng end = para.b;
        if (SDKInitializer.getCoordType() == CoordType.GCJ02 && end != null) {
            end = CoordTrans.gcjToBaidu(end);
        }
        sb.append("&destination=");
        if (para.b != null && para.d != null && !para.d.equals("") && end != null) {
            sb.append("latlng:");
            sb.append(end.latitude);
            sb.append(",");
            sb.append(end.longitude);
            sb.append("|");
            sb.append("name:");
            sb.append(para.d);
        } else if (para.b != null && end != null) {
            sb.append(end.latitude);
            sb.append(",");
            sb.append(end.longitude);
        } else {
            sb.append(para.d);
        }
        String mode = "";
        switch (type) {
            case 0: {
                mode = "driving";
                break;
            }
            case 1: {
                mode = "transit";
                break;
            }
            case 2: {
                mode = "walking";
                break;
            }
        }
        sb.append("&mode=");
        sb.append(mode);
        sb.append("&region=");
        if (para.getCityName() == null || para.getCityName().equals("")) {
            sb.append("\u5168\u56fd");
        } else {
            sb.append(para.getCityName());
        }
        sb.append("&output=html");
        sb.append("&src=");
        sb.append(context.getPackageName());
        Uri uri = Uri.parse((String)sb.toString());
        Intent intent = new Intent();
        intent.setAction("android.intent.action.VIEW");
        intent.setFlags(0x10000000);
        intent.setData(uri);
        context.startActivity(intent);
    }

    public static boolean openBaiduMapNewEnergyRoute(RouteParaOption para, Context context) {
        int version;
        if (para == null || context == null) {
            throw new IllegalPoiSearchArgumentException("BDMapSDKException: para or context can not be null.");
        }
        if (para.c == null && para.a == null) {
            throw new IllegalNaviArgumentException("BDMapSDKException: startPoint and startName not all null.");
        }
        if (para.d == null && para.b == null) {
            throw new IllegalNaviArgumentException("BDMapSDKException: endPoint and endName not all null.");
        }
        if (TextUtils.isEmpty((CharSequence)para.c) && para.a == null || TextUtils.isEmpty((CharSequence)para.d) && para.b == null) {
            Log.e((String)BaiduMapRoutePlan.class.getName(), (String)"poi startName or endName can not be empty string while pt is null");
            return false;
        }
        if (para.f == null) {
            para.f = RouteParaOption.EBusStrategyType.bus_recommend_way;
        }
        if ((version = OpenClientUtil.getBaiduMapVersion(context)) != 0) {
            if (version >= 810) {
                return b.a(para, context, 101);
            }
            Log.e((String)"baidumapsdk", (String)"Baidumap app version is too lowl.Version is greater than 8.1");
            if (a) {
                BaiduMapRoutePlan.a(para, context, 101);
                return true;
            }
            throw new IllegalPoiSearchArgumentException("BDMapSDKException: Baidumap app version is too lowl.Version is greater than 8.1");
        }
        Log.e((String)"baidumapsdk", (String)"BaiduMap app is not installed.");
        if (a) {
            BaiduMapRoutePlan.a(para, context, 101);
            return true;
        }
        throw new IllegalPoiSearchArgumentException("BDMapSDKException: BaiduMap app is not installed.");
    }

    public static boolean openBaiduMapTruckRoute(RouteParaOption para, Context context) {
        int version;
        if (para == null || context == null) {
            throw new IllegalPoiSearchArgumentException("BDMapSDKException: para or context can not be null.");
        }
        if (para.c == null && para.a == null) {
            throw new IllegalNaviArgumentException("BDMapSDKException: startPoint and startName not all null.");
        }
        if (para.d == null && para.b == null) {
            throw new IllegalNaviArgumentException("BDMapSDKException: endPoint and endName not all null.");
        }
        if (TextUtils.isEmpty((CharSequence)para.c) && para.a == null || TextUtils.isEmpty((CharSequence)para.d) && para.b == null) {
            Log.e((String)BaiduMapRoutePlan.class.getName(), (String)"poi startName or endName can not be empty string while pt is null");
            return false;
        }
        if (para.f == null) {
            para.f = RouteParaOption.EBusStrategyType.bus_recommend_way;
        }
        if ((version = OpenClientUtil.getBaiduMapVersion(context)) != 0) {
            if (version >= 810) {
                return b.a(para, context, 102);
            }
            Log.e((String)"baidumapsdk", (String)"Baidumap app version is too lowl.Version is greater than 8.1");
            if (a) {
                BaiduMapRoutePlan.a(para, context, 7);
                return true;
            }
            throw new IllegalPoiSearchArgumentException("BDMapSDKException: Baidumap app version is too lowl.Version is greater than 8.1");
        }
        Log.e((String)"baidumapsdk", (String)"BaiduMap app is not installed.");
        if (a) {
            BaiduMapRoutePlan.a(para, context, 7);
            return true;
        }
        throw new IllegalPoiSearchArgumentException("BDMapSDKException: BaiduMap app is not installed.");
    }
}

