/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.platform.comapi.longlink;

import com.baidu.platform.comapi.exception.ComInitException;
import com.baidu.platform.comapi.exception.InvalidComException;
import com.baidu.platform.comapi.longlink.ELongLinkStatus;
import com.baidu.platform.comapi.longlink.LongLinkDataCallback;
import com.baidu.platform.comapi.longlink.LongLinkFileData;
import com.baidu.platform.comjni.base.longlink.NALongLink;
import java.util.ArrayList;

public class LongLinkClient {
    private int a;
    private long b;
    private int c;

    public static LongLinkClient create() throws ComInitException {
        long addr = NALongLink.create();
        if (addr != 0L) {
            LongLinkClient client = new LongLinkClient(addr);
            return client;
        }
        throw new ComInitException("LongLink Component created failed!");
    }

    public static LongLinkClient create(int moduleId) throws ComInitException {
        long addr = NALongLink.create();
        if (addr != 0L) {
            LongLinkClient client = new LongLinkClient(addr, moduleId);
            return client;
        }
        throw new ComInitException("LongLink Component created failed!");
    }

    public boolean init(String domain, String params) throws InvalidComException {
        if (this.isValid()) {
            return NALongLink.init(this.b, domain, params);
        }
        throw new InvalidComException();
    }

    public int release() {
        int res;
        if (this.isValid() && (res = NALongLink.release(this.b)) <= 0) {
            this.b = 0L;
        }
        return -1;
    }

    private LongLinkClient(long nativeJniPtr, int longlinkModuleId) {
        this.b = nativeJniPtr;
        this.a = longlinkModuleId;
    }

    private LongLinkClient(long nativeJniPtr) {
        this.b = nativeJniPtr;
    }

    public void setModuleId(int longlinkModuleId) {
        this.a = longlinkModuleId;
    }

    public boolean isValid() {
        return this.b != 0L;
    }

    public synchronized int getRequestId() {
        return this.c;
    }

    public synchronized boolean register(LongLinkDataCallback callback) throws InvalidComException {
        if (this.isValid()) {
            return NALongLink.register(this.b, this.a, callback);
        }
        throw new InvalidComException();
    }

    public synchronized boolean unRegister(LongLinkDataCallback callback) throws InvalidComException {
        if (this.isValid()) {
            return NALongLink.unRegister(this.b, this.a, callback);
        }
        throw new InvalidComException();
    }

    public synchronized ELongLinkStatus sendData(byte[] dataBuffer) throws InvalidComException {
        if (this.isValid()) {
            ++this.c;
            ELongLinkStatus status = ELongLinkStatus.values()[NALongLink.sendData(this.b, this.a, this.c, dataBuffer)];
            status.setRequestId(this.c);
            return status;
        }
        throw new InvalidComException();
    }

    public synchronized ELongLinkStatus sendFileData(String fileParams, ArrayList<LongLinkFileData> fileData) throws InvalidComException {
        if (this.isValid()) {
            ++this.c;
            ELongLinkStatus status = ELongLinkStatus.values()[NALongLink.sendFileData(this.b, this.a, this.c, fileParams, fileData)];
            status.setRequestId(this.c);
            return status;
        }
        throw new InvalidComException();
    }

    public boolean start() throws InvalidComException {
        if (this.isValid()) {
            return NALongLink.start(this.b);
        }
        throw new InvalidComException();
    }

    public void stop() throws InvalidComException {
        if (!this.isValid()) {
            throw new InvalidComException();
        }
        NALongLink.stop(this.b);
    }
}

