/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.platform.comapi.map;

import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import com.baidu.platform.comapi.basestruct.GeoPoint;
import com.baidu.platform.comapi.map.MapSurfaceView;
import com.baidu.platform.comapi.map.MapTextureView;
import com.baidu.platform.comapi.map.Overlay;
import com.baidu.platform.comapi.map.OverlayItem;
import com.baidu.platform.comapi.map.aa;
import com.baidu.platform.comapi.map.ae;
import com.baidu.platform.comapi.util.d;
import com.baidu.platform.comjni.tools.ParcelItem;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class ItemizedOverlay<Item extends OverlayItem>
extends Overlay
implements Comparator<Integer> {
    protected ArrayList<OverlayItem> a;
    protected ArrayList<Integer> b;
    protected Drawable c;
    protected MapSurfaceView d;
    protected MapTextureView e;
    protected boolean f;
    protected Drawable g;
    protected OverlayItem h;
    protected int i = 0;
    protected int j;

    public ItemizedOverlay(Drawable defaultMarker, MapSurfaceView mapView) {
        this.mType = 27;
        this.c = defaultMarker;
        this.a = new ArrayList();
        this.b = new ArrayList();
        this.d = mapView;
        this.mLayerID = 0L;
    }

    public ItemizedOverlay(Drawable defaultMarker, MapTextureView mapView) {
        this.mType = 27;
        this.c = defaultMarker;
        this.a = new ArrayList();
        this.b = new ArrayList();
        this.e = mapView;
        this.mLayerID = 0L;
    }

    public void setmMarker(Drawable mMarker) {
        this.c = mMarker;
    }

    public int getUpdateType() {
        return this.i;
    }

    public void setUpdateType(int updateType) {
        this.i = updateType;
    }

    public void initLayer() {
        this.mLayerID = this.d.getController().getBaseMap().AddLayer(0, 0, "item");
        if (this.mLayerID == 0L) {
            throw new RuntimeException("can not add new layer");
        }
    }

    public void addItem(OverlayItem item) {
        if (item != null) {
            ArrayList<OverlayItem> items = new ArrayList<OverlayItem>(1);
            items.add(item);
            this.addItem(items);
        }
    }

    public void setFocusMarker(Drawable focusMarker) {
        this.g = focusMarker;
        if (this.h == null) {
            this.h = new OverlayItem(null, "", "");
        }
        this.h.setMarker(this.g);
    }

    public void setFocusMarker(Drawable focusMarker, float anchorX, float anchorY) {
        this.g = focusMarker;
        if (this.h == null) {
            this.h = new OverlayItem(null, "", "");
            this.h.setAnchor(anchorX, anchorY);
        }
        this.h.setMarker(this.g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFocus(int index, boolean bFocus) {
        if (this.h == null) {
            return;
        }
        OverlayItem needFocus = this.getItem(index);
        if (needFocus != null) {
            if (bFocus) {
                this.h.setGeoPoint(new GeoPoint(needFocus.getPoint().getLatitude(), needFocus.getPoint().getLongitude()));
                ArrayList<OverlayItem> overlayItems = null;
                ItemizedOverlay itemizedOverlay = this;
                synchronized (itemizedOverlay) {
                    overlayItems = new ArrayList<OverlayItem>(this.a);
                }
                if (overlayItems.contains(this.h)) {
                    this.updateItem(this.h);
                } else {
                    this.addItem(this.h);
                }
            } else {
                this.removeItem(this.h);
            }
            if (this.d != null) {
                this.d.refresh(this);
            }
        }
    }

    public void addItemsByReplace(List<OverlayItem> items) {
        this.a(items, false, true);
    }

    public void addItem(List<OverlayItem> items) {
        this.a(items, false, false);
    }

    private void a(List<OverlayItem> items, boolean isUpdateMode) {
        this.a(items, isUpdateMode, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(List<OverlayItem> items, boolean isUpdateMode, boolean isReplace) {
        ItemizedOverlay itemizedOverlay;
        if (isReplace) {
            itemizedOverlay = this;
            synchronized (itemizedOverlay) {
                if (this.a != null) {
                    this.a.clear();
                }
            }
        }
        if (this.mLayerID == 0L) {
            if (!isUpdateMode) {
                itemizedOverlay = this;
                synchronized (itemizedOverlay) {
                    if (this.a != null && items != null) {
                        this.a.addAll(items);
                    }
                }
            }
            return;
        }
        Bundle bundle = new Bundle();
        bundle.clear();
        ArrayList<ParcelItem> parcle = new ArrayList<ParcelItem>();
        bundle.putLong("itemaddr", this.mLayerID);
        bundle.putInt("bshow", 1);
        if (isUpdateMode) {
            bundle.putString("extparam", "update");
        }
        for (int i2 = 0; i2 < items.size(); ++i2) {
            OverlayItem subItem = items.get(i2);
            if (subItem.getMarker() == null) {
                subItem.setMarker(this.c);
            }
            if (TextUtils.isEmpty((CharSequence)subItem.getId())) {
                subItem.setId(ae.a());
            }
            ParcelItem subParacel = new ParcelItem();
            Drawable drawable = subItem.getMarker();
            byte[] gifData = subItem.getGifData();
            if (drawable == null && gifData == null) continue;
            Bundle subBunle = new Bundle();
            GeoPoint subpt = null;
            subpt = subItem.getCoordType() == OverlayItem.CoordType.CoordType_BD09LL ? aa.a(subItem.getPoint()) : subItem.getPoint();
            subBunle.putDouble("x", subpt.getLongitude());
            subBunle.putDouble("y", subpt.getLatitude());
            subBunle.putFloat("geoz", subItem.getGeoZ());
            subBunle.putInt("indoorpoi", subItem.getIndoorPoi());
            subBunle.putInt("showLR", 1);
            subBunle.putInt("iconwidth", 0);
            subBunle.putInt("iconlayer", 1);
            subBunle.putFloat("ax", subItem.getAnchorX());
            subBunle.putFloat("ay", subItem.getAnchorY());
            subBunle.putInt("bound", subItem.getBound());
            subBunle.putInt("level", subItem.getLevel());
            subBunle.putInt("mask", subItem.getMask());
            subBunle.putString("popname", "" + subItem.getId());
            if (gifData != null) {
                subBunle.putFloat("gifscale", subItem.getScale());
                subBunle.putInt("gifsize", gifData.length);
                subBunle.putByteArray("imgdata", gifData);
                subBunle.putInt("imgindex", this.c());
            } else {
                Bitmap bmp = com.baidu.platform.comapi.util.d.a(drawable);
                if (bmp == null) continue;
                subBunle.putInt("imgindex", subItem.getResId());
                subBunle.putInt("imgW", bmp.getWidth());
                subBunle.putInt("imgH", bmp.getHeight());
                if (!isUpdateMode && this.a(subItem)) {
                    subBunle.putByteArray("imgdata", null);
                } else {
                    ByteBuffer dstBuffer = ByteBuffer.allocate(bmp.getWidth() * bmp.getHeight() * 4);
                    bmp.copyPixelsToBuffer((Buffer)dstBuffer);
                    byte[] bmpData = dstBuffer.array();
                    subBunle.putByteArray("imgdata", bmpData);
                }
            }
            String[] clickRectArray = this.a(subItem.getClickRect());
            if (clickRectArray != null && clickRectArray.length > 0) {
                subBunle.putStringArray("clickrect", clickRectArray);
            }
            subBunle.putBundle("animate", subItem.getAnimate());
            subBunle.putBundle("delay", subItem.getDelay());
            subParacel.setBundle(subBunle);
            parcle.add(subParacel);
            if (isUpdateMode) continue;
            this.a.add(subItem);
        }
        if (parcle.size() > 0) {
            Parcelable[] midpar = new ParcelItem[parcle.size()];
            for (int j2 = 0; j2 < parcle.size(); ++j2) {
                midpar[j2] = (ParcelItem)parcle.get(j2);
            }
            bundle.putParcelableArray("itemdatas", midpar);
            this.d.getController().getBaseMap().AddItemData(bundle, isReplace);
        }
        ItemizedOverlay itemizedOverlay2 = this;
        synchronized (itemizedOverlay2) {
            this.f = true;
        }
    }

    protected String[] a(ArrayList<Bundle> clickRectList) {
        if (clickRectList != null && clickRectList.size() > 0) {
            int len = clickRectList.size();
            String[] rectStringList = new String[len];
            for (int i2 = 0; i2 < len; ++i2) {
                JSONObject itemObj = new JSONObject();
                Bundle itemBundle = clickRectList.get(i2);
                Set keys = itemBundle.keySet();
                for (String key : keys) {
                    try {
                        itemObj.put(key, itemBundle.get(key));
                    }
                    catch (JSONException jSONException) {}
                }
                rectStringList[i2] = itemObj.toString();
            }
            return rectStringList;
        }
        return null;
    }

    public ArrayList<OverlayItem> getAllItem() {
        return this.a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final OverlayItem getItem(int position) {
        if (this.a == null) {
            return null;
        }
        ArrayList<OverlayItem> overlayItems = null;
        ItemizedOverlay itemizedOverlay = this;
        synchronized (itemizedOverlay) {
            overlayItems = new ArrayList<OverlayItem>(this.a);
        }
        if (overlayItems.size() > position && position >= 0) {
            return overlayItems.get(position);
        }
        return null;
    }

    public int getLatSpanE6() {
        return this.b(true);
    }

    public int getLonSpanE6() {
        return this.b(false);
    }

    public GeoPoint getCenter() {
        int i2 = this.a(0);
        if (i2 == -1) {
            return null;
        }
        return this.getItem(i2).getPoint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int b(boolean latSpan) {
        if (this.a == null) {
            return 0;
        }
        ArrayList<OverlayItem> overlayItems = null;
        ItemizedOverlay itemizedOverlay = this;
        synchronized (itemizedOverlay) {
            if (this.a.size() == 0) {
                return 0;
            }
            ItemizedOverlay itemizedOverlay2 = this;
            synchronized (itemizedOverlay2) {
                overlayItems = new ArrayList<OverlayItem>(this.a);
            }
        }
        int max = Integer.MIN_VALUE;
        int min = Integer.MAX_VALUE;
        Iterator<OverlayItem> iterator = overlayItems.iterator();
        while (iterator.hasNext()) {
            int k2;
            GeoPoint geopoint = iterator.next().getPoint();
            int n2 = k2 = latSpan ? (int)geopoint.getLatitude() : (int)geopoint.getLongitude();
            if (k2 > max) {
                max = k2;
            }
            if (k2 >= min) continue;
            min = k2;
        }
        return max - min;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int a(int drawingOrder) {
        ItemizedOverlay itemizedOverlay = this;
        synchronized (itemizedOverlay) {
            if (this.a == null || this.a.size() == 0) {
                return -1;
            }
        }
        return drawingOrder;
    }

    public boolean onTap(int index) {
        return false;
    }

    public boolean onTap(GeoPoint p2, MapSurfaceView mapView) {
        return false;
    }

    public boolean onTap(int index, int clickIndex, GeoPoint p2) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int compare(Integer object1, Integer object2) {
        GeoPoint pt1 = null;
        GeoPoint pt2 = null;
        ItemizedOverlay itemizedOverlay = this;
        synchronized (itemizedOverlay) {
            pt1 = this.a.get(object1).getPoint();
            pt2 = this.a.get(object2).getPoint();
        }
        if (pt1.getLatitude() > pt2.getLatitude()) {
            return -1;
        }
        if (pt1.getLatitude() < pt2.getLatitude()) {
            return 1;
        }
        if (pt1.getLongitude() < pt2.getLongitude()) {
            return -1;
        }
        return pt1.getLongitude() == pt2.getLongitude() ? 0 : 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateItem(OverlayItem item) {
        if (item == null) {
            return false;
        }
        if (item.getId().equals("")) {
            return false;
        }
        boolean isItemAdded = false;
        ArrayList<OverlayItem> overlayItems = null;
        ItemizedOverlay itemizedOverlay = this;
        synchronized (itemizedOverlay) {
            overlayItems = new ArrayList<OverlayItem>(this.a);
        }
        for (OverlayItem mItem : overlayItems) {
            if (!item.getId().equals(mItem.getId())) continue;
            isItemAdded = true;
            break;
        }
        if (!isItemAdded) {
            return false;
        }
        ArrayList<OverlayItem> items = new ArrayList<OverlayItem>();
        items.add(item);
        this.a(items, true);
        return true;
    }

    public boolean updateItem(List<OverlayItem> items) {
        if (items == null) {
            return false;
        }
        this.a(items, true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeItem(OverlayItem item) {
        if (this.mLayerID == 0L) {
            return false;
        }
        Bundle bundle = new Bundle();
        bundle.putLong("itemaddr", this.mLayerID);
        if (item.getId().equals("")) {
            return false;
        }
        bundle.putString("id", item.getId());
        if (!this.d.getController().getBaseMap().RemoveItemData(bundle)) {
            return false;
        }
        ItemizedOverlay itemizedOverlay = this;
        synchronized (itemizedOverlay) {
            this.a.remove(item);
            this.f = true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll() {
        ItemizedOverlay itemizedOverlay = this;
        synchronized (itemizedOverlay) {
            if (this.a.isEmpty()) {
                return false;
            }
        }
        if (this.d.getController() != null && this.d.getController().getBaseMap() != null) {
            this.d.getController().getBaseMap().ClearLayer(this.mLayerID);
        }
        itemizedOverlay = this;
        synchronized (itemizedOverlay) {
            this.a.clear();
            this.f = true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void a() {
        ArrayList<OverlayItem> tmp = null;
        ItemizedOverlay itemizedOverlay = this;
        synchronized (itemizedOverlay) {
            tmp = new ArrayList<OverlayItem>(this.a);
        }
        this.removeAll();
        this.addItem(tmp);
    }

    synchronized void a(boolean isNeedUpdate) {
        this.f = isNeedUpdate;
    }

    boolean b() {
        return this.f;
    }

    public synchronized int size() {
        return this.a == null ? 0 : this.a.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean a(OverlayItem Item) {
        ArrayList<OverlayItem> overlayItems = null;
        ItemizedOverlay itemizedOverlay = this;
        synchronized (itemizedOverlay) {
            overlayItems = new ArrayList<OverlayItem>(this.a);
        }
        for (OverlayItem overlayItem : overlayItems) {
            if (Item.getResId() == -1) {
                return false;
            }
            if (overlayItem.getResId() == -1 || Item.getResId() != overlayItem.getResId()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeOneItem(Iterator<OverlayItem> iterator, OverlayItem item) {
        if (this.mLayerID == 0L) {
            return false;
        }
        Bundle bundle = new Bundle();
        bundle.putLong("itemaddr", this.mLayerID);
        if (item.getId().equals("")) {
            return false;
        }
        bundle.putString("id", item.getId());
        if (!this.d.getController().getBaseMap().RemoveItemData(bundle)) {
            return false;
        }
        iterator.remove();
        ItemizedOverlay itemizedOverlay = this;
        synchronized (itemizedOverlay) {
            this.f = true;
        }
        return true;
    }

    private int c() {
        return this.j < Integer.MAX_VALUE ? (this.j = this.j + 1) : 0;
    }
}

