/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.platform.comapi.map;

import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Parcelable;
import com.baidu.platform.comapi.map.InnerOverlay;
import com.baidu.platform.comapi.map.OverlayLocationData;
import com.baidu.platform.comjni.map.basemap.AppBaseMap;
import com.baidu.platform.comjni.tools.ParcelItem;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class LocationOverlay
extends InnerOverlay {
    private AppBaseMap a;

    public LocationOverlay() {
        super(7);
    }

    public LocationOverlay(AppBaseMap baseMap) {
        super(7, baseMap);
        this.a = baseMap;
    }

    @Override
    public String getLayerTag() {
        return "location";
    }

    @Override
    public boolean getDefaultShowStatus() {
        return true;
    }

    public void setLocationLayerData(List<OverlayLocationData> list) {
        if (list == null || list.size() <= 0 || this.mLayerID == 0L) {
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putLong("locationaddr", this.mLayerID);
        ArrayList<ParcelItem> parcle = new ArrayList<ParcelItem>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            OverlayLocationData subItem = list.get(i2);
            if (subItem.getImage() == null) {
                return;
            }
            ParcelItem subParacel = new ParcelItem();
            Bitmap bmp = subItem.getImage();
            Bundle subBunle = new Bundle();
            ByteBuffer dstBuffer = ByteBuffer.allocate(bmp.getWidth() * bmp.getHeight() * 4);
            bmp.copyPixelsToBuffer((Buffer)dstBuffer);
            byte[] bmpData = dstBuffer.array();
            subBunle.putByteArray("imgbin", bmpData);
            subBunle.putInt("w", subItem.getImgWidth());
            subBunle.putInt("h", subItem.getImgHeight());
            subBunle.putInt("rotation", subItem.isRotation());
            subBunle.putString("name", subItem.getImgName() + "_" + Arrays.hashCode(bmpData));
            subParacel.setBundle(subBunle);
            parcle.add(subParacel);
        }
        if (parcle.size() > 0) {
            Parcelable[] midpar = new ParcelItem[parcle.size()];
            for (int j2 = 0; j2 < parcle.size(); ++j2) {
                midpar[j2] = (ParcelItem)parcle.get(j2);
            }
            bundle.putParcelableArray("imagedata", midpar);
        }
        this.a.SetLocationLayerData(bundle);
    }

    public void clearLocationLayerData(Bundle bundle) {
        if (bundle == null) {
            bundle = new Bundle();
        }
        bundle.putLong("locationaddr", this.mLayerID);
        this.a.ClearLocationLayerData(bundle);
    }

    public void beginLocationLayerAnimation() {
        this.a.BeginLocationLayerAnimation();
    }
}

