/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.platform.comapi.map;

import java.io.Serializable;

public class MapStatus
implements Serializable {
    public float level;
    public int rotation;
    public int overlooking;
    public double centerPtX;
    public double centerPtY;
    public double centerPtZ;
    public WinRound winRound;
    public GeoBound geoRound;
    public float xOffset;
    public float yOffset;
    public boolean bfpp;
    public String panoId;
    public float streetIndicateAngle;
    public boolean isBirdEye;
    public int streetExt;
    public float roadOffsetX;
    public float roadOffsetY;
    public int hasAnimation;
    public int animationTime;
    public int animationType = 0;
    public boolean bOverlookSpringback;
    public int minOverlooking;
    public float xScreenOffset;
    public float yScreenOffset;

    public int hashCode() {
        int prime = 31;
        double result = 1.0;
        result = 31.0 * result + this.centerPtX;
        result = 31.0 * result + this.centerPtY;
        result = 31.0 * result + this.centerPtZ;
        result = 31.0 * result + (double)(this.bfpp ? 1 : 0);
        result = 31.0 * result + (double)(this.geoRound == null ? 0 : this.geoRound.hashCode());
        result = 31.0 * result + (double)Float.floatToIntBits(this.level);
        result = 31.0 * result + (double)this.overlooking;
        result = 31.0 * result + (double)this.rotation;
        result = 31.0 * result + (double)(this.winRound == null ? 0 : this.winRound.hashCode());
        return (int)result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MapStatus)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        MapStatus other = (MapStatus)obj;
        if (this.centerPtX != other.centerPtX) {
            return false;
        }
        if (this.centerPtY != other.centerPtY) {
            return false;
        }
        if (this.centerPtZ != other.centerPtZ) {
            return false;
        }
        if (this.bfpp != other.bfpp) {
            return false;
        }
        if (this.geoRound == null ? other.geoRound != null : !this.geoRound.equals(other.geoRound)) {
            return false;
        }
        if (Float.floatToIntBits(this.level) != Float.floatToIntBits(other.level)) {
            return false;
        }
        if (this.overlooking != other.overlooking) {
            return false;
        }
        if (this.rotation != other.rotation) {
            return false;
        }
        if (this.yOffset != other.yOffset) {
            return false;
        }
        if (this.xOffset != other.xOffset) {
            return false;
        }
        if (this.xScreenOffset != other.xScreenOffset) {
            return false;
        }
        if (this.yScreenOffset != other.yScreenOffset) {
            return false;
        }
        return !(this.winRound == null ? other.winRound != null : !this.winRound.equals(other.winRound));
    }

    public MapStatus() {
        this.level = -1.0f;
        this.rotation = -1;
        this.overlooking = -1;
        this.centerPtX = -1.0;
        this.centerPtY = -1.0;
        this.centerPtZ = 0.0;
        this.xOffset = 0.0f;
        this.yOffset = 0.0f;
        this.winRound = new WinRound();
        this.geoRound = new GeoBound();
        this.bfpp = false;
        this.panoId = "";
        this.streetIndicateAngle = 0.0f;
        this.isBirdEye = false;
        this.streetExt = 0;
        this.roadOffsetX = 0.0f;
        this.roadOffsetY = 0.0f;
        this.bOverlookSpringback = false;
        this.minOverlooking = -1;
        this.xScreenOffset = 0.0f;
        this.yScreenOffset = 0.0f;
    }

    public MapStatus(MapStatus other) {
        this.level = other.level;
        this.rotation = other.rotation;
        this.overlooking = other.overlooking;
        this.centerPtX = other.centerPtX;
        this.centerPtY = other.centerPtY;
        this.centerPtZ = other.centerPtZ;
        this.xOffset = other.xOffset;
        this.yOffset = other.yOffset;
        this.winRound = other.winRound;
        this.geoRound = other.geoRound;
        this.bfpp = other.bfpp;
        this.panoId = other.panoId;
        this.streetIndicateAngle = other.streetIndicateAngle;
        this.isBirdEye = other.isBirdEye;
        this.streetExt = other.streetExt;
        this.roadOffsetX = other.roadOffsetX;
        this.roadOffsetY = other.roadOffsetY;
        this.bOverlookSpringback = other.bOverlookSpringback;
        this.minOverlooking = other.minOverlooking;
        this.xScreenOffset = other.xScreenOffset;
        this.yScreenOffset = other.yScreenOffset;
    }

    public String toString() {
        return "MapStatus{level=" + this.level + ", rotation=" + this.rotation + ", overlooking=" + this.overlooking + ", centerPtX=" + this.centerPtX + ", centerPtY=" + this.centerPtY + ", centerPtZ=" + this.centerPtZ + ", winRound=" + this.winRound + ", geoRound=" + this.geoRound + ", xOffset=" + this.xOffset + ", yOffset=" + this.yOffset + ", bfpp=" + this.bfpp + ", panoId='" + this.panoId + '\'' + ", streetIndicateAngle=" + this.streetIndicateAngle + ", isBirdEye=" + this.isBirdEye + ", streetExt=" + this.streetExt + ", roadOffsetX=" + this.roadOffsetX + ", roadOffsetY=" + this.roadOffsetY + ", xScreenOffset=" + this.xScreenOffset + ", yScreenOffset=" + this.yScreenOffset + '}';
    }

    public static class WinRound
    implements Serializable {
        public int left = 0;
        public int right = 0;
        public int top = 0;
        public int bottom = 0;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.bottom;
            result = 31 * result + this.left;
            result = 31 * result + this.right;
            result = 31 * result + this.top;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof WinRound)) {
                return false;
            }
            WinRound other = (WinRound)obj;
            if (this.bottom != other.bottom) {
                return false;
            }
            if (this.left != other.left) {
                return false;
            }
            if (this.right != other.right) {
                return false;
            }
            return this.top == other.top;
        }
    }

    public static class GeoBound
    implements Serializable {
        public long left = 0L;
        public long right = 0L;
        public long top = 0L;
        public long bottom = 0L;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.bottom ^ this.bottom >>> 32);
            result = 31 * result + (int)(this.left ^ this.left >>> 32);
            result = 31 * result + (int)(this.right ^ this.right >>> 32);
            result = 31 * result + (int)(this.top ^ this.top >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof GeoBound)) {
                return false;
            }
            GeoBound other = (GeoBound)obj;
            if (this.bottom != other.bottom) {
                return false;
            }
            if (this.left != other.left) {
                return false;
            }
            if (this.right != other.right) {
                return false;
            }
            return this.top == other.top;
        }
    }
}

