/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.platform.comapi.map;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.opengl.GLSurfaceView;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import com.baidu.mapapi.common.SysOSUtil;
import com.baidu.mapsdkplatform.comapi.map.d;
import com.baidu.platform.comapi.basestruct.GeoPoint;
import com.baidu.platform.comapi.basestruct.MapBound;
import com.baidu.platform.comapi.bmsdk.BmLayer;
import com.baidu.platform.comapi.map.IndoorMapInfo;
import com.baidu.platform.comapi.map.InnerOverlay;
import com.baidu.platform.comapi.map.ItemizedOverlay;
import com.baidu.platform.comapi.map.MapController;
import com.baidu.platform.comapi.map.MapRenderModeChangeListener;
import com.baidu.platform.comapi.map.MapStatus;
import com.baidu.platform.comapi.map.MapViewInterface;
import com.baidu.platform.comapi.map.Overlay;
import com.baidu.platform.comapi.map.Projection;
import com.baidu.platform.comapi.map.ac;
import com.baidu.platform.comapi.map.af;
import com.baidu.platform.comapi.map.ak;
import com.baidu.platform.comapi.map.al;
import com.baidu.platform.comapi.map.am;
import com.baidu.platform.comapi.map.h;
import com.baidu.platform.comapi.map.l;
import com.baidu.platform.comapi.map.p;
import com.baidu.platform.comapi.map.y;
import com.baidu.platform.comjni.map.basemap.AppBaseMap;
import java.util.ArrayList;
import java.util.List;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;

public class MapTextureView
extends h
implements MapRenderModeChangeListener,
MapViewInterface,
ak {
    protected d a;
    protected MapController b = null;
    protected af c = null;
    protected l d = null;
    protected p e = null;
    int f;
    int g;
    private List<BmLayer> l = new ArrayList<BmLayer>();
    protected List<Overlay> h = new ArrayList<Overlay>();
    protected ac i;
    protected am j;
    protected GestureDetector k;
    private c m;

    public MapTextureView(Context context) {
        super(context);
        this.a(context);
    }

    public MapTextureView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.a(context);
    }

    public MapTextureView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.a(context);
    }

    private void a(Context context) {
        this.setEGLContextClientVersion(2);
        this.j = new am();
        this.k = new GestureDetector(context, (GestureDetector.OnGestureListener)this.j);
        this.j.a(new b(null));
    }

    public void listenMapRenderMessage(c listener) {
        this.m = listener;
    }

    public void unListenMapRenderMessage() {
        this.m = null;
    }

    public void setBaseMap(d baseMap) {
        this.a = baseMap;
    }

    public d getBaseMap() {
        return this.a;
    }

    public void attachBaseMapController(MapController mapController) {
        this.e = new p(this, (ak)this);
        this.b = mapController;
        this.e.a(mapController.getBaseMap());
        this.setEGLContextFactory(new a(null));
        this.setRenderer(this.e);
        this.setRenderMode(0);
        this.e.a(true);
        this.c = new af(this.b.getBaseMap());
        this.b.setOverlayMapCallBack(this.c);
        this.b.setMapViewInterface(this);
        this.b();
        this.b.setMapRenderModeChangeListener(this);
        this.d = new l(this.b);
        this.j.a(this.b);
    }

    public void setMapRenderStableListener(ac listener) {
        this.i = listener;
    }

    @Override
    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        super.onSurfaceTextureAvailable(surface, width, height);
        this.f = width;
        this.g = height;
        if (this.b != null) {
            if (this.b.getMapViewSurfaceListener() != null) {
                this.b.getMapViewSurfaceListener().onSurfaceChanged(width, height);
            }
            MapStatus st = this.getMapStatus();
            this.f = Math.abs(st.winRound.right - st.winRound.left);
            this.g = Math.abs(st.winRound.bottom - st.winRound.top);
        }
        if (this.a != null) {
            this.a.a(this.f, this.g);
        }
    }

    @Override
    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
        super.onSurfaceTextureSizeChanged(surface, width, height);
        this.f = width;
        this.g = height;
        this.e.a = width;
        this.e.b = height;
        this.e.c = 0;
        if (this.b != null) {
            MapStatus st = this.getMapStatus();
            st.winRound.left = 0;
            st.winRound.top = 0;
            st.winRound.bottom = height;
            st.winRound.right = width;
            this.b.setMapStatusWithAnimation(st, 4, 0);
            if (this.b.getMapViewSurfaceListener() != null) {
                this.b.getMapViewSurfaceListener().onSurfaceChanged(width, height);
            }
            st = this.getMapStatus();
            this.f = Math.abs(st.winRound.right - st.winRound.left);
            this.g = Math.abs(st.winRound.bottom - st.winRound.top);
            this.b.setScreenSize(this.f, this.g);
        }
        if (this.a != null) {
            this.a.a(this.f, this.g);
        }
    }

    @Override
    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        super.onSurfaceTextureDestroyed(surface);
        return true;
    }

    @Override
    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
        super.onSurfaceTextureUpdated(surface);
    }

    public void doCaptureMapView(com.baidu.platform.comapi.map.c captureMapViewListener, int width, int height, Bitmap.Config config) {
        this.e.a(captureMapViewListener, width, height, config);
    }

    public void doCaptureMapView(com.baidu.platform.comapi.map.c captureMapViewListener, Rect rect, Bitmap.Config config) {
        if (rect != null) {
            int startX = rect.left;
            int startY = this.g < rect.bottom ? 0 : this.g - rect.bottom;
            int width = rect.width();
            int height = rect.height();
            if (startX < 0 || startY < 0 || width <= 0 || height <= 0) {
                return;
            }
            if (width > this.f) {
                width = Math.abs(rect.width()) - (rect.right - this.f);
            }
            if (height > this.g) {
                height = Math.abs(rect.height()) - (rect.bottom - this.g);
            }
            if (startX > SysOSUtil.getScreenSizeX() || startY > SysOSUtil.getScreenSizeY()) {
                return;
            }
            this.e.a(captureMapViewListener, startX, startY, width, height, config);
        }
    }

    @Override
    public void onMapRenderModeChange(int arg) {
        if (this.m != null) {
            this.m.a(arg);
        }
        if (arg == 1) {
            this.requestRender();
        } else if (arg == 0) {
            if (this.getRenderMode() != 0) {
                this.setRenderMode(0);
            }
        } else if (arg == 2 && this.i != null) {
            this.i.a();
        }
    }

    @Override
    public void onRequestRender() {
    }

    @Override
    public MapController getController() {
        return this.b;
    }

    public void animateTo(MapStatus st, int animTime) {
        if (this.b != null) {
            this.b.setMapStatusWithAnimation(st, animTime);
        }
    }

    @Override
    public int getLatitudeSpan() {
        MapStatus mapStatus = this.getMapStatus();
        l p2 = (l)this.getProjection();
        GeoPoint viewTopLeft = p2.fromPixels(mapStatus.winRound.left, mapStatus.winRound.top);
        GeoPoint viewBottomRight = p2.fromPixels(mapStatus.winRound.right - 1, mapStatus.winRound.bottom - 1);
        return (int)Math.abs(viewTopLeft.getLatitude() - viewBottomRight.getLatitude());
    }

    @Override
    public int getLongitudeSpan() {
        MapStatus mapStatus = this.getMapStatus();
        l p2 = (l)this.getProjection();
        GeoPoint viewTopLeft = p2.fromPixels(mapStatus.winRound.left, mapStatus.winRound.top);
        GeoPoint viewBottomRight = p2.fromPixels(mapStatus.winRound.right - 1, mapStatus.winRound.bottom - 1);
        return (int)Math.abs(viewBottomRight.getLongitude() - viewTopLeft.getLongitude());
    }

    @Override
    public void setMapCenter(GeoPoint geoPoint) {
        if (this.b != null) {
            MapStatus mapStatus = this.b.getMapStatus();
            mapStatus.centerPtX = geoPoint.getLongitude();
            mapStatus.centerPtY = geoPoint.getLatitude();
            this.b.setMapStatus(mapStatus);
        }
    }

    @Override
    public GeoPoint getMapCenter() {
        if (this.b == null) {
            return null;
        }
        MapStatus mapStatus = this.b.getMapStatus();
        GeoPoint geoPoint = new GeoPoint(mapStatus.centerPtY, mapStatus.centerPtX);
        return geoPoint;
    }

    @Override
    public void setZoomLevel(float zoomLevel) {
        if (this.b == null) {
            return;
        }
        float iLevel = zoomLevel;
        int maxZoomLevel = 21;
        IndoorMapInfo indoorMapInfo = this.getController().getFocusedBaseIndoorMapInfo();
        if (indoorMapInfo != null) {
            maxZoomLevel = 22;
        }
        if (iLevel < 4.0f) {
            iLevel = 4.0f;
        } else if (iLevel > (float)maxZoomLevel) {
            iLevel = 21.0f;
        }
        MapStatus st = this.getMapStatus();
        if (st != null) {
            st.level = iLevel;
            this.animateTo(st, 300);
        }
    }

    @Override
    public void setZoomLevel(int zoomLevel) {
        this.setZoomLevel((float)zoomLevel);
    }

    @Override
    public float getZoomLevel() {
        return this.b != null ? this.b.getZoomLevel() : 0.0f;
    }

    @Override
    public float getCurrentZoomLevel() {
        return this.b != null ? this.b.getCurrentZoomLevel() : 0.0f;
    }

    @Override
    public void setRotation(int rotation) {
        if (this.b != null) {
            MapStatus mapStatus = this.b.getMapStatus();
            mapStatus.rotation = rotation;
            this.b.setMapStatus(mapStatus);
        }
    }

    @Override
    public int getMapRotation() {
        if (this.b == null) {
            return 0;
        }
        MapStatus mapStatus = this.b.getMapStatus();
        return mapStatus.rotation;
    }

    @Override
    public void setOverlooking(int overlooking) {
        if (this.b != null) {
            MapStatus mapStatus = this.b.getMapStatus();
            mapStatus.overlooking = overlooking;
            this.b.setMapStatus(mapStatus);
        }
    }

    @Override
    public int getOverlooking() {
        if (this.b == null) {
            return 0;
        }
        MapStatus mapStatus = this.b.getMapStatus();
        return mapStatus.overlooking;
    }

    @Override
    public void setWinRound(MapStatus.WinRound winRound) {
        if (this.b != null) {
            MapStatus mapStatus = this.b.getMapStatus();
            mapStatus.winRound = winRound;
            this.b.setMapStatus(mapStatus);
        }
    }

    @Override
    public MapStatus.WinRound getWinRound() {
        if (this.b == null) {
            return null;
        }
        MapStatus mapStatus = this.b.getMapStatus();
        return mapStatus.winRound;
    }

    @Override
    public void setGeoRound(MapStatus.GeoBound geoRound) {
    }

    @Override
    public MapStatus.GeoBound getGeoRound() {
        if (this.b == null) {
            return null;
        }
        MapStatus mapStatus = this.b.getMapStatus();
        return mapStatus.geoRound;
    }

    @Override
    public void setMapStatus(MapStatus mapStatus) {
        if (this.b != null) {
            this.b.setMapStatus(mapStatus);
        }
    }

    @Override
    public MapStatus getMapStatus() {
        return this.b != null ? this.b.getMapStatus() : null;
    }

    @Override
    public MapStatus getCurrentMapStatus() {
        return this.b != null ? this.b.getCurrentMapStatus() : null;
    }

    @Override
    public boolean addBmLayer(BmLayer bmLayer) {
        return this.a(0L, bmLayer);
    }

    @Override
    public boolean addBmLayerBelow(Overlay overlay, BmLayer bmLayer) {
        if (overlay != null) {
            return this.a(overlay.mLayerID, bmLayer);
        }
        return this.a(0L, bmLayer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean a(long overlayId, BmLayer bmLayer) {
        if (bmLayer == null || this.b == null) {
            return false;
        }
        AppBaseMap baseMap = this.b.getBaseMap();
        if (baseMap == null) {
            return false;
        }
        MapTextureView mapTextureView = this;
        synchronized (mapTextureView) {
            if (this.l.contains(bmLayer)) {
                return false;
            }
            this.l.add(bmLayer);
        }
        return baseMap.addBmLayerBelow(overlayId, bmLayer.a(), 1, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean removeBmLayer(BmLayer bmLayer) {
        if (bmLayer == null || this.b == null) {
            return false;
        }
        AppBaseMap baseMap = this.b.getBaseMap();
        if (baseMap == null) {
            return false;
        }
        baseMap.removeBmLayer(bmLayer.a());
        MapTextureView mapTextureView = this;
        synchronized (mapTextureView) {
            this.l.remove(bmLayer);
        }
        return true;
    }

    @Override
    public List<BmLayer> getBmlayers() {
        return this.l;
    }

    @Override
    public List<Overlay> getOverlays() {
        return this.h;
    }

    public Overlay getPopupOverlay() {
        return null;
    }

    public synchronized Overlay getOverlay(int layerType) {
        for (Overlay layer : this.h) {
            if (layer.mType != layerType) continue;
            return layer;
        }
        return null;
    }

    public synchronized Overlay getOverlay(Class<?> overlayClass) {
        for (Overlay layer : this.h) {
            if (layer.getClass() != overlayClass) continue;
            return layer;
        }
        return null;
    }

    @Override
    public Projection getProjection() {
        return this.d;
    }

    @Override
    public boolean enable3D() {
        return false;
    }

    @Override
    public boolean isSatellite() {
        return false;
    }

    @Override
    public boolean isTraffic() {
        return false;
    }

    @Override
    public boolean isStreetRoad() {
        return false;
    }

    @Override
    public boolean isBaseIndoorMap() {
        return false;
    }

    @Override
    public void setBaseIndoorMap(boolean on) {
    }

    @Override
    public void setSatellite(boolean on) {
    }

    @Override
    public void setStreetRoad(boolean on) {
    }

    @Override
    public void setTraffic(boolean on) {
        AppBaseMap baseMap;
        if (this.b != null && (baseMap = this.b.getBaseMap()) != null) {
            baseMap.ShowTrafficMap(on);
        }
    }

    @Override
    public void setMapTo2D(boolean on) {
    }

    protected void b() {
        if (this.b == null) {
            return;
        }
        AppBaseMap baseMap = this.b.getBaseMap();
        if (baseMap == null) {
            return;
        }
        this.c();
    }

    protected void c() {
        if (this.b == null) {
            return;
        }
        AppBaseMap baseMap = this.b.getBaseMap();
        if (baseMap == null) {
            return;
        }
        if (this.c == null) {
            return;
        }
        this.h.clear();
        this.c.a();
    }

    @Override
    public boolean addOverlay(Overlay overlay) {
        if (overlay == null || this.b == null) {
            return false;
        }
        AppBaseMap baseMap = this.b.getBaseMap();
        if (baseMap == null) {
            return false;
        }
        if (overlay instanceof InnerOverlay) {
            if (((InnerOverlay)overlay).mBaseMap == null) {
                ((InnerOverlay)overlay).mBaseMap = this.getController().getBaseMap();
            }
            if (((InnerOverlay)overlay).addedToMapView()) {
                this.h.add(overlay);
                this.c.a((InnerOverlay)overlay);
                return true;
            }
            return false;
        }
        if (overlay instanceof ItemizedOverlay) {
            overlay.mLayerID = baseMap.AddLayer(((ItemizedOverlay)overlay).getUpdateType(), 0, "item");
            if (overlay.mLayerID == 0L) {
                return false;
            }
            this.h.add(overlay);
            ((ItemizedOverlay)overlay).a();
            baseMap.SetLayersClickable(overlay.mLayerID, true);
            baseMap.ShowLayers(overlay.mLayerID, true);
            baseMap.UpdateLayers(overlay.mLayerID);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeOverlay(Overlay overlay) {
        if (overlay == null || this.b == null) {
            return false;
        }
        AppBaseMap baseMap = this.b.getBaseMap();
        if (baseMap == null) {
            return false;
        }
        baseMap.ClearLayer(overlay.mLayerID);
        baseMap.ShowLayers(overlay.mLayerID, false);
        baseMap.UpdateLayers(overlay.mLayerID);
        baseMap.RemoveLayer(overlay.mLayerID);
        if (overlay instanceof ItemizedOverlay) {
            this.h.remove(overlay);
        } else if (overlay instanceof InnerOverlay) {
            this.h.remove(overlay);
            this.c.a(overlay);
        }
        overlay.mLayerID = 0L;
        return true;
    }

    @Override
    public boolean switchOverlay(Overlay overlaySrc, Overlay overlayDest) {
        if (overlaySrc == null || overlayDest == null || this.b == null) {
            return false;
        }
        AppBaseMap baseMap = this.b.getBaseMap();
        if (baseMap == null) {
            return false;
        }
        return baseMap.SwitchLayer(overlaySrc.mLayerID, overlayDest.mLayerID);
    }

    @Override
    public void saveScreenToLocal(String strPath) {
    }

    @Override
    public float getZoomToBound(MapBound bound) {
        return this.getZoomToBound(bound, this.f, this.g);
    }

    @Override
    public float getZoomToBoundF(MapBound bound, int width, int height) {
        if (this.b == null) {
            return 0.0f;
        }
        Bundle bd = new Bundle();
        bd.putInt("left", bound.leftBottomPt.getIntX());
        bd.putInt("bottom", bound.leftBottomPt.getIntY());
        bd.putInt("right", bound.rightTopPt.getIntX());
        bd.putInt("top", bound.rightTopPt.getIntY());
        return this.b.getZoomToBoundF(bd);
    }

    @Override
    public float getZoomToBoundF(MapBound bound) {
        return this.getZoomToBoundF(bound, this.f, this.g);
    }

    @Override
    public float getZoomToBound(MapBound bound, int width, int height) {
        if (this.b == null) {
            return 0.0f;
        }
        Bundle bd = new Bundle();
        bd.putInt("left", bound.leftBottomPt.getIntX());
        bd.putInt("bottom", bound.leftBottomPt.getIntY());
        bd.putInt("right", bound.rightTopPt.getIntX());
        bd.putInt("top", bound.rightTopPt.getIntY());
        return this.b.getZoomToBound(bd, width, height);
    }

    @Override
    public void refresh(Overlay overlay) {
        if (overlay == null || this.b == null) {
            return;
        }
        if (overlay instanceof ItemizedOverlay && ((ItemizedOverlay)overlay).b()) {
            if (((ItemizedOverlay)overlay).getAllItem().size() <= 0) {
                this.b.getBaseMap().ClearLayer(overlay.mLayerID);
                this.b.getBaseMap().ShowLayers(overlay.mLayerID, false);
                this.b.getBaseMap().UpdateLayers(overlay.mLayerID);
            } else {
                this.b.getBaseMap().ShowLayers(overlay.mLayerID, true);
                this.b.getBaseMap().UpdateLayers(overlay.mLayerID);
            }
            ((ItemizedOverlay)overlay).a(false);
        }
        if (this.b != null && this.b.getBaseMap() != null) {
            this.b.getBaseMap().UpdateLayers(overlay.mLayerID);
        }
    }

    @Override
    public void onResume() {
        if (this.b != null) {
            this.b.getBaseMap().OnResume();
        }
        super.onResume();
    }

    @Override
    public void onPause() {
        if (this.b != null) {
            this.b.getBaseMap().OnPause();
        }
        super.onPause();
    }

    public void onDestroy() {
        if (this.a != null) {
            if (null != this.a.h) {
                for (al listener : this.a.h) {
                    if (null == listener) continue;
                    listener.d();
                }
            }
            this.a.L();
            this.a = null;
        }
        this.b.unInit();
        this.b = null;
        this.c.a();
        this.c = null;
        this.d = null;
    }

    public void destroyForMultiViews() {
        if (this.b != null) {
            this.b.unInitForMultiTextureView();
            this.b = null;
        }
        if (this.c != null) {
            this.c.a();
            this.c = null;
        }
        this.d = null;
    }

    public void onRecycle() {
        if (this.b != null && this.b.getBaseMap() != null) {
            this.b.getBaseMap().ResetImageRes();
        }
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        try {
            if (this.k != null && this.k.onTouchEvent(event)) {
                return true;
            }
            if (this.b != null && this.b.handleTouchEvent(event)) {
                return true;
            }
        }
        catch (Exception e2) {
            return super.onTouchEvent(event);
        }
        return super.onTouchEvent(event);
    }

    private class b
    extends GestureDetector.SimpleOnGestureListener {
        private b() {
        }

        public void onLongPress(MotionEvent e2) {
            block9: {
                block8: {
                    super.onLongPress(e2);
                    if (MapTextureView.this.b == null || MapTextureView.this.b.getBaseMap() == null || !MapTextureView.this.b.mIsMapLoadFinish) {
                        return;
                    }
                    String s2 = MapTextureView.this.b.getBaseMap().GetNearlyObjID(-1L, (int)e2.getX(), (int)e2.getY(), MapTextureView.this.b.nearlyRadius);
                    if (s2 == null || s2.equals("")) break block8;
                    if (null == MapTextureView.this.b.mListeners) break block9;
                    GeoPoint gp = null;
                    if (MapTextureView.this.getProjection() != null) {
                        gp = MapTextureView.this.getProjection().fromPixels((int)e2.getX(), (int)e2.getY());
                    }
                    for (al listener : MapTextureView.this.b.mListeners) {
                        if (null == listener) continue;
                        if (listener.b(s2)) {
                            MapTextureView.this.b.mHasMapObjDraging = true;
                            continue;
                        }
                        if (gp == null) continue;
                        listener.c(gp);
                    }
                    break block9;
                }
                if (null != MapTextureView.this.b.mListeners) {
                    GeoPoint gp = null;
                    if (MapTextureView.this.getProjection() != null) {
                        gp = MapTextureView.this.getProjection().fromPixels((int)e2.getX(), (int)e2.getY());
                    }
                    if (gp == null) {
                        return;
                    }
                    for (al listener : MapTextureView.this.b.mListeners) {
                        if (null == listener || gp == null) continue;
                        listener.c(gp);
                    }
                }
            }
        }

        /* synthetic */ b(y x1) {
            this();
        }
    }

    private class a
    implements GLSurfaceView.EGLContextFactory {
        private int b = 12440;

        private a() {
        }

        public EGLContext createContext(EGL10 egl, EGLDisplay display, EGLConfig config) {
            int[] attrib_list = new int[]{this.b, 2, 12344};
            return egl.eglCreateContext(display, config, EGL10.EGL_NO_CONTEXT, attrib_list);
        }

        public void destroyContext(EGL10 egl, EGLDisplay display, EGLContext context) {
            if (!egl.eglDestroyContext(display, context)) {
                this.a("eglDestroyContex", egl.eglGetError());
            }
            MapTextureView.this.onRecycle();
        }

        public void a(String function, int error) {
            String message = this.b(function, error);
            throw new RuntimeException(message);
        }

        public String b(String function, int error) {
            return function + " failed: " + this.a(error);
        }

        private String a(int error) {
            switch (error) {
                case 12288: {
                    return "EGL_SUCCESS";
                }
                case 12289: {
                    return "EGL_NOT_INITIALIZED";
                }
                case 12290: {
                    return "EGL_BAD_ACCESS";
                }
                case 12291: {
                    return "EGL_BAD_ALLOC";
                }
                case 12292: {
                    return "EGL_BAD_ATTRIBUTE";
                }
                case 12293: {
                    return "EGL_BAD_CONFIG";
                }
                case 12294: {
                    return "EGL_BAD_CONTEXT";
                }
                case 12295: {
                    return "EGL_BAD_CURRENT_SURFACE";
                }
                case 12296: {
                    return "EGL_BAD_DISPLAY";
                }
                case 12297: {
                    return "EGL_BAD_MATCH";
                }
                case 12298: {
                    return "EGL_BAD_NATIVE_PIXMAP";
                }
                case 12299: {
                    return "EGL_BAD_NATIVE_WINDOW";
                }
                case 12300: {
                    return "EGL_BAD_PARAMETER";
                }
                case 12301: {
                    return "EGL_BAD_SURFACE";
                }
                case 12302: {
                    return "EGL_CONTEXT_LOST";
                }
            }
            return this.b(error);
        }

        private String b(int value) {
            return "0x" + Integer.toHexString(value);
        }

        /* synthetic */ a(y x1) {
            this();
        }
    }

    public static interface c {
        public void a(int var1);
    }
}

