/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.platform.comapi.util;

import org.json.JSONObject;

public class JsonBuilder {
    private StringBuilder a = new StringBuilder();
    private boolean b = false;

    public void reset() {
        this.a.setLength(0);
        this.b = false;
    }

    public JsonBuilder object() {
        this.a();
        this.a.append("{");
        this.b();
        return this;
    }

    public JsonBuilder endObject() {
        this.a.append("}");
        this.c();
        return this;
    }

    public JsonBuilder putStringValue(String key, String value) {
        if (value != null) {
            this.key(key).value(value);
        }
        return this;
    }

    public JsonBuilder putObjectValue(String key, String value) {
        if (value != null) {
            this.key(key).objectValue(value);
        }
        return this;
    }

    public JsonBuilder key(String key) {
        this.a();
        this.a.append(JSONObject.quote((String)key));
        this.a.append(":");
        this.b();
        return this;
    }

    public JsonBuilder value(boolean value) {
        this.a();
        this.a.append(value);
        this.c();
        return this;
    }

    public JsonBuilder value(int value) {
        this.a();
        this.a.append(value);
        this.c();
        return this;
    }

    public JsonBuilder value(long value) {
        this.a();
        this.a.append(value);
        this.c();
        return this;
    }

    public JsonBuilder value(double value) {
        this.a();
        this.a.append(String.format("%f", value));
        this.c();
        return this;
    }

    public JsonBuilder value(String value) {
        this.a();
        this.a.append(JSONObject.quote((String)value));
        this.c();
        return this;
    }

    public JsonBuilder valueDirect(String value) {
        this.a();
        this.a.append(value);
        this.c();
        return this;
    }

    public JsonBuilder value(Object value) {
        if (value instanceof Number) {
            Number num = (Number)value;
            if (value instanceof Byte) {
                return this.value(num.byteValue());
            }
            if (value instanceof Short) {
                return this.value(num.shortValue());
            }
            if (value instanceof Integer) {
                return this.value(num.intValue());
            }
            if (value instanceof Long) {
                return this.value(num.longValue());
            }
            if (value instanceof Float) {
                return this.value(num.floatValue());
            }
            if (value instanceof Double) {
                return this.value(num.doubleValue());
            }
        }
        return this.value(value.toString());
    }

    public JsonBuilder objectValue(String value) {
        this.a();
        this.a.append(value);
        this.c();
        return this;
    }

    public JsonBuilder arrayValue() {
        this.a();
        this.a.append("[");
        this.b();
        return this;
    }

    public JsonBuilder endArrayValue() {
        this.a.append("]");
        this.c();
        return this;
    }

    private void a() {
        if (this.b) {
            this.a.append(",");
        }
    }

    private void b() {
        this.b = false;
    }

    private void c() {
        this.b = true;
    }

    public String getJson() {
        return this.a.toString();
    }

    public String toString() {
        return this.getJson();
    }
}

