/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.platform.comjni.base.longlink;

import android.util.Log;
import com.baidu.platform.comapi.b;
import com.baidu.platform.comapi.longlink.ELongLinkStatus;
import com.baidu.platform.comapi.longlink.LongLinkDataCallback;
import com.baidu.platform.comapi.longlink.LongLinkFileData;
import com.baidu.platform.comjni.JNIBaseApi;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class NALongLink
extends JNIBaseApi {
    private static Map<Integer, LinkedList<Object>> a = new ConcurrentHashMap<Integer, LinkedList<Object>>();
    private static ELongLinkStatus[] b = new ELongLinkStatus[]{ELongLinkStatus.OK, ELongLinkStatus.SendFormatError, ELongLinkStatus.SendUnRegistered, ELongLinkStatus.SendLimited, ELongLinkStatus.SendDataLenLimited, ELongLinkStatus.SendInvalidReqID, ELongLinkStatus.ResultConnectError, ELongLinkStatus.ResultSendError, ELongLinkStatus.ResultTimeout, ELongLinkStatus.ResultServerError, ELongLinkStatus.CloudStop, ELongLinkStatus.CloudRestart};

    public static long create() {
        return NALongLink.nativeCreate();
    }

    public static int release(long addr) {
        return NALongLink.nativeRelease(addr);
    }

    public static boolean init(long addr, String domain, String params) {
        return NALongLink.nativeInit(addr, domain, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean register(long addr, int moduleId, Object callback) {
        if (callback != null) {
            Log.e((String)"JNILongLink", (String)("register moduleId = " + moduleId + ", callback = " + callback.getClass().getName()));
        } else {
            Log.e((String)"JNILongLink", (String)("register moduleId = " + moduleId + ", callback = " + callback));
        }
        LinkedList<Object> list = null;
        boolean isCreate = false;
        Class<NALongLink> clazz = NALongLink.class;
        synchronized (NALongLink.class) {
            list = a.get(moduleId);
            if (list == null) {
                isCreate = true;
                list = new LinkedList();
                list.add(callback);
                a.put(moduleId, list);
            } else if (!list.contains(callback)) {
                list.add(callback);
                a.put(moduleId, list);
            }
            // ** MonitorExit[var6_5] (shouldn't be in output)
            if (isCreate) {
                return NALongLink.nativeRegister(addr, moduleId);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unRegister(long addr, int moduleId, Object callback) {
        if (callback != null) {
            Log.e((String)"JNILongLink", (String)("unegister moduleId = " + moduleId + ", callback = " + callback.getClass().getName()));
        } else {
            Log.e((String)"JNILongLink", (String)("unregister moduleId = " + moduleId + ", callback = " + callback));
        }
        LinkedList<Object> list = null;
        Class<NALongLink> clazz = NALongLink.class;
        synchronized (NALongLink.class) {
            list = a.get(moduleId);
            if (list != null) {
                if (callback != null) {
                    list.remove(callback);
                }
                if (list.isEmpty()) {
                    a.remove(moduleId);
                }
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            if (list != null) {
                if (list.isEmpty()) {
                    return NALongLink.nativeUnRegister(addr, moduleId);
                }
                return true;
            }
            return false;
        }
    }

    public static int sendData(long addr, int moduleId, int reqId, byte[] dataBuffer) {
        return NALongLink.nativeSendData(addr, moduleId, reqId, dataBuffer);
    }

    public static int sendFileData(long addr, int moduleId, int reqId, String fileNameParams, ArrayList<LongLinkFileData> fileData) {
        return NALongLink.nativeSendFileData(addr, moduleId, reqId, fileNameParams, fileData);
    }

    public static boolean start(long addr) {
        return NALongLink.nativeStart(addr);
    }

    public static boolean stop(long addr) {
        return NALongLink.nativeStop(addr);
    }

    private static native long nativeCreate();

    private static native int nativeRelease(long var0);

    private static native boolean nativeInit(long var0, String var2, String var3);

    private static native boolean nativeRegister(long var0, int var2);

    private static native boolean nativeUnRegister(long var0, int var2);

    private static native int nativeSendData(long var0, int var2, int var3, byte[] var4);

    private static native int nativeSendFileData(long var0, int var2, int var3, String var4, ArrayList<LongLinkFileData> var5);

    private static native boolean nativeStart(long var0);

    private static native boolean nativeStop(long var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean onJNILongLinkDataCallback(int moduleId, int status, int reqId, byte[] dataBuffer, boolean isPush) {
        Log.e((String)"JNILongLink", (String)("onJNILongLinkDataCallback:" + moduleId + " status:" + status + " reqId:" + reqId + " isPush:" + isPush));
        if (status < 0 || status >= b.length) {
            Log.e((String)"JNILongLink", (String)("invalid status = " + status));
            if (com.baidu.platform.comapi.b.e()) {
                throw new IndexOutOfBoundsException();
            }
            return false;
        }
        byte[] dataParam = dataBuffer;
        if (dataBuffer == null || dataBuffer.length <= 0) {
            dataParam = new byte[]{};
        }
        LinkedList<Object> callbacks = null;
        Class<NALongLink> clazz = NALongLink.class;
        synchronized (NALongLink.class) {
            LinkedList<Object> linkedList = a.get(moduleId);
            if (linkedList != null) {
                callbacks = new LinkedList<Object>(linkedList);
            }
            // ** MonitorExit[clazz] (shouldn't be in output)
            if (callbacks != null && callbacks.size() > 0) {
                for (Object e2 : callbacks) {
                    if (e2 == null) continue;
                    try {
                        if (!(e2 instanceof LongLinkDataCallback)) continue;
                        ELongLinkStatus retStatus = b[status];
                        retStatus.setRequestId(reqId);
                        String className = e2.getClass().getName();
                        Log.d((String)"JNILongLink", (String)("className = " + className));
                        ((LongLinkDataCallback)e2).onReceiveData(retStatus, reqId, dataParam, isPush);
                        Log.d((String)"JNILongLink", (String)("className = " + className + "done"));
                    }
                    catch (Exception e22) {
                        Log.e((String)"JNILongLink", (String)("className = " + e2.getClass().getName() + ",exception = " + e22.toString()));
                        if (!com.baidu.platform.comapi.b.e()) continue;
                        throw e22;
                    }
                }
            }
            return true;
        }
    }
}

