/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.content.Intent;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.hyphenate.agora.FunctionIconItem;
import com.hyphenate.agora.FunctionUtils;
import com.hyphenate.agora.ICecBroadcast;
import com.hyphenate.agora.ICecMessageNotify;
import com.hyphenate.agora.IVecBroadcast;
import com.hyphenate.agora.IVecEndCallback;
import com.hyphenate.agora.IVecMessageNotify;
import com.hyphenate.agora.IVecPushMessage;
import com.hyphenate.agora.ZuoXiSendRequestObj;
import com.hyphenate.chat.ChatClient;
import com.hyphenate.chat.ChatManager;
import com.hyphenate.chat.CustomBroadcastManager;
import com.hyphenate.chat.EMCmdMessageBody;
import com.hyphenate.chat.EMTextMessageBody;
import com.hyphenate.chat.KefuHttpClient;
import com.hyphenate.chat.MarketingHttpClient;
import com.hyphenate.chat.Message;
import com.hyphenate.chat.VecConfig;
import com.hyphenate.helpdesk.callback.Callback;
import com.hyphenate.helpdesk.callback.ValueCallBack;
import com.hyphenate.helpdesk.model.VisitorInfo;
import com.hyphenate.util.EMLog;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AgoraMessage {
    private static final String TAG = AgoraMessage.class.getSimpleName();
    private static final AgoraMessage sAgoraMessage = new AgoraMessage();
    private static final List<IVecBroadcast> mVecBroadcast = new ArrayList<IVecBroadcast>();
    private static final List<ICecBroadcast> mCecBroadcast = new ArrayList<ICecBroadcast>();
    private static final Map<String, IVecMessageNotify> mMapVec = new HashMap<String, IVecMessageNotify>();
    private static final Map<String, ICecMessageNotify> mMap = new HashMap<String, ICecMessageNotify>();
    private static final Map<String, IVecEndCallback> mMapIEnd = new HashMap<String, IVecEndCallback>();
    private static final Map<String, IVecPushMessage> mPushMessage = new HashMap<String, IVecPushMessage>();
    private volatile String mVecImServiceNumber;
    private volatile String mCecImServiceNumber;
    private VisitorInfo mVisitorInfo;
    public static String TYPE_LINK_MESSAGE_PUSH = "infopush";
    public static String TYPE_CARD_OCR = "cardocr";
    public static String TYPE_ELECSIGN = "elecsign";
    public static String TYPE_IDENTITYAUTH = "identityauth";
    public static String TYPE_ENQUIRYINVITE = "enquiryInvite";
    public static String TYPE_MICROPHONE = "microphone";
    public static String TYPE_CAMERA = "camera";
    public static String TYPE_FLASH_LIGHT = "flashlight";
    public static String TYPE_FOCUS_CAMERA = "focusCamera";
    public static String TYPE_CAMERA_TORCH_ON = "cameraTorchOn";
    public static String TYPE_CAMERA_CHANGE_ON = "cameraChange";
    public static String TYPE_VIDEO = "video";
    public static String TYPE_AGENT_REJECT = "agentReject";

    private AgoraMessage() {
    }

    public void setVisitorInfo(VisitorInfo visitorInfo) {
        this.mVisitorInfo = visitorInfo;
    }

    public VisitorInfo getVisitorInfo() {
        return this.mVisitorInfo;
    }

    void addVisitorInfoToMessage(Message message) {
        try {
            if (this.mVisitorInfo != null) {
                message.addContent(this.mVisitorInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void pushVecMessage(String content, String type) {
        for (String key : mPushMessage.keySet()) {
            mPushMessage.get(key).pushMessage(content, type);
        }
    }

    public static void visitorAnswerResponse(Message message, String ticket, String callNickName, String to, String from, String sessionId) {
        try {
            ZuoXiSendRequestObj obj = AgoraMessage.get(message, ticket, callNickName);
            obj.setTo(to);
            obj.setFrom(from);
            EMLog.d(TAG, "VEC \u5750\u5e2d\u4e3b\u52a8\u53d1\u8d77\u89c6\u9891\u9080\u8bf7\uff0c\u8bbf\u5ba2\u63a5\u542c\u54cd\u5e94 \u901a\u77e5\u672c\u5730");
            AgoraMessage.visitorAnswerResponse(message, obj, sessionId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void agentAnswerResponse(Message item, String ticket, String callNickName, String to, String from, String sessionId) {
        try {
            ZuoXiSendRequestObj obj = AgoraMessage.get(item, ticket, callNickName);
            obj.setTo(to);
            obj.setFrom(from);
            AgoraMessage.agentAnswerResponse(item, obj, sessionId);
        }
        catch (Exception e) {
            e.printStackTrace();
            EMLog.d(TAG, "putTicket Exception = " + e.getMessage());
        }
    }

    private static ZuoXiSendRequestObj get(Message message, String ticket, String nickName) throws JSONException {
        JSONObject agentTicket;
        ZuoXiSendRequestObj obj = new ZuoXiSendRequestObj();
        JSONObject ticketObj = new JSONObject(ticket);
        if (ticketObj.has("isThirdAgent")) {
            boolean isThirdAgent = ticketObj.getBoolean("isThirdAgent");
            obj.setIsAddThreeUser(isThirdAgent);
        }
        if (ticketObj.has("agentTicket") && (agentTicket = ticketObj.getJSONObject("agentTicket")).has("trueName")) {
            obj.setThreeTrueName(agentTicket.getString("trueName"));
            obj.setThreeNiceName(agentTicket.getString("niceName"));
            obj.setThreeUid(agentTicket.getInt("uid"));
            obj.setThreeCallId(agentTicket.getInt("callId"));
        }
        obj.setNiceName(ticketObj.getString("niceName"));
        obj.setTrueName(ticketObj.getString("trueName"));
        obj.setCallId(ticketObj.getInt("callId"));
        obj.setUid(ticketObj.getInt("uid"));
        obj.setToken(ticketObj.getString("token"));
        obj.setAppId(ticketObj.getString("appId"));
        obj.setChannel(ticketObj.getString("channel"));
        if (TextUtils.isEmpty((CharSequence)nickName) || "null".equalsIgnoreCase(nickName)) {
            obj.setNickName(TextUtils.isEmpty((CharSequence)obj.getThreeTrueName()) ? obj.getThreeNiceName() : obj.getThreeTrueName());
        } else {
            obj.setNickName(nickName);
        }
        return obj;
    }

    public synchronized void registerVecMessageNotify(String classKey, IVecMessageNotify message) {
        mMapVec.put(classKey, message);
    }

    public synchronized void unRegisterVecMessageNotify(String classKey) {
        mMapVec.remove(classKey);
    }

    public synchronized void registerCecMessageNotify(String classKey, ICecMessageNotify message) {
        mMap.put(classKey, message);
    }

    public synchronized void unRegisterCecMessageNotify(String classKey) {
        mMap.remove(classKey);
    }

    public synchronized void registerVecBroadcast(IVecBroadcast vecBroadcast) {
        mVecBroadcast.add(vecBroadcast);
    }

    public synchronized void unRegisterVecBroadcast(IVecBroadcast vecBroadcast) {
        mVecBroadcast.remove(vecBroadcast);
    }

    public synchronized void registerCecBroadcast(ICecBroadcast cecBroadcast) {
        mCecBroadcast.add(cecBroadcast);
    }

    public synchronized void unRegisterCecBroadcast(ICecBroadcast cecBroadcast) {
        mCecBroadcast.remove(cecBroadcast);
    }

    static synchronized void onSessionCreateEvent(Message message, String sessionId, String visitorUserId) {
        for (IVecBroadcast videoMessage : mVecBroadcast) {
            videoMessage.onSessionCreateEvent(message, sessionId, visitorUserId);
        }
    }

    static synchronized void onAgentRequest(Message message, String msg, String sessionId) {
        for (IVecBroadcast videoMessage : mVecBroadcast) {
            videoMessage.onAgentRequest(msg, sessionId, message);
        }
    }

    static synchronized void onVisitorAnswerResponse(Message message, String sessionId, ZuoXiSendRequestObj obj) {
        for (IVecBroadcast videoMessage : mVecBroadcast) {
            videoMessage.onVisitorAnswerResponse(obj, sessionId, message);
        }
    }

    static synchronized void onAgentAnswerResponse(Message message, String sessionId, ZuoXiSendRequestObj obj) {
        for (IVecBroadcast videoMessage : mVecBroadcast) {
            videoMessage.onAgentAnswerResponse(obj, sessionId, message);
        }
    }

    static synchronized void onEvaluation(Message message, String content) {
        for (IVecBroadcast videoMessage : mVecBroadcast) {
            videoMessage.onEvaluation(content, message);
        }
    }

    static synchronized void onCecAgentAnswerResponse(Message message, String sessionId, ZuoXiSendRequestObj obj) {
        for (ICecBroadcast videoMessage : mCecBroadcast) {
            videoMessage.onAgentAnswerResponse(obj, sessionId, message);
        }
    }

    public synchronized void registerIEndCallback(String classKey, IVecEndCallback callback) {
        if (mMapIEnd.containsKey(classKey)) {
            return;
        }
        mMapIEnd.put(classKey, callback);
    }

    public synchronized void unRegisterIEndCallback(String classKey) {
        mMapIEnd.remove(classKey);
    }

    public synchronized void registerVecPushMessage(String classKey, IVecPushMessage callback) {
        if (mPushMessage.containsKey(classKey)) {
            return;
        }
        mPushMessage.put(classKey, callback);
    }

    public synchronized void unRegisterVecPushMessage(String classKey) {
        mPushMessage.remove(classKey);
    }

    public static AgoraMessage newAgoraMessage() {
        return sAgoraMessage;
    }

    static synchronized void zuoXiToBreakOff() {
        for (String key : mMap.keySet()) {
            mMap.get(key).zuoXiToBreakOff();
        }
    }

    static synchronized void waitResponse(int callType, String rtcSessionId, String tenantId) {
        for (String key : mMapIEnd.keySet()) {
            mMapIEnd.get(key).onInitWaitPage(callType, rtcSessionId, tenantId);
        }
    }

    static synchronized void waitTimeoutCloseRtcWaitCall(Message message) {
        for (String key : mMapIEnd.keySet()) {
            mMapIEnd.get(key).onWaitTimeout(message);
        }
    }

    static synchronized void vecBreakOff() {
        VecConfig.newVecConfig().setPopupView(false);
        for (String key : mMapIEnd.keySet()) {
            mMapIEnd.get(key).onVecZuoXiToBreakOff();
        }
    }

    static synchronized void createFlatRoom(Message message, ZuoXiSendRequestObj obj) {
        for (String key : mMap.keySet()) {
            mMap.get(key).createFlatRoom(message, obj);
        }
    }

    static synchronized void createVecFlatRoom(Message message, ZuoXiSendRequestObj obj) {
        for (String key : mMapVec.keySet()) {
            mMapVec.get(key).createFlatRoom(message, obj);
        }
    }

    static synchronized void agentRequest(Message message, String msg, String to, String from, String sessionId) {
        try {
            AgoraMessage.onAgentRequest(message, msg, sessionId);
        }
        catch (Exception e) {
            e.printStackTrace();
            EMLog.e(TAG, "zuoXiActiveRequest notifyVideoMessage error = " + e.getMessage());
        }
        try {
            EMLog.e(TAG, "VEC \u6536\u5230\u5750\u5e2d\u4e3b\u52a8\u9080\u8bf7 \u53d1\u9001\u672c\u5730\u5e7f\u64ad from = " + from + ", to = " + to);
            VecConfig.newVecConfig().setPopupView(true);
            Intent intent = new Intent(ChatClient.getInstance().callManager().getIncomingCallBroadcastAction());
            intent.putExtra("zuo_xi_active", 1);
            intent.addFlags(0x10000000);
            intent.putExtra("type", "video");
            intent.putExtra("msg", msg);
            intent.putExtra("to", to);
            intent.putExtra("from", from);
            intent.putExtra("message", (Parcelable)message);
            intent.putExtra("isVecVideo", true);
            intent.putExtra("sessionId", sessionId);
            AgoraMessage.sendCustom(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
            EMLog.e(TAG, "VEC \u5750\u5e2d\u4e3b\u52a8\u9080\u8bf7 \u53d1\u9001\u5e7f\u64ad \u53d1\u9001\u5e7f\u64adsendBroadcast \u5f02\u5e38 Exception = " + e.getMessage());
        }
    }

    public static void vecBreakOffSendBroadcast(Message item) {
        try {
            Intent intent = new Intent(ChatClient.getInstance().callManager().getIncomingCallBroadcastAction());
            intent.addFlags(0x10000000);
            intent.putExtra("type", TYPE_AGENT_REJECT);
            intent.putExtra("to", item.to());
            intent.putExtra("from", item.from());
            intent.putExtra("message", (Parcelable)item);
            intent.putExtra("isVecVideo", true);
            AgoraMessage.sendCustom(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static synchronized void visitorAnswerResponse(Message message, ZuoXiSendRequestObj obj, String sessionId) {
        EMLog.e(TAG, "VEC \u5750\u5e2d\u4e3b\u52a8\u53d1\u8d77\u89c6\u9891\u9080\u8bf7\uff0c\u8bbf\u5ba2\u63a5\u542c\uff0c\u54cd\u5e94 isAddThreeUser = " + obj.isAddThreeUser());
        try {
            if (obj.isAddThreeUser()) {
                for (String key : mMapVec.keySet()) {
                    mMapVec.get(key).zuoXiSendThreeUserRequest(message, obj);
                }
                EMLog.e(TAG, "VEC \u5750\u5e2d\u4e3b\u52a8\u53d1\u8d77\u89c6\u9891\u9080\u8bf7 \u4e09\u65b9\u9080\u8bf7 return \u4e0d\u6267\u5e7f\u64ad");
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            EMLog.e(TAG, "VEC \u5750\u5e2d\u4e3b\u52a8\u53d1\u8d77\u89c6\u9891\u9080\u8bf7 \u4e09\u65b9\u9080\u8bf7 error = " + e.getMessage());
            return;
        }
        try {
            AgoraMessage.onVisitorAnswerResponse(message, sessionId, obj);
        }
        catch (Exception e) {
            e.printStackTrace();
            EMLog.e(TAG, "fangKeAnswer notifyVideoMessage error = " + e.getMessage());
        }
        try {
            EMLog.e(TAG, "VEC \u5750\u5e2d\u4e3b\u52a8\u53d1\u8d77\u89c6\u9891\u9080\u8bf7 \u8bbf\u5ba2\u63a5\u542c \u54cd\u5e94 \u53d1\u9001\u672c\u5730\u5e7f\u64ad from = " + obj.getFrom() + ", to = " + obj.getTo());
            Intent intent = new Intent(ChatClient.getInstance().callManager().getIncomingCallBroadcastAction());
            intent.addFlags(0x10000000);
            intent.putExtra("zuo_xi_active", 2);
            intent.putExtra("type", "video");
            intent.putExtra("appid", obj.getAppId());
            intent.putExtra("zuoXiSendRequestObj", (Parcelable)obj);
            intent.putExtra("to", obj.getTo());
            intent.putExtra("from", obj.getFrom());
            intent.putExtra("message", (Parcelable)message);
            intent.putExtra("isVecVideo", true);
            intent.putExtra("sessionId", sessionId);
            AgoraMessage.sendCustom(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
            EMLog.d(TAG, "VEC \u5750\u5e2d\u4e3b\u52a8\u53d1\u8d77\u89c6\u9891\u9080\u8bf7 \u8bbf\u5ba2\u63a5\u542c \u54cd\u5e94 \u53d1\u9001\u5e7f\u64adsendBroadcast \u5f02\u5e38 Exception = " + e.getMessage());
        }
    }

    static synchronized void agentAnswerResponse(Message message, ZuoXiSendRequestObj obj, String sessionId) {
        EMLog.e(TAG, "VEC \u8bbf\u5ba2\u4e3b\u52a8\u53d1\u9001\u89c6\u9891\u9080\u8bf7\uff0c\u5750\u5e2d\u63a5\u901a zuoXiAnswer isAddThreeUser = " + obj.isAddThreeUser());
        if (obj.isAddThreeUser()) {
            for (String key : mMapVec.keySet()) {
                mMapVec.get(key).zuoXiSendThreeUserRequest(message, obj);
            }
            EMLog.e(TAG, "VEC \u8bbf\u5ba2\u4e3b\u52a8\u53d1\u9001\u89c6\u9891\u9080\u8bf7 \u4e09\u65b9\u9080\u8bf7 return \u4e0d\u6267\u5e7f\u64ad");
            return;
        }
        try {
            AgoraMessage.onAgentAnswerResponse(message, sessionId, obj);
        }
        catch (Exception e) {
            e.printStackTrace();
            EMLog.e(TAG, "zuoXiAnswer notifyVideoMessage error = " + e.getMessage());
        }
        try {
            EMLog.d(TAG, "VEC \u8bbf\u5ba2\u4e3b\u52a8\u53d1\u9001\u89c6\u9891\u9080\u8bf7\uff0c\u5750\u5e2d\u63a5\u901a \u53d1\u9001\u5e7f\u64ad");
            Intent intent = new Intent(ChatClient.getInstance().callManager().getIncomingCallBroadcastAction());
            intent.addFlags(0x10000000);
            intent.putExtra("zuo_xi_active", 0);
            intent.putExtra("type", "video");
            intent.putExtra("appid", obj.getAppId());
            intent.putExtra("zuoXiSendRequestObj", (Parcelable)obj);
            intent.putExtra("to", obj.getTo());
            intent.putExtra("from", obj.getFrom());
            intent.putExtra("message", (Parcelable)message);
            intent.putExtra("isVecVideo", true);
            intent.putExtra("sessionId", sessionId);
            AgoraMessage.sendCustom(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
            EMLog.d(TAG, "VEC \u8bbf\u5ba2\u4e3b\u52a8\u53d1\u9001\u89c6\u9891\u9080\u8bf7\uff0c\u5750\u5e2d\u63a5\u901a \u53d1\u9001\u5e7f\u64adsendBroadcast \u5f02\u5e38 Exception = " + e.getMessage());
        }
    }

    public static synchronized void sendEvaluation(Message message, JSONObject enquiryInvite, String to, String from) {
        try {
            EMLog.e(TAG, "\u53d1\u9001\u6ee1\u610f\u5ea6\u8bc4\u4ef7\u5e7f\u64ad sendEvaluation error from = " + from);
            AgoraMessage.onEvaluation(message, enquiryInvite.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            EMLog.e(TAG, "\u53d1\u9001\u6ee1\u610f\u5ea6\u8bc4\u4ef7\u5e7f\u64ad notifyVideoMessage error = " + e.getMessage());
        }
        try {
            Intent intent = new Intent(ChatClient.getInstance().callManager().getIncomingCallBroadcastAction());
            intent.addFlags(0x10000000);
            intent.putExtra("type", TYPE_ENQUIRYINVITE);
            intent.putExtra("content", enquiryInvite.toString());
            intent.putExtra("to", to);
            intent.putExtra("from", from);
            intent.putExtra("isVecVideo", true);
            intent.putExtra("message", (Parcelable)message);
            AgoraMessage.sendCustom(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
            EMLog.e(TAG, "\u53d1\u9001\u6ee1\u610f\u5ea6\u8bc4\u4ef7\u5e7f\u64ad sendBroadcast error = " + e.getMessage());
        }
    }

    static synchronized void zuoXiSendRequestLine(Message message, ZuoXiSendRequestObj obj, String sessionId) {
        EMLog.e(TAG, "\u5728\u7ebf zuoXiSendRequest obj.isAddThreeUser() = " + obj.isAddThreeUser());
        if (obj.isAddThreeUser()) {
            for (String key : mMap.keySet()) {
                mMap.get(key).zuoXiSendThreeUserRequest(message, obj);
            }
            EMLog.e(TAG, "\u5728\u7ebf zuoXiSendRequest obj.isAddThreeUser() return \u4e0d\u6267\u884c\u53d1\u9001\u5e7f\u64ad\u5750\u5e2d\u63a5\u901a");
            return;
        }
        try {
            AgoraMessage.onCecAgentAnswerResponse(message, sessionId, obj);
        }
        catch (Exception e) {
            e.printStackTrace();
            EMLog.e(TAG, "fangKeAnswer notifyVideoMessage error = " + e.getMessage());
        }
        try {
            EMLog.d(TAG, "\u65e0\u8bba\u662f\u4e3b\u52a8\u8fd8\u662f\u88ab\u52a8\u9080\u8bf7 \u53d1\u9001\u5e7f\u64ad");
            Intent intent = new Intent(ChatClient.getInstance().callManager().getIncomingCallBroadcastAction());
            intent.addFlags(0x10000000);
            intent.putExtra("type", "video");
            intent.putExtra("appid", obj.getAppId());
            intent.putExtra("zuoXiSendRequestObj", (Parcelable)obj);
            intent.putExtra("to", obj.getTo());
            intent.putExtra("from", obj.getFrom());
            intent.putExtra("message", (Parcelable)message);
            intent.putExtra("isVecVideo", false);
            intent.putExtra("sessionId", sessionId);
            AgoraMessage.sendCustom(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
            EMLog.d(TAG, "\u5728\u7ebf \u65e0\u8bba\u662f\u4e3b\u52a8\u8fd8\u662f\u88ab\u52a8\u9080\u8bf7\uff0c\u5750\u5e2d\u63a5\u901a \u53d1\u9001\u5e7f\u64adsendBroadcast \u5f02\u5e38 Exception = " + e.getMessage());
        }
    }

    private static void sendCustom(Intent intent) {
        try {
            CustomBroadcastManager.getCustomBroadcastManager().sendBroadcast(ChatClient.getInstance().getContext(), intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void setVecImServiceNumber(String vecImServiceNumber) {
        this.mVecImServiceNumber = vecImServiceNumber;
        EMLog.e(TAG, "\u5df2\u8c03\u7528setVecImServiceNumber\u65b9\u6cd5 \u8bbe\u7f6eVEC IM\u670d\u52a1\u53f7 \u63d0\u4f9b\u7ed9\u89c6\u9891\u4f7f\u7528 = " + this.mVecImServiceNumber);
    }

    public String getVecImServiceNumber() {
        EMLog.e(TAG, "AgoraMessage getVecImServiceNumber = " + this.mVecImServiceNumber);
        return this.mVecImServiceNumber;
    }

    public synchronized void setCecImServiceNumber(String cecImServiceNumber) {
        this.mCecImServiceNumber = cecImServiceNumber;
        EMLog.e(TAG, "\u5df2\u8c03\u7528setCecImServiceNumber\u65b9\u6cd5 \u8bbe\u7f6eCEC IM\u670d\u52a1\u53f7 \u63d0\u4f9b\u7ed9\u89c6\u9891\u4f7f\u7528 = " + this.mCecImServiceNumber);
    }

    public String getCecImServiceNumber() {
        EMLog.e(TAG, "AgoraMessage getCecImServiceNumber = " + this.mCecImServiceNumber);
        return this.mCecImServiceNumber;
    }

    public void onDestroy() {
        this.mVecImServiceNumber = null;
        this.mCecImServiceNumber = null;
        this.mVisitorInfo = null;
    }

    public String getTenantId() {
        return ChatClient.getInstance().tenantId();
    }

    public static void asyncGetTenantIdFunctionIcons(String tenantId, final ValueCallBack<List<FunctionIconItem>> callBack) {
        if (TextUtils.isEmpty((CharSequence)tenantId)) {
            EMLog.e(TAG, "asyncGetTenantIdFunctionIcons tenantId is null.");
            return;
        }
        MarketingHttpClient.asyncGetTenantIdFunctionIcons(tenantId, new ValueCallBack<String>(){

            @Override
            public void onSuccess(String value) {
                try {
                    ArrayList<FunctionIconItem> list = new ArrayList<FunctionIconItem>();
                    JSONObject object = new JSONObject(value);
                    if (!object.isNull("status")) {
                        String status = object.getString("status");
                        if ("ok".equalsIgnoreCase(status)) {
                            if (!object.isNull("entities")) {
                                JSONArray entities = object.getJSONArray("entities");
                                for (int i = 0; i < entities.length(); ++i) {
                                    JSONObject jsonObject = entities.getJSONObject(i);
                                    if (jsonObject == null || !jsonObject.has("grayName")) continue;
                                    String grayName = jsonObject.getString("grayName");
                                    if ("visitorLeave".equalsIgnoreCase(grayName)) {
                                        if (!jsonObject.has("status")) continue;
                                        VecConfig.newVecConfig().setEnableReport("enable".equalsIgnoreCase(jsonObject.getString("status")));
                                        continue;
                                    }
                                    if ("whiteBoard".equalsIgnoreCase(grayName) || "shareDesktop".equalsIgnoreCase(grayName)) {
                                        FunctionIconItem iconItem = new FunctionIconItem(grayName);
                                        if (!jsonObject.isNull("status")) {
                                            iconItem.setStatus(jsonObject.getString("status"));
                                        }
                                        if (!jsonObject.isNull("description")) {
                                            iconItem.setDescription(jsonObject.getString("description"));
                                        }
                                        if (!iconItem.isEnable()) continue;
                                        list.add(iconItem);
                                        continue;
                                    }
                                    if ("agoraVideo".equalsIgnoreCase(grayName) && jsonObject.has("status")) {
                                        VecConfig.newVecConfig().setEnableCecVideo("enable".equalsIgnoreCase(jsonObject.getString("status")));
                                    }
                                    if (!"vecIndependentVideo".equalsIgnoreCase(grayName) || !jsonObject.has("status")) continue;
                                    VecConfig.newVecConfig().setEnableVecVideo("enable".equalsIgnoreCase(jsonObject.getString("status")));
                                }
                            }
                            callBack.onSuccess(list);
                        } else {
                            VecConfig.newVecConfig().setEnableVecVideo(false);
                            EMLog.e(TAG, "asyncGetTenantIdFunctionIcons --> status = " + status);
                        }
                    } else {
                        VecConfig.newVecConfig().setEnableVecVideo(false);
                        callBack.onError(-1, value);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    VecConfig.newVecConfig().setEnableVecVideo(false);
                    callBack.onError(-1, e.toString());
                    EMLog.e(TAG, "asyncGetTenantIdFunctionIcons --> JSONException e = " + e.toString());
                }
            }

            @Override
            public void onError(int error, String errorMsg) {
                EMLog.e(TAG, "asyncGetTenantIdFunctionIcons --> error = " + error + ", errorMsg = " + errorMsg);
                callBack.onError(error, errorMsg);
            }
        });
    }

    static void asyncGetTenantIdFunctionIcons(String tenantId) {
        if (TextUtils.isEmpty((CharSequence)tenantId)) {
            EMLog.e(TAG, "init asyncGetTenantIdFunctionIcons tenantId is null.");
            return;
        }
        MarketingHttpClient.asyncGetTenantIdFunctionIcons(tenantId, new ValueCallBack<String>(){

            @Override
            public void onSuccess(String value) {
                try {
                    JSONObject object = new JSONObject(value);
                    if (!object.isNull("status")) {
                        String status = object.getString("status");
                        if ("ok".equalsIgnoreCase(status)) {
                            if (!object.isNull("entities")) {
                                ArrayList<FunctionIconItem> list = new ArrayList<FunctionIconItem>();
                                JSONArray entities = object.getJSONArray("entities");
                                for (int i = 0; i < entities.length(); ++i) {
                                    JSONObject jsonObject = entities.getJSONObject(i);
                                    if (jsonObject == null || !jsonObject.has("grayName")) continue;
                                    String grayName = jsonObject.getString("grayName");
                                    if ("visitorLeave".equalsIgnoreCase(grayName)) {
                                        if (!jsonObject.has("status")) continue;
                                        VecConfig.newVecConfig().setEnableReport("enable".equalsIgnoreCase(jsonObject.getString("status")));
                                        continue;
                                    }
                                    if ("whiteBoard".equalsIgnoreCase(grayName) || "shareDesktop".equalsIgnoreCase(grayName)) {
                                        FunctionIconItem iconItem = new FunctionIconItem(grayName);
                                        if (jsonObject.has("status")) {
                                            iconItem.setStatus(jsonObject.getString("status"));
                                        }
                                        if (jsonObject.has("description")) {
                                            iconItem.setDescription(jsonObject.getString("description"));
                                        }
                                        list.add(iconItem);
                                        continue;
                                    }
                                    if ("agoraVideo".equalsIgnoreCase(grayName) && jsonObject.has("status")) {
                                        VecConfig.newVecConfig().setEnableCecVideo("enable".equalsIgnoreCase(jsonObject.getString("status")));
                                    }
                                    if (!"vecIndependentVideo".equalsIgnoreCase(grayName) || !jsonObject.has("status")) continue;
                                    VecConfig.newVecConfig().setEnableVecVideo("enable".equalsIgnoreCase(jsonObject.getString("status")));
                                }
                                FunctionUtils.get().setIconItems(list);
                            }
                        } else {
                            VecConfig.newVecConfig().setEnableVecVideo(false);
                            EMLog.e(TAG, "asyncGetTenantIdFunctionIcons --> status = " + status);
                        }
                    } else {
                        VecConfig.newVecConfig().setEnableVecVideo(false);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    VecConfig.newVecConfig().setEnableVecVideo(false);
                    EMLog.e(TAG, "asyncGetTenantIdFunctionIcons --> JSONException e = " + e.toString());
                }
            }

            @Override
            public void onError(int error, String errorMsg) {
                EMLog.e(TAG, "asyncGetTenantIdFunctionIcons --> error = " + error + ", errorMsg = " + errorMsg);
            }
        });
    }

    public static void asyncUploadFile(String file, String token, int callId, String tenantId, ValueCallBack<String> callBack) {
        MarketingHttpClient.asyncUploadFile(file, token, callId, tenantId, callBack);
    }

    public static String getToken() {
        if (!ChatClient.getInstance().isLoggedInBefore()) {
            throw new RuntimeException();
        }
        return ChatClient.getInstance().imAccessToken();
    }

    public static void asyncFileConverted(String file, String token, int callId, String tenantId, String type, ValueCallBack<String> callBack) {
        MarketingHttpClient.asyncFileConverted(file, token, callId, tenantId, type, callBack);
    }

    public static void asyncFileConvertedProgress(String tenantId, String token, int callId, String type, String taskId, ValueCallBack<String> callBack) {
        MarketingHttpClient.asyncFileConvertedProgress(tenantId, token, callId, type, taskId, callBack);
    }

    public static void asyncInitLanguage(String tenantId, String language, String appKey, String visitorUserName, ValueCallBack<String> callBack) {
        MarketingHttpClient.asyncInitLanguage(tenantId, language, appKey, visitorUserName, callBack);
    }

    public static void asyncInitStyle(String tenantId, String configId, ValueCallBack<String> callBack) {
        MarketingHttpClient.asyncInitStyle(tenantId, configId, callBack);
    }

    public static void asyncCloseVec(String tenantId, String rtcSessionId, String visitorId, ValueCallBack<String> callBack) {
        MarketingHttpClient.asyncCloseVec(tenantId, rtcSessionId, visitorId, callBack);
    }

    public static void closeVec(String tenantId, String rtcSessionId, String visitorId, ValueCallBack<String> callBack) {
        MarketingHttpClient.closeVec(tenantId, rtcSessionId, visitorId, callBack);
    }

    public static void getAsyncVisitorId(String conversationId, ValueCallBack<String> callBack) {
        MarketingHttpClient.asyncVisitorId(conversationId, callBack);
    }

    public static void getVisitorId(String conversationId, ValueCallBack<String> callBack) {
        MarketingHttpClient.getVisitorIdAndVecSessionId(conversationId, callBack);
    }

    public static void asyncResultReporting(String tenantId, String visitorId, String type, JSONObject resultObj, ValueCallBack<String> callBack) {
        MarketingHttpClient.asyncResultReporting(tenantId, visitorId, type, resultObj, callBack);
    }

    public static void resultReporting(String tenantId, String visitorId, String type, JSONObject resultObj, ValueCallBack<String> callBack) {
        MarketingHttpClient.resultReporting(tenantId, visitorId, type, resultObj, callBack);
    }

    public static void getSkillGroupMenuWithVisitorUserName(String tenantId, String visitorUserName, ValueCallBack<String> callBack) {
        MarketingHttpClient.getSkillGroupMenuWithVisitorUserName(tenantId, visitorUserName, callBack);
    }

    public static void getAppRelevanceSkillGroupMenuWithVisitorUserName(String easeMobIMNumber, String visitorUserName, ValueCallBack<String> callBack) {
        MarketingHttpClient.getAppRelevanceSkillGroupMenuWithVisitorUserName(easeMobIMNumber, visitorUserName, callBack);
    }

    public static void getAppRelevanceEnterpriseWelcomeWithVisitorUserName(String easeMobIMNumber, String visitorUserName, ValueCallBack<String> callback) {
        KefuHttpClient.getAppRelevanceEnterpriseWelcomeWithVisitorUserName(easeMobIMNumber, visitorUserName, callback);
    }

    public static void asyncUploadSignatureImage(File file, String token, String tenantId, String flowId, ValueCallBack<String> callBack) {
        MarketingHttpClient.asyncUploadSignatureImage(file, token, tenantId, flowId, callBack);
    }

    public static void getWaitNumber(String tenantId, String rtcSessionId, ValueCallBack<String> callBack) {
        MarketingHttpClient.getWaitNumber(tenantId, rtcSessionId, callBack);
    }

    public static void asyncSubmitEvaluate(String tenantId, String jsonData, ValueCallBack<String> callBack) {
        MarketingHttpClient.asyncSubmitEvaluate(tenantId, jsonData, callBack);
    }

    public static void asyncGetInfo(String tenantId, ValueCallBack<String> callBack) {
        MarketingHttpClient.asyncGetInfo(tenantId, callBack);
    }

    public static void asyncProblemSolvingOnServiceSessionResolved(String tenantId, ValueCallBack<String> callBack) {
        MarketingHttpClient.asyncProblemSolvingOnServiceSessionResolved(tenantId, callBack);
    }

    public static void asyncEvalSolveWord(String tenantId, String serviceSessionId, ValueCallBack<String> callBack) {
        MarketingHttpClient.asyncEvalSolveWord(tenantId, serviceSessionId, callBack);
    }

    public static void asyncResolutionParams(String tenantId, String serviceSessionId, ValueCallBack<String> callBack) {
        MarketingHttpClient.asyncResolutionParams(tenantId, serviceSessionId, callBack);
    }

    public static void asyncGreetingMsgEnquiryInvite(String tenantId, String serviceSessionId, ValueCallBack<String> callBack) {
        MarketingHttpClient.asyncGreetingMsgEnquiryInvite(tenantId, serviceSessionId, callBack);
    }

    public static String getSessionIdFromMessage(Message message) {
        String sessionId = null;
        try {
            JSONObject service_session;
            String weichat;
            JSONObject wc;
            Map<String, Object> extMap = message.ext();
            if (extMap.containsKey("weichat") && (wc = new JSONObject(weichat = message.getStringAttribute("weichat"))).has("service_session") && (service_session = wc.getJSONObject("service_session")).has("serviceSessionId")) {
                sessionId = service_session.getString("serviceSessionId");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sessionId;
    }

    public static void asyncMarkAllMessagesAsRead(String tenantId, String sessionId, ValueCallBack<String> callBack) {
        MarketingHttpClient.asyncMarkAllMessagesAsRead(tenantId, sessionId, callBack);
    }

    public static void acceptVecCallFromZuoXi(String content, String vecImServiceNumber) {
        Message message = Message.createSendMessage(Message.Type.TXT);
        if (TextUtils.isEmpty((CharSequence)vecImServiceNumber)) {
            throw new RuntimeException("mVecImServiceNumber is null.");
        }
        try {
            AgoraMessage.newAgoraMessage().addVisitorInfoToMessage(message);
            message.setBody(new EMTextMessageBody(content));
            message.setTo(vecImServiceNumber);
            JSONObject object = new JSONObject();
            JSONObject visitorRejectInvitation = new JSONObject();
            visitorRejectInvitation.put("msg", (Object)content);
            object.put("visitorAcceptInvitation", (Object)visitorRejectInvitation);
            message.setAttribute("type", "agorartcmedia/video");
            message.setAttribute("msgtype", object);
            message.setAttribute("targetSystem", "kefurtc");
        }
        catch (Exception e) {
            e.printStackTrace();
            EMLog.e(TAG, "\u5ea7\u5e2d\u7aef\u8bf7\u6c42\u89c6\u9891\uff0c\u8bbf\u5ba2\u63a5\u901a \u6307\u4ee4 acceptCallFromZuoXi error = " + e.toString());
        }
        EMLog.e(TAG, "\u5750\u5e2d\u53d1\u8d77\u89c6\u9891\u9080\u8bf7\u3002\u8bbf\u5ba2\u53d1\u9001\u63a5\u901a\u4fe1\u4ee4 vecImServiceNumber = " + vecImServiceNumber);
        ChatManager.getInstance().sendMessage(message);
        EMLog.e(TAG, "\u5ea7\u5e2d\u7aef\u8bf7\u6c42\u89c6\u9891\uff0c\u8bbf\u5ba2\u63a5\u901a \u6307\u4ee4 acceptCallFromZuoXi vecImServiceNumber = " + vecImServiceNumber);
    }

    public static void endVecCallFromZuoXi(String content, String vecImServiceNumber) {
        if (TextUtils.isEmpty((CharSequence)vecImServiceNumber)) {
            throw new RuntimeException("mVecImServiceNumber is null.");
        }
        Message message = Message.createSendMessage(Message.Type.TXT);
        message.setBody(new EMTextMessageBody(content));
        AgoraMessage.newAgoraMessage().addVisitorInfoToMessage(message);
        try {
            message.setTo(vecImServiceNumber);
            JSONObject object = new JSONObject();
            JSONObject visitorRejectInvitation = new JSONObject();
            visitorRejectInvitation.put("msg", (Object)content);
            object.put("visitorRejectInvitation", (Object)visitorRejectInvitation);
            message.setAttribute("type", "agorartcmedia/video");
            message.setAttribute("msgtype", object);
            message.setAttribute("targetSystem", "kefurtc");
        }
        catch (Exception e) {
            e.printStackTrace();
            EMLog.e("VECVideo", "\u5750\u5e2d\u53d1\u8d77\u9080\u8bf7\uff0c\u672a\u63a5\u901a\uff0c\u8bbf\u5ba2\u6302\u65ad \u6307\u4ee4 endCallFromZuoXi error = " + e.toString());
        }
        ChatManager.getInstance().sendMessage(message);
        VecConfig.newVecConfig().setPopupView(false);
        EMLog.e("VECVideo", "\u5750\u5e2d\u53d1\u8d77\u9080\u8bf7\uff0c\u672a\u63a5\u901a\uff0c\u8bbf\u5ba2\u6302\u65ad \u6307\u4ee4 endCallFromZuoXi content = " + content);
    }

    public static void endVecCallFromOn(ValueCallBack<String> callBack) {
        EMLog.e("VECVideo", "\u63a5\u901a\u6302\u65ad \u6307\u4ee4 endCallFromOn getSessionId = " + VecConfig.newVecConfig().getSessionId() + ", tenantId = " + ChatClient.getInstance().tenantId());
        AgoraMessage.asyncCloseVec(ChatClient.getInstance().tenantId(), VecConfig.newVecConfig().getSessionId(), VecConfig.newVecConfig().getVisitorId(), callBack);
        VecConfig.newVecConfig().setPopupView(false);
    }

    public static void endVecCallFromOn(String sessionId, String visitorId, ValueCallBack<String> callBack) {
        EMLog.e("VECVideo", "\u63a5\u901a\u6302\u65ad \u6307\u4ee4 endCallFromOn sessionId = " + sessionId + ", tenantId = " + ChatClient.getInstance().tenantId() + ", visitorId = " + visitorId);
        AgoraMessage.asyncCloseVec(ChatClient.getInstance().tenantId(), sessionId, visitorId, callBack);
        VecConfig.newVecConfig().setPopupView(false);
    }

    public static void endVecCallFromOff(String vecImServiceNumber) {
        if (TextUtils.isEmpty((CharSequence)vecImServiceNumber)) {
            throw new RuntimeException("mVecImServiceNumber is null.");
        }
        try {
            Message message = AgoraMessage.requestOnAndOffMessage(0, vecImServiceNumber);
            ChatManager.getInstance().sendMessage(message);
            EMLog.e("VECVideo", "\u672a\u63a5\u901a\u6302\u65ad \u6307\u4ee4 endCallFromOff to = " + vecImServiceNumber);
        }
        catch (Exception e) {
            e.printStackTrace();
            EMLog.e(TAG, "endCallFromOff error = " + e.getMessage());
        }
        VecConfig.newVecConfig().setPopupView(false);
    }

    public static void createVecFlatRoom(int callId) {
        String to = AgoraMessage.newAgoraMessage().getVecImServiceNumber();
        if (TextUtils.isEmpty((CharSequence)to)) {
            throw new RuntimeException("mVecImServiceNumber is null.");
        }
        Message message = Message.createVecFlatRoomMessage(callId, to);
        ChatManager.getInstance().sendMessage(message);
    }

    public static Message createCallVecVideoMessage(String content, String vecImServiceNumber) {
        if (TextUtils.isEmpty((CharSequence)vecImServiceNumber)) {
            throw new RuntimeException("mVecImServiceNumber is null.");
        }
        VecConfig.newVecConfig().setPopupView(true);
        Message message = null;
        try {
            EMLog.e(TAG, "createCallVecVideoMessage \u53d1\u9001\u8bf7\u6c42\u5efa\u7acb\u89c6\u9891 sendCmd vecImServiceNumber = " + vecImServiceNumber);
            message = Message.createVecVideoInviteSendMessage(content, vecImServiceNumber);
            EMLog.e(TAG, "createCallVecVideoMessage \u53d1\u9001\u8bf7\u6c42\u5efa\u7acb\u89c6\u9891 sendCmd from = " + message.from());
        }
        catch (Exception e) {
            e.printStackTrace();
            EMLog.e(TAG, "callVecVideo \u53d1\u9001\u8bf7\u6c42\u5efa\u7acb\u89c6\u9891 e = " + e.getMessage());
        }
        return message;
    }

    public static void sendCallVecVideoMessage(Message message, final Callback callback) {
        final String vecImServiceNumber = message.to();
        if (TextUtils.isEmpty((CharSequence)vecImServiceNumber)) {
            throw new RuntimeException("Message \u672a\u6307\u5b9aIM\u670d\u52a1\u53f7 vecImServiceNumber is null.");
        }
        ChatClient.getInstance().chatManager().sendMessage(message, new Callback(){

            @Override
            public void onSuccess() {
                if (VecConfig.newVecConfig().isEnableReport()) {
                    ChatClient.getInstance().chatManager().sendVecReport(vecImServiceNumber);
                }
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            @Override
            public void onError(int code, String error) {
                if (callback != null) {
                    callback.onError(code, error);
                }
            }

            @Override
            public void onProgress(int progress, String status) {
                if (callback != null) {
                    callback.onProgress(progress, status);
                }
            }
        });
    }

    String getNickname() {
        if (this.mVisitorInfo != null) {
            JSONObject content = this.mVisitorInfo.getContent();
            String name = content.optString("userNickname");
            if (!TextUtils.isEmpty((CharSequence)name) && !"null".equals(name)) {
                return name;
            }
            name = content.optString("trueName");
            if (!TextUtils.isEmpty((CharSequence)name) && !"null".equals(name)) {
                return name;
            }
            name = VecConfig.newVecConfig().getUserName();
            if (TextUtils.isEmpty((CharSequence)name) || "null".equals(name)) {
                name = ChatClient.getInstance().currentUserName();
            }
            return name;
        }
        String name = VecConfig.newVecConfig().getUserName();
        if (!TextUtils.isEmpty((CharSequence)name) && !"null".equals(name)) {
            return name;
        }
        return ChatClient.getInstance().currentUserName();
    }

    public static void callVecVideo(String content, final String vecImServiceNumber) {
        if (TextUtils.isEmpty((CharSequence)vecImServiceNumber)) {
            throw new RuntimeException("mVecImServiceNumber is null.");
        }
        VecConfig.newVecConfig().setPopupView(true);
        try {
            EMLog.e(TAG, "callVecVideo \u53d1\u9001\u8bf7\u6c42\u5efa\u7acb\u89c6\u9891 sendCmd vecImServiceNumber = " + vecImServiceNumber);
            Message message = Message.createVecVideoInviteSendMessage(content, vecImServiceNumber);
            AgoraMessage.newAgoraMessage().addVisitorInfoToMessage(message);
            EMLog.e(TAG, "callVecVideo \u53d1\u9001\u8bf7\u6c42\u5efa\u7acb\u89c6\u9891 sendCmd from = " + message.from());
            ChatClient.getInstance().chatManager().sendMessage(message, new Callback(){

                @Override
                public void onSuccess() {
                    if (VecConfig.newVecConfig().isEnableReport()) {
                        ChatClient.getInstance().chatManager().sendVecReport(vecImServiceNumber);
                    }
                }

                @Override
                public void onError(int code, String error) {
                }

                @Override
                public void onProgress(int progress, String status) {
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            EMLog.e(TAG, "callVecVideo \u53d1\u9001\u8bf7\u6c42\u5efa\u7acb\u89c6\u9891 e = " + e.getMessage());
        }
    }

    public static void callVecVideo(String content, final String vecImServiceNumber, MessageCall messageCall) {
        if (TextUtils.isEmpty((CharSequence)vecImServiceNumber)) {
            throw new RuntimeException("mVecImServiceNumber is null.");
        }
        VecConfig.newVecConfig().setPopupView(true);
        EMLog.e(TAG, "callVecVideo \u53d1\u9001\u8bf7\u6c42\u5efa\u7acb\u89c6\u9891 sendCmd vecImServiceNumber = " + vecImServiceNumber);
        try {
            Message message = Message.createVecVideoInviteSendMessage(content, vecImServiceNumber);
            AgoraMessage.newAgoraMessage().addVisitorInfoToMessage(message);
            if (messageCall != null) {
                messageCall.getMessage(message);
            }
            EMLog.e(TAG, "callVecVideo \u53d1\u9001\u8bf7\u6c42\u5efa\u7acb\u89c6\u9891 sendCmd from = " + message.from());
            ChatClient.getInstance().chatManager().sendMessage(message, new Callback(){

                @Override
                public void onSuccess() {
                    if (VecConfig.newVecConfig().isEnableReport()) {
                        ChatClient.getInstance().chatManager().sendVecReport(vecImServiceNumber);
                    }
                }

                @Override
                public void onError(int code, String error) {
                }

                @Override
                public void onProgress(int progress, String status) {
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            EMLog.e(TAG, "callVecVideo \u53d1\u9001\u8bf7\u6c42\u5efa\u7acb\u89c6\u9891 e = " + e.getMessage());
        }
    }

    private static void test(Message message) {
        JSONObject weichat = null;
        try {
            weichat = message.getJSONObjectAttribute("weichat");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (weichat == null) {
                weichat = new JSONObject();
            }
            JSONObject visitor = new JSONObject();
            JSONArray tags = new JSONArray();
            tags.put((Object)"vip1");
            tags.put((Object)"vip2");
            visitor.put("tags", (Object)tags);
            weichat.put("visitor", (Object)visitor);
            message.setAttribute("weichat", weichat);
            Log.e((String)"oooooooooo", (String)("weichat = " + weichat));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void callVecVideo(String content, final String vecImServiceNumber, String relatedSessionId, String relatedVisitorUserId, String relatedImServiceNumber, int guideQueueId, int guideMenuId, String guideQueueType) {
        VecConfig.newVecConfig().setPopupView(true);
        if (TextUtils.isEmpty((CharSequence)vecImServiceNumber)) {
            throw new RuntimeException("mVecImServiceNumber is null.");
        }
        try {
            EMLog.e(TAG, "callVecVideo \u53d1\u9001\u8bf7\u6c42\u5efa\u7acb\u89c6\u9891 sendCmd vecImServiceNumber = " + vecImServiceNumber);
            Message message = Message.createVecVideoInviteSendMessage(content, vecImServiceNumber);
            AgoraMessage.newAgoraMessage().addVisitorInfoToMessage(message);
            EMLog.e(TAG, "callVecVideo \u53d1\u9001\u8bf7\u6c42\u5efa\u7acb\u89c6\u9891 sendCmd from = " + message.from());
            if (!TextUtils.isEmpty((CharSequence)relatedSessionId)) {
                JSONObject sessionExt = new JSONObject();
                sessionExt.put("relatedSessionId", (Object)relatedSessionId);
                sessionExt.put("relatedVisitorUserId", (Object)relatedVisitorUserId);
                sessionExt.put("source", (Object)"relatedSession");
                sessionExt.put("relatedImServiceNum", (Object)relatedImServiceNumber);
                sessionExt.put("queueId", guideQueueId);
                sessionExt.put("menuId", guideMenuId);
                sessionExt.put("queueType", (Object)guideQueueType);
                message.setAttribute("sessionExt", sessionExt);
            }
            ChatClient.getInstance().chatManager().sendMessage(message, new Callback(){

                @Override
                public void onSuccess() {
                    if (VecConfig.newVecConfig().isEnableReport()) {
                        ChatClient.getInstance().chatManager().sendVecReport(vecImServiceNumber);
                    }
                }

                @Override
                public void onError(int code, String error) {
                }

                @Override
                public void onProgress(int progress, String status) {
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            EMLog.e(TAG, "callVecVideo \u53d1\u9001\u8bf7\u6c42\u5efa\u7acb\u89c6\u9891 e = " + e.getMessage());
        }
    }

    public static void callVecVideo(String content, final String vecImServiceNumber, String relatedSessionId, String relatedVisitorUserId, String relatedImServiceNumber, int guideQueueId, int guideMenuId, String guideQueueType, MessageCall messageCall) {
        VecConfig.newVecConfig().setPopupView(true);
        if (TextUtils.isEmpty((CharSequence)vecImServiceNumber)) {
            throw new RuntimeException("mVecImServiceNumber is null.");
        }
        try {
            EMLog.e(TAG, "callVecVideo \u53d1\u9001\u8bf7\u6c42\u5efa\u7acb\u89c6\u9891 sendCmd vecImServiceNumber = " + vecImServiceNumber);
            Message message = Message.createVecVideoInviteSendMessage(content, vecImServiceNumber);
            AgoraMessage.newAgoraMessage().addVisitorInfoToMessage(message);
            EMLog.e(TAG, "callVecVideo \u53d1\u9001\u8bf7\u6c42\u5efa\u7acb\u89c6\u9891 sendCmd from = " + message.from());
            if (messageCall != null) {
                messageCall.getMessage(message);
            }
            if (!TextUtils.isEmpty((CharSequence)relatedSessionId)) {
                AgoraMessage.addSessionExt(message, relatedSessionId, relatedVisitorUserId, relatedImServiceNumber, guideQueueId, guideMenuId, guideQueueType);
            }
            ChatClient.getInstance().chatManager().sendMessage(message, new Callback(){

                @Override
                public void onSuccess() {
                    if (VecConfig.newVecConfig().isEnableReport()) {
                        ChatClient.getInstance().chatManager().sendVecReport(vecImServiceNumber);
                    }
                }

                @Override
                public void onError(int code, String error) {
                }

                @Override
                public void onProgress(int progress, String status) {
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            EMLog.e(TAG, "callVecVideo \u53d1\u9001\u8bf7\u6c42\u5efa\u7acb\u89c6\u9891 e = " + e.getMessage());
        }
    }

    private static void addSessionExt(Message message, String relatedSessionId, String relatedVisitorUserId, String relatedImServiceNumber, int guideQueueId, int guideMenuId, String guideQueueType) {
        JSONObject sessionExt = null;
        try {
            sessionExt = message.getJSONObjectAttribute("sessionExt");
        }
        catch (Exception var3) {
            var3.printStackTrace();
        }
        if (sessionExt == null) {
            sessionExt = new JSONObject();
        }
        try {
            sessionExt.put("relatedSessionId", (Object)relatedSessionId);
            sessionExt.put("relatedVisitorUserId", (Object)relatedVisitorUserId);
            sessionExt.put("source", (Object)"relatedSession");
            sessionExt.put("relatedImServiceNum", (Object)relatedImServiceNumber);
            sessionExt.put("queueId", guideQueueId);
            sessionExt.put("menuId", guideMenuId);
            sessionExt.put("queueType", (Object)guideQueueType);
            message.setAttribute("sessionExt", sessionExt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Message requestOnAndOffMessage(int callId, String toUserName) {
        Message message = Message.createSendMessage(Message.Type.CMD);
        message.setBody(new EMCmdMessageBody(""));
        message.setTo(toUserName);
        try {
            JSONObject object = new JSONObject();
            JSONObject call = new JSONObject();
            call.put("callId", (Object)(callId > 0 ? String.valueOf(callId) : "null"));
            object.put("visitorCancelInvitation", (Object)call);
            message.setAttribute("type", "agorartcmedia/video");
            message.setAttribute("msgtype", object);
            message.setAttribute("targetSystem", "kefurtc");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return message;
    }

    private static void sendNotify(String action, String type, String state, String msg) {
        Message message = Message.createSendMessage(Message.Type.CMD);
        message.setBody(new EMCmdMessageBody(action));
        String toUserName = AgoraMessage.newAgoraMessage().getVecImServiceNumber();
        if (TextUtils.isEmpty((CharSequence)toUserName)) {
            throw new RuntimeException("mVecImServiceNumber is null.");
        }
        try {
            message.setTo(toUserName);
            JSONObject obj = new JSONObject();
            JSONObject flashlightcallback = new JSONObject();
            flashlightcallback.put("action", (Object)state);
            obj.put("msg", (Object)msg);
            obj.put(type, (Object)flashlightcallback);
            message.setAttribute("type", "agorartcmedia/video");
            message.setAttribute("msgtype", obj);
            message.setAttribute("targetSystem", "kefurtc");
        }
        catch (Exception e) {
            e.printStackTrace();
            EMLog.e(TAG, "sendNotify error = " + e.getMessage());
        }
        ChatManager.getInstance().sendMessage(message);
    }

    public static void sendFlashLight(boolean isOk, String msg) {
        AgoraMessage.sendNotify("flashlightcallback", "flashlightcallback", isOk ? "on" : "off", msg);
    }

    public static void sendCameraTorch(boolean isOk, String msg) {
        AgoraMessage.sendNotify("cameraTorchOncallback", "cameraTorchOncallback", isOk ? "on" : "off", msg);
    }

    public static void sendCameraFocus(String msg) {
        AgoraMessage.sendNotify("focusCameracallback", "focusCameracallback", "", msg);
    }

    public static void sendMicrophone(String msg) {
        AgoraMessage.sendNotify("microphonecallback", "microphonecallback", "", msg);
    }

    public static void sendCamera(String msg) {
        AgoraMessage.sendNotify("cameracallback", "cameracallback", "", msg);
    }

    public static void sendChangeCamera(String msg) {
        AgoraMessage.sendNotify("cameraChangecallback", "cameraChangecallback", "", msg);
    }

    public static void saveVisitorRegion(String visitorId, ValueCallBack<String> callBack) {
        MarketingHttpClient.saveVisitorRegion(visitorId, callBack);
    }

    public static interface MessageCall {
        public void getMessage(Message var1);
    }
}

