/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.text.TextUtils;
import com.hyphenate.agora.ZuoXiSendRequestObj;
import com.hyphenate.chat.AgoraMessage;
import com.hyphenate.chat.ChatClient;
import com.hyphenate.chat.ChatManager;
import com.hyphenate.chat.Message;
import com.hyphenate.helpdesk.callback.Callback;
import com.hyphenate.util.EMLog;
import org.json.JSONException;
import org.json.JSONObject;

public final class CallManager {
    static final String TAG = "CallManager";
    private static CallManager sInstance;
    private static final String IncomingCallAction = ".action.incomingcall";

    static synchronized CallManager getInstance() {
        if (sInstance == null) {
            sInstance = new CallManager();
        }
        return sInstance;
    }

    public String getIncomingCallBroadcastAction() {
        return ChatClient.getInstance().getContext().getPackageName() + IncomingCallAction;
    }

    void putTicket(Message message, String ticket, String callNickName, String to, String from, String sessionId) {
        try {
            ZuoXiSendRequestObj obj = this.get(message, ticket, callNickName);
            obj.setTo(to);
            obj.setFrom(from);
            AgoraMessage.zuoXiSendRequestLine(message, obj, sessionId);
        }
        catch (Exception e) {
            e.printStackTrace();
            EMLog.d(TAG, "putTicket Exception = " + e.getMessage());
        }
    }

    private ZuoXiSendRequestObj get(Message message, String ticket, String nickName) throws JSONException {
        JSONObject agentTicket;
        ZuoXiSendRequestObj obj = new ZuoXiSendRequestObj();
        JSONObject ticketObj = new JSONObject(ticket);
        if (ticketObj.has("isThirdAgent")) {
            boolean isThirdAgent = ticketObj.getBoolean("isThirdAgent");
            obj.setIsAddThreeUser(isThirdAgent);
        }
        if (ticketObj.has("agentTicket") && (agentTicket = ticketObj.getJSONObject("agentTicket")).has("trueName")) {
            obj.setThreeTrueName(agentTicket.getString("trueName"));
            obj.setThreeNiceName(agentTicket.getString("niceName"));
            obj.setThreeUid(agentTicket.getInt("uid"));
            obj.setThreeCallId(agentTicket.getInt("callId"));
        }
        obj.setNiceName(ticketObj.getString("niceName"));
        obj.setTrueName(ticketObj.getString("trueName"));
        obj.setCallId(ticketObj.getInt("callId"));
        obj.setUid(ticketObj.getInt("uid"));
        obj.setToken(ticketObj.getString("token"));
        obj.setAppId(ticketObj.getString("appId"));
        obj.setChannel(ticketObj.getString("channel"));
        if (TextUtils.isEmpty((CharSequence)nickName) || "null".equalsIgnoreCase(nickName)) {
            obj.setNickName(TextUtils.isEmpty((CharSequence)obj.getThreeTrueName()) ? obj.getThreeNiceName() : obj.getThreeTrueName());
        } else {
            obj.setNickName(nickName);
        }
        return obj;
    }

    public void endCall(int callId, boolean isConnected) {
        String to = AgoraMessage.newAgoraMessage().getCecImServiceNumber();
        if (!TextUtils.isEmpty((CharSequence)to)) {
            EMLog.e(TAG, "endCall AgoraMessage.newAgoraMessage().getCecImServiceNumber() = " + to);
            Message message = isConnected ? Message.createCancelVideoMessage(callId, to) : Message.createHangUpVideoMessage(callId, to);
            ChatManager.getInstance().sendMessage(message);
        } else {
            EMLog.d(TAG, "endCall mCecImServiceNumber is null.");
        }
    }

    public void endCall(String cecImServiceNumber, int callId, boolean isConnected) {
        Message message = isConnected ? Message.createCancelVideoMessage(callId, cecImServiceNumber) : Message.createHangUpVideoMessage(callId, cecImServiceNumber);
        ChatManager.getInstance().sendMessage(message);
    }

    public void createFlatRoom(int callId) {
        String to = AgoraMessage.newAgoraMessage().getCecImServiceNumber();
        if (TextUtils.isEmpty((CharSequence)to)) {
            throw new RuntimeException("mCecImServiceNumber is null.");
        }
        EMLog.d(TAG, "createFlatRoom AgoraMessage.newAgoraMessage().getCecImServiceNumber() = " + to);
        Message message = Message.createFlatRoomMessage(callId, to);
        ChatManager.getInstance().sendMessage(message);
    }

    public void endCall(int callId, boolean isConnected, Callback callback) {
        String to = AgoraMessage.newAgoraMessage().getCecImServiceNumber();
        if (TextUtils.isEmpty((CharSequence)to)) {
            throw new RuntimeException("mCecImServiceNumber is null.");
        }
        EMLog.d(TAG, "endCall AgoraMessage.newAgoraMessage().getCecImServiceNumber() = " + to);
        Message message = isConnected ? Message.createCancelVideoMessage(callId, to) : Message.createHangUpVideoMessage(callId, to);
        ChatManager.getInstance().sendMessage(message, callback);
    }

    public void callVideo(String content, String toChatUsername) {
        EMLog.d(TAG, "\u5728\u7ebf\u89c6\u9891 \u8bbf\u5ba2\u4e3b\u52a8\u53d1\u8d77\u89c6\u9891\u9080\u8bf7 toChatUsername = " + toChatUsername);
        Message message = Message.createVideoInviteSendMessage(content, toChatUsername);
        ChatClient.getInstance().chatManager().sendMessage(message);
    }
}

