/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import android.os.SystemClock;
import android.text.TextUtils;
import com.hyphenate.EMConnectionListener;
import com.hyphenate.chat.AgoraMessage;
import com.hyphenate.chat.CallManager;
import com.hyphenate.chat.ChatConfig;
import com.hyphenate.chat.ChatManager;
import com.hyphenate.chat.CountDownUtils;
import com.hyphenate.chat.EMChatManager;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMOptions;
import com.hyphenate.chat.ILoginCallback;
import com.hyphenate.chat.INeedLoginCallback;
import com.hyphenate.chat.ISdkInitCallback;
import com.hyphenate.chat.KefuDBManager;
import com.hyphenate.chat.MarketingHttpClient;
import com.hyphenate.chat.PreferenceUtil;
import com.hyphenate.chat.ProcessUtils;
import com.hyphenate.chat.SdkReport;
import com.hyphenate.chat.VecChatManager;
import com.hyphenate.exceptions.HyphenateException;
import com.hyphenate.helpdesk.callback.Callback;
import com.hyphenate.helpdesk.callback.ValueCallBack;
import com.hyphenate.helpdesk.manager.EmojiconManager;
import com.hyphenate.helpdesk.manager.TicketManager;
import com.hyphenate.helpdesk.model.VisitorInfo;
import com.hyphenate.helpdesk.util.Log;
import com.hyphenate.push.EMPushConfig;
import com.hyphenate.util.EMLog;
import com.hyphenate.util.PathUtil;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class ChatClient {
    public static final String TAG = "ChatClient";
    private static ChatClient instance = new ChatClient();
    private EMClient _client = null;
    private ChatManager chatManager = null;
    private VecChatManager vecChatManager = null;
    private CallManager callManager = null;
    private TicketManager leaveMsgManager = null;
    private EmojiconManager emojiconManager = null;
    private final List<ConnectionListener> connectionListeners = new ArrayList<ConnectionListener>();
    private String userName = null;
    private boolean isInitialized = false;
    private volatile String tenantId = null;
    private volatile String configId = "";
    public static boolean multiChannel = false;
    private static final String DEFAULT_KEFU_HOST = "https://kefu.sh.absoloop.com";
    private String kefuHost;
    boolean hasSecondChannel = true;
    private Context mContext;
    private boolean isDebugMode;
    private static final String sdkVersion = "1.3.4.0";
    boolean isShowAgentInputState;
    boolean isShowVisitorWaitCount;
    boolean isShowMessagePredict;
    private Options mOptions = null;
    private static volatile String sTemporaryName;
    private static volatile String sTemporaryToken;
    private static volatile String sTemporaryPassword;
    private INeedLoginCallback mNeedLoginCallback;
    private Handler mHandler = new Handler(Looper.getMainLooper());
    private boolean useIm;
    private String imServiceUser;
    ISdkInitCallback mISdkInitCallback;
    private boolean userDataInited = false;
    private volatile long mReportTimer = 5L;
    private volatile boolean mIsSdkReport;

    public String getImServiceUser() {
        return this.imServiceUser;
    }

    public boolean isUseIm() {
        return this.useIm;
    }

    private ChatClient() {
    }

    boolean isCountDownDisconnect() {
        ChatConfig.DnsConfig dnsConfig = ChatConfig.getInstance().getDnsConfig();
        return dnsConfig != null && dnsConfig.keepAliveTime > 0L;
    }

    long getKeepAliveTime() {
        ChatConfig.DnsConfig dnsConfig = ChatConfig.getInstance().getDnsConfig();
        if (dnsConfig != null) {
            return dnsConfig.keepAliveTime;
        }
        return -1L;
    }

    public static ChatClient getInstance() {
        return instance;
    }

    public Options getOptions() {
        return this.mOptions;
    }

    Context getContext() {
        if (this.mContext != null) {
            return this.mContext;
        }
        this.mContext = this._client.getContext();
        return this.mContext;
    }

    @Deprecated
    public String getKefuServerAddress() {
        return this.kefuRestServer();
    }

    public String kefuRestServer() {
        if (TextUtils.isEmpty((CharSequence)this.kefuHost)) {
            this.kefuHost = DEFAULT_KEFU_HOST;
        }
        return this.kefuHost;
    }

    private void initAutoLoginState(Options options) {
        long triggerEventTime = PreferenceUtil.getInstance().getTriggerEventTime();
        if (triggerEventTime > 0L && triggerEventTime < SystemClock.elapsedRealtime()) {
            PreferenceUtil.getInstance().setTriggerEventTime(0L);
            options.isAutoLogin = false;
        }
    }

    public synchronized boolean init(final Context context, final Options options, String runProcessName) {
        if (this.isInitialized) {
            android.util.Log.e((String)TAG, (String)"sdk already initialized");
            try {
                AgoraMessage.asyncGetTenantIdFunctionIcons(options.tenantId);
            }
            catch (Exception e) {
                e.printStackTrace();
                android.util.Log.e((String)TAG, (String)"init asyncGetTenantIdFunctionIcons error");
            }
            return false;
        }
        if (context == null) {
            android.util.Log.e((String)TAG, (String)"init fail, context is null");
            return false;
        }
        if (options == null) {
            android.util.Log.e((String)TAG, (String)"init fail, options is null");
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)options.appkey)) {
            android.util.Log.e((String)TAG, (String)"init fail, appkey is null");
            return false;
        }
        this.mOptions = options;
        this.imServiceUser = options.imServiceUser;
        this.useIm = options.useIm;
        String processAppName = ProcessUtils.getCurrentProcessName();
        this.kefuHost = options.kefuHost;
        android.util.Log.d((String)TAG, (String)("process app name : " + processAppName));
        if (processAppName == null || !processAppName.endsWith(runProcessName)) {
            android.util.Log.e((String)TAG, (String)"enter the service process!");
            return false;
        }
        this._client = EMClient.getInstance();
        EMOptions emoptions = new EMOptions();
        emoptions.setAppKey(options.appkey);
        emoptions.setUsingHttpsOnly(options.getUseHttps());
        if (!TextUtils.isEmpty((CharSequence)options.restHost)) {
            emoptions.setRestServer(options.restHost);
        }
        if (!TextUtils.isEmpty((CharSequence)options.imHost)) {
            emoptions.setIMServer(options.imHost);
        }
        if (options.imPort > 0) {
            emoptions.setImPort(options.imPort);
        }
        this.tenantId = options.tenantId;
        this.configId = options.configId;
        this.isShowAgentInputState = options.showAgentInputState;
        this.isShowVisitorWaitCount = options.showVisitorWaitCount;
        this.isShowMessagePredict = options.showMessagePredict;
        this.isDebugMode = options.consoleLogEnable;
        long currentTime = System.currentTimeMillis();
        PreferenceUtil.getInstance().init(context);
        CountDownUtils.getInstance().init(context);
        if (options.pushConfig != null) {
            emoptions.setPushConfig(options.pushConfig);
        }
        emoptions.setAutoLogin(false);
        if (!TextUtils.isEmpty((CharSequence)options.getDnsUrl())) {
            String dnsUrl = options.getDnsUrl();
            dnsUrl = dnsUrl.concat("?app_key=" + URLEncoder.encode(options.appkey));
            emoptions.setDnsUrl(dnsUrl);
        }
        this._client.init(context, emoptions);
        EMLog.d(TAG, "im init time(ms):" + (System.currentTimeMillis() - currentTime));
        this.chatManager = ChatManager.getInstance();
        this.vecChatManager = VecChatManager.getInstance();
        try {
            if (Class.forName("com.hyphenate.chat.CallManager") != null) {
                this.callManager = CallManager.getInstance();
            }
        }
        catch (ClassNotFoundException e) {
            EMLog.d(TAG, "" + android.util.Log.getStackTraceString((Throwable)e));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            AgoraMessage.asyncGetTenantIdFunctionIcons(options.tenantId);
        }
        catch (Exception e) {
            e.printStackTrace();
            android.util.Log.e((String)TAG, (String)"init asyncGetTenantIdFunctionIcons error");
        }
        try {
            this.chatManager.asyncGetReportTimer();
        }
        catch (Exception e) {
            e.printStackTrace();
            android.util.Log.e((String)TAG, (String)"init asyncGetReportTimer error");
        }
        ChatConfig.getInstance().loadLocalDnsConfig();
        EMLog.d(TAG, "loadLocalDnsConfig finished");
        this.initNameAndPasswordToLogout(options);
        String username = sTemporaryName;
        username = TextUtils.isEmpty((CharSequence)username) ? "" : username;
        this.mNeedLoginCallback = options.mINeedLoginCallback;
        MarketingHttpClient.asyncGetLoginFlag(username, this.tenantId, new ValueCallBack<Boolean>(){

            @Override
            public void onSuccess(final Boolean value) {
                ChatClient.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        ChatClient.this.starInitDemo(context, options, value, ChatClient.this.mNeedLoginCallback);
                    }
                });
            }

            @Override
            public void onError(int error, String errorMsg) {
                ChatClient.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        ChatClient.this.starInitDemo(context, options, false, ChatClient.this.mNeedLoginCallback);
                    }
                });
            }
        });
        ChatConfig.getInstance().loadDnsConfigFromRemote(false);
        EMChatManager _emChatManager = this._client.chatManager();
        this._client.addConnectionListener(new EMConnectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onConnected() {
                EMLog.d(ChatClient.TAG, "init sdk onConnected");
                List list = ChatClient.this.connectionListeners;
                synchronized (list) {
                    for (ConnectionListener listener : ChatClient.this.connectionListeners) {
                        if (listener == null) continue;
                        listener.onConnected();
                    }
                    PreferenceUtil.getInstance().setToken(EMClient.getInstance().getAccessToken());
                    MarketingHttpClient.asyncRequest();
                }
            }

            @Override
            public void onDisconnected(int errorCode) {
                int code = 1;
                EMLog.d(ChatClient.TAG, "init sdk onConnected onDisconnected = " + errorCode);
                switch (errorCode) {
                    case 207: {
                        code = 207;
                        ChatClient.this.chatManager().kefuLogout();
                        break;
                    }
                    case 200: {
                        code = 200;
                        break;
                    }
                    case 206: {
                        code = 206;
                        ChatClient.this.chatManager().kefuLogout();
                        break;
                    }
                    case 202: {
                        code = 202;
                        ChatClient.this.chatManager().kefuLogout();
                        break;
                    }
                    case 204: {
                        code = 204;
                        ChatClient.this.chatManager().kefuLogout();
                        break;
                    }
                }
                ChatClient.this.notifyOnDisconnected(code);
            }
        });
        this.leaveMsgManager = TicketManager.getInstance();
        this.isInitialized = true;
        EMClient.getInstance().setDebugMode(options.consoleLogEnable);
        return true;
    }

    public synchronized boolean init(final Context context, final Options options) {
        if (this.isInitialized) {
            android.util.Log.e((String)TAG, (String)"sdk already initialized");
            try {
                AgoraMessage.asyncGetTenantIdFunctionIcons(options.tenantId);
            }
            catch (Exception e) {
                e.printStackTrace();
                android.util.Log.e((String)TAG, (String)"init asyncGetTenantIdFunctionIcons error");
            }
            return false;
        }
        if (context == null) {
            android.util.Log.e((String)TAG, (String)"init fail, context is null");
            return false;
        }
        if (options == null) {
            android.util.Log.e((String)TAG, (String)"init fail, options is null");
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)options.appkey)) {
            android.util.Log.e((String)TAG, (String)"init fail, appkey is null");
            return false;
        }
        this.mOptions = options;
        this.imServiceUser = options.imServiceUser;
        this.useIm = options.useIm;
        String processAppName = ProcessUtils.getCurrentProcessName();
        this.kefuHost = options.kefuHost;
        android.util.Log.d((String)TAG, (String)("process app name : " + processAppName));
        if (processAppName == null || !processAppName.equalsIgnoreCase(context.getPackageName())) {
            android.util.Log.e((String)TAG, (String)"enter the service process!");
            return false;
        }
        this._client = EMClient.getInstance();
        EMOptions emoptions = new EMOptions();
        emoptions.setAppKey(options.appkey);
        emoptions.setUsingHttpsOnly(options.isUseHttps);
        if (!TextUtils.isEmpty((CharSequence)options.restHost)) {
            emoptions.setRestServer(options.restHost);
        }
        if (!TextUtils.isEmpty((CharSequence)options.imHost)) {
            emoptions.setIMServer(options.imHost);
        }
        if (options.imPort > 0) {
            emoptions.setImPort(options.imPort);
        }
        this.tenantId = options.tenantId;
        this.configId = options.configId;
        this.isShowAgentInputState = options.showAgentInputState;
        this.isShowVisitorWaitCount = options.showVisitorWaitCount;
        this.isShowMessagePredict = options.showMessagePredict;
        this.isDebugMode = options.consoleLogEnable;
        long currentTime = System.currentTimeMillis();
        PreferenceUtil.getInstance().init(context);
        CountDownUtils.getInstance().init(context);
        if (options.pushConfig != null) {
            emoptions.setPushConfig(options.pushConfig);
        }
        emoptions.setAutoLogin(false);
        if (!TextUtils.isEmpty((CharSequence)options.getDnsUrl())) {
            String dnsUrl = options.getDnsUrl();
            dnsUrl = dnsUrl.concat("?app_key=" + URLEncoder.encode(options.appkey));
            emoptions.setDnsUrl(dnsUrl);
        }
        this._client.init(context, emoptions);
        EMLog.d(TAG, "im init time(ms):" + (System.currentTimeMillis() - currentTime));
        this.chatManager = ChatManager.getInstance();
        this.vecChatManager = VecChatManager.getInstance();
        try {
            if (Class.forName("com.hyphenate.chat.CallManager") != null) {
                this.callManager = CallManager.getInstance();
            }
        }
        catch (ClassNotFoundException e) {
            EMLog.d(TAG, "" + android.util.Log.getStackTraceString((Throwable)e));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            AgoraMessage.asyncGetTenantIdFunctionIcons(options.tenantId);
        }
        catch (Exception e) {
            e.printStackTrace();
            android.util.Log.e((String)TAG, (String)"init asyncGetTenantIdFunctionIcons error");
        }
        try {
            this.chatManager.asyncGetReportTimer();
        }
        catch (Exception e) {
            e.printStackTrace();
            android.util.Log.e((String)TAG, (String)"init asyncGetReportTimer error");
        }
        ChatConfig.getInstance().loadLocalDnsConfig();
        EMLog.d(TAG, "loadLocalDnsConfig finished");
        this.initNameAndPasswordToLogout(options);
        String username = sTemporaryName;
        username = TextUtils.isEmpty((CharSequence)username) ? "" : username;
        this.mNeedLoginCallback = options.mINeedLoginCallback;
        MarketingHttpClient.asyncGetLoginFlag(username, this.tenantId, new ValueCallBack<Boolean>(){

            @Override
            public void onSuccess(final Boolean value) {
                ChatClient.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        ChatClient.this.starInitDemo(context, options, value, ChatClient.this.mNeedLoginCallback);
                    }
                });
            }

            @Override
            public void onError(int error, String errorMsg) {
                ChatClient.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        ChatClient.this.starInitDemo(context, options, false, ChatClient.this.mNeedLoginCallback);
                    }
                });
            }
        });
        ChatConfig.getInstance().loadDnsConfigFromRemote(false);
        EMChatManager _emChatManager = this._client.chatManager();
        this._client.addConnectionListener(new EMConnectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onConnected() {
                List list = ChatClient.this.connectionListeners;
                synchronized (list) {
                    for (ConnectionListener listener : ChatClient.this.connectionListeners) {
                        if (listener == null) continue;
                        listener.onConnected();
                    }
                    PreferenceUtil.getInstance().setToken(EMClient.getInstance().getAccessToken());
                    MarketingHttpClient.asyncRequest();
                }
            }

            @Override
            public void onDisconnected(int errorCode) {
                int code = 1;
                switch (errorCode) {
                    case 207: {
                        code = 207;
                        ChatClient.this.chatManager().kefuLogout();
                        break;
                    }
                    case 200: {
                        code = 200;
                        break;
                    }
                    case 206: {
                        code = 206;
                        ChatClient.this.chatManager().kefuLogout();
                        break;
                    }
                    case 202: {
                        code = 202;
                        ChatClient.this.chatManager().kefuLogout();
                        break;
                    }
                    case 204: {
                        code = 204;
                        ChatClient.this.chatManager().kefuLogout();
                        break;
                    }
                }
                ChatClient.this.notifyOnDisconnected(code);
            }
        });
        this.leaveMsgManager = TicketManager.getInstance();
        this.isInitialized = true;
        EMClient.getInstance().setDebugMode(options.consoleLogEnable);
        return true;
    }

    public synchronized void init(final Context context, final Options options, final ISdkInitCallback callback) {
        if (this.isInitialized) {
            android.util.Log.e((String)TAG, (String)"sdk already initialized");
            try {
                AgoraMessage.asyncGetTenantIdFunctionIcons(options.tenantId);
            }
            catch (Exception e) {
                e.printStackTrace();
                android.util.Log.e((String)TAG, (String)"init asyncGetTenantIdFunctionIcons error");
            }
            if (callback != null) {
                callback.init(false, "");
            }
            return;
        }
        if (context == null) {
            android.util.Log.e((String)TAG, (String)"init fail, context is null");
            if (callback != null) {
                callback.init(false, "init fail, context is null");
            }
            return;
        }
        if (options == null) {
            android.util.Log.e((String)TAG, (String)"init fail, options is null");
            if (callback != null) {
                callback.init(false, "init fail, options is null");
            }
            return;
        }
        if (TextUtils.isEmpty((CharSequence)options.appkey)) {
            android.util.Log.e((String)TAG, (String)"init fail, appkey is null");
            if (callback != null) {
                callback.init(false, "init fail, appkey is null");
            }
            return;
        }
        this.mISdkInitCallback = callback;
        this.mOptions = options;
        this.imServiceUser = options.imServiceUser;
        this.useIm = options.useIm;
        String processAppName = ProcessUtils.getCurrentProcessName();
        this.kefuHost = options.kefuHost;
        android.util.Log.d((String)TAG, (String)("process app name : " + processAppName));
        if (processAppName == null || !processAppName.equalsIgnoreCase(context.getPackageName())) {
            android.util.Log.e((String)TAG, (String)"enter the service process!");
            if (callback != null) {
                callback.init(false, "enter the service process!");
            }
            return;
        }
        this._client = EMClient.getInstance();
        EMOptions emoptions = new EMOptions();
        emoptions.setAppKey(options.appkey);
        emoptions.setUsingHttpsOnly(options.isUseHttps);
        if (!TextUtils.isEmpty((CharSequence)options.restHost)) {
            emoptions.setRestServer(options.restHost);
        }
        if (!TextUtils.isEmpty((CharSequence)options.imHost)) {
            emoptions.setIMServer(options.imHost);
        }
        if (options.imPort > 0) {
            emoptions.setImPort(options.imPort);
        }
        this.tenantId = options.tenantId;
        this.configId = options.configId;
        this.isShowAgentInputState = options.showAgentInputState;
        this.isShowVisitorWaitCount = options.showVisitorWaitCount;
        this.isShowMessagePredict = options.showMessagePredict;
        this.isDebugMode = options.consoleLogEnable;
        long currentTime = System.currentTimeMillis();
        PreferenceUtil.getInstance().init(context);
        CountDownUtils.getInstance().init(context);
        if (options.pushConfig != null) {
            emoptions.setPushConfig(options.pushConfig);
        }
        emoptions.setAutoLogin(false);
        if (!TextUtils.isEmpty((CharSequence)options.getDnsUrl())) {
            String dnsUrl = options.getDnsUrl();
            dnsUrl = dnsUrl.concat("?app_key=" + URLEncoder.encode(options.appkey));
            emoptions.setDnsUrl(dnsUrl);
        }
        this._client.init(context, emoptions);
        EMLog.d(TAG, "im init time(ms):" + (System.currentTimeMillis() - currentTime));
        this.chatManager = ChatManager.getInstance();
        this.vecChatManager = VecChatManager.getInstance();
        try {
            if (Class.forName("com.hyphenate.chat.CallManager") != null) {
                this.callManager = CallManager.getInstance();
            }
        }
        catch (ClassNotFoundException e) {
            EMLog.d(TAG, "" + android.util.Log.getStackTraceString((Throwable)e));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            AgoraMessage.asyncGetTenantIdFunctionIcons(options.tenantId);
        }
        catch (Exception e) {
            e.printStackTrace();
            android.util.Log.e((String)TAG, (String)"init asyncGetTenantIdFunctionIcons error");
        }
        try {
            this.chatManager.asyncGetReportTimer();
        }
        catch (Exception e) {
            e.printStackTrace();
            android.util.Log.e((String)TAG, (String)"init asyncGetReportTimer error");
        }
        ChatConfig.getInstance().loadLocalDnsConfig();
        EMLog.d(TAG, "loadLocalDnsConfig finished");
        this.initNameAndPasswordToLogoutCallback(options, new Callback(){

            @Override
            public void onSuccess() {
                ChatClient.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        ChatClient.this.getLoginFlag(context, options, callback);
                    }
                });
            }

            @Override
            public void onError(int code, String error) {
                ChatClient.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        ChatClient.this.getLoginFlag(context, options, callback);
                    }
                });
            }

            @Override
            public void onProgress(int progress, String status) {
            }
        });
        ChatConfig.getInstance().loadDnsConfigFromRemote(false);
        EMChatManager _emChatManager = this._client.chatManager();
        this._client.addConnectionListener(new EMConnectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onConnected() {
                List list = ChatClient.this.connectionListeners;
                synchronized (list) {
                    for (ConnectionListener listener : ChatClient.this.connectionListeners) {
                        if (listener == null) continue;
                        listener.onConnected();
                    }
                    PreferenceUtil.getInstance().setToken(EMClient.getInstance().getAccessToken());
                    MarketingHttpClient.asyncRequest();
                }
            }

            @Override
            public void onDisconnected(int errorCode) {
                int code = 1;
                switch (errorCode) {
                    case 207: {
                        code = 207;
                        ChatClient.this.chatManager().kefuLogout();
                        break;
                    }
                    case 200: {
                        code = 200;
                        break;
                    }
                    case 206: {
                        code = 206;
                        ChatClient.this.chatManager().kefuLogout();
                        break;
                    }
                    case 202: {
                        code = 202;
                        ChatClient.this.chatManager().kefuLogout();
                        break;
                    }
                    case 204: {
                        code = 204;
                        ChatClient.this.chatManager().kefuLogout();
                        break;
                    }
                }
                ChatClient.this.notifyOnDisconnected(code);
            }
        });
        this.leaveMsgManager = TicketManager.getInstance();
        this.isInitialized = true;
        EMClient.getInstance().setDebugMode(options.consoleLogEnable);
    }

    private void getLoginFlag(final Context context, final Options options, ISdkInitCallback callback) {
        String username = sTemporaryName;
        username = TextUtils.isEmpty((CharSequence)username) ? "" : username;
        this.mNeedLoginCallback = options.mINeedLoginCallback;
        MarketingHttpClient.asyncGetLoginFlag(username, this.tenantId, new ValueCallBack<Boolean>(){

            @Override
            public void onSuccess(final Boolean value) {
                ChatClient.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        ChatClient.this.starInitDemo(context, options, value, ChatClient.this.mNeedLoginCallback);
                    }
                });
            }

            @Override
            public void onError(int error, String errorMsg) {
                ChatClient.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        ChatClient.this.starInitDemo(context, options, false, ChatClient.this.mNeedLoginCallback);
                    }
                });
            }
        });
    }

    private void initNameAndPasswordToLogout(Options options) {
        VisitorInfo visitorInfo = options.getVisitorInfo();
        if (visitorInfo != null) {
            sTemporaryName = visitorInfo.getLoginUserName();
            sTemporaryPassword = visitorInfo.getLoginPassword();
            sTemporaryToken = visitorInfo.getLoginToken();
        }
        if (TextUtils.isEmpty((CharSequence)sTemporaryName)) {
            sTemporaryName = PreferenceUtil.getInstance().getUsername();
            sTemporaryPassword = PreferenceUtil.getInstance().getPassword();
            sTemporaryToken = PreferenceUtil.getInstance().getToken();
            if (this._client.isLoggedInBefore()) {
                String currentUser = this._client.getCurrentUser();
                if (!TextUtils.isEmpty((CharSequence)sTemporaryName) && sTemporaryName.equals(currentUser)) {
                    sTemporaryToken = this._client.getOptions().getAccessToken();
                }
            }
        }
        this.cleanCache();
        EMClient.getInstance().logout(false);
        Log.d(TAG, "sdk init \u540c\u6b65\u8c03\u7528im logout\u9000\u51fa\u65b9\u6cd5");
    }

    private void initNameAndPasswordToLogoutCallback(Options options, Callback callback) {
        VisitorInfo visitorInfo = options.getVisitorInfo();
        if (visitorInfo != null) {
            sTemporaryName = visitorInfo.getLoginUserName();
            sTemporaryPassword = visitorInfo.getLoginPassword();
            sTemporaryToken = visitorInfo.getLoginToken();
        }
        if (TextUtils.isEmpty((CharSequence)sTemporaryName)) {
            sTemporaryName = PreferenceUtil.getInstance().getUsername();
            sTemporaryPassword = PreferenceUtil.getInstance().getPassword();
            sTemporaryToken = PreferenceUtil.getInstance().getToken();
            if (this._client.isLoggedInBefore()) {
                String currentUser = this._client.getCurrentUser();
                if (!TextUtils.isEmpty((CharSequence)sTemporaryName) && sTemporaryName.equals(currentUser)) {
                    sTemporaryToken = this._client.getOptions().getAccessToken();
                }
            }
        }
        ChatClient.getInstance().logout(false, callback);
    }

    public synchronized boolean init(final Context context, final Options options, EMOptions emoptions) {
        if (this.isInitialized) {
            android.util.Log.e((String)TAG, (String)"sdk already initialized");
            try {
                AgoraMessage.asyncGetTenantIdFunctionIcons(options.tenantId);
            }
            catch (Exception e) {
                e.printStackTrace();
                android.util.Log.e((String)TAG, (String)"init asyncGetTenantIdFunctionIcons error");
            }
            return false;
        }
        if (context == null) {
            android.util.Log.e((String)TAG, (String)"init fail, context is null");
            return false;
        }
        if (options == null) {
            android.util.Log.e((String)TAG, (String)"init fail, options is null");
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)options.appkey)) {
            android.util.Log.e((String)TAG, (String)"init fail, appkey is null");
            return false;
        }
        this.mOptions = options;
        this.imServiceUser = options.imServiceUser;
        this.useIm = options.useIm;
        String processAppName = ProcessUtils.getCurrentProcessName();
        this.kefuHost = options.kefuHost;
        android.util.Log.d((String)TAG, (String)("process app name : " + processAppName));
        if (processAppName == null || !processAppName.equalsIgnoreCase(context.getPackageName())) {
            android.util.Log.e((String)TAG, (String)"enter the service process!");
            return false;
        }
        this._client = EMClient.getInstance();
        emoptions.setAppKey(options.appkey);
        if (!TextUtils.isEmpty((CharSequence)options.restHost)) {
            emoptions.setRestServer(options.restHost);
        }
        if (!TextUtils.isEmpty((CharSequence)options.imHost)) {
            emoptions.setIMServer(options.imHost);
        }
        if (options.imPort > 0) {
            emoptions.setImPort(options.imPort);
        }
        this.tenantId = options.tenantId;
        this.configId = options.configId;
        this.isShowAgentInputState = options.showAgentInputState;
        this.isShowVisitorWaitCount = options.showVisitorWaitCount;
        this.isShowMessagePredict = options.showMessagePredict;
        this.isDebugMode = options.consoleLogEnable;
        long currentTime = System.currentTimeMillis();
        PreferenceUtil.getInstance().init(context);
        CountDownUtils.getInstance().init(context);
        if (options.pushConfig != null) {
            emoptions.setPushConfig(options.pushConfig);
        }
        emoptions.setAutoLogin(false);
        if (!TextUtils.isEmpty((CharSequence)options.getDnsUrl())) {
            String dnsUrl = options.getDnsUrl();
            dnsUrl = dnsUrl.concat("?app_key=" + URLEncoder.encode(options.appkey));
            emoptions.setDnsUrl(dnsUrl);
        }
        this._client.init(context, emoptions);
        EMLog.d(TAG, "im init time(ms):" + (System.currentTimeMillis() - currentTime));
        this.chatManager = ChatManager.getInstance();
        this.vecChatManager = VecChatManager.getInstance();
        try {
            if (Class.forName("com.hyphenate.chat.CallManager") != null) {
                this.callManager = CallManager.getInstance();
            }
        }
        catch (ClassNotFoundException e) {
            EMLog.d(TAG, "" + android.util.Log.getStackTraceString((Throwable)e));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            AgoraMessage.asyncGetTenantIdFunctionIcons(this.tenantId);
        }
        catch (Exception e) {
            e.printStackTrace();
            android.util.Log.e((String)TAG, (String)"init asyncGetTenantIdFunctionIcons error");
        }
        try {
            this.chatManager.asyncGetReportTimer();
        }
        catch (Exception e) {
            e.printStackTrace();
            android.util.Log.e((String)TAG, (String)"init asyncGetReportTimer error");
        }
        ChatConfig.getInstance().loadLocalDnsConfig();
        EMLog.d(TAG, "loadLocalDnsConfig finished");
        this.initNameAndPasswordToLogout(options);
        String username = sTemporaryName;
        username = TextUtils.isEmpty((CharSequence)username) ? "" : username;
        this.mNeedLoginCallback = options.mINeedLoginCallback;
        MarketingHttpClient.asyncGetLoginFlag(username, this.tenantId, new ValueCallBack<Boolean>(){

            @Override
            public void onSuccess(final Boolean value) {
                ChatClient.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        ChatClient.this.starInitDemo(context, options, value, ChatClient.this.mNeedLoginCallback);
                    }
                });
            }

            @Override
            public void onError(int error, String errorMsg) {
                ChatClient.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        ChatClient.this.starInitDemo(context, options, false, ChatClient.this.mNeedLoginCallback);
                    }
                });
            }
        });
        ChatConfig.getInstance().loadDnsConfigFromRemote(false);
        this._client.addConnectionListener(new EMConnectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onConnected() {
                Log.e(ChatClient.TAG, "init addConnectionListener onConnected");
                List list = ChatClient.this.connectionListeners;
                synchronized (list) {
                    for (ConnectionListener listener : ChatClient.this.connectionListeners) {
                        if (listener == null) continue;
                        listener.onConnected();
                    }
                    PreferenceUtil.getInstance().setToken(EMClient.getInstance().getAccessToken());
                    MarketingHttpClient.asyncRequest();
                }
            }

            @Override
            public void onDisconnected(int errorCode) {
                int code = 1;
                Log.e(ChatClient.TAG, "init addConnectionListener onDisconnected = " + errorCode);
                switch (errorCode) {
                    case 207: {
                        code = 207;
                        ChatClient.this.chatManager().kefuLogout();
                        break;
                    }
                    case 200: {
                        code = 200;
                        break;
                    }
                    case 206: {
                        code = 206;
                        ChatClient.this.chatManager().kefuLogout();
                        break;
                    }
                    case 202: {
                        code = 202;
                        ChatClient.this.chatManager().kefuLogout();
                        break;
                    }
                    case 204: {
                        code = 204;
                        ChatClient.this.chatManager().kefuLogout();
                        break;
                    }
                }
                ChatClient.this.notifyOnDisconnected(code);
            }
        });
        this.leaveMsgManager = TicketManager.getInstance();
        this.isInitialized = true;
        EMClient.getInstance().setDebugMode(options.consoleLogEnable);
        return true;
    }

    void initUserData(Context context, Options options, String userName) {
        PathUtil.getInstance().initDirs(options.appkey, userName, context);
        ChatManager.getInstance().initDB(userName);
        ChatManager.getInstance().loadDB();
        this.userDataInited = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyOnDisconnected(int errorCode) {
        List<ConnectionListener> list = this.connectionListeners;
        synchronized (list) {
            for (ConnectionListener listener : this.connectionListeners) {
                if (listener == null) continue;
                listener.onDisconnected(errorCode);
            }
        }
    }

    private void getEmojiconManager() {
        if (this.emojiconManager == null) {
            this.emojiconManager = EmojiconManager.getInstance();
        }
        this.emojiconManager.reflesh();
    }

    public boolean addEmojiconInfo(String tenantId, String iconsJson, String packagesJson) {
        if (KefuDBManager.getInstance() == null) {
            return false;
        }
        return KefuDBManager.getInstance().addEmojiconInfo(tenantId, iconsJson, packagesJson);
    }

    public boolean deleteEmojiconInfo(String tenantId) {
        if (KefuDBManager.getInstance() == null) {
            return false;
        }
        return KefuDBManager.getInstance().deleteEmojiconInfo(tenantId);
    }

    public String getEmojiconInfoIconsJson(String tenantId) {
        if (KefuDBManager.getInstance() == null) {
            return "";
        }
        return KefuDBManager.getInstance().getEmojiconInfoIconsJson(tenantId);
    }

    public String getEmojiconInfoPackagesJson(String tenantId) {
        if (KefuDBManager.getInstance() == null) {
            return "";
        }
        return KefuDBManager.getInstance().getEmojiconInfoPackagesJson(tenantId);
    }

    private String getAppName(Context appContext) {
        try {
            int pid = Process.myPid();
            String processName = null;
            ActivityManager am = (ActivityManager)appContext.getSystemService("activity");
            assert (am != null);
            List l = am.getRunningAppProcesses();
            if (l == null) {
                android.util.Log.e((String)TAG, (String)"getRunningAppProcesses is null");
                return null;
            }
            Iterator i = l.iterator();
            PackageManager pm = appContext.getPackageManager();
            while (i.hasNext()) {
                ActivityManager.RunningAppProcessInfo info = (ActivityManager.RunningAppProcessInfo)i.next();
                try {
                    if (info.pid != pid) continue;
                    processName = info.processName;
                    return processName;
                }
                catch (Exception exception) {
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public void login(String userName, String password, final Callback callback) {
        if (!this.userDataInited) {
            this.initUserData(this.getContext(), this.mOptions, userName);
        }
        this.chatManager().login(userName, password, new Callback(){

            @Override
            public void onSuccess() {
                try {
                    SdkReport.getSdkReport().loginReport();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ChatClient.this.getEmojiconManager();
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            @Override
            public void onError(int code, String error) {
                if (callback != null) {
                    callback.onError(code, error);
                }
            }

            @Override
            public void onProgress(int progress, String status) {
                if (callback != null) {
                    callback.onProgress(progress, status);
                }
            }
        });
    }

    public void loginWithToken(String userName, String token, final Callback callback) {
        if (!this.userDataInited) {
            this.initUserData(this.getContext(), this.mOptions, userName);
        }
        this.chatManager().loginWithToken(userName, token, new Callback(){

            @Override
            public void onSuccess() {
                try {
                    SdkReport.getSdkReport().loginReport();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ChatClient.this.getEmojiconManager();
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            @Override
            public void onError(int code, String error) {
                if (callback != null) {
                    callback.onError(code, error);
                }
            }

            @Override
            public void onProgress(int progress, String status) {
                if (callback != null) {
                    callback.onProgress(progress, status);
                }
            }
        });
    }

    public void logout(boolean unbindToken, Callback callback) {
        this.chatManager().logout(unbindToken, callback);
    }

    void cleanCache() {
        CountDownUtils.getInstance().cancel();
        this.emojiconManager().clear();
        this.userName = null;
        this.userDataInited = false;
        EMLog.d(TAG, "logout and remove all cache");
        PreferenceUtil.getInstance().removeAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loginWithTokenFail() {
        PreferenceUtil.getInstance().removeAll();
        List<ConnectionListener> list = this.connectionListeners;
        synchronized (list) {
            for (ConnectionListener listener : this.connectionListeners) {
                if (listener == null) continue;
                listener.onDisconnected(202);
            }
        }
    }

    public boolean isLoggedInBefore() {
        if (this._client == null) {
            EMLog.e(TAG, "please first init");
            return false;
        }
        boolean isLogged = this._client.isLoggedInBefore();
        if (this.isCountDownDisconnect() && !isLogged) {
            String username = PreferenceUtil.getInstance().getUsername();
            String password = PreferenceUtil.getInstance().getPassword();
            String token = PreferenceUtil.getInstance().getToken();
            boolean isTokenLogin = PreferenceUtil.getInstance().loginWithToken();
            if (!TextUtils.isEmpty((CharSequence)username)) {
                if (isTokenLogin) {
                    if (!TextUtils.isEmpty((CharSequence)token)) {
                        isLogged = true;
                    }
                } else if (!TextUtils.isEmpty((CharSequence)password)) {
                    isLogged = true;
                }
            }
        }
        EMLog.d(TAG, "isLoggedIn:" + isLogged);
        return isLogged;
    }

    public void sendFCMTokenToServer(String token) {
        EMClient.getInstance().sendFCMTokenToServer(token);
    }

    @Deprecated
    public boolean isConnected() {
        return this._client != null && this._client.isConnected();
    }

    public boolean setPushNickname(String userNick) {
        try {
            return EMClient.getInstance().pushManager().updatePushNickname(userNick);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Deprecated
    public boolean updateNickToServer(String userNick) {
        return this.setPushNickname(userNick);
    }

    public void register(final String userName, final String password, final Callback callback) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                block7: {
                    try {
                        ChatClient.this._client.createAccount(userName, password);
                        if (callback != null) {
                            callback.onSuccess();
                        }
                    }
                    catch (HyphenateException ex) {
                        int errorCode = ex.getErrorCode();
                        EMLog.e(ChatClient.TAG, "error:" + errorCode + ", errorMsg:" + ex.getMessage());
                        Log.e(ChatClient.TAG, "error:" + errorCode + ", errorMsg:" + ex.getMessage());
                        if (callback == null) break block7;
                        if (errorCode == 203) {
                            callback.onError(203, "user already exist");
                        }
                        if (errorCode == 2) {
                            callback.onError(2, "network is not available");
                        }
                        if (errorCode == 202) {
                            callback.onError(202, "register fail without permission");
                        }
                        if (errorCode == 205) {
                            callback.onError(205, "illegal user name");
                        }
                        callback.onError(1, "general error");
                    }
                }
            }
        });
        thread.start();
    }

    @Deprecated
    public void createAccount(String userName, String password, Callback callback) {
        this.register(userName, password, callback);
    }

    @Deprecated
    public ChatManager getChat() {
        return this.chatManager();
    }

    public CallManager callManager() {
        return this.callManager;
    }

    public ChatManager chatManager() {
        return this.chatManager;
    }

    public VecChatManager vecChatManager() {
        return this.vecChatManager;
    }

    public TicketManager leaveMsgManager() {
        return this.leaveMsgManager;
    }

    public EmojiconManager emojiconManager() {
        if (this.emojiconManager == null) {
            this.emojiconManager = EmojiconManager.getInstance();
        }
        return this.emojiconManager;
    }

    public String currentUserName() {
        if (TextUtils.isEmpty((CharSequence)this.userName)) {
            if (this._client.isLoggedInBefore()) {
                this.userName = this._client.getCurrentUser();
            } else if (this.isCountDownDisconnect()) {
                this.userName = PreferenceUtil.getInstance().getUsername();
            }
        }
        return this.userName;
    }

    @Deprecated
    public String getCurrentUserName() {
        return this.currentUserName();
    }

    public void changeAppKey(String appKey) throws HyphenateException {
        EMClient.getInstance().changeAppkey(appKey);
    }

    public void changeTenantId(String newTenantId) {
        if (newTenantId == null) {
            EMLog.e(TAG, "tenant id is set null");
            return;
        }
        if (!TextUtils.isDigitsOnly((CharSequence)newTenantId)) {
            throw new IllegalArgumentException("tenantid is digit");
        }
        if (this.tenantId == null || !this.tenantId.equals(newTenantId)) {
            this.tenantId = newTenantId;
            ChatConfig.getInstance().loadDnsConfigFromRemote(true);
        }
    }

    public void changeConfigId(String configId) {
        this.configId = configId;
    }

    public String getConfigId() {
        return this.configId;
    }

    @Deprecated
    public void setTenantId(String newTenantId) {
        this.changeTenantId(newTenantId);
    }

    public String tenantId() {
        return this.tenantId;
    }

    @Deprecated
    public String getTenantId() {
        return this.tenantId();
    }

    public String accessToken() {
        if (this._client != null) {
            String token = PreferenceUtil.getInstance().getToken();
            return token;
        }
        return null;
    }

    public String imAccessToken() {
        if (this._client.isLoggedInBefore()) {
            return this._client.getOptions().getAccessToken();
        }
        return null;
    }

    @Deprecated
    public String getAccessToken() {
        return this.accessToken();
    }

    public String sdkVersion() {
        return sdkVersion;
    }

    @Deprecated
    public String getSDKVersion() {
        return this.sdkVersion();
    }

    public String iMSdkVersion() {
        if (this._client != null) {
            return this._client.getOptions().getVersion();
        }
        return "";
    }

    @Deprecated
    public String getIMSDKVersion() {
        return this.iMSdkVersion();
    }

    public String appKey() {
        if (this._client != null) {
            return this._client.getOptions().getAppKey();
        }
        return null;
    }

    @Deprecated
    public String getAppKey() {
        return this.appKey();
    }

    @Deprecated
    public void setDebugMode(boolean paramBoolean) {
        this.isDebugMode = paramBoolean;
        EMClient.getInstance().setDebugMode(paramBoolean);
    }

    boolean isDebugMode() {
        return this.isDebugMode;
    }

    public void addConnectionListener(ConnectionListener listener) {
        if (listener == null) {
            return;
        }
        if (!this.connectionListeners.contains(listener)) {
            this.connectionListeners.add(listener);
        }
    }

    public void removeConnectionListener(ConnectionListener listener) {
        if (listener == null) {
            return;
        }
        if (this.connectionListeners.contains(listener)) {
            this.connectionListeners.remove(listener);
        }
    }

    public long getReportTimer() {
        return this.mReportTimer;
    }

    void setReportTimer(long reportTimer) {
        this.mReportTimer = reportTimer;
    }

    boolean getSdkReport() {
        return this.mIsSdkReport;
    }

    void setSdkReport(boolean isSdkReport) {
        this.mIsSdkReport = isSdkReport;
    }

    public void sendHMSPushTokenToServer(String token) {
        EMClient.getInstance().sendHMSPushTokenToServer(token);
    }

    private void starInit(Context context, Options options, EMOptions emoptions, long currentTime, boolean isAutoLogin, INeedLoginCallback callback) {
        emoptions.setAutoLogin(false);
        this._client.init(context, emoptions);
        EMLog.d(TAG, "im init time(ms):" + (System.currentTimeMillis() - currentTime));
        this.chatManager = ChatManager.getInstance();
        this.vecChatManager = VecChatManager.getInstance();
        try {
            if (Class.forName("com.hyphenate.chat.CallManager") != null) {
                this.callManager = CallManager.getInstance();
            }
        }
        catch (ClassNotFoundException e) {
            EMLog.d(TAG, "" + android.util.Log.getStackTraceString((Throwable)e));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            AgoraMessage.asyncGetTenantIdFunctionIcons(this.tenantId);
        }
        catch (Exception e) {
            e.printStackTrace();
            EMLog.e(TAG, "init asyncGetTenantIdFunctionIcons error");
        }
        try {
            this.chatManager.asyncGetReportTimer();
        }
        catch (Exception e) {
            e.printStackTrace();
            EMLog.e(TAG, "init asyncGetReportTimer error");
        }
        ChatConfig.getInstance().loadLocalDnsConfig();
        EMLog.e(TAG, "loadLocalDnsConfig finished");
        Log.e("pppppppppppp", "isLoggedIn = " + this._client.isLoggedIn());
        Log.e("pppppppppppp", "isConnected = " + this._client.isConnected());
        Log.e("pppppppppppp", "isAutoLogin = " + isAutoLogin);
        Log.e("pppppppppppp", "isLoggedInBefore() = " + this.isLoggedInBefore());
        Log.e("pppppppppppp", "_client.isLoggedInBefore() = " + this._client.isLoggedInBefore());
        Log.e("pppppppppppp", "lastLoginUser = " + this.currentUserName());
        Log.e("pppppppppppp", "_client.lastLoginUser = " + this._client.getCurrentUser());
        EMLog.e(TAG, "init isAutoLogin = " + isAutoLogin);
        ChatConfig.getInstance().loadDnsConfigFromRemote(false);
        this._client.addConnectionListener(new EMConnectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onConnected() {
                EMLog.e(ChatClient.TAG, "init addConnectionListener onConnected");
                List list = ChatClient.this.connectionListeners;
                synchronized (list) {
                    for (ConnectionListener listener : ChatClient.this.connectionListeners) {
                        if (listener == null) continue;
                        listener.onConnected();
                    }
                    PreferenceUtil.getInstance().setToken(EMClient.getInstance().getAccessToken());
                    MarketingHttpClient.asyncRequest();
                }
            }

            @Override
            public void onDisconnected(int errorCode) {
                int code = 1;
                Log.e(ChatClient.TAG, "init addConnectionListener onDisconnected = " + errorCode);
                switch (errorCode) {
                    case 207: {
                        code = 207;
                        ChatClient.this.chatManager().kefuLogout();
                        break;
                    }
                    case 200: {
                        code = 200;
                        break;
                    }
                    case 206: {
                        code = 206;
                        ChatClient.this.chatManager().kefuLogout();
                        break;
                    }
                    case 202: {
                        code = 202;
                        ChatClient.this.chatManager().kefuLogout();
                        break;
                    }
                    case 204: {
                        code = 204;
                        ChatClient.this.chatManager().kefuLogout();
                        break;
                    }
                }
                ChatClient.this.notifyOnDisconnected(code);
            }
        });
        this.leaveMsgManager = TicketManager.getInstance();
        this.isInitialized = true;
        EMClient.getInstance().setDebugMode(options.consoleLogEnable);
        EMLog.e(TAG, "init initSuccess");
    }

    private void starInitDemo(Context context, Options options, boolean isAutoLogin, INeedLoginCallback callback) {
        EMLog.e(TAG, "init  _client.isLoggedIn = " + this._client.isLoggedIn());
        EMLog.e(TAG, "init  _client.isConnected = " + this._client.isConnected());
        EMLog.e(TAG, "init isLoggedInBefore() = " + this.isLoggedInBefore());
        EMLog.e(TAG, "init _client.isLoggedInBefore() = " + this._client.isLoggedInBefore());
        EMLog.e(TAG, "init lastLoginUser = " + this.currentUserName());
        EMLog.e(TAG, "init _client.getCurrentUser = " + this._client.getCurrentUser());
        EMLog.e(TAG, "init sTemporaryName = " + sTemporaryName);
        EMLog.e(TAG, "init sTemporaryPassword = " + sTemporaryPassword);
        EMLog.e(TAG, "init sTemporaryToken = " + sTemporaryToken);
        EMLog.e(TAG, "init isAutoLogin = " + isAutoLogin);
        if (isAutoLogin) {
            EMLog.e(TAG, "init isLoggedInBefore = " + this.isLoggedInBefore());
            if (!TextUtils.isEmpty((CharSequence)sTemporaryName)) {
                EMLog.e(TAG, "init lastLoginUser = " + sTemporaryName);
                this.initUserData(context, options, sTemporaryName);
                try {
                    if (!TextUtils.isEmpty((CharSequence)sTemporaryPassword)) {
                        EMLog.e(TAG, "init autoLogin login");
                        ChatClient.getInstance().login(sTemporaryName, sTemporaryPassword, new ILoginCallback(sTemporaryName, callback, this.mISdkInitCallback));
                    } else if (!TextUtils.isEmpty((CharSequence)sTemporaryToken)) {
                        EMLog.e(TAG, "init autoLogin login");
                        ChatClient.getInstance().loginWithToken(sTemporaryName, sTemporaryToken, new ILoginCallback(sTemporaryName, callback, this.mISdkInitCallback));
                    } else {
                        this.visitorInfoLogin(callback);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.visitorInfoLogin(callback);
                    EMLog.e(TAG, "init isAutoLogin = true, error = " + android.util.Log.getStackTraceString((Throwable)e));
                }
                this.chatManager().registerCountDown();
                long triggerEventTime = PreferenceUtil.getInstance().getTriggerEventTime();
                if (triggerEventTime > 0L) {
                    CountDownUtils.getInstance().sendBroadcast(triggerEventTime);
                } else {
                    CountDownUtils.getInstance().sendBroadcast();
                }
                this.getEmojiconManager();
            } else {
                String loginUserName = PreferenceUtil.getInstance().getUsername();
                EMLog.e(TAG, "init autoLogin \u672c\u5730\u7528\u6237\u540d loginUserName = " + loginUserName);
                if (TextUtils.isEmpty((CharSequence)loginUserName)) {
                    if (this.mISdkInitCallback != null) {
                        this.mISdkInitCallback.init(true, "");
                    }
                    if (callback != null) {
                        callback.autoLoginCompleted(false);
                    }
                } else {
                    String loginPassword = PreferenceUtil.getInstance().getPassword();
                    String loginToken = PreferenceUtil.getInstance().getToken();
                    if (!TextUtils.isEmpty((CharSequence)loginPassword)) {
                        EMLog.e(TAG, "init autoLogin \u672c\u5730\u7528\u6237\u540d autoLogin = " + loginUserName);
                        this.autoLogin(context, options, loginUserName, loginPassword, loginToken, true, callback);
                    } else if (!TextUtils.isEmpty((CharSequence)loginToken)) {
                        EMLog.e(TAG, "init autoLogin \u672c\u5730\u7528\u6237\u540d autoLogin = " + loginUserName);
                        this.autoLogin(context, options, loginUserName, loginPassword, loginToken, false, callback);
                    } else {
                        EMLog.e(TAG, "init autoLogin \u672c\u5730\u7528\u6237\u540d needLogin");
                        if (this.mISdkInitCallback != null) {
                            this.mISdkInitCallback.init(true, "");
                        }
                        if (callback != null) {
                            callback.autoLoginCompleted(false);
                        }
                    }
                }
            }
        } else {
            if (this.mISdkInitCallback != null) {
                this.mISdkInitCallback.init(true, "");
            }
            if (callback != null) {
                callback.autoLoginCompleted(false);
            }
        }
        sTemporaryName = null;
        sTemporaryPassword = null;
        sTemporaryToken = null;
    }

    private void login_Password(final String name, final String password, final INeedLoginCallback callback) {
        ChatClient.getInstance().logout(false, new Callback(){

            @Override
            public void onSuccess() {
                ChatClient.getInstance().login(name, password, new ILoginCallback(name, callback, ChatClient.this.mISdkInitCallback));
            }

            @Override
            public void onError(int code, String error) {
                ChatClient.getInstance().login(name, password, new ILoginCallback(name, callback, ChatClient.this.mISdkInitCallback));
            }

            @Override
            public void onProgress(int progress, String status) {
            }
        });
    }

    private void login_Token(final String name, final String token, final INeedLoginCallback callback) {
        ChatClient.getInstance().logout(false, new Callback(){

            @Override
            public void onSuccess() {
                ChatClient.getInstance().loginWithToken(name, token, new ILoginCallback(name, callback, ChatClient.this.mISdkInitCallback));
            }

            @Override
            public void onError(int code, String error) {
                ChatClient.getInstance().loginWithToken(name, token, new ILoginCallback(name, callback, ChatClient.this.mISdkInitCallback));
            }

            @Override
            public void onProgress(int progress, String status) {
            }
        });
    }

    private void visitorInfoLogin(INeedLoginCallback callback) {
        String loginUserName = PreferenceUtil.getInstance().getUsername();
        EMLog.e(TAG, "init \u7528\u6237\u540d\u6216\u5bc6\u7801\u5931\u8d25\u91c7\u7528visitorInfo\u767b\u5f55 autoLogin visitorInfo != null loginUserName = " + loginUserName);
        if (TextUtils.isEmpty((CharSequence)loginUserName)) {
            if (this.mISdkInitCallback != null) {
                this.mISdkInitCallback.init(true, "");
            }
            if (callback != null) {
                callback.autoLoginCompleted(false);
            }
        } else {
            String loginPassword = PreferenceUtil.getInstance().getPassword();
            String loginToken = PreferenceUtil.getInstance().getToken();
            if (!TextUtils.isEmpty((CharSequence)loginPassword)) {
                EMLog.e(TAG, "init \u7528\u6237\u540d\u6216\u5bc6\u7801\u5931\u8d25\u91c7\u7528visitorInfo\u767b\u5f55 autoLogin visitorInfo != null autoLogin = " + loginUserName);
                ChatClient.getInstance().login(loginUserName, loginPassword, new ILoginCallback(loginUserName, callback, this.mISdkInitCallback));
            } else if (!TextUtils.isEmpty((CharSequence)loginToken)) {
                EMLog.e(TAG, "init \u7528\u6237\u540d\u6216\u5bc6\u7801\u5931\u8d25\u91c7\u7528visitorInfo\u767b\u5f55 autoLogin visitorInfo != null autoLogin = " + loginUserName);
                ChatClient.getInstance().loginWithToken(loginUserName, loginToken, new ILoginCallback(loginUserName, callback, this.mISdkInitCallback));
            } else {
                EMLog.e(TAG, "init \u7528\u6237\u540d\u6216\u5bc6\u7801\u5931\u8d25\u91c7\u7528visitorInfo\u767b\u5f55 autoLogin visitorInfo != null needLogin");
                if (this.mISdkInitCallback != null) {
                    this.mISdkInitCallback.init(true, "");
                }
                if (callback != null) {
                    callback.autoLoginCompleted(false);
                }
            }
        }
    }

    private void autoLogin(Context context, Options options, String loginUserName, String loginPassword, String loginToken, boolean isPasswordLogin, INeedLoginCallback callback) {
        block6: {
            try {
                this.initUserData(context, options, loginUserName);
                if (isPasswordLogin) {
                    ChatClient.getInstance().login(loginUserName, loginPassword, new ILoginCallback(loginUserName, callback, this.mISdkInitCallback));
                } else {
                    ChatClient.getInstance().loginWithToken(loginUserName, loginToken, new ILoginCallback(loginUserName, callback, this.mISdkInitCallback));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                EMLog.e(TAG, android.util.Log.getStackTraceString((Throwable)e));
                if (this.mISdkInitCallback == null) break block6;
                this.mISdkInitCallback.init(true, "");
            }
        }
        this.chatManager().registerCountDown();
        long triggerEventTime = PreferenceUtil.getInstance().getTriggerEventTime();
        if (triggerEventTime > 0L) {
            CountDownUtils.getInstance().sendBroadcast(triggerEventTime);
        } else {
            CountDownUtils.getInstance().sendBroadcast();
        }
        this.getEmojiconManager();
    }

    public static class Options {
        private INeedLoginCallback mINeedLoginCallback;
        private VisitorInfo mVisitorInfo;
        private String appkey = "";
        private String configId = "";
        private String tenantId = "";
        private String mipushAppid = "";
        private String mipushAppKey = "";
        private String kefuHost = "https://kefu.sh.absoloop.com";
        private String fcmNumber;
        private boolean showAgentInputState;
        private boolean showVisitorWaitCount;
        private boolean showMessagePredict;
        private String restHost;
        private String imHost;
        private int imPort = -1;
        private boolean consoleLogEnable = false;
        private String mediaHost;
        private String mediaSpecilServer;
        private boolean isUseFcm;
        private EMPushConfig pushConfig;
        private boolean isAutoLogin = true;
        private boolean use2channel = false;
        private String appVersion;
        private Boolean isUseHttps = false;
        private String dns_url;
        private boolean useIm;
        private String imServiceUser;

        public void setNeedLoginCallback(INeedLoginCallback INeedLoginCallback2) {
            this.mINeedLoginCallback = INeedLoginCallback2;
        }

        public void setVisitorInfo(VisitorInfo visitorInfo) {
            this.mVisitorInfo = visitorInfo;
        }

        public VisitorInfo getVisitorInfo() {
            return this.mVisitorInfo;
        }

        public Options setImServiceId(String imServiceId) {
            this.imServiceUser = imServiceId;
            return this;
        }

        public Options setUseIm(boolean useIm) {
            this.useIm = useIm;
            return this;
        }

        public Options setDnsUrl(String dnsUrl) {
            this.dns_url = dnsUrl;
            return this;
        }

        public String getDnsUrl() {
            return this.dns_url;
        }

        public Options setUsingHttpsOnly(boolean isUseHttps) {
            this.isUseHttps = isUseHttps;
            return this;
        }

        public Boolean getUseHttps() {
            return this.isUseHttps;
        }

        public Options setPushConfig(EMPushConfig pushConfig) {
            this.pushConfig = pushConfig;
            return this;
        }

        public Options setAppkey(String appkey) {
            this.appkey = appkey;
            return this;
        }

        public Options setConfigId(String configId) {
            this.configId = configId;
            return this;
        }

        public Options setTenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Deprecated
        public Options setMipushConfig(String mipushAppid, String mipushAppKey) {
            this.mipushAppid = mipushAppid;
            this.mipushAppKey = mipushAppKey;
            return this;
        }

        public Options setMediaServer(String mediaHost, String mediaSpecilServer) {
            this.mediaHost = mediaHost;
            this.mediaSpecilServer = mediaSpecilServer;
            return this;
        }

        @Deprecated
        public Options setFCMNumber(String fcmNumber) {
            this.fcmNumber = fcmNumber;
            return this;
        }

        @Deprecated
        public Options setUseFCM(boolean isUseFcm) {
            this.isUseFcm = isUseFcm;
            return this;
        }

        public Options showAgentInputState() {
            this.showAgentInputState = true;
            return this;
        }

        public Options showVisitorWaitCount() {
            this.showVisitorWaitCount = true;
            return this;
        }

        public Options showMessagePredict() {
            this.showMessagePredict = true;
            return this;
        }

        public Options setKefuRestServer(String restServer) {
            this.kefuHost = !restServer.contains("http") ? "http://" + restServer : restServer;
            EMLog.d(ChatClient.TAG, "set kefu host:" + this.kefuHost);
            return this;
        }

        @Deprecated
        public Options setKefuServerAddress(String restServer) {
            return this.setKefuRestServer(restServer);
        }

        public Options setRestServer(String restServer) {
            this.restHost = restServer;
            return this;
        }

        public Options setChatServer(String imServer) {
            this.imHost = imServer;
            return this;
        }

        @Deprecated
        public Options setIMServer(String imServer) {
            return this.setChatServer(imServer);
        }

        public Options setChatPort(int imPort) {
            this.imPort = imPort;
            return this;
        }

        @Deprecated
        public Options setIMPort(int imPort) {
            return this.setChatPort(imPort);
        }

        public Options setConsoleLog(boolean enable) {
            this.consoleLogEnable = enable;
            return this;
        }

        public String getAppVersion() {
            return this.appVersion;
        }

        public void setAppVersion(String appVersion) {
            this.appVersion = appVersion;
        }

        public boolean isUse2channel() {
            return this.use2channel;
        }

        public void setUse2channel(boolean use2channel) {
            this.use2channel = use2channel;
        }
    }

    public static interface ConnectionListener {
        public void onConnected();

        public void onDisconnected(int var1);
    }
}

