/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.text.TextUtils;
import com.hyphenate.chat.ChatManager;
import com.hyphenate.chat.ConversationInfo;
import com.hyphenate.chat.KefuConversationManager;
import com.hyphenate.chat.KefuDBManager;
import com.hyphenate.chat.MarketingHttpClient;
import com.hyphenate.chat.Message;
import com.hyphenate.chat.OfficialAccount;
import com.hyphenate.util.EMLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONObject;

public class Conversation {
    private static final String TAG = "conversation";
    List<Message> messages;
    private int unreadMsgCount = 0;
    private String conversationId;
    private OfficialAccount mOfficialAccount;
    private String mMarketings;
    private ConversationInfo conversationInfo;
    private long msgCount = 0L;

    public Conversation(String conversationId) {
        this.conversationId = conversationId;
        if (this.messages == null) {
            this.messages = Collections.synchronizedList(new ArrayList());
        }
        if (this.unreadMsgCount <= 0) {
            this.unreadMsgCount = KefuDBManager.getInstance().getConversationUnreadCount(conversationId);
        }
    }

    Conversation(String conversationId, List<Message> msgList, long msgCount) {
        this.conversationId = conversationId;
        if (this.messages == null) {
            this.messages = Collections.synchronizedList(msgList);
        }
        if (this.unreadMsgCount <= 0) {
            this.unreadMsgCount = KefuDBManager.getInstance().getConversationUnreadCount(conversationId);
        }
        this.msgCount = msgCount;
    }

    void setOfficialAccount(OfficialAccount officialAccount) {
        this.mOfficialAccount = officialAccount;
    }

    void clearOfficialAccount() {
        this.mOfficialAccount = null;
    }

    void setOfficialAccount(String strOfficialAccount) {
        if (strOfficialAccount == null) {
            this.mOfficialAccount = null;
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(strOfficialAccount);
            OfficialAccount officialAccount = null;
            if (jsonObject.has("official_account_id")) {
                String id = jsonObject.getString("official_account_id");
                officialAccount = new OfficialAccount();
                officialAccount.setId(id);
            }
            if (jsonObject.has("type")) {
                String type = jsonObject.getString("type");
                assert (officialAccount != null);
                officialAccount.setType(type);
            }
            if (jsonObject.has("name")) {
                String name = jsonObject.getString("name");
                assert (officialAccount != null);
                officialAccount.setName(name);
            }
            if (jsonObject.has("img")) {
                assert (officialAccount != null);
                officialAccount.setImg(jsonObject.getString("img"));
            }
            this.mOfficialAccount = officialAccount;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.mOfficialAccount = null;
        }
    }

    void setConversationInfo(ConversationInfo info) {
        this.conversationInfo = info;
    }

    ConversationInfo getConversationInfo() {
        return this.conversationInfo;
    }

    void setMarketings(String marketings) {
        this.mMarketings = marketings;
    }

    String getMarketings() {
        return this.mMarketings;
    }

    public OfficialAccount officialAccount() {
        return this.mOfficialAccount;
    }

    @Deprecated
    public OfficialAccount getOfficialAccount() {
        return this.officialAccount();
    }

    public String conversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conId) {
        this.conversationId = conId;
    }

    public void addMessage(Message message) {
        this.addMessage(message, true);
    }

    void addMessage(Message message, boolean unreadCountIncrease) {
        if (this.messages.size() > 0) {
            Message previousMsg = this.messages.get(this.messages.size() - 1);
            if (message.messageId() != null && previousMsg.messageId() != null && message.messageId().equals(previousMsg.messageId())) {
                return;
            }
        }
        if (KefuConversationManager.getInstance().isRecalledMessage(message.messageId())) {
            return;
        }
        boolean isAdded = false;
        for (Message msg : this.messages) {
            if (!msg.messageId().equals(message.messageId())) continue;
            isAdded = true;
            break;
        }
        if (!isAdded) {
            boolean isOldMsg = false;
            if (!this.messages.isEmpty()) {
                isOldMsg = this.messages.get(this.messages.size() - 1).messageTime() - message.messageTime() > 0L;
            }
            this.messages.add(message);
            ++this.msgCount;
            if (message.direct() == Message.Direct.RECEIVE && message.isUnread() && unreadCountIncrease) {
                ++this.unreadMsgCount;
                this.saveUnreadMsgCount(this.unreadMsgCount);
            }
            if (isOldMsg) {
                Collections.sort(this.messages);
            }
        }
    }

    synchronized void saveUnreadMsgCount(final int count) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                KefuDBManager.getInstance().saveConversationUnreadCount(Conversation.this.conversationId, count);
            }
        }).start();
    }

    synchronized void deleteUnreadMsgCountRecord() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                KefuDBManager.getInstance().deleteConversationUnreadrecord(Conversation.this.conversationId);
            }
        }).start();
    }

    public synchronized int getAllMsgCount() {
        return (int)this.msgCount;
    }

    @Deprecated
    public int getUnreadMsgCount() {
        return this.unreadMessagesCount();
    }

    public void markAllMessagesAsRead() {
        this.unreadMsgCount = 0;
        this.saveUnreadMsgCount(0);
        MarketingHttpClient.asyncOpened(this.conversationId);
    }

    @Deprecated
    public int getMsgCount() {
        return this.messages.size();
    }

    public Message getMessageOfPosition(int position) {
        return this.getMessageOfPosition(position, true);
    }

    public synchronized Message getMessageOfPosition(int position, boolean markAsRead) {
        int msgSize = this.messages.size();
        if (position >= msgSize) {
            EMLog.e(TAG, "outofbound, message.size:" + msgSize);
            return null;
        }
        Message message = this.messages.get(position);
        if (markAsRead && message != null && message.isUnread()) {
            message.setUnread(false);
            if (this.unreadMsgCount > 0) {
                --this.unreadMsgCount;
                this.saveUnreadMsgCount(this.unreadMsgCount);
            }
        }
        return message;
    }

    public List<Message> loadMessages(String startMsgId, int pageSize) {
        List<Message> msgList = KefuDBManager.getInstance().findMessages(this.conversationId, startMsgId, pageSize);
        this.messages.addAll(0, msgList);
        for (Message message : msgList) {
            ChatManager.getInstance().addMessage(message, false);
        }
        return msgList;
    }

    @Deprecated
    public List<Message> loadMoreMsgFromDB(String startMsgId, int pageSize) {
        return this.loadMessages(startMsgId, pageSize);
    }

    public Message getMessage(String messageId) {
        return this.getMessage(messageId, true);
    }

    public Message getMessage(String messageId, boolean markAsRead) {
        for (int i = this.messages.size() - 1; i >= 0; --i) {
            Message msg = this.messages.get(i);
            if (!msg.messageId().equals(messageId)) continue;
            if (markAsRead && msg.isUnread()) {
                msg.setUnread(false);
                if (this.unreadMsgCount > 0) {
                    --this.unreadMsgCount;
                    this.saveUnreadMsgCount(this.unreadMsgCount);
                }
            }
            return msg;
        }
        return null;
    }

    public Message loadMessage(String msgId) {
        if (TextUtils.isEmpty((CharSequence)msgId)) {
            return null;
        }
        Message msg = this.getMessage(msgId, false);
        if (msg == null) {
            msg = KefuDBManager.getInstance().getMessage(msgId);
        }
        return msg;
    }

    public List<Message> loadMessages(List<String> msgIds) {
        if (msgIds == null) {
            return null;
        }
        ArrayList<Message> msgList = new ArrayList<Message>();
        for (String msgId : msgIds) {
            Message message = this.loadMessage(msgId);
            if (message == null) continue;
            msgList.add(message);
        }
        return msgList.size() > 0 ? msgList : null;
    }

    public void markMessageAsRead(String msgId) {
        this.getMessage(msgId);
    }

    public List<Message> getAllMessages() {
        return this.messages;
    }

    public int getMessagePosition(Message message) {
        try {
            for (Message msg : this.messages) {
                if (!message.messageId().equals(msg.messageId())) continue;
                return this.messages.indexOf(msg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    public void removeMessage(String messageId) {
        this.removeMessage(messageId, true);
    }

    public void removeMessage(String messageId, boolean deleteDB) {
        EMLog.d(TAG, "remove msg from conversation:" + messageId);
        if (messageId == null) {
            return;
        }
        for (int i = this.messages.size() - 1; i >= 0; --i) {
            Message msg = this.messages.get(i);
            if (!msg.messageId().equals(messageId)) continue;
            if (msg.isUnread()) {
                msg.setUnread(false);
                if (this.unreadMsgCount > 0) {
                    --this.unreadMsgCount;
                    this.saveUnreadMsgCount(this.unreadMsgCount);
                }
            }
            this.messages.remove(i);
            if (this.msgCount > 0L) {
                --this.msgCount;
            }
            if (deleteDB) {
                KefuDBManager.getInstance().deleteMessage(messageId);
            } else {
                KefuConversationManager.getInstance().addRecalledMessage(messageId);
            }
            KefuConversationManager.getInstance().removeMessage(messageId);
            break;
        }
    }

    public Message latestMessage() {
        if (this.messages.size() == 0) {
            return null;
        }
        return this.messages.get(this.messages.size() - 1);
    }

    @Deprecated
    public Message getLastMessage() {
        return this.latestMessage();
    }

    public void clear() {
        this.messages.clear();
        this.unreadMsgCount = 0;
        this.msgCount = 0L;
        KefuDBManager.getInstance().deleteConversationUnreadrecord(this.conversationId);
    }

    @Deprecated
    public void setExtField(String ext) {
        KefuDBManager.getInstance().setExtField(this.conversationId, ext);
    }

    @Deprecated
    public String getExtField() {
        return KefuDBManager.getInstance().getExtField(this.conversationId);
    }

    public int unreadMessagesCount() {
        if (this.unreadMsgCount < 0) {
            this.unreadMsgCount = 0;
        }
        return this.unreadMsgCount;
    }

    @Deprecated
    public int messagesCount() {
        return this.messages.size();
    }
}

