/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.text.TextUtils;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMEncryptProvider;
import com.hyphenate.util.EMLog;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class CryptoUtils {
    private static final String TAG = CryptoUtils.class.getSimpleName();
    private EMEncryptProvider mEncryptProvider;
    private static final String sKey = "123456";

    public void initAES() {
        this.mEncryptProvider = EMClient.getInstance().getEncryptProvider();
    }

    public String encryptBase64String(String tempPwd) {
        try {
            byte[] encrypt = tempPwd.getBytes("UTF-8");
            byte[] data = this.mEncryptProvider.encrypt(encrypt, "");
            return CryptoUtils.AES256Encode(data, sKey);
        }
        catch (Exception e) {
            e.printStackTrace();
            EMLog.e(TAG, "encryptBase64String error = " + e.toString());
            return null;
        }
    }

    public String decryptBase64String(String tempPwd) {
        try {
            EMLog.e(TAG, "decryptBase64String tempPwd = ***********");
            String s = CryptoUtils.AES256Decrypt(tempPwd, sKey);
            byte[] data = this.mEncryptProvider.decrypt(s.getBytes("UTF-8"), "");
            return new String(data, "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            EMLog.e(TAG, "decryptBase64String error = " + e.toString());
            return null;
        }
    }

    public static String AES256Encode(byte[] data, String keyString) throws NullPointerException {
        if (TextUtils.isEmpty((CharSequence)keyString)) {
            return null;
        }
        if (data == null) {
            return null;
        }
        try {
            SecretKeySpec skeySpec = CryptoUtils.getKey(keyString);
            byte[] iv = new byte[16];
            Arrays.fill(iv, (byte)0);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, (Key)skeySpec, ivParameterSpec);
            return CryptoUtils.bytes2Hex(cipher.doFinal(data));
        }
        catch (Exception e) {
            e.printStackTrace();
            EMLog.e(TAG, "AES256Encode error = " + e.toString());
            return null;
        }
    }

    public static String AES256Decrypt(String text, String keyString) {
        if (TextUtils.isEmpty((CharSequence)keyString)) {
            EMLog.e(TAG, "AES256Decrypt TextUtils.isEmpty(keyString) = " + keyString);
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)text)) {
            EMLog.e(TAG, "AES256Decrypt TextUtils.isEmpty(text) = " + text);
            return null;
        }
        try {
            SecretKeySpec key = CryptoUtils.getKey(keyString);
            byte[] iv = new byte[16];
            Arrays.fill(iv, (byte)0);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
            byte[] data = CryptoUtils.toByte(text);
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, (Key)key, ivParameterSpec);
            byte[] decrypedValueBytes = cipher.doFinal(data);
            return new String(decrypedValueBytes, "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            EMLog.e(TAG, "AES256Decrypt error = " + e.toString());
            return null;
        }
    }

    private static SecretKeySpec getKey(String password) throws UnsupportedEncodingException {
        int keyLength = 256;
        byte[] keyBytes = new byte[keyLength / 8];
        Arrays.fill(keyBytes, (byte)0);
        byte[] passwordBytes = CryptoUtils.toByte(password);
        int length = Math.min(passwordBytes.length, keyBytes.length);
        System.arraycopy(passwordBytes, 0, keyBytes, 0, length);
        return new SecretKeySpec(keyBytes, "AES");
    }

    public static String bytes2Hex(byte[] bts) {
        String des = "";
        String tmp = null;
        for (int i = 0; i < bts.length; ++i) {
            tmp = Integer.toHexString(bts[i] & 0xFF);
            if (tmp.length() == 1) {
                des = des + "0";
            }
            des = des + tmp;
        }
        return des;
    }

    private static byte[] toByte(String hexString) {
        int len = hexString.length() / 2;
        byte[] result = new byte[len];
        for (int i = 0; i < len; ++i) {
            result[i] = Integer.valueOf(hexString.substring(2 * i, 2 * i + 2), 16).byteValue();
        }
        return result;
    }
}

