/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.os.AsyncTask;
import com.hyphenate.chat.EMLanguage;
import com.hyphenate.chat.EMTranslateParams;
import com.hyphenate.cloud.EMHttpClient;
import com.hyphenate.cloud.HttpClientManager;
import com.hyphenate.cloud.HttpResponse;
import com.hyphenate.util.EMLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Deprecated
class EMTranslator {
    private static EMTranslateParams mParams;
    static final String mGetLanguagePath = "/languages?api-version=3.0";
    static final String mTranslatePath = "/translate?api-version=3.0";

    EMTranslator(EMTranslateParams params) {
        mParams = params;
        EMTranslator.mParams.EndPoint = EMTranslator.mParams.EndPoint.replaceAll("/$", "");
    }

    List<EMLanguage> getSupportedLanguages() {
        String string = EMTranslator.mParams.EndPoint + mGetLanguagePath;
        List<EMLanguage> list = new ArrayList<EMLanguage>();
        try {
            HttpResponse httpResponse = HttpClientManager.httpExecute(string, new HashMap<String, String>(), "", EMHttpClient.GET);
            if (httpResponse.code == 200) {
                list = this.getLanguageListFromResponse(httpResponse.content);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return list;
    }

    void translate(final String text, final String languageCode, final TranslationCallback callback) {
        new AsyncTask<String, Void, HttpResponse>(){

            protected HttpResponse doInBackground(String ... str) {
                try {
                    String string = mParams.EndPoint + EMTranslator.mTranslatePath + "&to=" + languageCode;
                    JSONArray jSONArray = new JSONArray();
                    JSONObject jSONObject = new JSONObject();
                    jSONObject.put("Text", (Object)text);
                    jSONArray.put((Object)jSONObject);
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("Ocp-Apim-Subscription-Key", mParams.SubscriptionKey);
                    hashMap.put("Content-Type", "application/json; charset=UTF-8");
                    HttpResponse httpResponse = HttpClientManager.httpExecute(string, hashMap, jSONArray.toString(), EMHttpClient.POST);
                    return httpResponse;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return null;
                }
            }

            protected void onPostExecute(HttpResponse response) {
                if (response != null) {
                    try {
                        int n = response.code;
                        if (n == 200) {
                            String string = response.content;
                            if (string != null && string.length() > 0) {
                                String string2 = EMTranslator.this.getTranslationFromResponse(string);
                                String string3 = EMTranslator.this.getTranslatedText(string2);
                                callback.onResult(string3, "");
                                return;
                            }
                        } else {
                            EMLog.d("EMTranslator", n + ":" + response.content);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                callback.onResult("", "Fail to translation");
            }
        }.execute((Object[])new String[0]);
    }

    String getTranslatedText(String translationMessage) {
        String string = "";
        try {
            JSONObject jSONObject = new JSONObject(translationMessage);
            Object object = jSONObject.getJSONArray("translations").get(0);
            if (object instanceof JSONObject) {
                string = ((JSONObject)object).getString("text");
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return string;
    }

    private String getTranslationFromResponse(String response) {
        String string = "";
        try {
            JSONArray jSONArray = new JSONArray(response);
            string = jSONArray.get(0).toString();
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return string;
    }

    private List<EMLanguage> getLanguageListFromResponse(String response) {
        ArrayList<EMLanguage> arrayList = new ArrayList<EMLanguage>();
        try {
            JSONObject jSONObject = new JSONObject(response);
            JSONObject jSONObject2 = jSONObject.getJSONObject("translation");
            Iterator iterator = jSONObject2.keys();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                JSONObject jSONObject3 = (JSONObject)jSONObject2.get(string);
                if (!(jSONObject3 instanceof JSONObject)) continue;
                EMLanguage eMLanguage = new EMLanguage();
                eMLanguage.LanguageCode = string;
                eMLanguage.LanguageName = jSONObject3.getString("name");
                eMLanguage.LanguageLocalName = jSONObject3.getString("nativeName");
                arrayList.add(eMLanguage);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    static interface TranslationCallback {
        public void onResult(String var1, String var2);
    }
}

