/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.text.TextUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class GetRealFilePathFromUri {
    public static String getFileAbsolutePath(Context context, Uri imageUri) {
        if (context == null || imageUri == null) {
            return null;
        }
        int code = Build.VERSION.SDK_INT;
        int kitkat = 19;
        if (code < kitkat) {
            return GetRealFilePathFromUri.getRealFilePath(context, imageUri);
        }
        if (code < 29 && DocumentsContract.isDocumentUri((Context)context, (Uri)imageUri)) {
            if (GetRealFilePathFromUri.isExternalStorageDocument(imageUri)) {
                String docId = DocumentsContract.getDocumentId((Uri)imageUri);
                String[] split = docId.split(":");
                String type = split[0];
                if ("primary".equalsIgnoreCase(type)) {
                    return Environment.getExternalStorageDirectory() + "/" + split[1];
                }
            } else {
                if (GetRealFilePathFromUri.isDownloadsDocument(imageUri)) {
                    String id = DocumentsContract.getDocumentId((Uri)imageUri);
                    Uri contentUri = ContentUris.withAppendedId((Uri)Uri.parse((String)"content://downloads/public_downloads"), (long)Long.parseLong(id));
                    return GetRealFilePathFromUri.getDataColumn(context, contentUri, null, null);
                }
                if (GetRealFilePathFromUri.isMediaDocument(imageUri)) {
                    String docId = DocumentsContract.getDocumentId((Uri)imageUri);
                    String[] split = docId.split(":");
                    String type = split[0];
                    Uri contentUri = "image".equals(type) ? MediaStore.Images.Media.EXTERNAL_CONTENT_URI : ("video".equals(type) ? MediaStore.Video.Media.EXTERNAL_CONTENT_URI : ("audio".equals(type) ? MediaStore.Audio.Media.EXTERNAL_CONTENT_URI : MediaStore.Files.getContentUri((String)"external")));
                    String selection = "_id=?";
                    String[] selectionArgs = new String[]{split[1]};
                    return GetRealFilePathFromUri.getDataColumn(context, contentUri, selection, selectionArgs);
                }
            }
        }
        if (code >= 29) {
            return GetRealFilePathFromUri.uriToFileApiQ(context, imageUri);
        }
        if ("content".equalsIgnoreCase(imageUri.getScheme())) {
            if (GetRealFilePathFromUri.isGooglePhotosUri(imageUri)) {
                return imageUri.getLastPathSegment();
            }
            if (Build.VERSION.SDK_INT >= 24) {
                return GetRealFilePathFromUri.getFilePathFromUri(context, imageUri);
            }
            return GetRealFilePathFromUri.getDataColumn(context, imageUri, null, null);
        }
        if ("file".equalsIgnoreCase(imageUri.getScheme())) {
            return imageUri.getPath();
        }
        return null;
    }

    private static String getRealFilePath(Context context, Uri uri) {
        if (null == uri) {
            return null;
        }
        String scheme = uri.getScheme();
        String data = null;
        if (scheme == null) {
            data = uri.getPath();
        } else if ("file".equals(scheme)) {
            data = uri.getPath();
        } else if ("content".equals(scheme)) {
            String[] projection = new String[]{"_data"};
            Cursor cursor = context.getContentResolver().query(uri, projection, null, null, null);
            if (null != cursor) {
                int index;
                if (cursor.moveToFirst() && (index = cursor.getColumnIndex("_data")) > -1) {
                    data = cursor.getString(index);
                }
                cursor.close();
            }
        }
        return data;
    }

    private static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    private static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        Cursor cursor = null;
        String column = "_data";
        String[] projection = new String[]{column};
        try {
            cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);
            if (cursor != null && cursor.moveToFirst()) {
                int index = cursor.getColumnIndexOrThrow(column);
                String string = cursor.getString(index);
                return string;
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return null;
    }

    private static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }

    private static boolean isGooglePhotosUri(Uri uri) {
        return "com.google.android.apps.photos.content".equals(uri.getAuthority());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"Range"})
    private static String getFileFromContentUri(Context context, Uri uri) {
        if (uri == null) {
            return null;
        }
        String[] filePathColumn = new String[]{"_data", "_display_name"};
        ContentResolver contentResolver = context.getContentResolver();
        Cursor cursor = contentResolver.query(uri, filePathColumn, null, null, null);
        if (cursor != null) {
            cursor.moveToFirst();
            try {
                String filePath;
                String string = filePath = cursor.getString(cursor.getColumnIndex(filePathColumn[0]));
                return string;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                cursor.close();
            }
        }
        return "";
    }

    private static String uriToFileApiQ(Context context, Uri uri) {
        ContentResolver contentResolver;
        Cursor cursor;
        File file = null;
        String scheme = uri.getScheme();
        if ("file".equals(scheme)) {
            file = new File(uri.getPath());
        } else if ("content".equals(scheme) && (cursor = (contentResolver = context.getContentResolver()).query(uri, null, null, null, null)) != null) {
            if (cursor.moveToFirst()) {
                String displayName = cursor.getString(cursor.getColumnIndexOrThrow("_display_name"));
                try {
                    InputStream is = contentResolver.openInputStream(uri);
                    File cache = new File(context.getFilesDir(), displayName);
                    if (cache.exists()) {
                        cache.delete();
                    }
                    FileOutputStream fos = new FileOutputStream(cache);
                    assert (is != null);
                    GetRealFilePathFromUri.copy(is, fos);
                    file = cache;
                    fos.close();
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    cursor.close();
                }
            }
            cursor.close();
        }
        return file != null ? file.getAbsolutePath() : "";
    }

    private static void copy(InputStream inputStream, FileOutputStream outputStream) throws IOException {
        int read;
        int m = 1;
        int maxBufferSize = m * 1024 * 1024;
        int bytesAvailable = inputStream.available();
        int bufferSize = Math.min(bytesAvailable, maxBufferSize);
        byte[] buffers = new byte[bufferSize];
        while ((read = inputStream.read(buffers)) != -1) {
            outputStream.write(buffers, 0, read);
        }
    }

    private static String getFilePathFromUri(Context context, Uri uri) {
        String realFilePath = GetRealFilePathFromUri.getRealFilePath(context, uri);
        if (!TextUtils.isEmpty((CharSequence)realFilePath)) {
            return realFilePath;
        }
        File filesDir = context.getApplicationContext().getFilesDir();
        String fileName = GetRealFilePathFromUri.getFileName(context, uri);
        if (!TextUtils.isEmpty((CharSequence)fileName)) {
            File copyFile = new File(filesDir + File.separator + fileName);
            GetRealFilePathFromUri.copyFile(context, uri, copyFile);
            return copyFile.getAbsolutePath();
        }
        return null;
    }

    @SuppressLint(value={"Range"})
    private static String getFileName(Context context, Uri uri) {
        String fileName;
        block8: {
            if (uri == null) {
                return null;
            }
            fileName = null;
            String path = uri.getPath();
            if (path != null) {
                int cut = path.lastIndexOf(47);
                if (cut != -1) {
                    fileName = path.substring(cut + 1);
                }
            } else {
                Cursor cursor = null;
                try {
                    cursor = context.getContentResolver().query(uri, null, null, null, null);
                    if (cursor != null) {
                        if (cursor.moveToFirst()) {
                            fileName = cursor.getString(cursor.getColumnIndex("_display_name"));
                        }
                        cursor.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (cursor == null) break block8;
                    cursor.close();
                }
            }
        }
        return fileName;
    }

    private static void copyFile(Context context, Uri srcUri, File dstFile) {
        try {
            InputStream inputStream = context.getContentResolver().openInputStream(srcUri);
            if (inputStream == null) {
                return;
            }
            if (dstFile.exists()) {
                dstFile.delete();
            }
            FileOutputStream outputStream = new FileOutputStream(dstFile);
            GetRealFilePathFromUri.copyStream(inputStream, outputStream);
            inputStream.close();
            ((OutputStream)outputStream).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyStream(InputStream input, OutputStream output) {
        int BUFFER_SIZE = 2048;
        byte[] buffer = new byte[2048];
        BufferedInputStream in = new BufferedInputStream(input, 2048);
        BufferedOutputStream out = new BufferedOutputStream(output, 2048);
        try {
            int n;
            while ((n = in.read(buffer, 0, 2048)) != -1) {
                out.write(buffer, 0, n);
            }
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                out.close();
                in.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

