/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat.adapter;

import com.hyphenate.chat.adapter.EMABase;
import com.hyphenate.chat.adapter.EMAChatConfig;
import com.hyphenate.chat.adapter.EMAChatManager;
import com.hyphenate.chat.adapter.EMAChatRoomManager;
import com.hyphenate.chat.adapter.EMAConnectionListener;
import com.hyphenate.chat.adapter.EMAContactManager;
import com.hyphenate.chat.adapter.EMADeviceInfo;
import com.hyphenate.chat.adapter.EMAError;
import com.hyphenate.chat.adapter.EMAGroupManager;
import com.hyphenate.chat.adapter.EMALogCallbackListener;
import com.hyphenate.chat.adapter.EMAMultiDeviceListener;
import com.hyphenate.chat.adapter.EMAPresenceManager;
import com.hyphenate.chat.adapter.EMAPushManager;
import com.hyphenate.chat.adapter.EMAReactionManager;
import com.hyphenate.chat.adapter.EMASessionManager;
import com.hyphenate.chat.adapter.EMAStatisticsManager;
import com.hyphenate.chat.adapter.EMAThreadManager;
import com.hyphenate.chat.adapter.EMATranslateManager;
import com.hyphenate.chat.adapter.EMAUserInfoManager;
import java.util.List;

public class EMAChatClient
extends EMABase {
    private EMAChatManager chatManager = null;
    private EMAChatRoomManager chatRoomManager = null;
    private EMAGroupManager groupManager = null;
    private EMAContactManager contactManager = null;
    private EMAPushManager pushManager = null;
    private EMAUserInfoManager userInfoManager = null;
    private EMASessionManager sessionManager = null;
    private EMATranslateManager translateManager = null;
    private EMAPresenceManager presenceManager = null;
    private EMAReactionManager reactionManager = null;
    private EMAThreadManager threadManager = null;
    private EMAStatisticsManager statisticsManager = null;

    public static EMAChatClient create(EMAChatConfig chatConfig) {
        EMAChatClient eMAChatClient = new EMAChatClient();
        eMAChatClient.nativeHandler = EMAChatClient.native_create(chatConfig);
        if (eMAChatClient.getChatManager() == null) {
            eMAChatClient.chatManager = new EMAChatManager();
            eMAChatClient.getChatManager().nativeHandler = eMAChatClient.native_getChatManager();
        }
        if (eMAChatClient.getChatRoomManager() == null) {
            eMAChatClient.chatRoomManager = new EMAChatRoomManager();
            eMAChatClient.getChatRoomManager().nativeHandler = eMAChatClient.native_getChatRoomManager();
        }
        if (eMAChatClient.getGroupManager() == null) {
            eMAChatClient.groupManager = new EMAGroupManager();
            eMAChatClient.getGroupManager().nativeHandler = eMAChatClient.native_getGroupManager();
        }
        if (eMAChatClient.getContactManager() == null) {
            eMAChatClient.contactManager = new EMAContactManager();
            eMAChatClient.getContactManager().nativeHandler = eMAChatClient.native_getContactManager();
        }
        if (eMAChatClient.getPushMnager() == null) {
            eMAChatClient.pushManager = new EMAPushManager();
            eMAChatClient.getPushMnager().nativeHandler = eMAChatClient.native_getPushManager();
        }
        if (eMAChatClient.getUserInfoManager() == null) {
            eMAChatClient.userInfoManager = new EMAUserInfoManager();
            eMAChatClient.getUserInfoManager().nativeHandler = eMAChatClient.native_getUserInfoManager();
        }
        if (eMAChatClient.getSessionManager() == null) {
            eMAChatClient.sessionManager = new EMASessionManager();
            eMAChatClient.getSessionManager().nativeHandler = eMAChatClient.native_getSessionManager();
        }
        if (eMAChatClient.getTranslateManager() == null) {
            eMAChatClient.translateManager = new EMATranslateManager();
            eMAChatClient.getTranslateManager().nativeHandler = eMAChatClient.native_getTranslateManager();
        }
        if (eMAChatClient.getPresenceManager() == null) {
            eMAChatClient.presenceManager = new EMAPresenceManager();
            eMAChatClient.getPresenceManager().nativeHandler = eMAChatClient.native_getPresenceManager();
        }
        if (eMAChatClient.getReactionManager() == null) {
            eMAChatClient.reactionManager = new EMAReactionManager();
            eMAChatClient.getReactionManager().nativeHandler = eMAChatClient.native_getReactionManager();
        }
        if (eMAChatClient.getThreadManager() == null) {
            eMAChatClient.threadManager = new EMAThreadManager();
            eMAChatClient.getThreadManager().nativeHandler = eMAChatClient.native_getThreadManager();
        }
        if (eMAChatClient.getStatisticsManager() == null) {
            eMAChatClient.statisticsManager = new EMAStatisticsManager();
            eMAChatClient.getStatisticsManager().nativeHandler = eMAChatClient.native_getStatisticsManager();
        }
        return eMAChatClient;
    }

    public void login(String username, String code, boolean autoLogin, int loginType, EMAError error) {
        this.native_login(username, code, autoLogin, loginType, error);
    }

    public String getUserToken(boolean fetchFromServer, EMAError error) {
        return this.native_getUserToken(fetchFromServer, error);
    }

    public String getUserTokenFromServer(String username, String password, EMAError error) {
        return this.native_getUserTokenFromServer(username, password, error);
    }

    public void logout() {
        this.native_logout();
    }

    public EMAError createAccount(String username, String password) {
        return this.native_createAccount(username, password);
    }

    public EMAError changeAppkey(String appkey) {
        return this.native_changeAppkey(appkey);
    }

    public EMAChatManager getChatManager() {
        return this.chatManager;
    }

    public EMAChatRoomManager getChatRoomManager() {
        return this.chatRoomManager;
    }

    public EMAGroupManager getGroupManager() {
        return this.groupManager;
    }

    public EMAPushManager getPushMnager() {
        return this.pushManager;
    }

    public EMAContactManager getContactManager() {
        return this.contactManager;
    }

    public EMAUserInfoManager getUserInfoManager() {
        return this.userInfoManager;
    }

    public EMASessionManager getSessionManager() {
        return this.sessionManager;
    }

    public EMATranslateManager getTranslateManager() {
        return this.translateManager;
    }

    public EMAPresenceManager getPresenceManager() {
        return this.presenceManager;
    }

    public EMAReactionManager getReactionManager() {
        return this.reactionManager;
    }

    public EMAThreadManager getThreadManager() {
        return this.threadManager;
    }

    public EMAStatisticsManager getStatisticsManager() {
        return this.statisticsManager;
    }

    public void addConnectionListener(EMAConnectionListener listener) {
        this.native_addConnectionListener(listener);
    }

    public void removeConnectionListener(EMAConnectionListener listener) {
        this.native_removeConnectionListener(listener);
    }

    public void addMultiDeviceListener(EMAMultiDeviceListener listener) {
        this.native_addMultiDeviceListener(listener);
    }

    public void addLogCallbackListener(EMALogCallbackListener listener) {
        this.native_addLogCallbackListener(listener);
    }

    public void removeLogCallbackListener(EMALogCallbackListener listener) {
        this.native_removeLogCallbackListener(listener);
    }

    public boolean sendPing(boolean waitPong, long timeout) {
        return this.native_sendPing(waitPong, timeout);
    }

    public void disconnect() {
        this.native_disconnect();
    }

    public void reconnect() {
        this.natvie_reconnect();
    }

    public void onNetworkChanged(EMANetwork network) {
        this.native_onNetworkChanged(network.ordinal());
    }

    public boolean isConnected() {
        return this.native_isConnected();
    }

    public boolean isLogout() {
        return this.native_isLogout();
    }

    public String compressLogs(EMAError error) {
        return this.native_compressLogs(error);
    }

    public List<EMADeviceInfo> getLoggedInDevicesFromServer(String username, String password, EMAError error) {
        return this.nativeGetLoggedInDevicesFromServer(username, password, error);
    }

    public List<EMADeviceInfo> getLoggedInDevicesFromServerWithToken(String username, String token, EMAError error) {
        return this.nativeGetLoggedInDevicesFromServerWithToken(username, token, error);
    }

    public void kickDevice(String username, String password, String resource, EMAError error) {
        this.nativeKickDevice(username, password, resource, error);
    }

    public void kickAllDevices(String username, String password, EMAError error) {
        this.nativeKickAllDevices(username, password, error);
    }

    public void kickDeviceWithToken(String username, String token, String resource, EMAError error) {
        this.nativeKickDeviceWithToken(username, token, resource, error);
    }

    public void kickAllDevicesWithToken(String username, String token, EMAError error) {
        this.nativeKickAllDevicesWithToken(username, token, error);
    }

    public void check(String username, String password, CheckResultListener listener) {
        this.nativeCheck(username, password, listener);
    }

    public boolean isLoggedIn() {
        return this.native_isLoggedIn();
    }

    public void renewToken(String newTokn) {
        this.native_renewToken(newTokn);
    }

    public long getTokenExpiredTs(String newToken, EMAError error) {
        return this.nativeGetTokenExpiredTs(newToken, error);
    }

    static native long native_create(EMAChatConfig var0);

    native EMAError native_createAccount(String var1, String var2);

    native void native_login(String var1, String var2, boolean var3, int var4, EMAError var5);

    native String native_getUserToken(boolean var1, EMAError var2);

    native String native_getUserTokenFromServer(String var1, String var2, EMAError var3);

    native void native_logout();

    native EMAError native_changeAppkey(String var1);

    native long native_getChatManager();

    native long native_getCallManager();

    native long native_getGroupManager();

    native long native_getContactManager();

    native long native_getChatRoomManager();

    native long native_getPushManager();

    native long native_getRtcConfigManager();

    native long native_getUserInfoManager();

    native long native_getSessionManager();

    native long native_getTranslateManager();

    native long native_getPresenceManager();

    native long native_getReactionManager();

    native long native_getThreadManager();

    native long native_getStatisticsManager();

    native void native_onNetworkChanged(int var1);

    native List<EMADeviceInfo> nativeGetLoggedInDevicesFromServer(String var1, String var2, EMAError var3);

    native List<EMADeviceInfo> nativeGetLoggedInDevicesFromServerWithToken(String var1, String var2, EMAError var3);

    native void nativeKickDevice(String var1, String var2, String var3, EMAError var4);

    native void nativeKickAllDevices(String var1, String var2, EMAError var3);

    native void nativeKickDeviceWithToken(String var1, String var2, String var3, EMAError var4);

    native void nativeKickAllDevicesWithToken(String var1, String var2, EMAError var3);

    native void native_addConnectionListener(EMAConnectionListener var1);

    native void native_removeConnectionListener(EMAConnectionListener var1);

    native void native_addMultiDeviceListener(EMAMultiDeviceListener var1);

    native void native_removeMultiDeviceListener(EMAMultiDeviceListener var1);

    native void native_addLogCallbackListener(EMALogCallbackListener var1);

    native void native_removeLogCallbackListener(EMALogCallbackListener var1);

    native boolean native_sendPing(boolean var1, long var2);

    native void native_disconnect();

    native void natvie_reconnect();

    native boolean native_isConnected();

    native boolean native_isLogout();

    native boolean native_isLoggedIn();

    native void native_renewToken(String var1);

    native String native_compressLogs(EMAError var1);

    native void nativeCheck(String var1, String var2, CheckResultListener var3);

    native long nativeGetTokenExpiredTs(String var1, EMAError var2);

    public static enum EMANetwork {
        NETWORK_NONE,
        NETWORK_CABLE,
        NETWORK_WIFI,
        NETWORK_MOBILE;

    }

    public static class CheckResultListener {
        public void onResult(int type, int result, String desc) {
        }
    }
}

