/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat.adapter;

import com.hyphenate.chat.EMCursorResult;
import com.hyphenate.chat.adapter.EMABase;
import com.hyphenate.chat.adapter.EMAContact;
import com.hyphenate.chat.adapter.EMAContactListener;
import com.hyphenate.chat.adapter.EMAError;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class EMAContactManager
extends EMABase {
    private Set<EMAContactListener> listeners = new HashSet<EMAContactListener>();

    public void inviteContact(String username, String message, EMAError error) {
        this.nativeInviteContact(username, message, error);
    }

    public void deleteContact(String username, EMAError error, boolean keepConversation) {
        this.nativeDeleteContact(username, error, keepConversation);
    }

    public List<String> getContactsFromServer(EMAError error) {
        return this.nativeGetContactsFromServer(error);
    }

    public List<String> getContactsFromDB(EMAError error) {
        return this.nativeGetContactsFromDB(error);
    }

    public void acceptInvitation(String username, EMAError error) {
        this.nativeAcceptInvitation(username, error);
    }

    public void declineInvitation(String username, EMAError error) {
        this.nativeDeclineInvitation(username, error);
    }

    public void setSupportRosterVersion(boolean supportRosterVersion) {
        this.nativeSetSupportRosterVersion(supportRosterVersion);
    }

    public void registerContactListener(EMAContactListener listener) {
        this.listeners.add(listener);
        this.nativeRegisterContactListener(listener);
    }

    public void removeContactListener(EMAContactListener listener) {
        this.listeners.remove(listener);
        this.nativeRemoveContactListener(listener);
    }

    public List<String> getBlackListFromServer(EMAError error) {
        return this.nativeGetBlackListFromServer(error);
    }

    public List<String> getBlackListFromDB(EMAError error) {
        return this.nativeGetBlackListFromDB(error);
    }

    public void saveBlackList(List<String> blacklist, EMAError error) {
        this.nativeSaveBlackList(blacklist, error);
    }

    public void addToBlackList(String username, boolean both, EMAError error) {
        this.nativeAddToBlackList(username, both, error);
    }

    public void removeFromBlackList(String username, EMAError error) {
        this.nativeRemoveFromBlackList(username, error);
    }

    public List<String> getSelfIdsOnOtherPlatform(EMAError error) {
        return this.nativeGetSelfIdsOnOtherPlatform(error);
    }

    public void setContactRemark(String username, String remark, EMAError error) {
        this.nativeSetContactRemark(username, remark, error);
    }

    public EMAContact fetchContactFromLocal(String username, EMAError error) {
        return this.nativeFetchContactFromLocal(username, error);
    }

    public List<EMAContact> fetchAllContactsFromLocal(EMAError error) {
        return this.nativeFetchAllContactsFromLocal(error);
    }

    public List<EMAContact> fetchAllContactsFromServer(EMAError error) {
        return this.nativeFetchAllContactsFromServer(error);
    }

    public EMCursorResult<EMAContact> fetchAllContactsFromServer(int limit, String cursor, EMAError error) {
        return this.nativeFetchAllContactsFromServer_(limit, cursor, error);
    }

    public EMAContactManager() {
    }

    public EMAContactManager(EMAContactManager old) {
        this.nativeInit(old);
    }

    native void nativeInviteContact(String var1, String var2, EMAError var3);

    native void nativeDeleteContact(String var1, EMAError var2, boolean var3);

    native List<String> nativeGetContactsFromServer(EMAError var1);

    native List<String> nativeGetContactsFromDB(EMAError var1);

    native void nativeAcceptInvitation(String var1, EMAError var2);

    native void nativeDeclineInvitation(String var1, EMAError var2);

    native void nativeSetSupportRosterVersion(boolean var1);

    native void nativeRegisterContactListener(EMAContactListener var1);

    native void nativeRemoveContactListener(EMAContactListener var1);

    native List<String> nativeGetBlackListFromServer(EMAError var1);

    native List<String> nativeGetBlackListFromDB(EMAError var1);

    native void nativeSaveBlackList(List<String> var1, EMAError var2);

    native void nativeAddToBlackList(String var1, boolean var2, EMAError var3);

    native void nativeRemoveFromBlackList(String var1, EMAError var2);

    native List<String> nativeGetSelfIdsOnOtherPlatform(EMAError var1);

    native void nativeInit(EMAContactManager var1);

    native void nativeSetContactRemark(String var1, String var2, EMAError var3);

    native EMAContact nativeFetchContactFromLocal(String var1, EMAError var2);

    native List<EMAContact> nativeFetchAllContactsFromLocal(EMAError var1);

    native List<EMAContact> nativeFetchAllContactsFromServer(EMAError var1);

    native EMCursorResult<EMAContact> nativeFetchAllContactsFromServer_(int var1, String var2, EMAError var3);
}

