/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat.adapter.message;

import android.net.Uri;
import com.hyphenate.chat.adapter.EMACallback;
import com.hyphenate.chat.adapter.message.EMAMessageBody;
import com.hyphenate.util.EMFileHelper;

public class EMAFileMessageBody
extends EMAMessageBody {
    public static final int EMDownloadStatus_DOWNLOADING = 0;
    public static final int EMDownloadStatus_SUCCESSED = 1;
    public static final int EMDownloadStatus_FAILED = 2;
    public static final int EMDownloadStatus_PENDING = 3;

    private EMAFileMessageBody() {
        this("", 5);
    }

    public EMAFileMessageBody(String localPath) {
        this(EMFileHelper.getInstance().formatInUri(localPath));
    }

    public EMAFileMessageBody(Uri localPath) {
        this(localPath, 5);
    }

    public EMAFileMessageBody(String localPath, int type) {
        this(EMFileHelper.getInstance().formatInUri(localPath), type);
    }

    public EMAFileMessageBody(Uri localPath, int type) {
        if (type == 5) {
            this.nativeInit(EMFileHelper.getInstance().uriToString(localPath), type);
        }
        this.type = type;
    }

    public EMAFileMessageBody(EMAFileMessageBody body) {
        this.nativeInit(body);
    }

    public void finalize() throws Throwable {
        if (this.type == 5) {
            this.nativeFinalize();
        }
        super.finalize();
    }

    public String displayName() {
        return this.nativedisplayName();
    }

    native String nativedisplayName();

    public void setDisplayName(String displayName) {
        this.nativesetDisplayName(displayName);
    }

    native void nativesetDisplayName(String var1);

    public String getLocalUrl() {
        return this.nativelocalPath();
    }

    native String nativelocalPath();

    public void setLocalPath(String localPath) {
        this.nativesetLocalPath(localPath);
    }

    native void nativesetLocalPath(String var1);

    public String getRemoteUrl() {
        return this.nativeremotePath();
    }

    native String nativeremotePath();

    public void setRemotePath(String remotePath) {
        this.nativesetRemotePath(remotePath);
    }

    native void nativesetRemotePath(String var1);

    public String getSecret() {
        return this.nativesecretKey();
    }

    native String nativesecretKey();

    public void setSecretKey(String secreyKey) {
        this.nativesetSecretKey(secreyKey);
    }

    native void nativesetSecretKey(String var1);

    public long fileLength() {
        return this.nativefileLength();
    }

    native long nativefileLength();

    public void setFileLength(long length) {
        this.nativesetFileLength(length);
    }

    native void nativesetFileLength(long var1);

    public EMADownloadStatus downloadStatus() {
        int n = this.nativedownloadStatus();
        if (n == EMADownloadStatus.DOWNLOADING.ordinal()) {
            return EMADownloadStatus.DOWNLOADING;
        }
        if (n == EMADownloadStatus.SUCCESSED.ordinal()) {
            return EMADownloadStatus.SUCCESSED;
        }
        if (n == EMADownloadStatus.FAILED.ordinal()) {
            return EMADownloadStatus.FAILED;
        }
        return EMADownloadStatus.PENDING;
    }

    native int nativedownloadStatus();

    public void setDownloadStatus(EMADownloadStatus status) {
        int n = status.ordinal();
        this.nativesetDownloadStatus(n);
    }

    native void nativesetDownloadStatus(int var1);

    public void setDownloadCallback(EMACallback callback) {
        this.nativeSetDownloadCallback(callback);
    }

    native void nativeSetDownloadCallback(EMACallback var1);

    native void nativeInit(String var1, int var2);

    native void nativeInit(EMAFileMessageBody var1);

    native void nativeFinalize();

    public static enum EMADownloadStatus {
        DOWNLOADING,
        SUCCESSED,
        FAILED,
        PENDING;

    }
}

