/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.cloud;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import com.hyphenate.chat.EMClient;
import com.hyphenate.cloud.HttpCallback;
import com.hyphenate.cloud.HttpClientConfig;
import com.hyphenate.cloud.HttpResponse;
import com.hyphenate.util.EMFileHelper;
import com.hyphenate.util.EMLog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

class HttpClientController {
    private static final String a = HttpClientController.class.getSimpleName();
    private final Context b;
    private URL c;
    private HttpURLConnection d;
    private boolean e;
    private static final String[] f = new String[]{"GET", "POST", "HEAD", "OPTIONS", "PUT", "DELETE", "TRACE"};
    private static int g = 60000;
    private static int h = 60000;
    private static final String i = UUID.randomUUID().toString();
    private static final String j = "--";
    private static final String k = "\r\n";
    private static final String l = "Android";

    public HttpClientController(Context mContext) {
        this.b = mContext;
    }

    public void a(String string) throws IOException {
        this.a(string, -1);
    }

    public void a(String string, int n) throws IOException {
        string = HttpClientConfig.getFileRemoteUrl(string);
        string = HttpClientConfig.processUrl(string);
        URL uRL = new URL(string);
        String string2 = uRL.getProtocol();
        int n2 = uRL.getPort();
        if (n2 != -1) {
            n = n2;
        }
        this.c = new URL(string2, uRL.getHost(), n, uRL.getFile());
        this.d = (HttpURLConnection)this.c.openConnection();
    }

    public void b(String string) throws ProtocolException {
        this.d.setRequestMethod(string);
    }

    public void a(int n) {
        if (n <= 0) {
            n = g;
        }
        this.d.setConnectTimeout(n);
    }

    public void b(int n) {
        if (n <= 0) {
            n = h;
        }
        this.d.setReadTimeout(n);
    }

    public void a(boolean bl) {
        this.d.setInstanceFollowRedirects(bl);
    }

    public void a() {
        this.d.setRequestProperty("Authorization", "Bearer " + EMClient.getInstance().getOptions().getAccessToken());
    }

    public void b() {
        this.d.setRequestProperty("User-agent", HttpClientConfig.getDefaultUserAgent());
        this.d.setRequestProperty("Connection", "Keep-Alive");
    }

    public void c() {
        this.d.setRequestProperty("Charset", "UTF-8");
        this.d.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + i);
    }

    public void d() {
        this.d.setChunkedStreamingMode(0);
    }

    public void e() {
        this.d.setDoInput(true);
    }

    public void f() {
        this.d.setDoOutput(true);
        this.d.setDoInput(true);
        this.d.setUseCaches(false);
    }

    public void g() {
        if (Build.VERSION.SDK_INT >= 21) {
            this.d.setDoOutput(true);
            this.d.setDoInput(true);
            this.d.setUseCaches(false);
        }
    }

    public HttpURLConnection h() {
        return this.d;
    }

    public void a(Map<String, String> map) {
        if (map != null && map.size() > 0) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.d.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
    }

    public void a(Map<String, String> map, OutputStream outputStream) throws IOException {
        if (map == null || map.size() <= 0) {
            return;
        }
        String string = this.b(map);
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        outputStream.write(string.getBytes());
        outputStream.flush();
    }

    public void a(String string, OutputStream outputStream) throws IOException {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        outputStream.write(string.getBytes());
        outputStream.flush();
    }

    public void a(Uri uri, OutputStream outputStream, HttpCallback httpCallback) throws IOException {
        this.a("file", uri, null, outputStream, httpCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(String string, Uri uri, String string2, OutputStream outputStream, HttpCallback httpCallback) throws IOException {
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = "file";
        }
        if (!EMFileHelper.getInstance().isFileExist(uri)) {
            throw new FileNotFoundException("file not exist");
        }
        String string3 = EMFileHelper.getInstance().getFilename(uri);
        String string4 = EMFileHelper.getInstance().getFileMimeType(uri);
        long l = EMFileHelper.getInstance().getFileLength(uri);
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            string3 = string2;
        }
        String string5 = EMFileHelper.getInstance().getFilePath(uri);
        try (InputStream inputStream = null;){
            int n;
            inputStream = !TextUtils.isEmpty((CharSequence)string5) && new File(string5).exists() ? new FileInputStream(new File(string5)) : this.b.getContentResolver().openInputStream(uri);
            int n2 = inputStream.available();
            if ((long)n2 > l) {
                l = n2;
            }
            outputStream.write(this.a(string, string3, string4, l).getBytes());
            byte[] byArray = new byte[2048];
            long l2 = 0L;
            while ((n = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
                if ((l2 += (long)n) > l) {
                    l2 = l;
                }
                if (httpCallback == null) continue;
                httpCallback.onProgress(l, l2);
            }
        }
        outputStream.write(this.n().getBytes());
        outputStream.flush();
    }

    public HttpURLConnection i() throws IOException {
        this.b(false);
        this.d.connect();
        return this.d;
    }

    private void b(boolean bl) throws IllegalStateException {
        if (!bl || this.d != null) {
            // empty if block
        }
    }

    public HttpResponse j() throws IOException {
        HttpResponse httpResponse = new HttpResponse();
        httpResponse.code = this.d.getResponseCode();
        if (httpResponse.code == 200) {
            httpResponse.contentLength = this.d.getContentLength();
            httpResponse.inputStream = this.d.getInputStream();
            httpResponse.content = this.a(httpResponse.inputStream);
        } else {
            httpResponse.errorStream = this.d.getErrorStream();
            httpResponse.content = this.a(httpResponse.errorStream);
        }
        this.a(false, httpResponse);
        return httpResponse;
    }

    public HttpResponse k() throws IOException {
        HttpResponse httpResponse = new HttpResponse();
        httpResponse.code = this.d.getResponseCode();
        httpResponse.contentLength = this.d.getContentLength();
        httpResponse.errorStream = this.d.getErrorStream();
        if (httpResponse.code != 200) {
            httpResponse.content = this.a(httpResponse.errorStream);
        }
        try {
            httpResponse.inputStream = this.d.getInputStream();
        }
        catch (IOException iOException) {
            try {
                JSONObject jSONObject;
                if (!TextUtils.isEmpty((CharSequence)httpResponse.content) && (jSONObject = new JSONObject(httpResponse.content)).has("error_description")) {
                    String string = jSONObject.getString("error_description");
                    if (iOException.getClass().getSimpleName().equals("FileNotFoundException")) {
                        throw new FileNotFoundException(string);
                    }
                    throw iOException;
                }
            }
            catch (JSONException jSONException) {
                throw new RuntimeException(jSONException);
            }
        }
        this.a(false, httpResponse);
        return httpResponse;
    }

    private void a(boolean bl, HttpResponse httpResponse) {
        if (this.d == null || httpResponse == null) {
            return;
        }
        if (!bl) {
            EMLog.d(a, "response code: " + httpResponse.code);
            if (httpResponse.code != 200) {
                EMLog.d(a, "error message: " + httpResponse.content);
            }
        }
    }

    public HttpResponse a(Exception exception) throws IOException {
        HttpResponse httpResponse = new HttpResponse();
        if (this.d != null) {
            httpResponse.code = this.d.getResponseCode();
            httpResponse.contentLength = this.d.getContentLength();
            httpResponse.errorStream = this.d.getErrorStream();
            this.d.disconnect();
        }
        httpResponse.exception = exception;
        return httpResponse;
    }

    private String m() {
        return this.d.getHeaderField("Location");
    }

    private String a(InputStream inputStream) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            StringBuilder stringBuilder = new StringBuilder();
            String string = "";
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string + "\n");
            }
            String string2 = stringBuilder.toString();
            return string2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String b(Map<String, String> map) {
        if (map == null || map.size() <= 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : map.keySet()) {
            stringBuffer.append(j);
            stringBuffer.append(i);
            stringBuffer.append(k);
            stringBuffer.append("Content-Disposition: form-data; name=\"" + string + "\"");
            stringBuffer.append(k);
            stringBuffer.append("Content-Type: text/plain");
            stringBuffer.append(k);
            stringBuffer.append("Content-Length: " + map.get(string).length());
            stringBuffer.append(k);
            stringBuffer.append(k);
            stringBuffer.append(map.get(string));
            stringBuffer.append(k);
        }
        return stringBuffer.toString();
    }

    private String a(String string, String string2, String string3, long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(k);
        stringBuffer.append(j);
        stringBuffer.append(i);
        stringBuffer.append(k);
        stringBuffer.append("Content-Disposition: form-data; name=\"" + string + "\"; filename=\"" + string2 + "\"");
        stringBuffer.append(k);
        stringBuffer.append("Content-Type: " + string3);
        stringBuffer.append(k);
        stringBuffer.append("Content-Length: " + l);
        stringBuffer.append(k);
        stringBuffer.append(k);
        return stringBuffer.toString();
    }

    private String n() {
        return "\r\n--" + i + j + k;
    }

    private void c(String string) {
        HttpClientConfig.checkAndProcessSSL(string, this.d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(Uri uri, int n, long l, long l2, OutputStream outputStream, HttpCallback httpCallback) throws IOException {
        if (!EMFileHelper.getInstance().isFileExist(uri)) {
            throw new FileNotFoundException("file not exist");
        }
        if (n <= 0 || l < 0L || l2 < 0L) {
            throw new IllegalArgumentException("the upload part file params is invalid");
        }
        String string = EMFileHelper.getInstance().getFilePath(uri);
        try (InputStream inputStream = null;){
            int n2;
            long l3;
            inputStream = !TextUtils.isEmpty((CharSequence)string) && new File(string).exists() ? new FileInputStream(new File(string)) : this.b.getContentResolver().openInputStream(uri);
            if (inputStream == null) {
                throw new IOException("can't open file input stream");
            }
            int n3 = inputStream.available();
            if (l2 > (long)n3) {
                throw new IllegalArgumentException("the upload  part file start position is greater than the file size");
            }
            outputStream.write(this.a("blob", n, l).getBytes());
            byte[] byArray = new byte[2048];
            for (long i = l2; i > 0L && (l3 = inputStream.skip(i)) != 0L; i -= l3) {
            }
            l3 = l;
            while ((n2 = inputStream.read(byArray, 0, (int)Math.min((long)byArray.length, l3))) != -1) {
                outputStream.write(byArray, 0, n2);
                l3 -= (long)n2;
                if (httpCallback != null) {
                    httpCallback.onProgress(l, l - l3);
                }
                if (l3 != 0L) continue;
                break;
            }
        }
        outputStream.write(this.n().getBytes());
        outputStream.flush();
    }

    private String a(String string, int n, long l) throws UnsupportedEncodingException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(k);
        stringBuffer.append(j);
        stringBuffer.append(i);
        stringBuffer.append(k);
        stringBuffer.append("Content-Disposition: form-data; name=\"part_number\"");
        stringBuffer.append(k);
        stringBuffer.append(k);
        stringBuffer.append(n);
        stringBuffer.append(k);
        stringBuffer.append(j);
        stringBuffer.append(i);
        stringBuffer.append(k);
        stringBuffer.append("Content-Disposition: form-data; name=\"part_file\"; filename=\"" + string + "\"");
        stringBuffer.append(k);
        stringBuffer.append("Content-Type: application/octet-stream");
        stringBuffer.append(k);
        stringBuffer.append(k);
        return stringBuffer.toString();
    }

    public static class HttpParams {
        public final Context mContext;
        public String mRequestMethod;
        public int mPort = -1;
        public int mConnectTimeout;
        public int mReadTimeout;
        public boolean followRedirect = true;
        public boolean canRetry;
        public int mRetryTimes;
        public Map<String, String> mHeaders = new HashMap<String, String>();
        public Map<String, String> mParams = new HashMap<String, String>();
        public String mParamsString;
        public String mUrl;
        public String mLocalFileUri;
        public String mDownloadPath;
        public String mFilename;
        public String mFileKey;
        public boolean isUploadFile;
        public boolean isDownloadFile;
        public boolean isCheckSSL;
        public boolean isNotUseToken;
        public boolean isTokenExceeded;
        public boolean isDefaultRetry;
        public int partNum = -1;
        public long partLength;
        public long offset;

        public HttpParams(Context mContext) {
            this.mContext = mContext;
        }

        public void apply(HttpClientController controller) throws IOException {
            if (this.mPort != -1) {
                controller.a(this.mUrl, this.mPort);
            } else {
                controller.a(this.mUrl);
            }
            controller.b(this.mRequestMethod);
            if ("GET".equalsIgnoreCase(this.mRequestMethod)) {
                controller.e();
            } else if ("DELETE".equalsIgnoreCase(this.mRequestMethod)) {
                controller.g();
            } else {
                controller.f();
            }
            controller.a(this.mConnectTimeout);
            controller.b(this.mReadTimeout);
            controller.b();
            if (!this.isNotUseToken) {
                controller.a();
            }
            controller.a(this.followRedirect);
            if (this.isUploadFile) {
                controller.c();
                controller.d();
            }
            if (this.isDownloadFile) {
                if (TextUtils.isEmpty((CharSequence)this.mDownloadPath)) {
                    throw new FileNotFoundException("file download path is empty");
                }
                this.checkDownloadProperty();
            }
            controller.c(this.mUrl);
            this.checkToken();
            controller.a(this.mHeaders);
        }

        public void addFile(HttpClientController controller, OutputStream out, HttpCallback callback) throws IOException {
            if (this.isUploadFile) {
                if (this.partNum != -1) {
                    EMLog.e(a, "upload part file");
                    controller.a(EMFileHelper.getInstance().formatInUri(this.mLocalFileUri), this.partNum, this.partLength, this.offset, out, callback);
                } else {
                    EMLog.e(a, "upload normal file");
                    controller.a(this.mFileKey, EMFileHelper.getInstance().formatInUri(this.mLocalFileUri), this.mFilename, out, callback);
                }
            }
        }

        public HttpResponse getResponse(HttpClientController controller) throws IOException {
            return this.isDownloadFile ? controller.k() : controller.j();
        }

        public String getRedirectionUrl(HttpClientController controller) {
            return controller.m();
        }

        public HttpResponse getExceptionResponse(HttpClientController controller, IOException e) throws IOException {
            if (controller != null) {
                return controller.a(e);
            }
            return null;
        }

        public void checkDownloadProperty() {
            if (this.isDownloadFile) {
                this.mHeaders.put("Authorization", "Bearer " + EMClient.getInstance().getOptions().getAccessToken());
                this.mHeaders.put("Accept", "application/octet-stream");
            }
        }

        public void checkToken() {
            if (this.mHeaders.keySet().contains("Authorization") && TextUtils.isEmpty((CharSequence)this.mHeaders.get("Authorization"))) {
                this.mHeaders.put("Authorization", "Bearer " + EMClient.getInstance().getOptions().getAccessToken());
            }
        }
    }
}

