/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.helpdesk.httpclient;

import android.content.Context;
import android.os.Build;
import com.hyphenate.chat.ChatClient;
import com.hyphenate.helpdesk.httpclient.HttpRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public final class HttpClient {
    private static final String DEFAULT_USER_AGENT;
    private final Context context;
    private int connectTimeout;
    private int readTimeout;
    private String userAgent;
    private final Map<String, String> inMemoryCookies = new HashMap<String, String>(8);

    public HttpClient(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("Context cannot be null");
        }
        this.context = context;
    }

    Context getContext() {
        return this.context;
    }

    public HttpRequestBuilder get(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("URI cannot be null");
        }
        return new HttpRequestBuilder(this, uri, "GET");
    }

    public HttpRequestBuilder header(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("URI cannot be null");
        }
        return new HttpRequestBuilder(this, uri, "HEAD");
    }

    public HttpRequestBuilder post(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("URI cannot be null");
        }
        return new HttpRequestBuilder(this, uri, "POST");
    }

    public HttpRequestBuilder put(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("URI cannot be null");
        }
        return new HttpRequestBuilder(this, uri, "PUT");
    }

    public HttpRequestBuilder delete(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("URI cannot be null");
        }
        return new HttpRequestBuilder(this, uri, "DELETE");
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        if (connectTimeout < 0) {
            throw new IllegalArgumentException("Invalid connect timeout:" + connectTimeout);
        }
        this.connectTimeout = connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        if (readTimeout < 0) {
            throw new IllegalArgumentException("Invalid read timeout:" + readTimeout);
        }
        this.readTimeout = readTimeout;
    }

    public String getUserAgent() {
        if (this.userAgent == null) {
            return DEFAULT_USER_AGENT;
        }
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    Map<String, String> getInMemoryCookies() {
        return this.inMemoryCookies;
    }

    private static String getDefaultUserAgent() {
        return "Easemob-Android V" + ChatClient.getInstance().sdkVersion() + "(" + Build.MANUFACTURER + " " + Build.MODEL + "; Android " + Build.VERSION.RELEASE + "/" + Build.VERSION.SDK_INT + ")";
    }

    static {
        if (Build.VERSION.SDK_INT <= 8) {
            System.setProperty("http.keepAlive", "false");
        }
        DEFAULT_USER_AGENT = HttpClient.getDefaultUserAgent();
    }
}

