/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.helpdesk.manager;

import android.text.TextUtils;
import android.util.Log;
import com.hyphenate.chat.ChatClient;
import com.hyphenate.chat.EMClient;
import com.hyphenate.helpdesk.callback.ValueCallBack;
import com.hyphenate.helpdesk.emojicon.Emojicon;
import com.hyphenate.helpdesk.httpclient.HttpClient;
import com.hyphenate.helpdesk.httpclient.HttpRequestBuilder;
import com.hyphenate.helpdesk.httpclient.HttpResponse;
import com.hyphenate.util.PathUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EmojiconManager {
    public static final String TAG = "EmojiconManager";
    private ExecutorService requestService = Executors.newCachedThreadPool();
    private List<EmojiconEntity> iconList = new ArrayList<EmojiconEntity>();
    private String iconsJson;
    private String iconsJsonNew;
    private List<EmojiconPackage> packageList = new ArrayList<EmojiconPackage>();
    private String packagesJson;
    private String packagesJsonNew;
    private Queue<Url> downloadQueue = new LinkedList<Url>();
    private final List<EmojiconManagerDelegate> delegates = Collections.synchronizedList(new ArrayList());
    private static EmojiconManager instance;
    private volatile boolean refleshing = false;

    public static synchronized EmojiconManager getInstance() {
        if (instance == null) {
            instance = new EmojiconManager();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Emojicon> getEmojiconList(EmojiconPackage aPackage) {
        ArrayList<Emojicon> list = new ArrayList<Emojicon>();
        List<EmojiconEntity> list2 = this.iconList;
        synchronized (list2) {
            for (EmojiconEntity entity : this.iconList) {
                if (entity.packageId != aPackage.id) continue;
                Emojicon emojicon = new Emojicon();
                emojicon.setType(Emojicon.Type.BIG_EXPRESSION);
                if (!TextUtils.isEmpty((CharSequence)entity.origin.localUrl)) {
                    emojicon.setBigIconPath(entity.origin.localUrl);
                }
                if (!TextUtils.isEmpty((CharSequence)entity.thumbnail.localUrl)) {
                    emojicon.setIconPath(entity.thumbnail.localUrl);
                }
                if (!TextUtils.isEmpty((CharSequence)entity.origin.remoteUrl)) {
                    emojicon.setBigIconRemotePath(entity.origin.remoteUrl);
                }
                if (!TextUtils.isEmpty((CharSequence)entity.thumbnail.remoteUrl)) {
                    emojicon.setIconRemotePath(entity.thumbnail.remoteUrl);
                }
                if (!TextUtils.isEmpty((CharSequence)entity.fileName)) {
                    emojicon.setName(entity.fileName);
                }
                list.add(emojicon);
            }
        }
        return list;
    }

    public List<EmojiconPackage> getEmojiPackagesList() {
        this.reSortPackageList();
        return this.packageList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reflesh() {
        EmojiconManager emojiconManager = this;
        synchronized (emojiconManager) {
            if (this.refleshing) {
                return;
            }
            String tenantId = ChatClient.getInstance().tenantId();
            this.iconsJson = ChatClient.getInstance().getEmojiconInfoIconsJson(tenantId);
            this.packagesJson = ChatClient.getInstance().getEmojiconInfoPackagesJson(tenantId);
            this.refleshing = true;
        }
        this.getAllEmojiiconPackages();
    }

    public void clear() {
        this.iconList.clear();
        this.packageList.clear();
        this.notifyDelegateEmojiconChanged();
    }

    private void getAllEmojiiconPackages() {
        this.getAllEmojiiconPackages(new ValueCallBack<String>(){

            @Override
            public void onSuccess(String value) {
                EmojiconManager.this.getPackagesFromJson(value);
                EmojiconManager.this.getAllEmojiiconFiles();
            }

            @Override
            public void onError(int error, String errorMsg) {
                EmojiconManager.this.getPackagesFromJson(EmojiconManager.this.packagesJson);
                EmojiconManager.this.getAllEmojiiconFiles();
            }
        });
    }

    private void getPackagesFromJson(String value) {
        this.packageList.clear();
        try {
            JSONObject response = new JSONObject(value);
            JSONArray packagesEntities = response.getJSONArray("entities");
            if (packagesEntities != null) {
                for (int i = 0; i < packagesEntities.length(); ++i) {
                    EmojiconPackage emojiconPackage = new EmojiconPackage();
                    JSONObject obj = packagesEntities.getJSONObject(i);
                    emojiconPackage.id = obj.getInt("id");
                    emojiconPackage.packageName = obj.getString("packageName");
                    emojiconPackage.fileNum = obj.getInt("fileNum");
                    emojiconPackage.orderSQ = obj.getInt("orderSQ");
                    emojiconPackage.creatorId = obj.getString("creatorId");
                    this.packageList.add(emojiconPackage);
                }
                this.packagesJsonNew = value;
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void getAllEmojiiconFiles() {
        this.getAllEmojiiconFiles(new ValueCallBack<String>(){

            @Override
            public void onSuccess(String value) {
                if (!EmojiconManager.this.getEmojiconsFromJson(value)) {
                    EmojiconManager.this.getAllEmojiiconFiles(new ValueCallBack<String>(){

                        @Override
                        public void onSuccess(String value) {
                            EmojiconManager.this.getEmojiconsFromJson(value);
                        }

                        @Override
                        public void onError(int error, String errorMsg) {
                            EmojiconManager.this.getEmojiconsFromJson(EmojiconManager.this.iconsJson);
                        }
                    });
                }
            }

            @Override
            public void onError(int error, String errorMsg) {
                EmojiconManager.this.iconList.clear();
                EmojiconManager.this.getAllEmojiiconFiles(new ValueCallBack<String>(){

                    @Override
                    public void onSuccess(String value) {
                        EmojiconManager.this.getEmojiconsFromJson(value);
                    }

                    @Override
                    public void onError(int error, String errorMsg) {
                        EmojiconManager.this.getEmojiconsFromJson(EmojiconManager.this.iconsJson);
                    }
                });
            }
        });
    }

    private boolean getEmojiconsFromJson(String value) {
        this.iconList.clear();
        try {
            JSONObject response = new JSONObject(value);
            JSONArray entities = response.getJSONArray("entities");
            if (entities != null) {
                for (int i = 0; i < entities.length(); ++i) {
                    EmojiconEntity emojicon = new EmojiconEntity();
                    JSONObject obj = entities.getJSONObject(i);
                    emojicon.id = obj.getInt("id");
                    emojicon.packageId = obj.getInt("packageId");
                    emojicon.fileName = obj.getString("fileName");
                    emojicon.origin.remoteUrl = obj.getString("originUrl");
                    if (emojicon.origin.remoteUrl.startsWith("/v1/Tenant/")) {
                        emojicon.origin.remoteUrl = ChatClient.getInstance().kefuRestServer() + emojicon.origin.remoteUrl;
                    }
                    emojicon.origin.localUrl = new File(PathUtil.getInstance().getImagePath(), "origin_" + emojicon.packageId + "_" + emojicon.fileName).getPath();
                    emojicon.thumbnail.remoteUrl = obj.getString("thumbnailUrl");
                    if (emojicon.thumbnail.remoteUrl.startsWith("/v1/Tenant/")) {
                        emojicon.thumbnail.remoteUrl = ChatClient.getInstance().kefuRestServer() + emojicon.thumbnail.remoteUrl;
                    }
                    emojicon.thumbnail.localUrl = new File(PathUtil.getInstance().getImagePath(), "thumbnail__" + emojicon.packageId + "_" + emojicon.id + ".jpg").getPath();
                    this.iconList.add(emojicon);
                }
                this.iconsJsonNew = value;
                this.prepareDownloadAllIcons();
            }
            return true;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return false;
        }
    }

    private void reSortPackageList() {
        ArrayList<EmojiconPackage> tempList = new ArrayList<EmojiconPackage>();
        int i = 1;
        while (tempList.size() < this.packageList.size()) {
            for (EmojiconPackage tempPackage : this.packageList) {
                if (tempPackage.orderSQ != i) continue;
                tempList.add(tempPackage);
                break;
            }
            ++i;
        }
        this.packageList = tempList;
    }

    public EmojiconEntity getEmojicon(String remotePath) {
        if (TextUtils.isEmpty((CharSequence)remotePath)) {
            return null;
        }
        if (remotePath.startsWith("/v1/Tenant/")) {
            remotePath = ChatClient.getInstance().kefuRestServer() + remotePath;
        }
        for (EmojiconEntity entity : this.iconList) {
            if (!entity.origin.remoteUrl.contains(remotePath)) continue;
            return entity;
        }
        EmojiconEntity emojiconEntity = new EmojiconEntity();
        emojiconEntity.origin.remoteUrl = remotePath;
        return emojiconEntity;
    }

    private void getAllEmojiiconFiles(final ValueCallBack<String> callback) {
        this.requestService.submit(new Runnable(){

            @Override
            public void run() {
                block11: {
                    if (!ChatClient.getInstance().isLoggedInBefore()) {
                        if (callback != null) {
                            callback.onError(1, "no login");
                        }
                        return;
                    }
                    String tenantId = ChatClient.getInstance().tenantId();
                    if (TextUtils.isEmpty((CharSequence)tenantId)) {
                        if (callback != null) {
                            callback.onError(1, "tenantId is null");
                        }
                        return;
                    }
                    try {
                        StringBuilder urlStrBuilder = new StringBuilder();
                        String host = ChatClient.getInstance().kefuRestServer();
                        urlStrBuilder.append(host).append("/v1/webimplugin/emoj/tenants/").append(tenantId).append("/files");
                        String remoteUrl = urlStrBuilder.toString();
                        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                        HttpRequestBuilder requestBuilder = httpClient.get(remoteUrl);
                        requestBuilder.header("Authorization", "Easemob IM " + ChatClient.getInstance().accessToken());
                        requestBuilder.header("Content-Type", "application/json");
                        HttpResponse httpResponse = requestBuilder.execute();
                        assert (httpResponse != null);
                        int statusCode = httpResponse.getStatusCode();
                        if (statusCode == 200) {
                            StringBuffer sb = new StringBuffer();
                            httpResponse.read(sb);
                            if (callback != null) {
                                callback.onSuccess(sb.toString());
                            }
                        } else if (callback != null) {
                            callback.onError(1, "statusCode:" + statusCode);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (callback == null) break block11;
                        callback.onError(1, e.getMessage());
                    }
                }
            }
        });
    }

    private void getAllEmojiiconPackages(final ValueCallBack<String> callback) {
        this.requestService.submit(new Runnable(){

            @Override
            public void run() {
                block11: {
                    if (!ChatClient.getInstance().isLoggedInBefore()) {
                        if (callback != null) {
                            callback.onError(1, "no login");
                        }
                        return;
                    }
                    String tenantId = ChatClient.getInstance().tenantId();
                    if (TextUtils.isEmpty((CharSequence)tenantId)) {
                        if (callback != null) {
                            callback.onError(1, "tenantId is null");
                        }
                        return;
                    }
                    try {
                        StringBuilder urlStrBuilder = new StringBuilder();
                        String host = ChatClient.getInstance().kefuRestServer();
                        urlStrBuilder.append(host).append("/v1/webimplugin/emoj/tenants/").append(tenantId).append("/packages");
                        String remoteUrl = urlStrBuilder.toString();
                        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                        HttpRequestBuilder requestBuilder = httpClient.get(remoteUrl);
                        requestBuilder.header("Authorization", "Easemob IM " + ChatClient.getInstance().accessToken());
                        requestBuilder.header("Content-Type", "application/json");
                        HttpResponse httpResponse = requestBuilder.execute();
                        assert (httpResponse != null);
                        int statusCode = httpResponse.getStatusCode();
                        if (statusCode == 200) {
                            StringBuffer sb = new StringBuffer();
                            httpResponse.read(sb);
                            if (callback != null) {
                                callback.onSuccess(sb.toString());
                            }
                        } else if (callback != null) {
                            callback.onError(1, "statusCode:" + statusCode);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (callback == null) break block11;
                        callback.onError(1, e.getMessage());
                    }
                }
            }
        });
    }

    private void getEmojiiconPackageFile(final int packageId, final ValueCallBack<String> callback) {
        this.requestService.submit(new Runnable(){

            @Override
            public void run() {
                block11: {
                    if (!ChatClient.getInstance().isLoggedInBefore()) {
                        if (callback != null) {
                            callback.onError(1, "no login");
                        }
                        return;
                    }
                    String tenantId = ChatClient.getInstance().tenantId();
                    if (TextUtils.isEmpty((CharSequence)tenantId)) {
                        if (callback != null) {
                            callback.onError(1, "tenantId is null");
                        }
                        return;
                    }
                    try {
                        StringBuilder urlStrBuilder = new StringBuilder();
                        String host = ChatClient.getInstance().kefuRestServer();
                        urlStrBuilder.append(host).append("/v1/webimplugin/emoj/tenants/").append(tenantId).append("/packages/").append(packageId).append("/files");
                        String remoteUrl = urlStrBuilder.toString();
                        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                        HttpRequestBuilder requestBuilder = httpClient.get(remoteUrl);
                        requestBuilder.header("Authorization", "Easemob IM " + ChatClient.getInstance().accessToken());
                        requestBuilder.header("Content-Type", "application/json");
                        HttpResponse httpResponse = requestBuilder.execute();
                        assert (httpResponse != null);
                        int statusCode = httpResponse.getStatusCode();
                        if (statusCode == 200) {
                            StringBuffer sb = new StringBuffer();
                            httpResponse.read(sb);
                            if (callback != null) {
                                callback.onSuccess(sb.toString());
                            }
                        } else if (callback != null) {
                            callback.onError(1, "statusCode:" + statusCode);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (callback == null) break block11;
                        callback.onError(1, e.getMessage());
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareDownloadAllIcons() {
        if (this.iconsJsonNew != null && !this.iconsJsonNew.equals(this.iconsJson)) {
            this.downloadQueue.clear();
            if (this.iconList.size() != 0) {
                for (EmojiconEntity entity : this.iconList) {
                    this.downloadQueue.add(entity.origin);
                    this.downloadQueue.add(entity.thumbnail);
                }
                this.notifyDelegateEmojiconChanged();
            }
            this.downloadNextIcons();
        } else {
            if (this.packagesJsonNew != null && !this.packagesJsonNew.equals(this.packagesJson)) {
                this.notifyDelegateEmojiconChanged();
            }
            EmojiconManager emojiconManager = this;
            synchronized (emojiconManager) {
                String tenantId = ChatClient.getInstance().tenantId();
                ChatClient.getInstance().deleteEmojiconInfo(tenantId);
                ChatClient.getInstance().addEmojiconInfo(tenantId, this.iconsJsonNew, this.packagesJsonNew);
                this.refleshing = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadNextIcons() {
        if (this.downloadQueue.size() == 0) {
            EmojiconManager emojiconManager = this;
            synchronized (emojiconManager) {
                String tenantId = ChatClient.getInstance().tenantId();
                ChatClient.getInstance().deleteEmojiconInfo(tenantId);
                ChatClient.getInstance().addEmojiconInfo(tenantId, this.iconsJsonNew, this.packagesJsonNew);
                this.refleshing = false;
            }
            return;
        }
        final Url requestUrl = this.downloadQueue.poll();
        this.downloadFiles(requestUrl, new ValueCallBack<String>(){

            @Override
            public void onSuccess(String value) {
                EmojiconManager.this.downloadNextIcons();
            }

            @Override
            public void onError(int error, String errorMsg) {
                EmojiconManager.this.downloadFiles(requestUrl, new ValueCallBack<String>(){

                    @Override
                    public void onSuccess(String value) {
                        EmojiconManager.this.downloadNextIcons();
                    }

                    @Override
                    public void onError(int error, String errorMsg) {
                        Log.e((String)EmojiconManager.TAG, (String)("onError: downloadIcons Failed requestUrl = " + requestUrl.remoteUrl + " errpr = " + error + " errorMsg = " + errorMsg));
                        EmojiconManager.this.downloadNextIcons();
                    }
                });
            }
        });
    }

    public void downloadFiles(final Url requestUrl, final ValueCallBack<String> callback) {
        if (TextUtils.isEmpty((CharSequence)requestUrl.remoteUrl) || TextUtils.isEmpty((CharSequence)requestUrl.localUrl)) {
            return;
        }
        final File localFile = new File(requestUrl.localUrl);
        if (localFile.exists()) {
            if (callback != null) {
                callback.onSuccess("");
            }
            return;
        }
        final File tempLocalFile = new File(localFile.getParent(), "tmp_" + localFile.getName());
        this.requestService.execute(new Runnable(){

            @Override
            public void run() {
                block8: {
                    HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                    HttpRequestBuilder requestBuilder = httpClient.get(requestUrl.remoteUrl);
                    try {
                        requestBuilder.to(tempLocalFile);
                        HttpResponse httpResponse = requestBuilder.execute();
                        if (httpResponse == null) {
                            if (callback != null) {
                                callback.onError(403, "rfile download failed");
                            }
                            return;
                        }
                        int status = httpResponse.getStatusCode();
                        if (status / 100 == 2) {
                            tempLocalFile.renameTo(localFile);
                            if (callback != null) {
                                callback.onSuccess("");
                            }
                        } else if (callback != null) {
                            callback.onError(403, "file download failed");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (callback == null) break block8;
                        callback.onError(403, "file download failed");
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyDelegateEmojiconChanged() {
        List<EmojiconManagerDelegate> list = this.delegates;
        synchronized (list) {
            for (EmojiconManagerDelegate item : this.delegates) {
                if (item == null) continue;
                item.onEmojiconChanged();
            }
        }
    }

    public void addDelegate(EmojiconManagerDelegate listener) {
        if (!this.delegates.contains(listener)) {
            this.delegates.add(listener);
        }
    }

    public void removeDelegate(EmojiconManagerDelegate listener) {
        if (this.delegates.contains(listener)) {
            this.delegates.remove(listener);
        }
    }

    public static class EmojiconEntity {
        public int id = -1;
        public int packageId = -1;
        public String fileName = "";
        public Url origin = new Url();
        public Url thumbnail = new Url();
    }

    public static class EmojiconPackage {
        public int id = -1;
        public String packageName = "";
        public int fileNum = 0;
        public int orderSQ = -1;
        public String creatorId = "";
    }

    public static class Url {
        public String remoteUrl = "";
        public String localUrl = "";
    }

    public static interface EmojiconManagerDelegate {
        public void onEmojiconChanged();
    }
}

