/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.helpdesk.manager;

import android.text.TextUtils;
import com.hyphenate.chat.ChatClient;
import com.hyphenate.chat.EMClient;
import com.hyphenate.helpdesk.callback.ValueCallBack;
import com.hyphenate.helpdesk.httpclient.HttpClient;
import com.hyphenate.helpdesk.httpclient.HttpRequestBuilder;
import com.hyphenate.helpdesk.httpclient.HttpResponse;
import java.net.URLEncoder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TicketManager {
    private static TicketManager instance;
    private ExecutorService requestService = Executors.newCachedThreadPool();

    public static synchronized TicketManager getInstance() {
        if (instance == null) {
            instance = new TicketManager();
        }
        return instance;
    }

    public void getLeaveMsgDetail(final String projectId, final String targetUser, final String ticketId, final ValueCallBack<String> callback) {
        this.requestService.submit(new Runnable(){

            @Override
            public void run() {
                block11: {
                    if (!ChatClient.getInstance().isLoggedInBefore()) {
                        if (callback != null) {
                            callback.onError(1, "no login");
                        }
                        return;
                    }
                    String tenantId = ChatClient.getInstance().tenantId();
                    if (TextUtils.isEmpty((CharSequence)tenantId)) {
                        if (callback != null) {
                            callback.onError(1, "tenantId is null");
                        }
                        return;
                    }
                    String appkey = ChatClient.getInstance().appKey();
                    String loginUser = ChatClient.getInstance().currentUserName();
                    try {
                        StringBuilder urlStrBuilder = new StringBuilder();
                        String host = ChatClient.getInstance().kefuRestServer();
                        urlStrBuilder.append(host).append("/tenants/").append(tenantId).append("/projects/").append(projectId).append("/tickets/").append(ticketId).append("?easemob-appkey=").append(URLEncoder.encode(appkey, "UTF-8")).append("&");
                        urlStrBuilder.append("easemob-target-username=").append(targetUser).append("&");
                        urlStrBuilder.append("easemob-username=").append(loginUser);
                        String remoteUrl = urlStrBuilder.toString();
                        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                        HttpRequestBuilder requestBuilder = httpClient.get(remoteUrl);
                        requestBuilder.header("Authorization", "Easemob IM " + ChatClient.getInstance().accessToken());
                        requestBuilder.header("Content-Type", "application/json");
                        HttpResponse httpResponse = requestBuilder.execute();
                        assert (httpResponse != null);
                        int statusCode = httpResponse.getStatusCode();
                        if (statusCode == 200) {
                            StringBuffer sb = new StringBuffer();
                            httpResponse.read(sb);
                            if (callback != null) {
                                callback.onSuccess(sb.toString());
                            }
                        } else if (callback != null) {
                            callback.onError(1, "statusCode:" + statusCode);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (callback == null) break block11;
                        callback.onError(1, e.getMessage());
                    }
                }
            }
        });
    }

    public void getLeaveMsgs(final String projectId, final String targetUser, final int page, final int pageSize, final ValueCallBack<String> callback) {
        this.requestService.submit(new Runnable(){

            @Override
            public void run() {
                block11: {
                    if (!ChatClient.getInstance().isLoggedInBefore()) {
                        if (callback != null) {
                            callback.onError(1, "no login");
                        }
                        return;
                    }
                    String tenantId = ChatClient.getInstance().tenantId();
                    if (TextUtils.isEmpty((CharSequence)tenantId)) {
                        if (callback != null) {
                            callback.onError(1, "tenantId is null");
                        }
                        return;
                    }
                    String appkey = ChatClient.getInstance().appKey();
                    String loginUser = ChatClient.getInstance().currentUserName();
                    try {
                        StringBuilder urlStrBuilder = new StringBuilder();
                        String host = ChatClient.getInstance().kefuRestServer();
                        urlStrBuilder.append(host).append("/tenants/").append(tenantId).append("/projects/").append(projectId).append("/tickets?easemob-appkey=").append(URLEncoder.encode(appkey, "UTF-8")).append("&");
                        urlStrBuilder.append("easemob-target-username=").append(targetUser).append("&");
                        urlStrBuilder.append("easemob-username=").append(loginUser).append("&");
                        urlStrBuilder.append("page=").append(page).append("&").append("size=").append(pageSize);
                        String remoteUrl = urlStrBuilder.toString();
                        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                        HttpRequestBuilder requestBuilder = httpClient.get(remoteUrl);
                        requestBuilder.header("Authorization", "Easemob IM " + ChatClient.getInstance().accessToken());
                        requestBuilder.header("Content-Type", "application/json");
                        HttpResponse httpResponse = requestBuilder.execute();
                        assert (httpResponse != null);
                        int statusCode = httpResponse.getStatusCode();
                        if (statusCode == 200) {
                            StringBuffer sb = new StringBuffer();
                            httpResponse.read(sb);
                            if (callback != null) {
                                callback.onSuccess(sb.toString());
                            }
                        } else if (callback != null) {
                            callback.onError(1, "statusCode:" + statusCode);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (callback == null) break block11;
                        callback.onError(1, e.getMessage());
                    }
                }
            }
        });
    }

    @Deprecated
    public void getTickets(String projectId, String targetUser, int page, int pageSize, ValueCallBack<String> callback) {
        this.getLeaveMsgs(projectId, targetUser, page, pageSize, callback);
    }

    public void createLeaveMsg(final String postContent, final String projectId, final String imUser, final ValueCallBack<String> callback) {
        this.requestService.submit(new Runnable(){

            @Override
            public void run() {
                block12: {
                    if (!ChatClient.getInstance().isLoggedInBefore()) {
                        if (callback != null) {
                            callback.onError(1, "no login");
                        }
                        return;
                    }
                    String tenantId = ChatClient.getInstance().tenantId();
                    if (TextUtils.isEmpty((CharSequence)tenantId)) {
                        if (callback != null) {
                            callback.onError(1, "tenantId is null");
                        }
                        return;
                    }
                    String appkey = ChatClient.getInstance().appKey();
                    String loginUser = ChatClient.getInstance().currentUserName();
                    try {
                        StringBuilder urlStrBuilder = new StringBuilder();
                        String host = ChatClient.getInstance().kefuRestServer();
                        urlStrBuilder.append(host).append("/tenants/").append(tenantId).append("/projects/").append(projectId).append("/tickets?easemob-appkey=").append(URLEncoder.encode(appkey, "UTF-8")).append("&");
                        urlStrBuilder.append("easemob-target-username=").append(imUser).append("&");
                        urlStrBuilder.append("easemob-username=").append(loginUser);
                        String remoteUrl = urlStrBuilder.toString();
                        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                        HttpRequestBuilder requestBuilder = httpClient.post(remoteUrl);
                        requestBuilder.header("Authorization", "Easemob IM " + ChatClient.getInstance().accessToken());
                        requestBuilder.header("Content-Type", "application/json");
                        if (postContent != null) {
                            requestBuilder.content(postContent.getBytes(), "application/json");
                        }
                        HttpResponse httpResponse = requestBuilder.execute();
                        assert (httpResponse != null);
                        int statusCode = httpResponse.getStatusCode();
                        if (statusCode == 200) {
                            StringBuffer sb = new StringBuffer();
                            httpResponse.read(sb);
                            if (callback != null) {
                                callback.onSuccess(sb.toString());
                            }
                        } else if (callback != null) {
                            callback.onError(1, "statusCode:" + statusCode);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (callback == null) break block12;
                        callback.onError(1, e.getMessage());
                    }
                }
            }
        });
    }

    @Deprecated
    public void createLeaveMessage(String postContent, String projectId, String imUser, ValueCallBack<String> callback) {
        this.createLeaveMsg(postContent, projectId, imUser, callback);
    }

    @Deprecated
    public void getComments(String projectId, String ticketId, String targetUser, ValueCallBack<String> callback) {
        this.getComments(projectId, ticketId, targetUser, callback, 0, 100);
    }

    public void getLeaveMsgComments(final String projectId, final String ticketId, final String targetUser, final ValueCallBack<String> callback, final int page, final int size) {
        this.requestService.submit(new Runnable(){

            @Override
            public void run() {
                block11: {
                    if (!ChatClient.getInstance().isLoggedInBefore()) {
                        if (callback != null) {
                            callback.onError(1, "no login");
                        }
                        return;
                    }
                    String tenantId = ChatClient.getInstance().tenantId();
                    if (TextUtils.isEmpty((CharSequence)tenantId)) {
                        if (callback != null) {
                            callback.onError(1, "tenantId is null");
                        }
                        return;
                    }
                    String appkey = ChatClient.getInstance().appKey();
                    String loginUser = ChatClient.getInstance().currentUserName();
                    try {
                        StringBuilder urlStrBuilder = new StringBuilder();
                        String host = ChatClient.getInstance().kefuRestServer();
                        urlStrBuilder.append(host).append("/tenants/").append(tenantId).append("/projects/").append(projectId).append("/tickets/").append(ticketId).append("/comments").append("?");
                        urlStrBuilder.append("page=").append(page).append("&size=").append(size).append("&sort=createdAt,desc&");
                        urlStrBuilder.append("easemob-appkey=").append(URLEncoder.encode(appkey, "UTF-8")).append("&");
                        urlStrBuilder.append("easemob-target-username=").append(targetUser).append("&");
                        urlStrBuilder.append("easemob-username=").append(loginUser);
                        String remoteUrl = urlStrBuilder.toString();
                        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                        HttpRequestBuilder requestBuilder = httpClient.get(remoteUrl);
                        requestBuilder.header("Authorization", "Easemob IM " + ChatClient.getInstance().accessToken());
                        requestBuilder.header("Content-Type", "application/json");
                        HttpResponse httpResponse = requestBuilder.execute();
                        assert (httpResponse != null);
                        int statusCode = httpResponse.getStatusCode();
                        if (statusCode == 200) {
                            StringBuffer sb = new StringBuffer();
                            httpResponse.read(sb);
                            if (callback != null) {
                                callback.onSuccess(sb.toString());
                            }
                        } else if (callback != null) {
                            callback.onError(1, "statusCode:" + statusCode);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (callback == null) break block11;
                        callback.onError(1, e.getMessage());
                    }
                }
            }
        });
    }

    @Deprecated
    public void getComments(String projectId, String ticketId, String targetUser, ValueCallBack<String> callback, int page, int size) {
        this.getLeaveMsgComments(projectId, ticketId, targetUser, callback, page, size);
    }

    public void createLeaveMsgComment(final String projectId, final String ticketId, final String targetUser, final String newCommentBodyJson, final ValueCallBack<String> callback) {
        this.requestService.submit(new Runnable(){

            @Override
            public void run() {
                block12: {
                    if (!ChatClient.getInstance().isLoggedInBefore()) {
                        if (callback != null) {
                            callback.onError(1, "no login");
                        }
                        return;
                    }
                    String tenantId = ChatClient.getInstance().tenantId();
                    if (TextUtils.isEmpty((CharSequence)tenantId)) {
                        if (callback != null) {
                            callback.onError(1, "tenantId is null");
                        }
                        return;
                    }
                    String appkey = ChatClient.getInstance().appKey();
                    String loginUser = ChatClient.getInstance().currentUserName();
                    try {
                        StringBuilder urlStrBuilder = new StringBuilder();
                        String host = ChatClient.getInstance().kefuRestServer();
                        urlStrBuilder.append(host).append("/tenants/").append(tenantId).append("/projects/").append(projectId).append("/tickets/").append(ticketId).append("/comments");
                        urlStrBuilder.append("?easemob-appkey=").append(URLEncoder.encode(appkey, "UTF-8")).append("&");
                        urlStrBuilder.append("easemob-target-username=").append(targetUser).append("&");
                        urlStrBuilder.append("easemob-username=").append(loginUser);
                        String remoteUrl = urlStrBuilder.toString();
                        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                        HttpRequestBuilder requestBuilder = httpClient.post(remoteUrl);
                        requestBuilder.header("Authorization", "Easemob IM " + ChatClient.getInstance().accessToken());
                        requestBuilder.header("Content-Type", "application/json");
                        if (newCommentBodyJson != null) {
                            requestBuilder.content(newCommentBodyJson.getBytes(), "application/json");
                        }
                        HttpResponse httpResponse = requestBuilder.execute();
                        assert (httpResponse != null);
                        int statusCode = httpResponse.getStatusCode();
                        if (statusCode == 200) {
                            StringBuffer sb = new StringBuffer();
                            httpResponse.read(sb);
                            if (callback != null) {
                                callback.onSuccess(sb.toString());
                            }
                        } else if (callback != null) {
                            callback.onError(1, "statusCode:" + statusCode);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (callback == null) break block12;
                        callback.onError(1, e.getMessage());
                    }
                }
            }
        });
    }

    @Deprecated
    public void createComment(String projectId, String ticketId, String targetUser, String newCommentBodyJson, ValueCallBack<String> callback) {
        this.createLeaveMsgComment(projectId, ticketId, targetUser, newCommentBodyJson, callback);
    }

    public void getWorkStatus(final String customer_account, final ValueCallBack<String> callback) {
        this.getChannelsId(new ValueCallBack<String>(){

            @Override
            public void onSuccess(String value) {
                String appkey = ChatClient.getInstance().appKey();
                try {
                    JSONArray jsonArray = new JSONArray(value);
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        JSONObject obj = jsonArray.getJSONObject(i);
                        String tempChannelId = obj.getString("channelId");
                        String tempImServiceNumber = obj.getString("imServiceNumber");
                        String tempOrgName = obj.getString("orgName");
                        String tempAppName = obj.getString("appName");
                        if (!tempImServiceNumber.equals(customer_account) || !(tempOrgName + "#" + tempAppName).equals(appkey)) continue;
                        TicketManager.this.getWorkStatusByChannelId(tempChannelId, callback);
                        return;
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    if (callback != null) {
                        callback.onError(1, e.getMessage());
                    }
                    return;
                }
                if (callback != null) {
                    callback.onError(1, "customer_account is not correct");
                }
            }

            @Override
            public void onError(int error, String errorMsg) {
                if (callback != null) {
                    callback.onError(error, errorMsg);
                }
            }
        });
    }

    @Deprecated
    public void getWorkStatus(final ValueCallBack<String> callback) {
        this.requestService.submit(new Runnable(){

            @Override
            public void run() {
                block11: {
                    if (!ChatClient.getInstance().isLoggedInBefore()) {
                        if (callback != null) {
                            callback.onError(1, "no login");
                        }
                        return;
                    }
                    String tenantId = ChatClient.getInstance().tenantId();
                    if (TextUtils.isEmpty((CharSequence)tenantId)) {
                        if (callback != null) {
                            callback.onError(1, "tenantId is null");
                        }
                        return;
                    }
                    try {
                        StringBuilder urlStrBuilder = new StringBuilder();
                        String host = ChatClient.getInstance().kefuRestServer();
                        urlStrBuilder.append(host).append("/v1/webimplugin/showMessage?tenantId=").append(tenantId);
                        String remoteUrl = urlStrBuilder.toString();
                        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                        HttpRequestBuilder requestBuilder = httpClient.get(remoteUrl);
                        requestBuilder.header("Authorization", "Easemob IM " + ChatClient.getInstance().accessToken());
                        requestBuilder.header("Content-Type", "application/json");
                        HttpResponse httpResponse = requestBuilder.execute();
                        assert (httpResponse != null);
                        int statusCode = httpResponse.getStatusCode();
                        if (statusCode == 200) {
                            StringBuffer sb = new StringBuffer();
                            httpResponse.read(sb);
                            if (callback != null) {
                                callback.onSuccess(sb.toString());
                            }
                        } else if (callback != null) {
                            callback.onError(1, "statusCode:" + statusCode);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (callback == null) break block11;
                        callback.onError(1, e.getMessage());
                    }
                }
            }
        });
    }

    void getChannelsId(final ValueCallBack<String> callback) {
        this.requestService.submit(new Runnable(){

            @Override
            public void run() {
                block11: {
                    if (!ChatClient.getInstance().isLoggedInBefore()) {
                        if (callback != null) {
                            callback.onError(1, "no login");
                        }
                        return;
                    }
                    String tenantId = ChatClient.getInstance().tenantId();
                    if (TextUtils.isEmpty((CharSequence)tenantId)) {
                        if (callback != null) {
                            callback.onError(1, "tenantId is null");
                        }
                        return;
                    }
                    try {
                        StringBuilder urlStrBuilder = new StringBuilder();
                        String host = ChatClient.getInstance().kefuRestServer();
                        urlStrBuilder.append(host).append("/v1/webimplugin/targetChannels?tenantId=").append(tenantId);
                        String remoteUrl = urlStrBuilder.toString();
                        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                        HttpRequestBuilder requestBuilder = httpClient.get(remoteUrl);
                        requestBuilder.header("Authorization", "Easemob IM " + ChatClient.getInstance().accessToken());
                        requestBuilder.header("Content-Type", "application/json");
                        HttpResponse httpResponse = requestBuilder.execute();
                        assert (httpResponse != null);
                        int statusCode = httpResponse.getStatusCode();
                        if (statusCode == 200) {
                            StringBuffer sb = new StringBuffer();
                            httpResponse.read(sb);
                            if (callback != null) {
                                callback.onSuccess(sb.toString());
                            }
                        } else if (callback != null) {
                            callback.onError(1, "statusCode:" + statusCode);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (callback == null) break block11;
                        callback.onError(1, e.getMessage());
                    }
                }
            }
        });
    }

    void getWorkStatusByChannelId(final String channelId, final ValueCallBack<String> callback) {
        this.requestService.submit(new Runnable(){

            @Override
            public void run() {
                block11: {
                    if (!ChatClient.getInstance().isLoggedInBefore()) {
                        if (callback != null) {
                            callback.onError(1, "no login");
                        }
                        return;
                    }
                    String tenantId = ChatClient.getInstance().tenantId();
                    if (TextUtils.isEmpty((CharSequence)tenantId)) {
                        if (callback != null) {
                            callback.onError(1, "tenantId is null");
                        }
                        return;
                    }
                    try {
                        StringBuilder urlStrBuilder = new StringBuilder();
                        String host = ChatClient.getInstance().kefuRestServer();
                        urlStrBuilder.append(host).append("/v1/webimplugin/tenants/show-message?channelType=easemob&originType=app&").append("channelId=").append(channelId).append("&").append("tenantId=").append(tenantId);
                        String remoteUrl = urlStrBuilder.toString();
                        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                        HttpRequestBuilder requestBuilder = httpClient.get(remoteUrl);
                        requestBuilder.header("Authorization", "Easemob IM " + ChatClient.getInstance().accessToken());
                        requestBuilder.header("Content-Type", "application/json");
                        HttpResponse httpResponse = requestBuilder.execute();
                        assert (httpResponse != null);
                        int statusCode = httpResponse.getStatusCode();
                        if (statusCode == 200) {
                            StringBuffer sb = new StringBuffer();
                            httpResponse.read(sb);
                            JSONObject obj = new JSONObject(sb.toString());
                            if (callback != null) {
                                callback.onSuccess(obj.getString("entity"));
                            }
                        } else if (callback != null) {
                            callback.onError(1, "statusCode:" + statusCode);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (callback == null) break block11;
                        callback.onError(1, e.getMessage());
                    }
                }
            }
        });
    }
}

