/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.helpdesk.model;

import android.text.TextUtils;
import com.hyphenate.chat.ChatClient;
import com.hyphenate.chat.ChatManager;
import com.hyphenate.chat.EMCmdMessageBody;
import com.hyphenate.chat.EMTextMessageBody;
import com.hyphenate.chat.Message;
import com.hyphenate.exceptions.HyphenateException;
import com.hyphenate.helpdesk.callback.Callback;
import com.hyphenate.helpdesk.model.AgentInfo;
import com.hyphenate.helpdesk.model.ArticlesInfo;
import com.hyphenate.helpdesk.model.ContentFactory;
import com.hyphenate.helpdesk.model.ControlMessage;
import com.hyphenate.helpdesk.model.EvaluationInfo;
import com.hyphenate.helpdesk.model.FormInfo;
import com.hyphenate.helpdesk.model.OrderInfo;
import com.hyphenate.helpdesk.model.RobotMenuInfo;
import com.hyphenate.helpdesk.model.ToCustomServiceInfo;
import com.hyphenate.helpdesk.model.TransferGuideMenuInfo;
import com.hyphenate.helpdesk.model.TransferIndication;
import com.hyphenate.helpdesk.model.VisitorTrack;
import com.hyphenate.helpdesk.util.Log;
import com.hyphenate.util.EMLog;
import java.util.List;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MessageHelper {
    private static final String TAG = "MessageHelper";
    private static final boolean DEBUG = false;
    public static final String TAG_ROOT = "ext";
    public static final String TAG_MSGTYPE = "msgtype";
    public static final String TAG_WEICHAT = "weichat";
    static final String MESSAGE_ATTR_IS_BIG_EXPRESSION = "em_is_big_expression";
    static final String TRANSFER_INDICATION_ACTION = "transfer";
    static final String MODE_TRANSFER_GUIDE = "transferManualGuide";

    public static ExtMsgType getMessageExtType(Message message) {
        if (MessageHelper.getRichText(message)) {
            return ExtMsgType.RichText;
        }
        if (MessageHelper.getRootRichText(message)) {
            return ExtMsgType.RootRichText;
        }
        if (MessageHelper.getEvalRequest(message) != null) {
            return ExtMsgType.EvaluationMsg;
        }
        if (MessageHelper.getOrderInfo(message) != null) {
            return ExtMsgType.OrderMsg;
        }
        if (MessageHelper.getVisitorTrack(message) != null) {
            return ExtMsgType.TrackMsg;
        }
        if (MessageHelper.isFormMessage(message)) {
            return ExtMsgType.FormMsg;
        }
        if (MessageHelper.getRobotMenu(message) != null && !MessageHelper.isTransferGuideMenu(message)) {
            return ExtMsgType.RobotMenuMsg;
        }
        if (message.isCommentInvite()) {
            return ExtMsgType.RobotCommentInviteMsg;
        }
        if (MessageHelper.getTransferGuideMenu(message) != null) {
            return ExtMsgType.TransferGuideMenuMsg;
        }
        if (MessageHelper.isArticlesMessage(message)) {
            return ExtMsgType.ArticlesMsg;
        }
        if (message.getBooleanAttribute(MESSAGE_ATTR_IS_BIG_EXPRESSION, false)) {
            return ExtMsgType.BigExpressionMsg;
        }
        if (!TextUtils.isEmpty((CharSequence)MessageHelper.getCustomEmojiMessage(message))) {
            return ExtMsgType.CustomEmojiMsg;
        }
        if (MessageHelper.getToCustomServiceInfo(message) != null) {
            return ExtMsgType.ToCustomServiceMsg;
        }
        return ExtMsgType.GeneralMsg;
    }

    public static boolean getVecHtml(Message message) {
        try {
            JSONObject msgtype = message.getJSONObjectAttribute(TAG_MSGTYPE);
            if (msgtype != null && (msgtype.toString().contains("vechtml") || msgtype.toString().contains("vecHtml") || msgtype.toString().contains("VecHtml"))) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static boolean getRichText(Message message) {
        return message.body().toString().contains("richtext");
    }

    private static boolean getRootRichText(Message message) {
        return message.body().toString().contains("richText");
    }

    public static JSONObject getContainerObject(Message message, String tag) {
        JSONObject obj = null;
        try {
            if (message != null) {
                obj = message.getJSONObjectAttribute(tag);
            }
        }
        catch (HyphenateException hyphenateException) {
            // empty catch block
        }
        return obj;
    }

    public static EvaluationInfo getEvalRequest(Message message) {
        JSONObject content;
        String ctrlType;
        EvaluationInfo info = null;
        JSONObject jsonObject = MessageHelper.getContainerObject(message, TAG_WEICHAT);
        if (jsonObject != null && (ctrlType = MessageHelper.getString(jsonObject, "ctrlType")) != null && ctrlType.equals("inviteEnquiry") && (content = MessageHelper.getJSONObject(jsonObject, "ctrlArgs")) != null) {
            info = ContentFactory.createEvaluationInfo(content);
        }
        return info;
    }

    public void getSessionIdFromMessage() {
    }

    public static RobotMenuInfo getRobotMenu(Message message) {
        RobotMenuInfo menuInfo = null;
        JSONObject content = MessageHelper.extractObject(message, TAG_MSGTYPE, "choice", false);
        if (content != null) {
            menuInfo = ContentFactory.createRobotMenuInfo(content);
        }
        if (menuInfo != null && (menuInfo.has("items") || menuInfo.has("list"))) {
            return menuInfo;
        }
        return null;
    }

    public static TransferGuideMenuInfo getTransferGuideMenu(Message message) {
        TransferGuideMenuInfo menuInfo = null;
        JSONObject content = MessageHelper.extractObject(message, TAG_MSGTYPE, "choice", false);
        if (content != null) {
            menuInfo = ContentFactory.createTransferGuideMenuInfo(content);
        }
        if (menuInfo != null && menuInfo.has("mode") && (menuInfo.has("items") || menuInfo.has("list"))) {
            return menuInfo;
        }
        return null;
    }

    public static boolean isTransferGuideMenu(Message message) {
        JSONObject content = MessageHelper.extractObject(message, TAG_MSGTYPE, "choice", false);
        if (content != null) {
            TransferGuideMenuInfo menuInfo = MessageHelper.getTransferGuideMenu(message);
            String mode = "";
            if (menuInfo != null && menuInfo.getMode() != null && (mode = menuInfo.getMode()).equals(MODE_TRANSFER_GUIDE)) {
                return true;
            }
        }
        return false;
    }

    public static TransferIndication getTransferIndication(Message message) {
        JSONObject content;
        TransferIndication indication = null;
        if (MessageHelper.hasAction(message, TRANSFER_INDICATION_ACTION) && (content = MessageHelper.extractObject(message, TAG_WEICHAT, null, true)) != null && (indication = ContentFactory.createTransferIndication(content)).isNull()) {
            indication = null;
        }
        return indication;
    }

    public static AgentInfo getAgentInfo(Message message) {
        AgentInfo agentInfo = null;
        JSONObject content = MessageHelper.extractObject(message, TAG_WEICHAT, "agent", false);
        if (content != null) {
            agentInfo = ContentFactory.createAgentInfo(content);
        }
        return agentInfo;
    }

    public static ControlMessage getTransferToAgent(Message message) {
        return null;
    }

    public static OrderInfo getOrderInfo(Message message) {
        OrderInfo orderInfo = null;
        JSONObject content = MessageHelper.extractObject(message, TAG_MSGTYPE, "order", false);
        if (content != null) {
            orderInfo = ContentFactory.createOrderInfo(content);
        }
        if (orderInfo != null && orderInfo.getPrice() == null && orderInfo.getDesc() == null) {
            orderInfo = null;
        }
        return orderInfo;
    }

    public static VisitorTrack getVisitorTrack(Message message) {
        VisitorTrack visitorTrack = null;
        JSONObject content = MessageHelper.extractObject(message, TAG_MSGTYPE, "track", false);
        if (content != null) {
            visitorTrack = ContentFactory.createVisitorTrack(content);
        }
        if (visitorTrack != null && visitorTrack.getDesc() == null && visitorTrack.getPrice() == null) {
            visitorTrack = null;
        }
        return visitorTrack;
    }

    private static boolean hasAction(Message msg, String action) {
        EMCmdMessageBody body;
        return msg.getType() == Message.Type.CMD && (body = (EMCmdMessageBody)msg.body()).action().equals(action);
    }

    private static JSONObject extractObject(Message message, String parentName, String name, boolean isComposite) {
        JSONObject content = null;
        JSONObject container = MessageHelper.getContainerObject(message, parentName);
        if (!isComposite) {
            if (container != null) {
                if (container.isNull(name)) {
                    return null;
                }
                try {
                    content = container.getJSONObject(name);
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
            return content;
        }
        return container;
    }

    private static String extractString(Message message, String parentName, String name) {
        String content = null;
        JSONObject container = MessageHelper.getContainerObject(message, parentName);
        if (container != null) {
            try {
                content = container.getString(name);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return content;
    }

    public static ToCustomServiceInfo getToCustomServiceInfo(Message message) {
        ToCustomServiceInfo info = null;
        JSONObject jsonObject = MessageHelper.getContainerObject(message, TAG_WEICHAT);
        if (jsonObject != null) {
            String ctrlType = MessageHelper.getString(jsonObject, "ctrlType");
            JSONObject transferGroupInfo = MessageHelper.getJSONObject(jsonObject, "transferToHumanButtonInfo");
            if (ctrlType != null && ctrlType.equals("TransferToKfHint")) {
                JSONObject content = MessageHelper.getJSONObject(jsonObject, "ctrlArgs");
                if (transferGroupInfo != null) {
                    content = transferGroupInfo;
                }
                if (content != null) {
                    info = ContentFactory.createToCustomeServiceInfo(content);
                }
            }
        }
        return info;
    }

    public static ArticlesInfo getArticlesMessage(Message message) {
        ArticlesInfo articlesInfo = null;
        JSONObject content = MessageHelper.extractObject(message, TAG_MSGTYPE, null, true);
        if (content != null) {
            articlesInfo = ContentFactory.createArticlesInfo(content);
        }
        return articlesInfo;
    }

    public static boolean isArticlesMessage(Message message) {
        try {
            JSONArray articles;
            JSONObject msgtype = message.getJSONObjectAttribute(TAG_MSGTYPE);
            if (msgtype != null && (articles = msgtype.getJSONArray("articles")) != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static String getCustomEmojiMessage(Message message) {
        try {
            JSONObject customEmoji;
            JSONObject msgtype = message.getJSONObjectAttribute(TAG_MSGTYPE);
            if (msgtype != null && (customEmoji = msgtype.getJSONObject("customMagicEmoji")) != null && customEmoji.has("url")) {
                return customEmoji.getString("url");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static FormInfo getFormMessage(Message message) {
        FormInfo formInfo = null;
        JSONObject content = MessageHelper.extractObject(message, TAG_MSGTYPE, "html", false);
        if (content != null) {
            formInfo = ContentFactory.createFormInfo(content);
        }
        return formInfo;
    }

    public static boolean isFormMessage(Message message) {
        if (message.getStringAttribute("type", null) != null) {
            try {
                String type = message.getStringAttribute("type");
                if (type.equals("html/form")) {
                    return true;
                }
            }
            catch (HyphenateException hyphenateException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isNotificationMessage(Message message) {
        try {
            JSONObject weichatJson = message.getJSONObjectAttribute(TAG_WEICHAT);
            if (weichatJson != null && weichatJson.has("notification")) {
                return weichatJson.getBoolean("notification");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isTicketStatusChangedMessage(Message message) {
        try {
            String eventName;
            JSONObject eventJson;
            JSONObject weichatJson = message.getJSONObjectAttribute(TAG_WEICHAT);
            if (weichatJson != null && weichatJson.has("event") && (eventJson = weichatJson.getJSONObject("event")) != null && eventJson.has("eventName") && !TextUtils.isEmpty((CharSequence)(eventName = eventJson.getString("eventName"))) && (eventName.equals("TicketStatusChangedEvent") || eventName.equals("CommentCreatedEvent"))) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static JSONObject getJSONObject(JSONObject jsonObject, String name) {
        if (jsonObject.has(name) && !jsonObject.isNull(name)) {
            try {
                return jsonObject.getJSONObject(name);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return null;
    }

    private static String getString(JSONObject jsonObj, String name) {
        if (jsonObj.has(name) && !jsonObj.isNull(name)) {
            try {
                return jsonObj.getString(name);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return null;
    }

    public static void sendEvalMessage(Message message, String detail, EvaluationInfo.Degree degree, List<EvaluationInfo.TagInfo> selectedTags, final Callback callback) {
        EvaluationInfo evaluationInfo = MessageHelper.getEvalRequest(message);
        evaluationInfo.setResolutionParams(null, "");
        ControlMessage content = ContentFactory.createEvaluationResponse(evaluationInfo, detail, degree.getLevel(), degree.getId(), selectedTags);
        final Message messageToSend = Message.createTxtSendMessage("", message.from());
        messageToSend.addContent(content);
        ChatClient.getInstance().chatManager().sendMessage(messageToSend, new Callback(){

            @Override
            public void onSuccess() {
                ChatClient.getInstance().chatManager().getConversation(messageToSend.to()).removeMessage(messageToSend.messageId());
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            @Override
            public void onError(int code, String error) {
                ChatClient.getInstance().chatManager().getConversation(messageToSend.to()).removeMessage(messageToSend.messageId());
                if (callback != null) {
                    callback.onError(code, error);
                }
            }

            @Override
            public void onProgress(int progress, String status) {
            }
        });
    }

    public static void sendEvalMessage(Message message, String evaluateWay, String detail, EvaluationInfo.Degree degree, List<EvaluationInfo.TagInfo> selectedTags, List<EvaluationInfo.ResolutionParam> resolutionParams, final Callback callback) {
        EvaluationInfo evaluationInfo = MessageHelper.getEvalRequest(message);
        evaluationInfo.setResolutionParams(resolutionParams, evaluateWay);
        ControlMessage content = ContentFactory.createEvaluationResponse(evaluationInfo, detail, degree.getLevel(), degree.getId(), selectedTags);
        final Message messageToSend = Message.createTxtSendMessage("", message.from());
        messageToSend.addContent(content);
        try {
            String weichat = messageToSend.getStringAttribute(TAG_WEICHAT);
            Log.e(TAG, "weichat = " + weichat);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ChatClient.getInstance().chatManager().sendMessage(messageToSend, new Callback(){

            @Override
            public void onSuccess() {
                ChatClient.getInstance().chatManager().getConversation(messageToSend.to()).removeMessage(messageToSend.messageId());
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            @Override
            public void onError(int code, String error) {
                ChatClient.getInstance().chatManager().getConversation(messageToSend.to()).removeMessage(messageToSend.messageId());
                if (callback != null) {
                    callback.onError(code, error);
                }
            }

            @Override
            public void onProgress(int progress, String status) {
            }
        });
    }

    public static void sendEvalMessage(String msgId, String summary, String detail, final Callback callback) {
        Message message = ChatClient.getInstance().chatManager().getMessage(msgId);
        EvaluationInfo evaluationInfo = MessageHelper.getEvalRequest(message);
        int level = 5;
        try {
            level = Integer.parseInt(summary);
        }
        catch (NumberFormatException e) {
            try {
                level = (int)Float.parseFloat(summary);
            }
            catch (NumberFormatException err) {
                err.printStackTrace();
            }
        }
        ControlMessage content = ContentFactory.createEvaluationResponse(evaluationInfo, detail, level, -1, null);
        final Message messageToSend = Message.createTxtSendMessage("", message.from());
        messageToSend.addContent(content);
        ChatClient.getInstance().chatManager().sendMessage(messageToSend, new Callback(){

            @Override
            public void onSuccess() {
                ChatClient.getInstance().chatManager().getConversation(messageToSend.to()).removeMessage(messageToSend.messageId());
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            @Override
            public void onError(int code, String error) {
                ChatClient.getInstance().chatManager().getConversation(messageToSend.to()).removeMessage(messageToSend.messageId());
                if (callback != null) {
                    callback.onError(code, error);
                }
            }

            @Override
            public void onProgress(int progress, String status) {
            }
        });
    }

    public static Message createInviteCommentMsg(Message message, String content) {
        Message msg = null;
        if (message.isNeedToScore()) {
            EMLog.d(TAG, "createInviteCommentMsg");
            Message inviteMsg = Message.createReceiveMessage(Message.Type.TXT);
            inviteMsg.setMessageTime(message.getMsgTime() + 1L);
            EMTextMessageBody body = content == null || content.isEmpty() ? new EMTextMessageBody("\u8fd9\u6837\u56de\u7b54\u6709\u6ca1\u6709\u89e3\u51b3\u60a8\u7684\u95ee\u9898\u5462\uff1f") : new EMTextMessageBody(content);
            inviteMsg.addBody(body);
            inviteMsg.setFrom(message.getFrom());
            inviteMsg.setTo(message.getTo());
            inviteMsg.setMsgId(UUID.randomUUID().toString());
            try {
                JSONObject jsonObject = message.getJSONObjectAttribute(TAG_WEICHAT);
                if (jsonObject != null && jsonObject.has("extRobot")) {
                    JSONObject extRobot = jsonObject.getJSONObject("extRobot");
                    if (extRobot != null) {
                        extRobot.put("invite_comment", true);
                    }
                    jsonObject.put("extRobot", (Object)extRobot);
                    inviteMsg.setAttribute(TAG_WEICHAT, jsonObject);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            msg = inviteMsg;
            EMLog.d(TAG, "msg type: " + msg.isCommentInvite());
            ChatManager.getInstance().saveMessage(msg);
        }
        return msg;
    }

    public static Message createCommentSuccessMsg(Message message, String content) {
        Message commentSuccess = null;
        if (message.isCommentInvite()) {
            commentSuccess = Message.createReceiveMessage(Message.Type.TXT);
            commentSuccess.setMessageTime(message.getMsgTime() + 1L);
            EMTextMessageBody body = content == null || content.isEmpty() ? new EMTextMessageBody("\u8bc4\u4ef7\u6210\u529f\uff0c\u611f\u8c22\u60a8\u5bf9\u6211\u4eec\u5de5\u4f5c\u7684\u652f\u6301\uff01") : new EMTextMessageBody(content);
            commentSuccess.addBody(body);
            commentSuccess.setFrom(message.getFrom());
            commentSuccess.setTo(message.getTo());
            commentSuccess.setMsgId(UUID.randomUUID().toString());
            try {
                JSONObject extRobot;
                JSONObject jsonObject = new JSONObject(message.getJSONObjectAttribute(TAG_WEICHAT).toString());
                if (jsonObject != null && jsonObject.has("extRobot") && (extRobot = jsonObject.getJSONObject("extRobot")) != null && extRobot.has("invite_comment")) {
                    extRobot.remove("invite_comment");
                    jsonObject.put("extRobot", (Object)extRobot);
                }
                commentSuccess.setAttribute(TAG_WEICHAT, jsonObject);
            }
            catch (Exception e) {
                EMLog.e(TAG, e.getMessage());
            }
            ChatManager.getInstance().saveMessage(commentSuccess);
        }
        return commentSuccess;
    }

    public static enum ExtMsgType {
        EvaluationMsg,
        OrderMsg,
        TrackMsg,
        FormMsg,
        RobotMenuMsg,
        RobotCommentInviteMsg,
        TransferGuideMenuMsg,
        ArticlesMsg,
        ToCustomServiceMsg,
        BigExpressionMsg,
        CustomEmojiMsg,
        RichText,
        VecHtml,
        RootRichText,
        GeneralMsg;

    }
}

