/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.helpdesk.model;

import com.hyphenate.helpdesk.model.AgentInfo;
import com.hyphenate.helpdesk.model.CompositeContent;
import com.hyphenate.helpdesk.model.ContentFactory;
import com.hyphenate.helpdesk.model.Event;
import com.hyphenate.helpdesk.util.Log;
import org.json.JSONException;
import org.json.JSONObject;

public class TransferIndication
extends CompositeContent {
    private static final String TAG = "TransferIndication";
    public static final String PARENT_NAME = "weichat";
    private AgentInfo agentInfo;
    private Event event;

    TransferIndication() {
        this.agentInfo = ContentFactory.createAgentInfo(null);
        this.event = ContentFactory.createEvent(null);
        this.fillContents();
    }

    TransferIndication(JSONObject jsonObj) {
        try {
            String key = ContentFactory.createAgentInfo(null).getName();
            this.agentInfo = ContentFactory.createAgentInfo(jsonObj.getJSONObject(key));
            key = ContentFactory.createEvent(null).getName();
            this.event = ContentFactory.createEvent(jsonObj.getJSONObject(key));
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            Log.e(TAG, ex.getMessage());
        }
        this.fillContents();
    }

    public AgentInfo getAgentInfo() {
        return this.agentInfo;
    }

    public String getEventName() {
        if (this.event != null) {
            return this.event.getEventName();
        }
        return null;
    }

    public String getEventObj() {
        if (this.event != null) {
            return this.event.getEventObj();
        }
        return null;
    }

    @Override
    public String getParentName() {
        return PARENT_NAME;
    }

    @Override
    protected void fillContents() {
        if (this.agentInfo != null) {
            this.contents.add(this.agentInfo);
        }
        if (this.event != null) {
            this.contents.add(this.event);
        }
    }
}

