/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.helpdesk.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public final class ZipUtil {
    private ZipUtil() {
    }

    public static List<File> getFileList(String zipFileString, boolean bContainFolder, boolean bContainFile) throws Exception {
        ArrayList<File> fileList = new ArrayList<File>();
        try (ZipInputStream inZip = null;){
            ZipEntry zipEntry;
            inZip = new ZipInputStream(new FileInputStream(zipFileString));
            String szName = "";
            while ((zipEntry = inZip.getNextEntry()) != null) {
                szName = zipEntry.getName();
                if (szName.contains("../")) continue;
                if (zipEntry.isDirectory()) {
                    szName = szName.substring(0, szName.length() - 1);
                    File folder = new File(szName);
                    if (!bContainFolder) continue;
                    fileList.add(folder);
                    continue;
                }
                File file = new File(szName);
                if (!bContainFile) continue;
                fileList.add(file);
            }
        }
        return fileList;
    }

    public static void zipFolder(String srcFilePath, String zipFilePath) throws Exception {
        ZipOutputStream outZip = new ZipOutputStream(new FileOutputStream(zipFilePath));
        File file = new File(srcFilePath);
        ZipUtil.zipFiles(file.getParent() + File.separator, file.getName(), outZip);
        outZip.finish();
        outZip.close();
    }

    private static void zipFiles(String folderPath, String fileName, ZipOutputStream zipOut) throws Exception {
        if (zipOut == null) {
            return;
        }
        File file = new File(folderPath + fileName);
        if (file.isFile()) {
            ZipEntry zipEntry = new ZipEntry(fileName);
            try (FileInputStream inputStream = null;){
                int len;
                inputStream = new FileInputStream(file);
                zipOut.putNextEntry(zipEntry);
                byte[] buffer = new byte[4096];
                while ((len = inputStream.read(buffer)) != -1) {
                    zipOut.write(buffer, 0, len);
                }
                zipOut.closeEntry();
            }
        } else {
            String[] fileList = file.list();
            if (fileList.length <= 0) {
                ZipEntry zipEntry = new ZipEntry(fileName + File.separator);
                zipOut.putNextEntry(zipEntry);
                zipOut.closeEntry();
            }
            for (int i = 0; i < fileList.length; ++i) {
                ZipUtil.zipFiles(folderPath, fileName + File.separator + fileList[i], zipOut);
            }
        }
    }

    public static void deleteDirectory(File dirFile) {
        if (dirFile.exists()) {
            File[] files;
            for (File file : files = dirFile.listFiles()) {
                if (file.isFile()) {
                    file.delete();
                    continue;
                }
                if (!file.isDirectory()) continue;
                ZipUtil.deleteDirectory(file);
            }
            dirFile.delete();
        }
    }
}

