package com.easemob.veckit.bean;


public class FunctionSettingBean {
    private boolean visitorCameraOff;
    private boolean skipWaitingPage;

    /*inactiveWaitCloseStatus：boolean 不活跃会话超时是否开启
    inactiveWaitCloseTimeout：60 不活跃会话超时时间（传给后端的时间单位转换成秒）
    timeoutRemindMsgStatus：boolean 超时提示语是否开启
    timeoutRemindMsg：超时提示语内容*/

    // 不活跃会话超时是否开启
    private boolean inactiveWaitCloseStatus;
    // 不活跃会话超时时间
    private int inactiveWaitCloseTimeout;
    // 超时提示语是否开启
    private boolean timeoutRemindMsgStatus;
    // 超时提示语内容
    private String timeoutRemindMsg;

    public FunctionSettingBean(){

    }

    public static FunctionSettingBean create(){
        return new FunctionSettingBean(false, false, false, 60, false,"");
    }

    public FunctionSettingBean(boolean visitorCameraOff, boolean skipWaitingPage, boolean inactiveWaitCloseStatus,
                               int inactiveWaitCloseTimeout, boolean timeoutRemindMsgStatus, String timeoutRemindMsg){
        this.visitorCameraOff = visitorCameraOff;
        this.skipWaitingPage = skipWaitingPage;

        this.inactiveWaitCloseStatus = inactiveWaitCloseStatus;
        this.inactiveWaitCloseTimeout = inactiveWaitCloseTimeout;
        this.timeoutRemindMsgStatus = timeoutRemindMsgStatus;
        this.timeoutRemindMsg = timeoutRemindMsg;
    }


    public boolean isVisitorCameraOff() {
        return visitorCameraOff;
    }

    public void setVisitorCameraOff(boolean visitorCameraOff) {
        this.visitorCameraOff = visitorCameraOff;
    }

    public boolean isSkipWaitingPage() {
        return skipWaitingPage;
    }

    public void setSkipWaitingPage(boolean skipWaitingPage) {
        this.skipWaitingPage = skipWaitingPage;
    }

    public boolean isInactiveWaitCloseStatus() {
        return inactiveWaitCloseStatus;
    }

    public void setInactiveWaitCloseStatus(boolean inactiveWaitCloseStatus) {
        this.inactiveWaitCloseStatus = inactiveWaitCloseStatus;
    }

    public int getInactiveWaitCloseTimeout() {
        return inactiveWaitCloseTimeout;
    }

    public void setInactiveWaitCloseTimeout(int inactiveWaitCloseTimeout) {
        this.inactiveWaitCloseTimeout = inactiveWaitCloseTimeout;
    }

    public boolean isTimeoutRemindMsgStatus() {
        return timeoutRemindMsgStatus;
    }

    public void setTimeoutRemindMsgStatus(boolean timeoutRemindMsgStatus) {
        this.timeoutRemindMsgStatus = timeoutRemindMsgStatus;
    }

    public String getTimeoutRemindMsg() {
        return timeoutRemindMsg;
    }

    public void setTimeoutRemindMsg(String timeoutRemindMsg) {
        this.timeoutRemindMsg = timeoutRemindMsg;
    }

    @Override
    public String toString() {
        return "FunctionSettingBean{" +
                "visitorCameraOff=" + visitorCameraOff +
                ", skipWaitingPage=" + skipWaitingPage +
                ", inactiveWaitCloseStatus=" + inactiveWaitCloseStatus +
                ", inactiveWaitCloseTimeout=" + inactiveWaitCloseTimeout +
                ", timeoutRemindMsgStatus=" + timeoutRemindMsgStatus +
                ", timeoutRemindMsg='" + timeoutRemindMsg + '\'' +
                '}';
    }
}
