package com.easemob.veckit.ui;

import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.widget.ProgressBar;

import androidx.fragment.app.FragmentActivity;

import com.easemob.veckit.R;
import com.easemob.veckit.ui.widget.utils.CommonUtils;
import com.easemob.veckit.ui.widget.utils.FileSaveUtil;
import com.easemob.veckit.ui.widget.utils.ToastHelper;
import com.hyphenate.chat.ChatClient;
import com.hyphenate.chat.EMFileMessageBody;
import com.hyphenate.chat.Message;
import com.hyphenate.helpdesk.callback.Callback;
import com.hyphenate.helpdesk.easeui.util.StatusBarUtils;
import com.hyphenate.util.UriUtils;

import java.io.File;

public class ShowNormalFileActivity extends FragmentActivity {
    private ProgressBar progressBar;
    private File file;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        StatusBarUtils.setImmersiveStatusBar(this, false);
        setContentView(R.layout.vec_activity_show_file);
        progressBar = findViewById(R.id.progressBar);

        final String msgId = getIntent().getStringExtra("messageId");

        final Message message = ChatClient.getInstance().vecChatManager().getVecConversation().getMessage(msgId);
        if (message == null){
            finish();
            return;
        }

        String from = message.from();
        if (from.equals(ChatClient.getInstance().currentUserName())){
            String filePath = getFilePath(message);
            if (!TextUtils.isEmpty(filePath)) {
                CommonUtils.openFile(new File(filePath), ShowNormalFileActivity.this);
            }

            finish();
        }else {
            message.setMessageStatusCallback(new Callback() {
                @Override
                public void onSuccess() {
                    String filePath = getFilePath(message);
                    if (!TextUtils.isEmpty(filePath)){
                        try {
                            EMFileMessageBody body = (EMFileMessageBody) message.body();
                            String mimeType = CommonUtils.getMimeType(getApplicationContext(), filePath);
                            FileSaveUtil.saveTextFile(getApplicationContext(),body.getFileName(),mimeType,filePath);
                        }catch (Exception e){
                            e.printStackTrace();
                        }

                        runOnUiThread(new Runnable() {
                            @Override
                            public void run() {
                                String filePath = getFilePath(message);
                                if(!TextUtils.isEmpty(filePath)) {
                                    CommonUtils.openFile(new File(filePath), ShowNormalFileActivity.this);
                                }
                                finish();
                            }
                        });
                    }

                }

                @Override
                public void onError(int error, final String errorMsg) {
                    if (file != null && file.exists() && file.isFile()){
                        file.delete();
                    }

                    runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            String str4 = getResources().getString(R.string.Failed_to_download_file);
                            ToastHelper.show(getBaseContext(), str4 + errorMsg);
                            finish();
                        }
                    });

                }

                @Override
                public void onProgress(final int progress, String s) {
                    runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            progressBar.setProgress(progress);
                        }
                    });

                }
            });

            if (message.body() instanceof  EMFileMessageBody){
                EMFileMessageBody body = (EMFileMessageBody) message.body();
                file = new File(body.getLocalUrl());
            }
            ChatClient.getInstance().vecChatManager().downloadAttachment(message);
        }

    }

    private String getFilePath(Message message) {
        Uri localUrlUri = ((EMFileMessageBody) message.getBody()).getLocalUri();
        return UriUtils.getFilePath(this, localUrlUri);
    }

    @Override
    public void onBackPressed() {

    }
}
