package com.easemob.veckit.ui;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.webkit.CookieManager;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;

import androidx.core.view.MotionEventCompat;


public class VecWebView extends WebView {
//    private String APP_CACHE_DIRNAME;
    private int mHeight;
    private float mDownX;
    private float mDownY;
    private float mMoveX;
    private float mMoveY;
    private boolean mIsDown;
    private boolean mIsRun;

    public VecWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init();
    }

    public VecWebView(Context context) {
        super(context);
        init();
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        mHeight = MeasureSpec.getSize(heightMeasureSpec);
    }

    @SuppressLint("SetJavaScriptEnabled")
    private void init() {
        /*getSettings().setMediaPlaybackRequiresUserGesture(false);
        loadUrl("file:///android_asset/whiteboard/index.html");
        setWebChromeClient(new WebChromeClient());*/
//        APP_CACHE_DIRNAME = getContext().getFilesDir().getAbsolutePath() + "/webcache";
        WebSettings settings = getSettings();
        settings.setDomStorageEnabled(true);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            CookieManager.getInstance().setAcceptThirdPartyCookies(this, true);
            settings.setMixedContentMode(WebSettings.MIXED_CONTENT_ALWAYS_ALLOW);
        }
        /*//容许h5使用javascript
        webView.getSettings().setJavaScriptEnabled(true);
        //容许android调用javascript
        webView.getSettings().setDomStorageEnabled(true);*/

        settings.setAllowFileAccess(false);
//        settings.setAppCacheEnabled(false);
        settings.setCacheMode(WebSettings.LOAD_NO_CACHE);
        settings.setJavaScriptEnabled(true);
        settings.setLoadWithOverviewMode(true);
//        settings.setAppCachePath(APP_CACHE_DIRNAME);
        settings.setUseWideViewPort(true);
        settings.setSupportZoom(true);
        //不显示webview缩放按钮
        settings.setDisplayZoomControls(false);

        settings.setBuiltInZoomControls(true);
        setWebViewClient(new TestWebViewClient());

        /*if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            setOnScrollChangeListener(new OnScrollChangeListener() {
                @Override
                public void onScrollChange(View v, int scrollX, int scrollY, int oldScrollX, int oldScrollY) {
                    float currentHeight=(v.getHeight() + v.getScrollY());
                    Log.e("ttttttttttt","scrollY = "+scrollY);
                    Log.e("ttttttttttt","oldScrollY = "+oldScrollY);
                    Log.e("ttttttttttt","getScrollY aaaaaaa = "+v.getScrollY());

                    Log.e("ttttttttttt","v instanceof WebView = "+(v instanceof WebView));

                    WebView view = (WebView) v;
                    Log.e("ttttttttttt","Math.ceil(getContentHeight() * getScale()) = "+Math.ceil(view.getContentHeight() * view.getScale()));
                    Log.e("ttttttttttt","currentHeight = "+currentHeight);
                    Log.e("ttttttttttt"," Math.floor(getContentHeight() * getScale()) = "+ Math.floor(view.getContentHeight() * view.getScale()));
                }
            });
        }*/


        /*setOnTouchListener(new OnTouchListener() {
            @Override
            public boolean onTouch(View v, MotionEvent event) {
                ViewParent parent = getParent();
                if (parent != null) {
                    parent.requestDisallowInterceptTouchEvent(true);
                }
                Log.e("ttttttttttt","parent = "+parent);
                *//*if ((int) (getContentHeight() * getScale()) >= (getHeight() + getScrollY())) {
                    //滑动到底部，你要做的事·····
                    Log.e("ttttttttttt","qqqqqqqqq");
                }

                if (getScrollY() <= 0) {
                    //滑动到顶部，你要做的事····
                    Log.e("ttttttttttt","aaaaaaaaa");
                }*//*

                mIsRun = false;
                if (event.getAction() == MotionEvent.ACTION_DOWN){
                    mDownX = event.getX();
                    mDownY = event.getY();
                }else if (event.getAction() == MotionEvent.ACTION_MOVE){
                    mMoveX = event.getX();
                    mMoveY = event.getY();

                    if (Math.abs(mMoveY - mDownY) > Math.abs(mMoveX - mDownX)){
                        if (Math.abs((mMoveY - mDownY)) > 2){
                            mIsRun = true;
                            // 正 --》向下滑动
                            mIsDown = mMoveY - mDownY > 0;
                        }
                    }

                    mDownX = mMoveX;
                    mDownY = mMoveY;
                }
                // float currentHeight=(getHeight() + getScrollY());
                *//*if (mIsRun){
                    if (mIsDown){
                        if (getScrollY() == 0){
                            Log.e("ttttttttttt","顶部");
                            if (parent != null) {
                                parent.requestDisallowInterceptTouchEvent(false);
                            }
                        }
                    }else {

                        if(currentHeight <= Math.ceil(getContentHeight() * getScale())
                                && currentHeight >= Math.floor(getContentHeight() * getScale() - 6)){
                            Log.e("ttttttttttt","底部");
                            if (parent != null) {
                                parent.requestDisallowInterceptTouchEvent(false);
                            }
                        }
                    }
                }*//*
                return false;
            }
        });*/
    }

    private class TestWebViewClient extends WebViewClient {
        @Override
        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            super.onPageStarted(view, url, favicon);
        }
        @Override
        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            view.loadUrl(url);
            return true;
        }
        @Override
        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
        }
        @Override
        public void onReceivedError(WebView view, int errorCode,String description, String failingUrl) {
            super.onReceivedError(view, errorCode, description, failingUrl);
        }
    }


    // 是否垂直滚动
    boolean isScrollV;
    @Override
    public boolean onTouchEvent(MotionEvent event) {
        if (MotionEventCompat.getPointerCount(event) == 1) {
            switch (event.getAction()) {
                case MotionEvent.ACTION_DOWN:
                    isScrollV = false;
                    //isScrollH = false;

                    //事件由webview处理
                    getParent().getParent().getParent().getParent().getParent().requestDisallowInterceptTouchEvent(true);
                    break;
                case MotionEvent.ACTION_MOVE:
                    // 垂直viewpager，scrollview，listview等
                    getParent().getParent().getParent().getParent().getParent().requestDisallowInterceptTouchEvent(!isScrollV);

                    //嵌套Viewpager时
                    // getParent().getParent().requestDisallowInterceptTouchEvent(!isScrollH);
                    break;
                default:
                    getParent().getParent().getParent().getParent().getParent().requestDisallowInterceptTouchEvent(false);
            }
        } else {
            //使webview可以双指缩放（前提是webview必须开启缩放功能，并且加载的网页也支持缩放）
            getParent().getParent().getParent().getParent().getParent().requestDisallowInterceptTouchEvent(true);
        }
        return super.onTouchEvent(event);
    }

    //当webview滚动到边界时执行
    @Override
    protected void onOverScrolled(int scrollX, int scrollY, boolean clampedX, boolean clampedY) {
        super.onOverScrolled(scrollX, scrollY, clampedX, clampedY);
        isScrollV = clampedY;
        //isScrollH = clampedX;
    }

}
