package com.easemob.veckit.ui.widget.row;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.provider.Browser;
import android.text.TextPaint;
import android.text.style.URLSpan;
import android.view.View;

import com.easemob.veckit.utils.CloudCallbackUtils;


public class AutoLinkSpan extends URLSpan {
    private String mUrl;

    public AutoLinkSpan(String url) {
        super(url);
        mUrl = url;
    }

    @Override
    public void onClick(View widget) {
        CloudCallbackUtils.newCloudCallbackUtils().onCloseView();
        Context context = widget.getContext();
        Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse(mUrl));
        intent.putExtra(Browser.EXTRA_APPLICATION_ID, context.getPackageName());
        intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        widget.getContext().startActivity(intent);
    }

    @Override
    public void updateDrawState(TextPaint ds) {
        super.updateDrawState(ds);
        /*ds.setColor(ds.getColor());
        ds.setUnderlineText(false);*/
        ds.setUnderlineText(false);
    }
}