package com.easemob.veckit.ui.widget.row;


import android.content.Context;
import android.view.View;
import android.widget.BaseAdapter;

import com.easemob.veckit.R;
import com.easemob.veckit.ui.VecWebView;
import com.easemob.veckit.ui.widget.ChatRow;
import com.easemob.veckit.ui.widget.MessageAdapter;
import com.easemob.veckit.ui.widget.utils.UIProvider;
import com.hyphenate.chat.EMTextMessageBody;
import com.hyphenate.chat.Message;

import org.json.JSONArray;
import org.json.JSONObject;


public class ChatRowRichText extends ChatRow {

    private VecWebView mVecVebView;

    public ChatRowRichText(Context context, Message message, int position, BaseAdapter adapter) {
        super(context, message, position, adapter);
    }

    @Override
    protected void onInflatView() {
        inflater.inflate(message.direct() == Message.Direct.RECEIVE ?
                R.layout.vec_row_received_rich_text : R.layout.vec_row_sent_rich_text, this);
    }

    @Override
    protected void onFindViewById() {
        mVecVebView = findViewById(R.id.vecVebView);
    }

    @Override
    public void onSetUpView() {
        try {
            EMTextMessageBody body = (EMTextMessageBody) message.body();
            String s = body.getMessage();
            JSONObject jsonObject = new JSONObject(s);
            String content = jsonObject.getString("content");
            mVecVebView.loadUrl(content);
        }catch (Exception e){
            try {
                EMTextMessageBody body = (EMTextMessageBody) message.body();
                String s = body.getMessage();
                JSONArray jsonArray = new JSONArray(s);
                JSONObject jsonObject = (JSONObject) jsonArray.get(0);
                String content = jsonObject.getString("content");
                // String content = "https://static01.yangshipin.cn/dist/welfare/index.html?channel=kf_wz_flz#/home?act_id=ff6ede";
                mVecVebView.loadUrl(content);
            }catch (Exception e2){
                e2.printStackTrace();
            }

        }
        handleTextMessage();
    }

    protected void handleTextMessage() {
        boolean isShowProgress = UIProvider.getInstance().isShowProgress();
        if (message.direct() == Message.Direct.SEND) {
            setMessageSendCallback();
            switch (message.status()) {
                case CREATE:
                    progressBar.setVisibility(View.GONE);
                    statusView.setVisibility(View.VISIBLE);
                    // 发送消息
                    break;
                case SUCCESS: // 发送成功
                    progressBar.setVisibility(View.GONE);
                    statusView.setVisibility(View.GONE);
                    break;
                case FAIL: // 发送失败
                    progressBar.setVisibility(View.GONE);
                    statusView.setVisibility(View.VISIBLE);
                    break;
                case INPROGRESS: // 发送中
                    if (isShowProgress)
                        progressBar.setVisibility(View.VISIBLE);
                    statusView.setVisibility(View.GONE);
                    break;
                default:
                    break;
            }
        }
    }

    @Override
    protected void onUpdateView() {
        if (adapter instanceof MessageAdapter) {
            ((MessageAdapter) adapter).refresh();
        } else {
            adapter.notifyDataSetChanged();
        }

    }

    @Override
    protected void onBubbleClick() {
        // TODO Auto-generated method stub

    }



}