package com.easemob.veckit.ui.widget.row;


import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.text.Html;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.text.style.ImageSpan;
import android.text.style.URLSpan;
import android.view.View;
import android.widget.BaseAdapter;
import android.widget.TextView;

import com.easemob.veckit.R;
import com.easemob.veckit.ui.widget.ChatRow;
import com.easemob.veckit.ui.widget.MessageAdapter;
import com.easemob.veckit.ui.widget.utils.SmileUtils;
import com.easemob.veckit.ui.widget.utils.UIProvider;
import com.hyphenate.chat.ChatClient;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMTextMessageBody;
import com.hyphenate.chat.Message;
import com.hyphenate.helpdesk.util.Log;

import java.io.File;


public class ChatRowText extends ChatRow {

    private TextView contentView;

    public ChatRowText(Context context, Message message, int position, BaseAdapter adapter) {
        super(context, message, position, adapter);
    }

    @Override
    protected void onInflatView() {
        inflater.inflate(message.direct() == Message.Direct.RECEIVE ?
                R.layout.vec_row_received_message : R.layout.vec_row_sent_message, this);
    }

    @Override
    protected void onFindViewById() {
        contentView = (TextView) findViewById(R.id.tv_chatcontent);
    }

    @Override
    public void onSetUpView() {
        EMTextMessageBody txtBody = (EMTextMessageBody) message.body();

        //解析html超链接
        String content = txtBody.getMessage();
        //fromHtml method will ignore \n in string
        CharSequence htmpTxt;
        if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.N) {
            htmpTxt = Html.fromHtml(content, Html.FROM_HTML_MODE_LEGACY);
        } else {
            htmpTxt = Html.fromHtml(content);
        }

        //String new_content = htmpTxt.toString();
        //解析表情
        //Spannable span = SmileUtils.getSmiledText(context, new_content);

        //给超链接添加响应
        /*URLSpan[] urlSpans = span.getSpans(0, span.length(), URLSpan.class);
        for (URLSpan span1 : urlSpans) {
            int start = span.getSpanStart(span1);
            int end = span.getSpanEnd(span1);
            int flag = span.getSpanFlags(span1);
            final String link = span1.getURL();
            span.setSpan(new ClickableSpan() {
                @Override
                public void onClick(View widget) {
                    //打开超链接
                    if (link != null && link.startsWith("http")) {
                        //CloudCallbackUtils.newCloudCallbackUtils().notifyClick(true);
                        Intent intent = new Intent();
                        intent.setAction("android.intent.action.VIEW");
                        Uri content_url = Uri.parse(link);
                        intent.setData(content_url);
                        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                        getContext().startActivity(intent);
                    }
                }
            }, start, end, flag);
            span.removeSpan(span1);
        }*/

        contentView.setLinksClickable(true);
        contentView.setMovementMethod(LinkMovementMethod.getInstance());
        // 设置内容
        //contentView.setText(span, TextView.BufferType.SPANNABLE);

        // 文本点击跳转外部网页
        // clickTextLink(contentView);

        // 设置内容
        // contentView.setText(span, TextView.BufferType.SPANNABLE);
        contentView.setText(getClickableHtml(htmpTxt), TextView.BufferType.SPANNABLE);

        handleTextMessage();
    }

    private CharSequence getClickableHtml(CharSequence html) {
        SpannableStringBuilder clickableHtmlBuilder = new SpannableStringBuilder(html);
        SmileUtils.aa(context, clickableHtmlBuilder);

        URLSpan[] urls = clickableHtmlBuilder.getSpans(0, html.length(), URLSpan.class);
        ImageSpan[] images = clickableHtmlBuilder.getSpans(0, html.length(), ImageSpan.class);

        for(final URLSpan span : urls) {
            setLinkClickable(clickableHtmlBuilder, span);
        }

        for(final ImageSpan span : images) {
            setLinkClickable(clickableHtmlBuilder, span);
        }
        return clickableHtmlBuilder;

    }

    private void setLinkClickable(final SpannableStringBuilder clickableHtmlBuilder, final URLSpan urlSpan) {
        String url = urlSpan.getURL();
        int start = clickableHtmlBuilder.getSpanStart(urlSpan);
        int end = clickableHtmlBuilder.getSpanEnd(urlSpan);
        int flags = clickableHtmlBuilder.getSpanFlags(urlSpan);
        ClickableSpan clickableSpan = new ClickableSpan() {

            public void onClick(View view) {
                Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse(url));
                intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                context.startActivity(intent);
            }

        };
        clickableHtmlBuilder.setSpan(clickableSpan, start, end, flags);

    }

    private void setLinkClickable(final SpannableStringBuilder clickableHtmlBuilder, final ImageSpan urlSpan) {
        // 获取src地址，<img src=''/>
        String url = urlSpan.getSource();
        int start = clickableHtmlBuilder.getSpanStart(urlSpan);
        int end = clickableHtmlBuilder.getSpanEnd(urlSpan);
        int flags = clickableHtmlBuilder.getSpanFlags(urlSpan); // Spannable.SPAN_EXCLUSIVE_EXCLUSIVE


        ImageSpan[] spans = clickableHtmlBuilder.getSpans(start, end, ImageSpan.class);
        clickableHtmlBuilder.removeSpan(spans);

        // 添加新的span
        ImageSpan imageSpan = new ImageSpan(context, R.drawable.hd_default_image);
        clickableHtmlBuilder.setSpan(imageSpan, start, end, flags);
        ClickableSpan clickableSpan = new ClickableSpan() {

            public void onClick(View view) {
                Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse(url));
                intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                context.startActivity(intent);
            }

        };
        clickableHtmlBuilder.setSpan(clickableSpan, start, end, flags);

    }

    /*@Override
    public void onSetUpView() {
        EMTextMessageBody txtBody = (EMTextMessageBody) message.body();

        //解析html超链接
        String content = txtBody.getMessage().replace("\n", "<br />");
        //fromHtml method will ignore \n in string
        CharSequence htmpTxt;
        if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.N) {
            htmpTxt = Html.fromHtml(content.replace("<", "&lt;"), Html.FROM_HTML_MODE_LEGACY);
        } else {
            htmpTxt = Html.fromHtml(content.replace("<", "&lt;"));
        }

        String new_content = htmpTxt.toString().replace("<br />", "\n");
        //解析表情
        Spannable span = SmileUtils.getSmiledText(context, new_content);

        //给超链接添加响应
        URLSpan[] urlSpans = span.getSpans(0, span.length(), URLSpan.class);
        for (URLSpan span1 : urlSpans) {
            int start = span.getSpanStart(span1);
            int end = span.getSpanEnd(span1);
            int flag = span.getSpanFlags(span1);
            final String link = span1.getURL();
            span.setSpan(new ClickableSpan() {
                @Override
                public void onClick(View widget) {
                    //打开超链接
                    if (link != null && link.startsWith("http")) {
                        //CloudCallbackUtils.newCloudCallbackUtils().notifyClick(true);
                        Intent intent = new Intent();
                        intent.setAction("android.intent.action.VIEW");
                        Uri content_url = Uri.parse(link);
                        intent.setData(content_url);
                        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                        getContext().startActivity(intent);
                    }
                }
            }, start, end, flag);
            span.removeSpan(span1);
        }

        contentView.setLinksClickable(true);
        contentView.setMovementMethod(LinkMovementMethod.getInstance());
        // 设置内容
        contentView.setText(span, TextView.BufferType.SPANNABLE);

        // 文本点击跳转外部网页
        clickTextLink(contentView);


        handleTextMessage();
    }*/


    private void clickTextLink(TextView textView){
        Spannable spannable = (Spannable) textView.getText();
        URLSpan[] spans = spannable.getSpans(0, spannable.length(), URLSpan.class);
        for (int i = 0; i < spans.length; i++) {
            String url = spans[i].getURL();
            int index = spannable.toString().indexOf(url);
            int end = index + url.length();

            if (index != -1) {
                spannable.removeSpan(spans[i]);
                spannable.setSpan(new AutoLinkSpan(spans[i].getURL()), index
                        , end, Spanned.SPAN_INCLUSIVE_INCLUSIVE);
            }
        }
    }

    protected void handleTextMessage() {
        boolean isShowProgress = UIProvider.getInstance().isShowProgress();
        if (message.direct() == Message.Direct.SEND) {
            setMessageSendCallback();
            switch (message.status()) {
                case CREATE:
                    /*progressBar.setVisibility(View.GONE);
                    statusView.setVisibility(View.VISIBLE);*/
                    progressBar.setVisibility(View.VISIBLE);
                    statusView.setVisibility(View.GONE);
                    // 发送消息
                    break;
                case SUCCESS: // 发送成功
                    progressBar.setVisibility(View.GONE);
                    statusView.setVisibility(View.GONE);
                    break;
                case FAIL: // 发送失败
                    progressBar.setVisibility(View.GONE);
                    statusView.setVisibility(View.VISIBLE);
                    break;
                case INPROGRESS: // 发送中
                    if (isShowProgress)
                        progressBar.setVisibility(View.VISIBLE);
                    statusView.setVisibility(View.GONE);
                    break;
                default:
                    break;
            }
        }
    }

    @Override
    protected void onUpdateView() {
        if (adapter instanceof MessageAdapter) {
            ((MessageAdapter) adapter).refresh();
        } else {
            adapter.notifyDataSetChanged();
        }

    }

    @Override
    protected void onBubbleClick() {
        // TODO Auto-generated method stub

    }



}