package com.easemob.veckit.utils;

public class VecKitOptions {
    private static VecKitOptions sVecKitOptions;
    private VecKitOptions(){}

    // 点击询前引导发起视频时的 configId
    private String mGuideConfigId;
    // 在线访客id
    private String mGuideVisitorUserId;
    // 询前引导 在线会话 IM服务号
    private String mRelatedImServiceNumber;
    // 询前引导 在线会话ID
    private String mGuideSessionId;

    // queueId
    private int mQueueId;
    private int mMenuId;
    private String mQueueType;

    public static VecKitOptions getVecKitOptions() {
        if (sVecKitOptions == null){
            synchronized (VecKitOptions.class){
                if (sVecKitOptions == null){
                    sVecKitOptions = new VecKitOptions();
                }
            }
        }
        return sVecKitOptions;
    }

    public void setGuideQueueId(int queueId) {
        mQueueId = queueId;
    }

    public int getGuideQueueId() {
        return mQueueId;
    }

    public void setGuideMenuId(int menuId) {
        mMenuId = menuId;
    }

    public int getGuideMenuId() {
        return mMenuId;
    }

    public void setGuideQueueType(String queueType) {
        mQueueType = queueType;
    }

    public String getGuideQueueType() {
        return mQueueType;
    }

    public void setGuideConfigId(String guideConfigId) {
        mGuideConfigId = guideConfigId;
    }

    public String getGuideConfigId() {
        return mGuideConfigId;
    }

    public void setGuideSessionId(String guideSessionId) {
        mGuideSessionId = guideSessionId;
    }

    public String getGuideSessionId() {
        return mGuideSessionId;
    }

    public void setGuideVisitorUserId(String guideVisitorUserId) {
        mGuideVisitorUserId = guideVisitorUserId;
    }

    public String getGuideVisitorUserId() {
        return mGuideVisitorUserId;
    }

    public void setRelatedImServiceNumber(String relatedImServiceNumber) {
        mRelatedImServiceNumber = relatedImServiceNumber;
    }

    public String getRelatedImServiceNumber() {
        return mRelatedImServiceNumber;
    }

    private volatile boolean mIsShowCallingView = true;
    public void setShowCallingView(boolean isShowCallingView) {
        this.mIsShowCallingView = isShowCallingView;
    }

    public boolean isShowCallingView() {
        return mIsShowCallingView;
    }

    private volatile boolean mIsShowSatisfiedView = false;
    public void setShowSatisfiedView(boolean isShowSatisfiedView) {
        this.mIsShowSatisfiedView = isShowSatisfiedView;
    }

    public boolean isShowSatisfiedView() {
        return mIsShowSatisfiedView;
    }

    // 重新发起页面是否显示
    private volatile boolean mIsShowReissueView = false;

    public boolean isShowReissueView() {
        return mIsShowReissueView;
    }

    public void setShowReissueView(boolean showReissueView) {
        mIsShowReissueView = showReissueView;
    }
}
