package com.easemob.veckit.utils;

import android.app.Activity;
import android.content.Context;

import com.easemob.veckit.VECKitCalling;
import com.hyphenate.agora.IVecBroadcast;
import com.hyphenate.agora.IVecEndCallback;
import com.hyphenate.agora.ZuoXiSendRequestObj;
import com.hyphenate.chat.AgoraMessage;
import com.hyphenate.chat.Message;

// vec视频发起无界面时，使用此类
public class WaitPageUtils implements AppStateVecCallback.IAppStateVecCallback, IVecEndCallback, IVecBroadcast {

    private static WaitPageUtils sWaitPageUtils;
    private IWaitPageUtils mIWaitPageUtils;

    private WaitPageUtils(){

    }

    public static WaitPageUtils newWaitPageUtils(){
        if (sWaitPageUtils == null)  {
            synchronized (WaitPageUtils.class){
                if (sWaitPageUtils == null){
                    sWaitPageUtils = new WaitPageUtils();
                }
            }
        }
        return sWaitPageUtils;
    }

    // 注册监听
    public void register(IWaitPageUtils iWaitPageUtils){
        mIWaitPageUtils = iWaitPageUtils;
        AgoraMessage.newAgoraMessage().registerIEndCallback(getClass().getSimpleName(), this);
        AppStateVecCallback.getAppStateCallback().registerIAppStateVecCallback(this);
        AgoraMessage.newAgoraMessage().registerVecBroadcast(this);
    }

    // 注销监听
    public void unRegister(){
        onDestroy();
    }

    // 访客主动发起视频邀请
    public void sendVideo(Context context, String vecImServiceNumber, String configId){
        // 控制是否显示发起和排队页面
        VecKitOptions.getVecKitOptions().setShowCallingView(false);
        VECKitCalling.callingRequest(context, vecImServiceNumber, configId);
        VecKitReportUtils.getVecKitReportUtils().startReport(vecImServiceNumber);
    }

    // 访客发起视频邀请，坐席未接通，访客挂断视频邀请
    public void sendEndCall(){
        VecKitReportUtils.getVecKitReportUtils().closeReport();
        VECKitCalling.endCallFromOff();
    }

    @Override
    public void onAppForeground() {
        VecKitReportUtils.getVecKitReportUtils().onPageForegroundReport();
    }

    @Override
    public void onAppBackground() {
        VecKitReportUtils.getVecKitReportUtils().onPageBackgroundReport();
    }

    @Override
    public void onActivityStopped(Activity activity) {

    }

    @Override
    public void onVecZuoXiToBreakOff() {
        if (mIWaitPageUtils != null){
            mIWaitPageUtils.onAgentRejectBreakOff();
        }
        VecKitReportUtils.getVecKitReportUtils().closeReport();
    }

    @Override
    public void onInitWaitPage(int callType, String rtcSessionId, String tenantId) {
        if (callType == 0){
            // 访客主动邀请坐席
            requestWait(rtcSessionId, tenantId);
        }
    }


    private volatile boolean mIsWaitTimeout;
    @Override
    public void onWaitTimeout(Message message) {
        mIsWaitTimeout = true;
        if (mIWaitPageUtils != null){
            mIWaitPageUtils.onWaitTimeout(message);
        }
    }

    @Override
    public void onAgentRequest(String s, String s1, Message message) {

    }

    @Override
    public void onVisitorAnswerResponse(ZuoXiSendRequestObj zuoXiSendRequestObj, String s, Message message) {

    }

    @Override
    public void onAgentAnswerResponse(ZuoXiSendRequestObj zuoXiSendRequestObj, String s, Message message) {
        if (mIWaitPageUtils != null){
            mIWaitPageUtils.onAgentAnswerResponse();
        }
    }

    @Override
    public void onEvaluation(String s, Message message) {

    }

    @Override
    public void onSessionCreateEvent(Message message, String sessionId, String visitorUserId) {
        mIsWaitTimeout = false;
    }

    // 等待
    private void requestWait(String rtcSessionId, String tenantId) {
        WaitNetworkUtils.newWaitNetworkUtils().execute(rtcSessionId, tenantId, new WaitNetworkUtils.IWaitCallBack() {
            @Override
            public void onWaitData(boolean waitingFlag, String visitorWaitingNumber, String session) {

                if (mIsWaitTimeout){
                    return;
                }

                if (mIWaitPageUtils != null){
                    mIWaitPageUtils.onWait(waitingFlag, visitorWaitingNumber, session);
                }
            }

            @Override
            public void onWaitError(String errorMsg) {
                /*if (mIWaitPageUtils != null){
                    mIWaitPageUtils.onWaitError(errorMsg);
                }*/
            }
        });
    }

    private void onDestroy(){
        WaitNetworkUtils.newWaitNetworkUtils().clear();
        AppStateVecCallback.getAppStateCallback().unRegisterIAppStateVecCallback(this);
        AgoraMessage.newAgoraMessage().unRegisterIEndCallback(getClass().getSimpleName());
        AgoraMessage.newAgoraMessage().unRegisterVecBroadcast(this);
        mIWaitPageUtils = null;
    }

    public interface IWaitPageUtils{
        // 排队等待
        void onWait(boolean isWaiting, String visitorWaitingMsg, String session);
        // 等待超时触发
        void onWaitTimeout(Message message);
        // 坐席接通响应
        void onAgentAnswerResponse();
        // 坐席拒接挂断
        void onAgentRejectBreakOff();
    }
}