package com.easemob.helpdeskdemo;

import android.app.Activity;
import android.text.TextUtils;

import com.hihonor.push.sdk.HonorPushCallback;
import com.hihonor.push.sdk.HonorPushClient;
import com.huawei.agconnect.config.AGConnectServicesConfig;
import com.huawei.hms.aaid.HmsInstanceId;
import com.huawei.hms.common.ApiException;
import com.hyphenate.chat.EMClient;
import com.hyphenate.util.EMLog;

import java.lang.reflect.Method;

/**
 * 此类为配置荣耀推送的工具类
 */
public class HONORPushHelper {

	private static HONORPushHelper instance;

	private HONORPushHelper(){}

	public static HONORPushHelper getInstance() {
		if (instance == null) {
			instance = new HONORPushHelper();
		}
		return instance;
	}

	public void getHonorToken(Activity activity){
		// 判断是否启用FCM推送
		if (EMClient.getInstance().isFCMAvailable()) {
			return;
		}
		if (HonorPushClient.getInstance().checkSupportHonorPush(activity)){
			// 获取荣耀 device token。
			HonorPushClient.getInstance().getPushToken(new HonorPushCallback<String>() {
				@Override
				public void onSuccess(String token) {
					EMLog.d("HonorPushClient","getPushToken onSuccess: " + token);
					EMClient.getInstance().sendHonorPushTokenToServer(token);
				}

				@Override
				public void onFailure(int code, String error) {
					EMLog.e("HonorPushClient","getPushToken onFailure: " + code + " error:" + error);
				}
			});
		}
	}

}
