package com.easemob.helpdeskdemo;

import com.hihonor.push.sdk.HonorMessageService;
import com.hihonor.push.sdk.HonorPushDataMsg;
import com.hyphenate.chat.EMClient;
import com.hyphenate.util.EMLog;

public class HONORPushService extends HonorMessageService {
    //Device token 发生变化时，会触发 `onNewToken` 回调返回新 Token。
    @Override
    public void onNewToken(String token) {
        if(token != null && !token.equals("")){
            EMLog.d("HONORPush", "service register honor push token success token:" + token);
            // IM SDK 提供的上传 device token 的 API
            EMClient.getInstance().sendHonorPushTokenToServer(token);
        }else{
            EMLog.e("HONORPush", "service register honor push token fail!");
        }
    }
    @Override
    public void onMessageReceived(HonorPushDataMsg honorPushDataMsg) {
        EMLog.d("HONORPush", "onMessageReceived" + honorPushDataMsg.getData());
    }
}