package com.easemob.helpdeskdemo.fcm;

import android.util.Log;

import androidx.annotation.NonNull;

import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import com.hyphenate.chat.EMClient;
import com.hyphenate.helpdesk.easeui.UIProvider;
import com.hyphenate.util.EMLog;


public class EMFCMMSGService extends FirebaseMessagingService {
    private static final String TAG = "EMFCMMSGService";

    @Override
    public void onMessageReceived(RemoteMessage remoteMessage) {
        super.onMessageReceived(remoteMessage);
        EMLog.e(TAG, "EMFCMMSGService#onMessageReceived:" + remoteMessage.toString());
        if (remoteMessage.getData().size() > 0) {
            String message = remoteMessage.getData().get("alert");
            Log.i(TAG, "onMessageReceived: " + message);
            EMLog.e(TAG, "EMFCMMSGService#onMessageReceived");
            UIProvider.getInstance().getNotifier().sendNotification(message);
        }
    }

    @Override
    public void onNewToken(@NonNull String token) {
        super.onNewToken(token);
        Log.i(TAG, "onNewToken: " + token);
        EMClient.getInstance().sendFCMTokenToServer(token);
    }
}
